/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.licensemanager.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.licensemanager.model.ImageResponse;
import com.oracle.bmc.licensemanager.model.LicenseUnit;
import com.oracle.bmc.licensemanager.model.LifeCycleState;
import com.oracle.bmc.licensemanager.model.Status;
import java.beans.ConstructorProperties;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class ProductLicense
extends ExplicitlySetBmcModel {
    @JsonProperty(value="id")
    private final String id;
    @JsonProperty(value="compartmentId")
    private final String compartmentId;
    @JsonProperty(value="status")
    private final Status status;
    @JsonProperty(value="statusDescription")
    private final String statusDescription;
    @JsonProperty(value="totalActiveLicenseUnitCount")
    private final Integer totalActiveLicenseUnitCount;
    @JsonProperty(value="lifecycleState")
    private final LifeCycleState lifecycleState;
    @JsonProperty(value="totalLicenseUnitsConsumed")
    private final Double totalLicenseUnitsConsumed;
    @JsonProperty(value="totalLicenseRecordCount")
    private final Integer totalLicenseRecordCount;
    @JsonProperty(value="activeLicenseRecordCount")
    private final Integer activeLicenseRecordCount;
    @JsonProperty(value="licenseUnit")
    private final LicenseUnit licenseUnit;
    @JsonProperty(value="isVendorOracle")
    private final Boolean isVendorOracle;
    @JsonProperty(value="isOverSubscribed")
    private final Boolean isOverSubscribed;
    @JsonProperty(value="isUnlimited")
    private final Boolean isUnlimited;
    @JsonProperty(value="displayName")
    private final String displayName;
    @JsonProperty(value="vendorName")
    private final String vendorName;
    @JsonProperty(value="timeCreated")
    private final Date timeCreated;
    @JsonProperty(value="timeUpdated")
    private final Date timeUpdated;
    @JsonProperty(value="images")
    private final List<ImageResponse> images;
    @JsonProperty(value="freeformTags")
    private final Map<String, String> freeformTags;
    @JsonProperty(value="definedTags")
    private final Map<String, Map<String, Object>> definedTags;
    @JsonProperty(value="systemTags")
    private final Map<String, Map<String, Object>> systemTags;

    @Deprecated
    @ConstructorProperties(value={"id", "compartmentId", "status", "statusDescription", "totalActiveLicenseUnitCount", "lifecycleState", "totalLicenseUnitsConsumed", "totalLicenseRecordCount", "activeLicenseRecordCount", "licenseUnit", "isVendorOracle", "isOverSubscribed", "isUnlimited", "displayName", "vendorName", "timeCreated", "timeUpdated", "images", "freeformTags", "definedTags", "systemTags"})
    public ProductLicense(String id, String compartmentId, Status status, String statusDescription, Integer totalActiveLicenseUnitCount, LifeCycleState lifecycleState, Double totalLicenseUnitsConsumed, Integer totalLicenseRecordCount, Integer activeLicenseRecordCount, LicenseUnit licenseUnit, Boolean isVendorOracle, Boolean isOverSubscribed, Boolean isUnlimited, String displayName, String vendorName, Date timeCreated, Date timeUpdated, List<ImageResponse> images, Map<String, String> freeformTags, Map<String, Map<String, Object>> definedTags, Map<String, Map<String, Object>> systemTags) {
        this.id = id;
        this.compartmentId = compartmentId;
        this.status = status;
        this.statusDescription = statusDescription;
        this.totalActiveLicenseUnitCount = totalActiveLicenseUnitCount;
        this.lifecycleState = lifecycleState;
        this.totalLicenseUnitsConsumed = totalLicenseUnitsConsumed;
        this.totalLicenseRecordCount = totalLicenseRecordCount;
        this.activeLicenseRecordCount = activeLicenseRecordCount;
        this.licenseUnit = licenseUnit;
        this.isVendorOracle = isVendorOracle;
        this.isOverSubscribed = isOverSubscribed;
        this.isUnlimited = isUnlimited;
        this.displayName = displayName;
        this.vendorName = vendorName;
        this.timeCreated = timeCreated;
        this.timeUpdated = timeUpdated;
        this.images = images;
        this.freeformTags = freeformTags;
        this.definedTags = definedTags;
        this.systemTags = systemTags;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getId() {
        return this.id;
    }

    public String getCompartmentId() {
        return this.compartmentId;
    }

    public Status getStatus() {
        return this.status;
    }

    public String getStatusDescription() {
        return this.statusDescription;
    }

    public Integer getTotalActiveLicenseUnitCount() {
        return this.totalActiveLicenseUnitCount;
    }

    public LifeCycleState getLifecycleState() {
        return this.lifecycleState;
    }

    public Double getTotalLicenseUnitsConsumed() {
        return this.totalLicenseUnitsConsumed;
    }

    public Integer getTotalLicenseRecordCount() {
        return this.totalLicenseRecordCount;
    }

    public Integer getActiveLicenseRecordCount() {
        return this.activeLicenseRecordCount;
    }

    public LicenseUnit getLicenseUnit() {
        return this.licenseUnit;
    }

    public Boolean getIsVendorOracle() {
        return this.isVendorOracle;
    }

    public Boolean getIsOverSubscribed() {
        return this.isOverSubscribed;
    }

    public Boolean getIsUnlimited() {
        return this.isUnlimited;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getVendorName() {
        return this.vendorName;
    }

    public Date getTimeCreated() {
        return this.timeCreated;
    }

    public Date getTimeUpdated() {
        return this.timeUpdated;
    }

    public List<ImageResponse> getImages() {
        return this.images;
    }

    public Map<String, String> getFreeformTags() {
        return this.freeformTags;
    }

    public Map<String, Map<String, Object>> getDefinedTags() {
        return this.definedTags;
    }

    public Map<String, Map<String, Object>> getSystemTags() {
        return this.systemTags;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("ProductLicense(");
        sb.append("super=").append(super.toString());
        sb.append("id=").append(String.valueOf(this.id));
        sb.append(", compartmentId=").append(String.valueOf(this.compartmentId));
        sb.append(", status=").append(String.valueOf((Object)this.status));
        sb.append(", statusDescription=").append(String.valueOf(this.statusDescription));
        sb.append(", totalActiveLicenseUnitCount=").append(String.valueOf(this.totalActiveLicenseUnitCount));
        sb.append(", lifecycleState=").append(String.valueOf((Object)this.lifecycleState));
        sb.append(", totalLicenseUnitsConsumed=").append(String.valueOf(this.totalLicenseUnitsConsumed));
        sb.append(", totalLicenseRecordCount=").append(String.valueOf(this.totalLicenseRecordCount));
        sb.append(", activeLicenseRecordCount=").append(String.valueOf(this.activeLicenseRecordCount));
        sb.append(", licenseUnit=").append(String.valueOf((Object)this.licenseUnit));
        sb.append(", isVendorOracle=").append(String.valueOf(this.isVendorOracle));
        sb.append(", isOverSubscribed=").append(String.valueOf(this.isOverSubscribed));
        sb.append(", isUnlimited=").append(String.valueOf(this.isUnlimited));
        sb.append(", displayName=").append(String.valueOf(this.displayName));
        sb.append(", vendorName=").append(String.valueOf(this.vendorName));
        sb.append(", timeCreated=").append(String.valueOf(this.timeCreated));
        sb.append(", timeUpdated=").append(String.valueOf(this.timeUpdated));
        sb.append(", images=").append(String.valueOf(this.images));
        sb.append(", freeformTags=").append(String.valueOf(this.freeformTags));
        sb.append(", definedTags=").append(String.valueOf(this.definedTags));
        sb.append(", systemTags=").append(String.valueOf(this.systemTags));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ProductLicense)) {
            return false;
        }
        ProductLicense other = (ProductLicense)((Object)o);
        return Objects.equals(this.id, other.id) && Objects.equals(this.compartmentId, other.compartmentId) && Objects.equals((Object)this.status, (Object)other.status) && Objects.equals(this.statusDescription, other.statusDescription) && Objects.equals(this.totalActiveLicenseUnitCount, other.totalActiveLicenseUnitCount) && Objects.equals((Object)this.lifecycleState, (Object)other.lifecycleState) && Objects.equals(this.totalLicenseUnitsConsumed, other.totalLicenseUnitsConsumed) && Objects.equals(this.totalLicenseRecordCount, other.totalLicenseRecordCount) && Objects.equals(this.activeLicenseRecordCount, other.activeLicenseRecordCount) && Objects.equals((Object)this.licenseUnit, (Object)other.licenseUnit) && Objects.equals(this.isVendorOracle, other.isVendorOracle) && Objects.equals(this.isOverSubscribed, other.isOverSubscribed) && Objects.equals(this.isUnlimited, other.isUnlimited) && Objects.equals(this.displayName, other.displayName) && Objects.equals(this.vendorName, other.vendorName) && Objects.equals(this.timeCreated, other.timeCreated) && Objects.equals(this.timeUpdated, other.timeUpdated) && Objects.equals(this.images, other.images) && Objects.equals(this.freeformTags, other.freeformTags) && Objects.equals(this.definedTags, other.definedTags) && Objects.equals(this.systemTags, other.systemTags) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.id == null ? 43 : this.id.hashCode());
        result = result * 59 + (this.compartmentId == null ? 43 : this.compartmentId.hashCode());
        result = result * 59 + (this.status == null ? 43 : this.status.hashCode());
        result = result * 59 + (this.statusDescription == null ? 43 : this.statusDescription.hashCode());
        result = result * 59 + (this.totalActiveLicenseUnitCount == null ? 43 : this.totalActiveLicenseUnitCount.hashCode());
        result = result * 59 + (this.lifecycleState == null ? 43 : this.lifecycleState.hashCode());
        result = result * 59 + (this.totalLicenseUnitsConsumed == null ? 43 : this.totalLicenseUnitsConsumed.hashCode());
        result = result * 59 + (this.totalLicenseRecordCount == null ? 43 : this.totalLicenseRecordCount.hashCode());
        result = result * 59 + (this.activeLicenseRecordCount == null ? 43 : this.activeLicenseRecordCount.hashCode());
        result = result * 59 + (this.licenseUnit == null ? 43 : this.licenseUnit.hashCode());
        result = result * 59 + (this.isVendorOracle == null ? 43 : this.isVendorOracle.hashCode());
        result = result * 59 + (this.isOverSubscribed == null ? 43 : this.isOverSubscribed.hashCode());
        result = result * 59 + (this.isUnlimited == null ? 43 : this.isUnlimited.hashCode());
        result = result * 59 + (this.displayName == null ? 43 : this.displayName.hashCode());
        result = result * 59 + (this.vendorName == null ? 43 : this.vendorName.hashCode());
        result = result * 59 + (this.timeCreated == null ? 43 : this.timeCreated.hashCode());
        result = result * 59 + (this.timeUpdated == null ? 43 : this.timeUpdated.hashCode());
        result = result * 59 + (this.images == null ? 43 : this.images.hashCode());
        result = result * 59 + (this.freeformTags == null ? 43 : this.freeformTags.hashCode());
        result = result * 59 + (this.definedTags == null ? 43 : this.definedTags.hashCode());
        result = result * 59 + (this.systemTags == null ? 43 : this.systemTags.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="id")
        private String id;
        @JsonProperty(value="compartmentId")
        private String compartmentId;
        @JsonProperty(value="status")
        private Status status;
        @JsonProperty(value="statusDescription")
        private String statusDescription;
        @JsonProperty(value="totalActiveLicenseUnitCount")
        private Integer totalActiveLicenseUnitCount;
        @JsonProperty(value="lifecycleState")
        private LifeCycleState lifecycleState;
        @JsonProperty(value="totalLicenseUnitsConsumed")
        private Double totalLicenseUnitsConsumed;
        @JsonProperty(value="totalLicenseRecordCount")
        private Integer totalLicenseRecordCount;
        @JsonProperty(value="activeLicenseRecordCount")
        private Integer activeLicenseRecordCount;
        @JsonProperty(value="licenseUnit")
        private LicenseUnit licenseUnit;
        @JsonProperty(value="isVendorOracle")
        private Boolean isVendorOracle;
        @JsonProperty(value="isOverSubscribed")
        private Boolean isOverSubscribed;
        @JsonProperty(value="isUnlimited")
        private Boolean isUnlimited;
        @JsonProperty(value="displayName")
        private String displayName;
        @JsonProperty(value="vendorName")
        private String vendorName;
        @JsonProperty(value="timeCreated")
        private Date timeCreated;
        @JsonProperty(value="timeUpdated")
        private Date timeUpdated;
        @JsonProperty(value="images")
        private List<ImageResponse> images;
        @JsonProperty(value="freeformTags")
        private Map<String, String> freeformTags;
        @JsonProperty(value="definedTags")
        private Map<String, Map<String, Object>> definedTags;
        @JsonProperty(value="systemTags")
        private Map<String, Map<String, Object>> systemTags;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder id(String id) {
            this.id = id;
            this.__explicitlySet__.add("id");
            return this;
        }

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            this.__explicitlySet__.add("compartmentId");
            return this;
        }

        public Builder status(Status status) {
            this.status = status;
            this.__explicitlySet__.add("status");
            return this;
        }

        public Builder statusDescription(String statusDescription) {
            this.statusDescription = statusDescription;
            this.__explicitlySet__.add("statusDescription");
            return this;
        }

        public Builder totalActiveLicenseUnitCount(Integer totalActiveLicenseUnitCount) {
            this.totalActiveLicenseUnitCount = totalActiveLicenseUnitCount;
            this.__explicitlySet__.add("totalActiveLicenseUnitCount");
            return this;
        }

        public Builder lifecycleState(LifeCycleState lifecycleState) {
            this.lifecycleState = lifecycleState;
            this.__explicitlySet__.add("lifecycleState");
            return this;
        }

        public Builder totalLicenseUnitsConsumed(Double totalLicenseUnitsConsumed) {
            this.totalLicenseUnitsConsumed = totalLicenseUnitsConsumed;
            this.__explicitlySet__.add("totalLicenseUnitsConsumed");
            return this;
        }

        public Builder totalLicenseRecordCount(Integer totalLicenseRecordCount) {
            this.totalLicenseRecordCount = totalLicenseRecordCount;
            this.__explicitlySet__.add("totalLicenseRecordCount");
            return this;
        }

        public Builder activeLicenseRecordCount(Integer activeLicenseRecordCount) {
            this.activeLicenseRecordCount = activeLicenseRecordCount;
            this.__explicitlySet__.add("activeLicenseRecordCount");
            return this;
        }

        public Builder licenseUnit(LicenseUnit licenseUnit) {
            this.licenseUnit = licenseUnit;
            this.__explicitlySet__.add("licenseUnit");
            return this;
        }

        public Builder isVendorOracle(Boolean isVendorOracle) {
            this.isVendorOracle = isVendorOracle;
            this.__explicitlySet__.add("isVendorOracle");
            return this;
        }

        public Builder isOverSubscribed(Boolean isOverSubscribed) {
            this.isOverSubscribed = isOverSubscribed;
            this.__explicitlySet__.add("isOverSubscribed");
            return this;
        }

        public Builder isUnlimited(Boolean isUnlimited) {
            this.isUnlimited = isUnlimited;
            this.__explicitlySet__.add("isUnlimited");
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.__explicitlySet__.add("displayName");
            return this;
        }

        public Builder vendorName(String vendorName) {
            this.vendorName = vendorName;
            this.__explicitlySet__.add("vendorName");
            return this;
        }

        public Builder timeCreated(Date timeCreated) {
            this.timeCreated = timeCreated;
            this.__explicitlySet__.add("timeCreated");
            return this;
        }

        public Builder timeUpdated(Date timeUpdated) {
            this.timeUpdated = timeUpdated;
            this.__explicitlySet__.add("timeUpdated");
            return this;
        }

        public Builder images(List<ImageResponse> images) {
            this.images = images;
            this.__explicitlySet__.add("images");
            return this;
        }

        public Builder freeformTags(Map<String, String> freeformTags) {
            this.freeformTags = freeformTags;
            this.__explicitlySet__.add("freeformTags");
            return this;
        }

        public Builder definedTags(Map<String, Map<String, Object>> definedTags) {
            this.definedTags = definedTags;
            this.__explicitlySet__.add("definedTags");
            return this;
        }

        public Builder systemTags(Map<String, Map<String, Object>> systemTags) {
            this.systemTags = systemTags;
            this.__explicitlySet__.add("systemTags");
            return this;
        }

        public ProductLicense build() {
            ProductLicense model = new ProductLicense(this.id, this.compartmentId, this.status, this.statusDescription, this.totalActiveLicenseUnitCount, this.lifecycleState, this.totalLicenseUnitsConsumed, this.totalLicenseRecordCount, this.activeLicenseRecordCount, this.licenseUnit, this.isVendorOracle, this.isOverSubscribed, this.isUnlimited, this.displayName, this.vendorName, this.timeCreated, this.timeUpdated, this.images, this.freeformTags, this.definedTags, this.systemTags);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(ProductLicense model) {
            if (model.wasPropertyExplicitlySet("id")) {
                this.id(model.getId());
            }
            if (model.wasPropertyExplicitlySet("compartmentId")) {
                this.compartmentId(model.getCompartmentId());
            }
            if (model.wasPropertyExplicitlySet("status")) {
                this.status(model.getStatus());
            }
            if (model.wasPropertyExplicitlySet("statusDescription")) {
                this.statusDescription(model.getStatusDescription());
            }
            if (model.wasPropertyExplicitlySet("totalActiveLicenseUnitCount")) {
                this.totalActiveLicenseUnitCount(model.getTotalActiveLicenseUnitCount());
            }
            if (model.wasPropertyExplicitlySet("lifecycleState")) {
                this.lifecycleState(model.getLifecycleState());
            }
            if (model.wasPropertyExplicitlySet("totalLicenseUnitsConsumed")) {
                this.totalLicenseUnitsConsumed(model.getTotalLicenseUnitsConsumed());
            }
            if (model.wasPropertyExplicitlySet("totalLicenseRecordCount")) {
                this.totalLicenseRecordCount(model.getTotalLicenseRecordCount());
            }
            if (model.wasPropertyExplicitlySet("activeLicenseRecordCount")) {
                this.activeLicenseRecordCount(model.getActiveLicenseRecordCount());
            }
            if (model.wasPropertyExplicitlySet("licenseUnit")) {
                this.licenseUnit(model.getLicenseUnit());
            }
            if (model.wasPropertyExplicitlySet("isVendorOracle")) {
                this.isVendorOracle(model.getIsVendorOracle());
            }
            if (model.wasPropertyExplicitlySet("isOverSubscribed")) {
                this.isOverSubscribed(model.getIsOverSubscribed());
            }
            if (model.wasPropertyExplicitlySet("isUnlimited")) {
                this.isUnlimited(model.getIsUnlimited());
            }
            if (model.wasPropertyExplicitlySet("displayName")) {
                this.displayName(model.getDisplayName());
            }
            if (model.wasPropertyExplicitlySet("vendorName")) {
                this.vendorName(model.getVendorName());
            }
            if (model.wasPropertyExplicitlySet("timeCreated")) {
                this.timeCreated(model.getTimeCreated());
            }
            if (model.wasPropertyExplicitlySet("timeUpdated")) {
                this.timeUpdated(model.getTimeUpdated());
            }
            if (model.wasPropertyExplicitlySet("images")) {
                this.images(model.getImages());
            }
            if (model.wasPropertyExplicitlySet("freeformTags")) {
                this.freeformTags(model.getFreeformTags());
            }
            if (model.wasPropertyExplicitlySet("definedTags")) {
                this.definedTags(model.getDefinedTags());
            }
            if (model.wasPropertyExplicitlySet("systemTags")) {
                this.systemTags(model.getSystemTags());
            }
            return this;
        }
    }
}

