/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.limits;

import com.oracle.bmc.ClientConfiguration;
import com.oracle.bmc.Region;
import com.oracle.bmc.Service;
import com.oracle.bmc.Services;
import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.auth.BasicAuthenticationDetailsProvider;
import com.oracle.bmc.common.ClientBuilderBase;
import com.oracle.bmc.common.RegionalClientBuilder;
import com.oracle.bmc.http.ClientConfigurator;
import com.oracle.bmc.http.client.Method;
import com.oracle.bmc.http.internal.BaseAsyncClient;
import com.oracle.bmc.http.internal.BmcEnum;
import com.oracle.bmc.http.signing.RequestSignerFactory;
import com.oracle.bmc.http.signing.SigningStrategy;
import com.oracle.bmc.http.signing.internal.DefaultRequestSignerFactory;
import com.oracle.bmc.internal.Alloy;
import com.oracle.bmc.limits.QuotasAsync;
import com.oracle.bmc.limits.model.Quota;
import com.oracle.bmc.limits.model.QuotaSummary;
import com.oracle.bmc.limits.requests.AddQuotaLockRequest;
import com.oracle.bmc.limits.requests.CreateQuotaRequest;
import com.oracle.bmc.limits.requests.DeleteQuotaRequest;
import com.oracle.bmc.limits.requests.GetQuotaRequest;
import com.oracle.bmc.limits.requests.ListQuotasRequest;
import com.oracle.bmc.limits.requests.RemoveQuotaLockRequest;
import com.oracle.bmc.limits.requests.UpdateQuotaRequest;
import com.oracle.bmc.limits.responses.AddQuotaLockResponse;
import com.oracle.bmc.limits.responses.CreateQuotaResponse;
import com.oracle.bmc.limits.responses.DeleteQuotaResponse;
import com.oracle.bmc.limits.responses.GetQuotaResponse;
import com.oracle.bmc.limits.responses.ListQuotasResponse;
import com.oracle.bmc.limits.responses.RemoveQuotaLockResponse;
import com.oracle.bmc.limits.responses.UpdateQuotaResponse;
import com.oracle.bmc.responses.AsyncHandler;
import com.oracle.bmc.util.internal.Validate;
import jakarta.annotation.Nonnull;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Future;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QuotasAsyncClient
extends BaseAsyncClient
implements QuotasAsync {
    public static final Service SERVICE = Services.serviceBuilder().serviceName("QUOTAS").serviceEndpointPrefix("").serviceEndpointTemplate("https://limits.{region}.oci.{secondLevelDomain}").build();
    private static final Logger LOG = LoggerFactory.getLogger(QuotasAsyncClient.class);

    QuotasAsyncClient(ClientBuilderBase<?, ?> builder, AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
        super(builder, authenticationDetailsProvider);
    }

    public static Builder builder() {
        return new Builder(SERVICE);
    }

    @Override
    public void setRegion(Region region) {
        super.setRegion(region);
    }

    @Override
    public void setRegion(String regionId) {
        super.setRegion(regionId);
    }

    @Override
    public Future<AddQuotaLockResponse> addQuotaLock(AddQuotaLockRequest request, AsyncHandler<AddQuotaLockRequest, AddQuotaLockResponse> handler) {
        Validate.notBlank((String)request.getQuotaId(), (String)"quotaId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getAddLockDetails(), "addLockDetails is required");
        return this.clientCall(request, AddQuotaLockResponse::builder).logger(LOG, "addQuotaLock").serviceDetails("Quotas", "AddQuotaLock", "https://docs.oracle.com/iaas/api/#/en/limits/20181025/Quota/AddQuotaLock").method(Method.POST).requestBuilder(AddQuotaLockRequest::builder).basePath("/").appendPathParam("20181025").appendPathParam("quotas").appendPathParam(request.getQuotaId()).appendPathParam("actions").appendPathParam("addLock").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("if-match", request.getIfMatch()).hasBody().handleBody(Quota.class, AddQuotaLockResponse.Builder::quota).handleResponseHeaderString("etag", AddQuotaLockResponse.Builder::etag).handleResponseHeaderString("opc-request-id", AddQuotaLockResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<CreateQuotaResponse> createQuota(CreateQuotaRequest request, AsyncHandler<CreateQuotaRequest, CreateQuotaResponse> handler) {
        Objects.requireNonNull(request.getCreateQuotaDetails(), "createQuotaDetails is required");
        return this.clientCall(request, CreateQuotaResponse::builder).logger(LOG, "createQuota").serviceDetails("Quotas", "CreateQuota", "https://docs.oracle.com/iaas/api/#/en/limits/20181025/Quota/CreateQuota").method(Method.POST).requestBuilder(CreateQuotaRequest::builder).basePath("/").appendPathParam("20181025").appendPathParam("quotas").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBody().handleBody(Quota.class, CreateQuotaResponse.Builder::quota).handleResponseHeaderString("opc-request-id", CreateQuotaResponse.Builder::opcRequestId).handleResponseHeaderString("etag", CreateQuotaResponse.Builder::etag).callAsync(handler);
    }

    @Override
    public Future<DeleteQuotaResponse> deleteQuota(DeleteQuotaRequest request, AsyncHandler<DeleteQuotaRequest, DeleteQuotaResponse> handler) {
        Validate.notBlank((String)request.getQuotaId(), (String)"quotaId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, DeleteQuotaResponse::builder).logger(LOG, "deleteQuota").serviceDetails("Quotas", "DeleteQuota", "https://docs.oracle.com/iaas/api/#/en/limits/20181025/Quota/DeleteQuota").method(Method.DELETE).requestBuilder(DeleteQuotaRequest::builder).basePath("/").appendPathParam("20181025").appendPathParam("quotas").appendPathParam(request.getQuotaId()).appendQueryParam("isLockOverride", (Object)request.getIsLockOverride()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("if-match", request.getIfMatch()).handleResponseHeaderString("opc-request-id", DeleteQuotaResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<GetQuotaResponse> getQuota(GetQuotaRequest request, AsyncHandler<GetQuotaRequest, GetQuotaResponse> handler) {
        Validate.notBlank((String)request.getQuotaId(), (String)"quotaId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, GetQuotaResponse::builder).logger(LOG, "getQuota").serviceDetails("Quotas", "GetQuota", "https://docs.oracle.com/iaas/api/#/en/limits/20181025/Quota/GetQuota").method(Method.GET).requestBuilder(GetQuotaRequest::builder).basePath("/").appendPathParam("20181025").appendPathParam("quotas").appendPathParam(request.getQuotaId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(Quota.class, GetQuotaResponse.Builder::quota).handleResponseHeaderString("opc-request-id", GetQuotaResponse.Builder::opcRequestId).handleResponseHeaderString("etag", GetQuotaResponse.Builder::etag).callAsync(handler);
    }

    @Override
    public Future<ListQuotasResponse> listQuotas(ListQuotasRequest request, AsyncHandler<ListQuotasRequest, ListQuotasResponse> handler) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return this.clientCall(request, ListQuotasResponse::builder).logger(LOG, "listQuotas").serviceDetails("Quotas", "ListQuotas", "https://docs.oracle.com/iaas/api/#/en/limits/20181025/QuotaSummary/ListQuotas").method(Method.GET).requestBuilder(ListQuotasRequest::builder).basePath("/").appendPathParam("20181025").appendPathParam("quotas").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("page", (Object)request.getPage()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("name", (Object)request.getName()).appendEnumQueryParam("lifecycleState", (BmcEnum)request.getLifecycleState()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBodyList(QuotaSummary.class, ListQuotasResponse.Builder::items).handleResponseHeaderString("opc-next-page", ListQuotasResponse.Builder::opcNextPage).handleResponseHeaderString("opc-request-id", ListQuotasResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<RemoveQuotaLockResponse> removeQuotaLock(RemoveQuotaLockRequest request, AsyncHandler<RemoveQuotaLockRequest, RemoveQuotaLockResponse> handler) {
        Validate.notBlank((String)request.getQuotaId(), (String)"quotaId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getRemoveLockDetails(), "removeLockDetails is required");
        return this.clientCall(request, RemoveQuotaLockResponse::builder).logger(LOG, "removeQuotaLock").serviceDetails("Quotas", "RemoveQuotaLock", "https://docs.oracle.com/iaas/api/#/en/limits/20181025/Quota/RemoveQuotaLock").method(Method.POST).requestBuilder(RemoveQuotaLockRequest::builder).basePath("/").appendPathParam("20181025").appendPathParam("quotas").appendPathParam(request.getQuotaId()).appendPathParam("actions").appendPathParam("removeLock").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("if-match", request.getIfMatch()).hasBody().handleBody(Quota.class, RemoveQuotaLockResponse.Builder::quota).handleResponseHeaderString("etag", RemoveQuotaLockResponse.Builder::etag).handleResponseHeaderString("opc-request-id", RemoveQuotaLockResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<UpdateQuotaResponse> updateQuota(UpdateQuotaRequest request, AsyncHandler<UpdateQuotaRequest, UpdateQuotaResponse> handler) {
        Validate.notBlank((String)request.getQuotaId(), (String)"quotaId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdateQuotaDetails(), "updateQuotaDetails is required");
        return this.clientCall(request, UpdateQuotaResponse::builder).logger(LOG, "updateQuota").serviceDetails("Quotas", "UpdateQuota", "https://docs.oracle.com/iaas/api/#/en/limits/20181025/Quota/UpdateQuota").method(Method.PUT).requestBuilder(UpdateQuotaRequest::builder).basePath("/").appendPathParam("20181025").appendPathParam("quotas").appendPathParam(request.getQuotaId()).appendQueryParam("isLockOverride", (Object)request.getIsLockOverride()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("if-match", request.getIfMatch()).hasBody().handleBody(Quota.class, UpdateQuotaResponse.Builder::quota).handleResponseHeaderString("opc-request-id", UpdateQuotaResponse.Builder::opcRequestId).handleResponseHeaderString("etag", UpdateQuotaResponse.Builder::etag).callAsync(handler);
    }

    @Deprecated
    public QuotasAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider) {
        this((ClientBuilderBase<?, ?>)QuotasAsyncClient.builder(), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider);
    }

    @Deprecated
    public QuotasAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration) {
        this(QuotasAsyncClient.builder().configuration(configuration), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider);
    }

    @Deprecated
    public QuotasAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator) {
        this(((Builder)QuotasAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider);
    }

    @Deprecated
    public QuotasAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory) {
        this(((Builder)((Builder)QuotasAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory), authenticationDetailsProvider);
    }

    @Deprecated
    public QuotasAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators) {
        this(((Builder)((Builder)((Builder)QuotasAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators), authenticationDetailsProvider);
    }

    @Deprecated
    public QuotasAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(((Builder)((Builder)((Builder)((Builder)QuotasAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint), authenticationDetailsProvider);
    }

    @Deprecated
    public QuotasAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(((Builder)((Builder)((Builder)((Builder)((Builder)QuotasAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint)).signingStrategyRequestSignerFactories(signingStrategyRequestSignerFactories), authenticationDetailsProvider);
    }

    public static class Builder
    extends RegionalClientBuilder<Builder, QuotasAsyncClient> {
        private Builder(Service service) {
            super(service);
            String packageName = "limits";
            Alloy.throwDisabledServiceExceptionIfAppropriate((String)"limits");
            this.requestSignerFactory = new DefaultRequestSignerFactory(SigningStrategy.STANDARD);
        }

        public QuotasAsyncClient build(@Nonnull AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
            return new QuotasAsyncClient((ClientBuilderBase<?, ?>)this, authenticationDetailsProvider);
        }
    }
}

