/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.limits.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.http.internal.BmcEnum;
import java.beans.ConstructorProperties;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class LimitDefinitionSummary
extends ExplicitlySetBmcModel {
    @JsonProperty(value="name")
    private final String name;
    @JsonProperty(value="serviceName")
    private final String serviceName;
    @JsonProperty(value="description")
    private final String description;
    @JsonProperty(value="scopeType")
    private final ScopeType scopeType;
    @JsonProperty(value="areQuotasSupported")
    private final Boolean areQuotasSupported;
    @JsonProperty(value="isResourceAvailabilitySupported")
    private final Boolean isResourceAvailabilitySupported;
    @JsonProperty(value="isDeprecated")
    private final Boolean isDeprecated;
    @JsonProperty(value="isEligibleForLimitIncrease")
    private final Boolean isEligibleForLimitIncrease;
    @JsonProperty(value="isDynamic")
    private final Boolean isDynamic;
    @JsonProperty(value="supportedSubscriptions")
    private final List<String> supportedSubscriptions;
    @JsonProperty(value="supportedQuotaFamilies")
    private final List<String> supportedQuotaFamilies;

    @Deprecated
    @ConstructorProperties(value={"name", "serviceName", "description", "scopeType", "areQuotasSupported", "isResourceAvailabilitySupported", "isDeprecated", "isEligibleForLimitIncrease", "isDynamic", "supportedSubscriptions", "supportedQuotaFamilies"})
    public LimitDefinitionSummary(String name, String serviceName, String description, ScopeType scopeType, Boolean areQuotasSupported, Boolean isResourceAvailabilitySupported, Boolean isDeprecated, Boolean isEligibleForLimitIncrease, Boolean isDynamic, List<String> supportedSubscriptions, List<String> supportedQuotaFamilies) {
        this.name = name;
        this.serviceName = serviceName;
        this.description = description;
        this.scopeType = scopeType;
        this.areQuotasSupported = areQuotasSupported;
        this.isResourceAvailabilitySupported = isResourceAvailabilitySupported;
        this.isDeprecated = isDeprecated;
        this.isEligibleForLimitIncrease = isEligibleForLimitIncrease;
        this.isDynamic = isDynamic;
        this.supportedSubscriptions = supportedSubscriptions;
        this.supportedQuotaFamilies = supportedQuotaFamilies;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getName() {
        return this.name;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public String getDescription() {
        return this.description;
    }

    public ScopeType getScopeType() {
        return this.scopeType;
    }

    public Boolean getAreQuotasSupported() {
        return this.areQuotasSupported;
    }

    public Boolean getIsResourceAvailabilitySupported() {
        return this.isResourceAvailabilitySupported;
    }

    public Boolean getIsDeprecated() {
        return this.isDeprecated;
    }

    public Boolean getIsEligibleForLimitIncrease() {
        return this.isEligibleForLimitIncrease;
    }

    public Boolean getIsDynamic() {
        return this.isDynamic;
    }

    public List<String> getSupportedSubscriptions() {
        return this.supportedSubscriptions;
    }

    public List<String> getSupportedQuotaFamilies() {
        return this.supportedQuotaFamilies;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("LimitDefinitionSummary(");
        sb.append("super=").append(super.toString());
        sb.append("name=").append(String.valueOf(this.name));
        sb.append(", serviceName=").append(String.valueOf(this.serviceName));
        sb.append(", description=").append(String.valueOf(this.description));
        sb.append(", scopeType=").append(String.valueOf((Object)this.scopeType));
        sb.append(", areQuotasSupported=").append(String.valueOf(this.areQuotasSupported));
        sb.append(", isResourceAvailabilitySupported=").append(String.valueOf(this.isResourceAvailabilitySupported));
        sb.append(", isDeprecated=").append(String.valueOf(this.isDeprecated));
        sb.append(", isEligibleForLimitIncrease=").append(String.valueOf(this.isEligibleForLimitIncrease));
        sb.append(", isDynamic=").append(String.valueOf(this.isDynamic));
        sb.append(", supportedSubscriptions=").append(String.valueOf(this.supportedSubscriptions));
        sb.append(", supportedQuotaFamilies=").append(String.valueOf(this.supportedQuotaFamilies));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof LimitDefinitionSummary)) {
            return false;
        }
        LimitDefinitionSummary other = (LimitDefinitionSummary)((Object)o);
        return Objects.equals(this.name, other.name) && Objects.equals(this.serviceName, other.serviceName) && Objects.equals(this.description, other.description) && Objects.equals((Object)this.scopeType, (Object)other.scopeType) && Objects.equals(this.areQuotasSupported, other.areQuotasSupported) && Objects.equals(this.isResourceAvailabilitySupported, other.isResourceAvailabilitySupported) && Objects.equals(this.isDeprecated, other.isDeprecated) && Objects.equals(this.isEligibleForLimitIncrease, other.isEligibleForLimitIncrease) && Objects.equals(this.isDynamic, other.isDynamic) && Objects.equals(this.supportedSubscriptions, other.supportedSubscriptions) && Objects.equals(this.supportedQuotaFamilies, other.supportedQuotaFamilies) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.name == null ? 43 : this.name.hashCode());
        result = result * 59 + (this.serviceName == null ? 43 : this.serviceName.hashCode());
        result = result * 59 + (this.description == null ? 43 : this.description.hashCode());
        result = result * 59 + (this.scopeType == null ? 43 : this.scopeType.hashCode());
        result = result * 59 + (this.areQuotasSupported == null ? 43 : this.areQuotasSupported.hashCode());
        result = result * 59 + (this.isResourceAvailabilitySupported == null ? 43 : this.isResourceAvailabilitySupported.hashCode());
        result = result * 59 + (this.isDeprecated == null ? 43 : this.isDeprecated.hashCode());
        result = result * 59 + (this.isEligibleForLimitIncrease == null ? 43 : this.isEligibleForLimitIncrease.hashCode());
        result = result * 59 + (this.isDynamic == null ? 43 : this.isDynamic.hashCode());
        result = result * 59 + (this.supportedSubscriptions == null ? 43 : this.supportedSubscriptions.hashCode());
        result = result * 59 + (this.supportedQuotaFamilies == null ? 43 : this.supportedQuotaFamilies.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    public static enum ScopeType implements BmcEnum
    {
        Global("GLOBAL"),
        Region("REGION"),
        Ad("AD"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, ScopeType> map;

        private ScopeType(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static ScopeType create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'ScopeType', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(ScopeType.class);
            map = new HashMap<String, ScopeType>();
            for (ScopeType v : ScopeType.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="name")
        private String name;
        @JsonProperty(value="serviceName")
        private String serviceName;
        @JsonProperty(value="description")
        private String description;
        @JsonProperty(value="scopeType")
        private ScopeType scopeType;
        @JsonProperty(value="areQuotasSupported")
        private Boolean areQuotasSupported;
        @JsonProperty(value="isResourceAvailabilitySupported")
        private Boolean isResourceAvailabilitySupported;
        @JsonProperty(value="isDeprecated")
        private Boolean isDeprecated;
        @JsonProperty(value="isEligibleForLimitIncrease")
        private Boolean isEligibleForLimitIncrease;
        @JsonProperty(value="isDynamic")
        private Boolean isDynamic;
        @JsonProperty(value="supportedSubscriptions")
        private List<String> supportedSubscriptions;
        @JsonProperty(value="supportedQuotaFamilies")
        private List<String> supportedQuotaFamilies;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder name(String name) {
            this.name = name;
            this.__explicitlySet__.add("name");
            return this;
        }

        public Builder serviceName(String serviceName) {
            this.serviceName = serviceName;
            this.__explicitlySet__.add("serviceName");
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            this.__explicitlySet__.add("description");
            return this;
        }

        public Builder scopeType(ScopeType scopeType) {
            this.scopeType = scopeType;
            this.__explicitlySet__.add("scopeType");
            return this;
        }

        public Builder areQuotasSupported(Boolean areQuotasSupported) {
            this.areQuotasSupported = areQuotasSupported;
            this.__explicitlySet__.add("areQuotasSupported");
            return this;
        }

        public Builder isResourceAvailabilitySupported(Boolean isResourceAvailabilitySupported) {
            this.isResourceAvailabilitySupported = isResourceAvailabilitySupported;
            this.__explicitlySet__.add("isResourceAvailabilitySupported");
            return this;
        }

        public Builder isDeprecated(Boolean isDeprecated) {
            this.isDeprecated = isDeprecated;
            this.__explicitlySet__.add("isDeprecated");
            return this;
        }

        public Builder isEligibleForLimitIncrease(Boolean isEligibleForLimitIncrease) {
            this.isEligibleForLimitIncrease = isEligibleForLimitIncrease;
            this.__explicitlySet__.add("isEligibleForLimitIncrease");
            return this;
        }

        public Builder isDynamic(Boolean isDynamic) {
            this.isDynamic = isDynamic;
            this.__explicitlySet__.add("isDynamic");
            return this;
        }

        public Builder supportedSubscriptions(List<String> supportedSubscriptions) {
            this.supportedSubscriptions = supportedSubscriptions;
            this.__explicitlySet__.add("supportedSubscriptions");
            return this;
        }

        public Builder supportedQuotaFamilies(List<String> supportedQuotaFamilies) {
            this.supportedQuotaFamilies = supportedQuotaFamilies;
            this.__explicitlySet__.add("supportedQuotaFamilies");
            return this;
        }

        public LimitDefinitionSummary build() {
            LimitDefinitionSummary model = new LimitDefinitionSummary(this.name, this.serviceName, this.description, this.scopeType, this.areQuotasSupported, this.isResourceAvailabilitySupported, this.isDeprecated, this.isEligibleForLimitIncrease, this.isDynamic, this.supportedSubscriptions, this.supportedQuotaFamilies);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(LimitDefinitionSummary model) {
            if (model.wasPropertyExplicitlySet("name")) {
                this.name(model.getName());
            }
            if (model.wasPropertyExplicitlySet("serviceName")) {
                this.serviceName(model.getServiceName());
            }
            if (model.wasPropertyExplicitlySet("description")) {
                this.description(model.getDescription());
            }
            if (model.wasPropertyExplicitlySet("scopeType")) {
                this.scopeType(model.getScopeType());
            }
            if (model.wasPropertyExplicitlySet("areQuotasSupported")) {
                this.areQuotasSupported(model.getAreQuotasSupported());
            }
            if (model.wasPropertyExplicitlySet("isResourceAvailabilitySupported")) {
                this.isResourceAvailabilitySupported(model.getIsResourceAvailabilitySupported());
            }
            if (model.wasPropertyExplicitlySet("isDeprecated")) {
                this.isDeprecated(model.getIsDeprecated());
            }
            if (model.wasPropertyExplicitlySet("isEligibleForLimitIncrease")) {
                this.isEligibleForLimitIncrease(model.getIsEligibleForLimitIncrease());
            }
            if (model.wasPropertyExplicitlySet("isDynamic")) {
                this.isDynamic(model.getIsDynamic());
            }
            if (model.wasPropertyExplicitlySet("supportedSubscriptions")) {
                this.supportedSubscriptions(model.getSupportedSubscriptions());
            }
            if (model.wasPropertyExplicitlySet("supportedQuotaFamilies")) {
                this.supportedQuotaFamilies(model.getSupportedQuotaFamilies());
            }
            return this;
        }
    }
}

