/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.limits.requests;

import com.oracle.bmc.InternalSdk;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.limits.model.AddLockDetails;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class AddQuotaLockRequest
extends BmcRequest<AddLockDetails> {
    private String quotaId;
    private AddLockDetails addLockDetails;
    private String opcRequestId;
    private String ifMatch;

    public String getQuotaId() {
        return this.quotaId;
    }

    public AddLockDetails getAddLockDetails() {
        return this.addLockDetails;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public String getIfMatch() {
        return this.ifMatch;
    }

    @InternalSdk
    public AddLockDetails getBody$() {
        return this.addLockDetails;
    }

    public Builder toBuilder() {
        return new Builder().quotaId(this.quotaId).addLockDetails(this.addLockDetails).opcRequestId(this.opcRequestId).ifMatch(this.ifMatch);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",quotaId=").append(String.valueOf(this.quotaId));
        sb.append(",addLockDetails=").append(String.valueOf((Object)this.addLockDetails));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(",ifMatch=").append(String.valueOf(this.ifMatch));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof AddQuotaLockRequest)) {
            return false;
        }
        AddQuotaLockRequest other = (AddQuotaLockRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.quotaId, other.quotaId) && Objects.equals((Object)this.addLockDetails, (Object)other.addLockDetails) && Objects.equals(this.opcRequestId, other.opcRequestId) && Objects.equals(this.ifMatch, other.ifMatch);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.quotaId == null ? 43 : this.quotaId.hashCode());
        result = result * 59 + (this.addLockDetails == null ? 43 : this.addLockDetails.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        result = result * 59 + (this.ifMatch == null ? 43 : this.ifMatch.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<AddQuotaLockRequest, AddLockDetails> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String quotaId = null;
        private AddLockDetails addLockDetails = null;
        private String opcRequestId = null;
        private String ifMatch = null;

        public Builder quotaId(String quotaId) {
            this.quotaId = quotaId;
            return this;
        }

        public Builder addLockDetails(AddLockDetails addLockDetails) {
            this.addLockDetails = addLockDetails;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(AddQuotaLockRequest o) {
            this.quotaId(o.getQuotaId());
            this.addLockDetails(o.getAddLockDetails());
            this.opcRequestId(o.getOpcRequestId());
            this.ifMatch(o.getIfMatch());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public AddQuotaLockRequest build() {
            AddQuotaLockRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        @InternalSdk
        public Builder body$(AddLockDetails body) {
            this.addLockDetails(body);
            return this;
        }

        public AddQuotaLockRequest buildWithoutInvocationCallback() {
            AddQuotaLockRequest request = new AddQuotaLockRequest();
            request.quotaId = this.quotaId;
            request.addLockDetails = this.addLockDetails;
            request.opcRequestId = this.opcRequestId;
            request.ifMatch = this.ifMatch;
            return request;
        }
    }
}

