/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.limits;

import com.oracle.bmc.ClientConfiguration;
import com.oracle.bmc.Region;
import com.oracle.bmc.Service;
import com.oracle.bmc.Services;
import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.auth.BasicAuthenticationDetailsProvider;
import com.oracle.bmc.common.ClientBuilderBase;
import com.oracle.bmc.common.RegionalClientBuilder;
import com.oracle.bmc.http.ClientConfigurator;
import com.oracle.bmc.http.client.Method;
import com.oracle.bmc.http.internal.BaseSyncClient;
import com.oracle.bmc.http.internal.BmcEnum;
import com.oracle.bmc.http.signing.RequestSignerFactory;
import com.oracle.bmc.http.signing.SigningStrategy;
import com.oracle.bmc.http.signing.internal.DefaultRequestSignerFactory;
import com.oracle.bmc.internal.Alloy;
import com.oracle.bmc.limits.Limits;
import com.oracle.bmc.limits.LimitsPaginators;
import com.oracle.bmc.limits.model.LimitDefinitionSummary;
import com.oracle.bmc.limits.model.LimitValueSummary;
import com.oracle.bmc.limits.model.ResourceAvailability;
import com.oracle.bmc.limits.model.ServiceSummary;
import com.oracle.bmc.limits.requests.GetResourceAvailabilityRequest;
import com.oracle.bmc.limits.requests.ListLimitDefinitionsRequest;
import com.oracle.bmc.limits.requests.ListLimitValuesRequest;
import com.oracle.bmc.limits.requests.ListServicesRequest;
import com.oracle.bmc.limits.responses.GetResourceAvailabilityResponse;
import com.oracle.bmc.limits.responses.ListLimitDefinitionsResponse;
import com.oracle.bmc.limits.responses.ListLimitValuesResponse;
import com.oracle.bmc.limits.responses.ListServicesResponse;
import com.oracle.bmc.util.CircuitBreakerUtils;
import com.oracle.bmc.util.internal.Validate;
import jakarta.annotation.Nonnull;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LimitsClient
extends BaseSyncClient
implements Limits {
    public static final Service SERVICE = Services.serviceBuilder().serviceName("LIMITS").serviceEndpointPrefix("").serviceEndpointTemplate("https://limits.{region}.oci.{secondLevelDomain}").build();
    private static final Logger LOG = LoggerFactory.getLogger(LimitsClient.class);
    private final LimitsPaginators paginators = new LimitsPaginators(this);

    LimitsClient(ClientBuilderBase<?, ?> builder, AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
        super(builder, authenticationDetailsProvider, CircuitBreakerUtils.DEFAULT_CIRCUIT_BREAKER_CONFIGURATION);
    }

    public static Builder builder() {
        return new Builder(SERVICE);
    }

    @Override
    public void setRegion(Region region) {
        super.setRegion(region);
    }

    @Override
    public void setRegion(String regionId) {
        super.setRegion(regionId);
    }

    @Override
    public GetResourceAvailabilityResponse getResourceAvailability(GetResourceAvailabilityRequest request) {
        Validate.notBlank((String)request.getServiceName(), (String)"serviceName must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getLimitName(), (String)"limitName must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return (GetResourceAvailabilityResponse)this.clientCall(request, GetResourceAvailabilityResponse::builder).logger(LOG, "getResourceAvailability").serviceDetails("Limits", "GetResourceAvailability", "https://docs.oracle.com/iaas/api/#/en/limits/20181025/ResourceAvailability/GetResourceAvailability").method(Method.GET).requestBuilder(GetResourceAvailabilityRequest::builder).basePath("/").appendPathParam("20190729").appendPathParam("services").appendPathParam(request.getServiceName()).appendPathParam("limits").appendPathParam(request.getLimitName()).appendPathParam("resourceAvailability").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("availabilityDomain", (Object)request.getAvailabilityDomain()).appendQueryParam("subscriptionId", (Object)request.getSubscriptionId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleBody(ResourceAvailability.class, GetResourceAvailabilityResponse.Builder::resourceAvailability).handleResponseHeaderString("opc-request-id", GetResourceAvailabilityResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public ListLimitDefinitionsResponse listLimitDefinitions(ListLimitDefinitionsRequest request) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return (ListLimitDefinitionsResponse)this.clientCall(request, ListLimitDefinitionsResponse::builder).logger(LOG, "listLimitDefinitions").serviceDetails("Limits", "ListLimitDefinitions", "https://docs.oracle.com/iaas/api/#/en/limits/20181025/LimitDefinitionSummary/ListLimitDefinitions").method(Method.GET).requestBuilder(ListLimitDefinitionsRequest::builder).basePath("/").appendPathParam("20190729").appendPathParam("limitDefinitions").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("subscriptionId", (Object)request.getSubscriptionId()).appendQueryParam("serviceName", (Object)request.getServiceName()).appendQueryParam("name", (Object)request.getName()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleBodyList(LimitDefinitionSummary.class, ListLimitDefinitionsResponse.Builder::items).handleResponseHeaderString("opc-next-page", ListLimitDefinitionsResponse.Builder::opcNextPage).handleResponseHeaderString("opc-request-id", ListLimitDefinitionsResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public ListLimitValuesResponse listLimitValues(ListLimitValuesRequest request) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        Objects.requireNonNull(request.getServiceName(), "serviceName is required");
        return (ListLimitValuesResponse)this.clientCall(request, ListLimitValuesResponse::builder).logger(LOG, "listLimitValues").serviceDetails("Limits", "ListLimitValues", "https://docs.oracle.com/iaas/api/#/en/limits/20181025/LimitValueSummary/ListLimitValues").method(Method.GET).requestBuilder(ListLimitValuesRequest::builder).basePath("/").appendPathParam("20190729").appendPathParam("limitValues").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("subscriptionId", (Object)request.getSubscriptionId()).appendQueryParam("serviceName", (Object)request.getServiceName()).appendEnumQueryParam("scopeType", (BmcEnum)request.getScopeType()).appendQueryParam("availabilityDomain", (Object)request.getAvailabilityDomain()).appendQueryParam("name", (Object)request.getName()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleBodyList(LimitValueSummary.class, ListLimitValuesResponse.Builder::items).handleResponseHeaderString("opc-next-page", ListLimitValuesResponse.Builder::opcNextPage).handleResponseHeaderString("opc-request-id", ListLimitValuesResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public ListServicesResponse listServices(ListServicesRequest request) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return (ListServicesResponse)this.clientCall(request, ListServicesResponse::builder).logger(LOG, "listServices").serviceDetails("Limits", "ListServices", "https://docs.oracle.com/iaas/api/#/en/limits/20181025/ServiceSummary/ListServices").method(Method.GET).requestBuilder(ListServicesRequest::builder).basePath("/").appendPathParam("20190729").appendPathParam("services").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendQueryParam("subscriptionId", (Object)request.getSubscriptionId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleBodyList(ServiceSummary.class, ListServicesResponse.Builder::items).handleResponseHeaderString("opc-next-page", ListServicesResponse.Builder::opcNextPage).handleResponseHeaderString("opc-request-id", ListServicesResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public LimitsPaginators getPaginators() {
        return this.paginators;
    }

    @Deprecated
    public LimitsClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider) {
        this((ClientBuilderBase<?, ?>)LimitsClient.builder(), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider);
    }

    @Deprecated
    public LimitsClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration) {
        this(LimitsClient.builder().configuration(configuration), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider);
    }

    @Deprecated
    public LimitsClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator) {
        this(((Builder)LimitsClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider);
    }

    @Deprecated
    public LimitsClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory) {
        this(((Builder)((Builder)LimitsClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory), authenticationDetailsProvider);
    }

    @Deprecated
    public LimitsClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators) {
        this(((Builder)((Builder)((Builder)LimitsClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators), authenticationDetailsProvider);
    }

    @Deprecated
    public LimitsClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(((Builder)((Builder)((Builder)((Builder)LimitsClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint), authenticationDetailsProvider);
    }

    @Deprecated
    public LimitsClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(((Builder)((Builder)((Builder)((Builder)((Builder)LimitsClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint)).signingStrategyRequestSignerFactories(signingStrategyRequestSignerFactories), authenticationDetailsProvider);
    }

    public static class Builder
    extends RegionalClientBuilder<Builder, LimitsClient> {
        private Builder(Service service) {
            super(service);
            String packageName = "limits";
            Alloy.throwDisabledServiceExceptionIfAppropriate((String)"limits");
            this.requestSignerFactory = new DefaultRequestSignerFactory(SigningStrategy.STANDARD);
        }

        public LimitsClient build(@Nonnull AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
            return new LimitsClient((ClientBuilderBase<?, ?>)this, authenticationDetailsProvider);
        }
    }
}

