/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.loadbalancer.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.http.internal.BmcEnum;
import java.beans.ConstructorProperties;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class SSLConfiguration
extends ExplicitlySetBmcModel {
    @JsonProperty(value="verifyDepth")
    private final Integer verifyDepth;
    @JsonProperty(value="verifyPeerCertificate")
    private final Boolean verifyPeerCertificate;
    @JsonProperty(value="trustedCertificateAuthorityIds")
    private final List<String> trustedCertificateAuthorityIds;
    @JsonProperty(value="certificateIds")
    private final List<String> certificateIds;
    @JsonProperty(value="certificateName")
    private final String certificateName;
    @JsonProperty(value="serverOrderPreference")
    private final ServerOrderPreference serverOrderPreference;
    @JsonProperty(value="cipherSuiteName")
    private final String cipherSuiteName;
    @JsonProperty(value="protocols")
    private final List<String> protocols;

    @Deprecated
    @ConstructorProperties(value={"verifyDepth", "verifyPeerCertificate", "trustedCertificateAuthorityIds", "certificateIds", "certificateName", "serverOrderPreference", "cipherSuiteName", "protocols"})
    public SSLConfiguration(Integer verifyDepth, Boolean verifyPeerCertificate, List<String> trustedCertificateAuthorityIds, List<String> certificateIds, String certificateName, ServerOrderPreference serverOrderPreference, String cipherSuiteName, List<String> protocols) {
        this.verifyDepth = verifyDepth;
        this.verifyPeerCertificate = verifyPeerCertificate;
        this.trustedCertificateAuthorityIds = trustedCertificateAuthorityIds;
        this.certificateIds = certificateIds;
        this.certificateName = certificateName;
        this.serverOrderPreference = serverOrderPreference;
        this.cipherSuiteName = cipherSuiteName;
        this.protocols = protocols;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public Integer getVerifyDepth() {
        return this.verifyDepth;
    }

    public Boolean getVerifyPeerCertificate() {
        return this.verifyPeerCertificate;
    }

    public List<String> getTrustedCertificateAuthorityIds() {
        return this.trustedCertificateAuthorityIds;
    }

    public List<String> getCertificateIds() {
        return this.certificateIds;
    }

    public String getCertificateName() {
        return this.certificateName;
    }

    public ServerOrderPreference getServerOrderPreference() {
        return this.serverOrderPreference;
    }

    public String getCipherSuiteName() {
        return this.cipherSuiteName;
    }

    public List<String> getProtocols() {
        return this.protocols;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("SSLConfiguration(");
        sb.append("super=").append(super.toString());
        sb.append("verifyDepth=").append(String.valueOf(this.verifyDepth));
        sb.append(", verifyPeerCertificate=").append(String.valueOf(this.verifyPeerCertificate));
        sb.append(", trustedCertificateAuthorityIds=").append(String.valueOf(this.trustedCertificateAuthorityIds));
        sb.append(", certificateIds=").append(String.valueOf(this.certificateIds));
        sb.append(", certificateName=").append(String.valueOf(this.certificateName));
        sb.append(", serverOrderPreference=").append(String.valueOf((Object)this.serverOrderPreference));
        sb.append(", cipherSuiteName=").append(String.valueOf(this.cipherSuiteName));
        sb.append(", protocols=").append(String.valueOf(this.protocols));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SSLConfiguration)) {
            return false;
        }
        SSLConfiguration other = (SSLConfiguration)((Object)o);
        return Objects.equals(this.verifyDepth, other.verifyDepth) && Objects.equals(this.verifyPeerCertificate, other.verifyPeerCertificate) && Objects.equals(this.trustedCertificateAuthorityIds, other.trustedCertificateAuthorityIds) && Objects.equals(this.certificateIds, other.certificateIds) && Objects.equals(this.certificateName, other.certificateName) && Objects.equals((Object)this.serverOrderPreference, (Object)other.serverOrderPreference) && Objects.equals(this.cipherSuiteName, other.cipherSuiteName) && Objects.equals(this.protocols, other.protocols) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.verifyDepth == null ? 43 : this.verifyDepth.hashCode());
        result = result * 59 + (this.verifyPeerCertificate == null ? 43 : this.verifyPeerCertificate.hashCode());
        result = result * 59 + (this.trustedCertificateAuthorityIds == null ? 43 : this.trustedCertificateAuthorityIds.hashCode());
        result = result * 59 + (this.certificateIds == null ? 43 : this.certificateIds.hashCode());
        result = result * 59 + (this.certificateName == null ? 43 : this.certificateName.hashCode());
        result = result * 59 + (this.serverOrderPreference == null ? 43 : this.serverOrderPreference.hashCode());
        result = result * 59 + (this.cipherSuiteName == null ? 43 : this.cipherSuiteName.hashCode());
        result = result * 59 + (this.protocols == null ? 43 : this.protocols.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    public static enum ServerOrderPreference implements BmcEnum
    {
        Enabled("ENABLED"),
        Disabled("DISABLED"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, ServerOrderPreference> map;

        private ServerOrderPreference(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static ServerOrderPreference create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'ServerOrderPreference', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(ServerOrderPreference.class);
            map = new HashMap<String, ServerOrderPreference>();
            for (ServerOrderPreference v : ServerOrderPreference.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="verifyDepth")
        private Integer verifyDepth;
        @JsonProperty(value="verifyPeerCertificate")
        private Boolean verifyPeerCertificate;
        @JsonProperty(value="trustedCertificateAuthorityIds")
        private List<String> trustedCertificateAuthorityIds;
        @JsonProperty(value="certificateIds")
        private List<String> certificateIds;
        @JsonProperty(value="certificateName")
        private String certificateName;
        @JsonProperty(value="serverOrderPreference")
        private ServerOrderPreference serverOrderPreference;
        @JsonProperty(value="cipherSuiteName")
        private String cipherSuiteName;
        @JsonProperty(value="protocols")
        private List<String> protocols;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder verifyDepth(Integer verifyDepth) {
            this.verifyDepth = verifyDepth;
            this.__explicitlySet__.add("verifyDepth");
            return this;
        }

        public Builder verifyPeerCertificate(Boolean verifyPeerCertificate) {
            this.verifyPeerCertificate = verifyPeerCertificate;
            this.__explicitlySet__.add("verifyPeerCertificate");
            return this;
        }

        public Builder trustedCertificateAuthorityIds(List<String> trustedCertificateAuthorityIds) {
            this.trustedCertificateAuthorityIds = trustedCertificateAuthorityIds;
            this.__explicitlySet__.add("trustedCertificateAuthorityIds");
            return this;
        }

        public Builder certificateIds(List<String> certificateIds) {
            this.certificateIds = certificateIds;
            this.__explicitlySet__.add("certificateIds");
            return this;
        }

        public Builder certificateName(String certificateName) {
            this.certificateName = certificateName;
            this.__explicitlySet__.add("certificateName");
            return this;
        }

        public Builder serverOrderPreference(ServerOrderPreference serverOrderPreference) {
            this.serverOrderPreference = serverOrderPreference;
            this.__explicitlySet__.add("serverOrderPreference");
            return this;
        }

        public Builder cipherSuiteName(String cipherSuiteName) {
            this.cipherSuiteName = cipherSuiteName;
            this.__explicitlySet__.add("cipherSuiteName");
            return this;
        }

        public Builder protocols(List<String> protocols) {
            this.protocols = protocols;
            this.__explicitlySet__.add("protocols");
            return this;
        }

        public SSLConfiguration build() {
            SSLConfiguration model = new SSLConfiguration(this.verifyDepth, this.verifyPeerCertificate, this.trustedCertificateAuthorityIds, this.certificateIds, this.certificateName, this.serverOrderPreference, this.cipherSuiteName, this.protocols);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(SSLConfiguration model) {
            if (model.wasPropertyExplicitlySet("verifyDepth")) {
                this.verifyDepth(model.getVerifyDepth());
            }
            if (model.wasPropertyExplicitlySet("verifyPeerCertificate")) {
                this.verifyPeerCertificate(model.getVerifyPeerCertificate());
            }
            if (model.wasPropertyExplicitlySet("trustedCertificateAuthorityIds")) {
                this.trustedCertificateAuthorityIds(model.getTrustedCertificateAuthorityIds());
            }
            if (model.wasPropertyExplicitlySet("certificateIds")) {
                this.certificateIds(model.getCertificateIds());
            }
            if (model.wasPropertyExplicitlySet("certificateName")) {
                this.certificateName(model.getCertificateName());
            }
            if (model.wasPropertyExplicitlySet("serverOrderPreference")) {
                this.serverOrderPreference(model.getServerOrderPreference());
            }
            if (model.wasPropertyExplicitlySet("cipherSuiteName")) {
                this.cipherSuiteName(model.getCipherSuiteName());
            }
            if (model.wasPropertyExplicitlySet("protocols")) {
                this.protocols(model.getProtocols());
            }
            return this;
        }
    }
}

