/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.loadbalancer.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import java.beans.ConstructorProperties;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class Backend
extends ExplicitlySetBmcModel {
    @JsonProperty(value="name")
    private final String name;
    @JsonProperty(value="ipAddress")
    private final String ipAddress;
    @JsonProperty(value="port")
    private final Integer port;
    @JsonProperty(value="weight")
    private final Integer weight;
    @JsonProperty(value="drain")
    private final Boolean drain;
    @JsonProperty(value="backup")
    private final Boolean backup;
    @JsonProperty(value="offline")
    private final Boolean offline;

    @Deprecated
    @ConstructorProperties(value={"name", "ipAddress", "port", "weight", "drain", "backup", "offline"})
    public Backend(String name, String ipAddress, Integer port, Integer weight, Boolean drain, Boolean backup, Boolean offline) {
        this.name = name;
        this.ipAddress = ipAddress;
        this.port = port;
        this.weight = weight;
        this.drain = drain;
        this.backup = backup;
        this.offline = offline;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getName() {
        return this.name;
    }

    public String getIpAddress() {
        return this.ipAddress;
    }

    public Integer getPort() {
        return this.port;
    }

    public Integer getWeight() {
        return this.weight;
    }

    public Boolean getDrain() {
        return this.drain;
    }

    public Boolean getBackup() {
        return this.backup;
    }

    public Boolean getOffline() {
        return this.offline;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("Backend(");
        sb.append("super=").append(super.toString());
        sb.append("name=").append(String.valueOf(this.name));
        sb.append(", ipAddress=").append(String.valueOf(this.ipAddress));
        sb.append(", port=").append(String.valueOf(this.port));
        sb.append(", weight=").append(String.valueOf(this.weight));
        sb.append(", drain=").append(String.valueOf(this.drain));
        sb.append(", backup=").append(String.valueOf(this.backup));
        sb.append(", offline=").append(String.valueOf(this.offline));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Backend)) {
            return false;
        }
        Backend other = (Backend)((Object)o);
        return Objects.equals(this.name, other.name) && Objects.equals(this.ipAddress, other.ipAddress) && Objects.equals(this.port, other.port) && Objects.equals(this.weight, other.weight) && Objects.equals(this.drain, other.drain) && Objects.equals(this.backup, other.backup) && Objects.equals(this.offline, other.offline) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.name == null ? 43 : this.name.hashCode());
        result = result * 59 + (this.ipAddress == null ? 43 : this.ipAddress.hashCode());
        result = result * 59 + (this.port == null ? 43 : this.port.hashCode());
        result = result * 59 + (this.weight == null ? 43 : this.weight.hashCode());
        result = result * 59 + (this.drain == null ? 43 : this.drain.hashCode());
        result = result * 59 + (this.backup == null ? 43 : this.backup.hashCode());
        result = result * 59 + (this.offline == null ? 43 : this.offline.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="name")
        private String name;
        @JsonProperty(value="ipAddress")
        private String ipAddress;
        @JsonProperty(value="port")
        private Integer port;
        @JsonProperty(value="weight")
        private Integer weight;
        @JsonProperty(value="drain")
        private Boolean drain;
        @JsonProperty(value="backup")
        private Boolean backup;
        @JsonProperty(value="offline")
        private Boolean offline;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder name(String name) {
            this.name = name;
            this.__explicitlySet__.add("name");
            return this;
        }

        public Builder ipAddress(String ipAddress) {
            this.ipAddress = ipAddress;
            this.__explicitlySet__.add("ipAddress");
            return this;
        }

        public Builder port(Integer port) {
            this.port = port;
            this.__explicitlySet__.add("port");
            return this;
        }

        public Builder weight(Integer weight) {
            this.weight = weight;
            this.__explicitlySet__.add("weight");
            return this;
        }

        public Builder drain(Boolean drain) {
            this.drain = drain;
            this.__explicitlySet__.add("drain");
            return this;
        }

        public Builder backup(Boolean backup) {
            this.backup = backup;
            this.__explicitlySet__.add("backup");
            return this;
        }

        public Builder offline(Boolean offline) {
            this.offline = offline;
            this.__explicitlySet__.add("offline");
            return this;
        }

        public Backend build() {
            Backend model = new Backend(this.name, this.ipAddress, this.port, this.weight, this.drain, this.backup, this.offline);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(Backend model) {
            if (model.wasPropertyExplicitlySet("name")) {
                this.name(model.getName());
            }
            if (model.wasPropertyExplicitlySet("ipAddress")) {
                this.ipAddress(model.getIpAddress());
            }
            if (model.wasPropertyExplicitlySet("port")) {
                this.port(model.getPort());
            }
            if (model.wasPropertyExplicitlySet("weight")) {
                this.weight(model.getWeight());
            }
            if (model.wasPropertyExplicitlySet("drain")) {
                this.drain(model.getDrain());
            }
            if (model.wasPropertyExplicitlySet("backup")) {
                this.backup(model.getBackup());
            }
            if (model.wasPropertyExplicitlySet("offline")) {
                this.offline(model.getOffline());
            }
            return this;
        }
    }
}

