/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.loadbalancer.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.loadbalancer.model.Backend;
import com.oracle.bmc.loadbalancer.model.HealthChecker;
import com.oracle.bmc.loadbalancer.model.LBCookieSessionPersistenceConfigurationDetails;
import com.oracle.bmc.loadbalancer.model.SSLConfiguration;
import com.oracle.bmc.loadbalancer.model.SessionPersistenceConfigurationDetails;
import java.beans.ConstructorProperties;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class BackendSet
extends ExplicitlySetBmcModel {
    @JsonProperty(value="name")
    private final String name;
    @JsonProperty(value="policy")
    private final String policy;
    @JsonProperty(value="backends")
    private final List<Backend> backends;
    @JsonProperty(value="backendMaxConnections")
    private final Integer backendMaxConnections;
    @JsonProperty(value="healthChecker")
    private final HealthChecker healthChecker;
    @JsonProperty(value="sslConfiguration")
    private final SSLConfiguration sslConfiguration;
    @JsonProperty(value="sessionPersistenceConfiguration")
    private final SessionPersistenceConfigurationDetails sessionPersistenceConfiguration;
    @JsonProperty(value="lbCookieSessionPersistenceConfiguration")
    private final LBCookieSessionPersistenceConfigurationDetails lbCookieSessionPersistenceConfiguration;

    @Deprecated
    @ConstructorProperties(value={"name", "policy", "backends", "backendMaxConnections", "healthChecker", "sslConfiguration", "sessionPersistenceConfiguration", "lbCookieSessionPersistenceConfiguration"})
    public BackendSet(String name, String policy, List<Backend> backends, Integer backendMaxConnections, HealthChecker healthChecker, SSLConfiguration sslConfiguration, SessionPersistenceConfigurationDetails sessionPersistenceConfiguration, LBCookieSessionPersistenceConfigurationDetails lbCookieSessionPersistenceConfiguration) {
        this.name = name;
        this.policy = policy;
        this.backends = backends;
        this.backendMaxConnections = backendMaxConnections;
        this.healthChecker = healthChecker;
        this.sslConfiguration = sslConfiguration;
        this.sessionPersistenceConfiguration = sessionPersistenceConfiguration;
        this.lbCookieSessionPersistenceConfiguration = lbCookieSessionPersistenceConfiguration;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getName() {
        return this.name;
    }

    public String getPolicy() {
        return this.policy;
    }

    public List<Backend> getBackends() {
        return this.backends;
    }

    public Integer getBackendMaxConnections() {
        return this.backendMaxConnections;
    }

    public HealthChecker getHealthChecker() {
        return this.healthChecker;
    }

    public SSLConfiguration getSslConfiguration() {
        return this.sslConfiguration;
    }

    public SessionPersistenceConfigurationDetails getSessionPersistenceConfiguration() {
        return this.sessionPersistenceConfiguration;
    }

    public LBCookieSessionPersistenceConfigurationDetails getLbCookieSessionPersistenceConfiguration() {
        return this.lbCookieSessionPersistenceConfiguration;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("BackendSet(");
        sb.append("super=").append(super.toString());
        sb.append("name=").append(String.valueOf(this.name));
        sb.append(", policy=").append(String.valueOf(this.policy));
        sb.append(", backends=").append(String.valueOf(this.backends));
        sb.append(", backendMaxConnections=").append(String.valueOf(this.backendMaxConnections));
        sb.append(", healthChecker=").append(String.valueOf((Object)this.healthChecker));
        sb.append(", sslConfiguration=").append(String.valueOf((Object)this.sslConfiguration));
        sb.append(", sessionPersistenceConfiguration=").append(String.valueOf((Object)this.sessionPersistenceConfiguration));
        sb.append(", lbCookieSessionPersistenceConfiguration=").append(String.valueOf((Object)this.lbCookieSessionPersistenceConfiguration));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof BackendSet)) {
            return false;
        }
        BackendSet other = (BackendSet)((Object)o);
        return Objects.equals(this.name, other.name) && Objects.equals(this.policy, other.policy) && Objects.equals(this.backends, other.backends) && Objects.equals(this.backendMaxConnections, other.backendMaxConnections) && Objects.equals((Object)this.healthChecker, (Object)other.healthChecker) && Objects.equals((Object)this.sslConfiguration, (Object)other.sslConfiguration) && Objects.equals((Object)this.sessionPersistenceConfiguration, (Object)other.sessionPersistenceConfiguration) && Objects.equals((Object)this.lbCookieSessionPersistenceConfiguration, (Object)other.lbCookieSessionPersistenceConfiguration) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.name == null ? 43 : this.name.hashCode());
        result = result * 59 + (this.policy == null ? 43 : this.policy.hashCode());
        result = result * 59 + (this.backends == null ? 43 : this.backends.hashCode());
        result = result * 59 + (this.backendMaxConnections == null ? 43 : this.backendMaxConnections.hashCode());
        result = result * 59 + (this.healthChecker == null ? 43 : this.healthChecker.hashCode());
        result = result * 59 + (this.sslConfiguration == null ? 43 : this.sslConfiguration.hashCode());
        result = result * 59 + (this.sessionPersistenceConfiguration == null ? 43 : this.sessionPersistenceConfiguration.hashCode());
        result = result * 59 + (this.lbCookieSessionPersistenceConfiguration == null ? 43 : this.lbCookieSessionPersistenceConfiguration.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="name")
        private String name;
        @JsonProperty(value="policy")
        private String policy;
        @JsonProperty(value="backends")
        private List<Backend> backends;
        @JsonProperty(value="backendMaxConnections")
        private Integer backendMaxConnections;
        @JsonProperty(value="healthChecker")
        private HealthChecker healthChecker;
        @JsonProperty(value="sslConfiguration")
        private SSLConfiguration sslConfiguration;
        @JsonProperty(value="sessionPersistenceConfiguration")
        private SessionPersistenceConfigurationDetails sessionPersistenceConfiguration;
        @JsonProperty(value="lbCookieSessionPersistenceConfiguration")
        private LBCookieSessionPersistenceConfigurationDetails lbCookieSessionPersistenceConfiguration;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder name(String name) {
            this.name = name;
            this.__explicitlySet__.add("name");
            return this;
        }

        public Builder policy(String policy) {
            this.policy = policy;
            this.__explicitlySet__.add("policy");
            return this;
        }

        public Builder backends(List<Backend> backends) {
            this.backends = backends;
            this.__explicitlySet__.add("backends");
            return this;
        }

        public Builder backendMaxConnections(Integer backendMaxConnections) {
            this.backendMaxConnections = backendMaxConnections;
            this.__explicitlySet__.add("backendMaxConnections");
            return this;
        }

        public Builder healthChecker(HealthChecker healthChecker) {
            this.healthChecker = healthChecker;
            this.__explicitlySet__.add("healthChecker");
            return this;
        }

        public Builder sslConfiguration(SSLConfiguration sslConfiguration) {
            this.sslConfiguration = sslConfiguration;
            this.__explicitlySet__.add("sslConfiguration");
            return this;
        }

        public Builder sessionPersistenceConfiguration(SessionPersistenceConfigurationDetails sessionPersistenceConfiguration) {
            this.sessionPersistenceConfiguration = sessionPersistenceConfiguration;
            this.__explicitlySet__.add("sessionPersistenceConfiguration");
            return this;
        }

        public Builder lbCookieSessionPersistenceConfiguration(LBCookieSessionPersistenceConfigurationDetails lbCookieSessionPersistenceConfiguration) {
            this.lbCookieSessionPersistenceConfiguration = lbCookieSessionPersistenceConfiguration;
            this.__explicitlySet__.add("lbCookieSessionPersistenceConfiguration");
            return this;
        }

        public BackendSet build() {
            BackendSet model = new BackendSet(this.name, this.policy, this.backends, this.backendMaxConnections, this.healthChecker, this.sslConfiguration, this.sessionPersistenceConfiguration, this.lbCookieSessionPersistenceConfiguration);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(BackendSet model) {
            if (model.wasPropertyExplicitlySet("name")) {
                this.name(model.getName());
            }
            if (model.wasPropertyExplicitlySet("policy")) {
                this.policy(model.getPolicy());
            }
            if (model.wasPropertyExplicitlySet("backends")) {
                this.backends(model.getBackends());
            }
            if (model.wasPropertyExplicitlySet("backendMaxConnections")) {
                this.backendMaxConnections(model.getBackendMaxConnections());
            }
            if (model.wasPropertyExplicitlySet("healthChecker")) {
                this.healthChecker(model.getHealthChecker());
            }
            if (model.wasPropertyExplicitlySet("sslConfiguration")) {
                this.sslConfiguration(model.getSslConfiguration());
            }
            if (model.wasPropertyExplicitlySet("sessionPersistenceConfiguration")) {
                this.sessionPersistenceConfiguration(model.getSessionPersistenceConfiguration());
            }
            if (model.wasPropertyExplicitlySet("lbCookieSessionPersistenceConfiguration")) {
                this.lbCookieSessionPersistenceConfiguration(model.getLbCookieSessionPersistenceConfiguration());
            }
            return this;
        }
    }
}

