/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.loadbalancer.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import java.beans.ConstructorProperties;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class Certificate
extends ExplicitlySetBmcModel {
    @JsonProperty(value="certificateName")
    private final String certificateName;
    @JsonProperty(value="publicCertificate")
    private final String publicCertificate;
    @JsonProperty(value="caCertificate")
    private final String caCertificate;

    @Deprecated
    @ConstructorProperties(value={"certificateName", "publicCertificate", "caCertificate"})
    public Certificate(String certificateName, String publicCertificate, String caCertificate) {
        this.certificateName = certificateName;
        this.publicCertificate = publicCertificate;
        this.caCertificate = caCertificate;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getCertificateName() {
        return this.certificateName;
    }

    public String getPublicCertificate() {
        return this.publicCertificate;
    }

    public String getCaCertificate() {
        return this.caCertificate;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("Certificate(");
        sb.append("super=").append(super.toString());
        sb.append("certificateName=").append(String.valueOf(this.certificateName));
        sb.append(", publicCertificate=").append(String.valueOf(this.publicCertificate));
        sb.append(", caCertificate=").append(String.valueOf(this.caCertificate));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Certificate)) {
            return false;
        }
        Certificate other = (Certificate)((Object)o);
        return Objects.equals(this.certificateName, other.certificateName) && Objects.equals(this.publicCertificate, other.publicCertificate) && Objects.equals(this.caCertificate, other.caCertificate) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.certificateName == null ? 43 : this.certificateName.hashCode());
        result = result * 59 + (this.publicCertificate == null ? 43 : this.publicCertificate.hashCode());
        result = result * 59 + (this.caCertificate == null ? 43 : this.caCertificate.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="certificateName")
        private String certificateName;
        @JsonProperty(value="publicCertificate")
        private String publicCertificate;
        @JsonProperty(value="caCertificate")
        private String caCertificate;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder certificateName(String certificateName) {
            this.certificateName = certificateName;
            this.__explicitlySet__.add("certificateName");
            return this;
        }

        public Builder publicCertificate(String publicCertificate) {
            this.publicCertificate = publicCertificate;
            this.__explicitlySet__.add("publicCertificate");
            return this;
        }

        public Builder caCertificate(String caCertificate) {
            this.caCertificate = caCertificate;
            this.__explicitlySet__.add("caCertificate");
            return this;
        }

        public Certificate build() {
            Certificate model = new Certificate(this.certificateName, this.publicCertificate, this.caCertificate);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(Certificate model) {
            if (model.wasPropertyExplicitlySet("certificateName")) {
                this.certificateName(model.getCertificateName());
            }
            if (model.wasPropertyExplicitlySet("publicCertificate")) {
                this.publicCertificate(model.getPublicCertificate());
            }
            if (model.wasPropertyExplicitlySet("caCertificate")) {
                this.caCertificate(model.getCaCertificate());
            }
            return this;
        }
    }
}

