/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.loadbalancer.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.loadbalancer.model.Rule;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="action")
@JsonFilter(value="explicitlySetFilter")
public final class ControlAccessUsingHttpMethodsRule
extends Rule {
    @JsonProperty(value="allowedMethods")
    private final List<String> allowedMethods;
    @JsonProperty(value="statusCode")
    private final Integer statusCode;

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    @Deprecated
    public ControlAccessUsingHttpMethodsRule(List<String> allowedMethods, Integer statusCode) {
        this.allowedMethods = allowedMethods;
        this.statusCode = statusCode;
    }

    public List<String> getAllowedMethods() {
        return this.allowedMethods;
    }

    public Integer getStatusCode() {
        return this.statusCode;
    }

    @Override
    public String toString() {
        return this.toString(true);
    }

    @Override
    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("ControlAccessUsingHttpMethodsRule(");
        sb.append("super=").append(super.toString(includeByteArrayContents));
        sb.append(", allowedMethods=").append(String.valueOf(this.allowedMethods));
        sb.append(", statusCode=").append(String.valueOf(this.statusCode));
        sb.append(")");
        return sb.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ControlAccessUsingHttpMethodsRule)) {
            return false;
        }
        ControlAccessUsingHttpMethodsRule other = (ControlAccessUsingHttpMethodsRule)((Object)o);
        return Objects.equals(this.allowedMethods, other.allowedMethods) && Objects.equals(this.statusCode, other.statusCode) && super.equals((Object)other);
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.allowedMethods == null ? 43 : this.allowedMethods.hashCode());
        result = result * 59 + (this.statusCode == null ? 43 : this.statusCode.hashCode());
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="allowedMethods")
        private List<String> allowedMethods;
        @JsonProperty(value="statusCode")
        private Integer statusCode;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder allowedMethods(List<String> allowedMethods) {
            this.allowedMethods = allowedMethods;
            this.__explicitlySet__.add("allowedMethods");
            return this;
        }

        public Builder statusCode(Integer statusCode) {
            this.statusCode = statusCode;
            this.__explicitlySet__.add("statusCode");
            return this;
        }

        public ControlAccessUsingHttpMethodsRule build() {
            ControlAccessUsingHttpMethodsRule model = new ControlAccessUsingHttpMethodsRule(this.allowedMethods, this.statusCode);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(ControlAccessUsingHttpMethodsRule model) {
            if (model.wasPropertyExplicitlySet("allowedMethods")) {
                this.allowedMethods(model.getAllowedMethods());
            }
            if (model.wasPropertyExplicitlySet("statusCode")) {
                this.statusCode(model.getStatusCode());
            }
            return this;
        }
    }
}

