/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.loadbalancer.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.loadbalancer.model.ConnectionConfiguration;
import com.oracle.bmc.loadbalancer.model.SSLConfigurationDetails;
import java.beans.ConstructorProperties;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class UpdateListenerDetails
extends ExplicitlySetBmcModel {
    @JsonProperty(value="defaultBackendSetName")
    private final String defaultBackendSetName;
    @JsonProperty(value="port")
    private final Integer port;
    @JsonProperty(value="protocol")
    private final String protocol;
    @JsonProperty(value="hostnameNames")
    private final List<String> hostnameNames;
    @JsonProperty(value="pathRouteSetName")
    private final String pathRouteSetName;
    @JsonProperty(value="routingPolicyName")
    private final String routingPolicyName;
    @JsonProperty(value="sslConfiguration")
    private final SSLConfigurationDetails sslConfiguration;
    @JsonProperty(value="connectionConfiguration")
    private final ConnectionConfiguration connectionConfiguration;
    @JsonProperty(value="ruleSetNames")
    private final List<String> ruleSetNames;

    @Deprecated
    @ConstructorProperties(value={"defaultBackendSetName", "port", "protocol", "hostnameNames", "pathRouteSetName", "routingPolicyName", "sslConfiguration", "connectionConfiguration", "ruleSetNames"})
    public UpdateListenerDetails(String defaultBackendSetName, Integer port, String protocol, List<String> hostnameNames, String pathRouteSetName, String routingPolicyName, SSLConfigurationDetails sslConfiguration, ConnectionConfiguration connectionConfiguration, List<String> ruleSetNames) {
        this.defaultBackendSetName = defaultBackendSetName;
        this.port = port;
        this.protocol = protocol;
        this.hostnameNames = hostnameNames;
        this.pathRouteSetName = pathRouteSetName;
        this.routingPolicyName = routingPolicyName;
        this.sslConfiguration = sslConfiguration;
        this.connectionConfiguration = connectionConfiguration;
        this.ruleSetNames = ruleSetNames;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getDefaultBackendSetName() {
        return this.defaultBackendSetName;
    }

    public Integer getPort() {
        return this.port;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public List<String> getHostnameNames() {
        return this.hostnameNames;
    }

    public String getPathRouteSetName() {
        return this.pathRouteSetName;
    }

    public String getRoutingPolicyName() {
        return this.routingPolicyName;
    }

    public SSLConfigurationDetails getSslConfiguration() {
        return this.sslConfiguration;
    }

    public ConnectionConfiguration getConnectionConfiguration() {
        return this.connectionConfiguration;
    }

    public List<String> getRuleSetNames() {
        return this.ruleSetNames;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("UpdateListenerDetails(");
        sb.append("super=").append(super.toString());
        sb.append("defaultBackendSetName=").append(String.valueOf(this.defaultBackendSetName));
        sb.append(", port=").append(String.valueOf(this.port));
        sb.append(", protocol=").append(String.valueOf(this.protocol));
        sb.append(", hostnameNames=").append(String.valueOf(this.hostnameNames));
        sb.append(", pathRouteSetName=").append(String.valueOf(this.pathRouteSetName));
        sb.append(", routingPolicyName=").append(String.valueOf(this.routingPolicyName));
        sb.append(", sslConfiguration=").append(String.valueOf((Object)this.sslConfiguration));
        sb.append(", connectionConfiguration=").append(String.valueOf((Object)this.connectionConfiguration));
        sb.append(", ruleSetNames=").append(String.valueOf(this.ruleSetNames));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof UpdateListenerDetails)) {
            return false;
        }
        UpdateListenerDetails other = (UpdateListenerDetails)((Object)o);
        return Objects.equals(this.defaultBackendSetName, other.defaultBackendSetName) && Objects.equals(this.port, other.port) && Objects.equals(this.protocol, other.protocol) && Objects.equals(this.hostnameNames, other.hostnameNames) && Objects.equals(this.pathRouteSetName, other.pathRouteSetName) && Objects.equals(this.routingPolicyName, other.routingPolicyName) && Objects.equals((Object)this.sslConfiguration, (Object)other.sslConfiguration) && Objects.equals((Object)this.connectionConfiguration, (Object)other.connectionConfiguration) && Objects.equals(this.ruleSetNames, other.ruleSetNames) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.defaultBackendSetName == null ? 43 : this.defaultBackendSetName.hashCode());
        result = result * 59 + (this.port == null ? 43 : this.port.hashCode());
        result = result * 59 + (this.protocol == null ? 43 : this.protocol.hashCode());
        result = result * 59 + (this.hostnameNames == null ? 43 : this.hostnameNames.hashCode());
        result = result * 59 + (this.pathRouteSetName == null ? 43 : this.pathRouteSetName.hashCode());
        result = result * 59 + (this.routingPolicyName == null ? 43 : this.routingPolicyName.hashCode());
        result = result * 59 + (this.sslConfiguration == null ? 43 : this.sslConfiguration.hashCode());
        result = result * 59 + (this.connectionConfiguration == null ? 43 : this.connectionConfiguration.hashCode());
        result = result * 59 + (this.ruleSetNames == null ? 43 : this.ruleSetNames.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="defaultBackendSetName")
        private String defaultBackendSetName;
        @JsonProperty(value="port")
        private Integer port;
        @JsonProperty(value="protocol")
        private String protocol;
        @JsonProperty(value="hostnameNames")
        private List<String> hostnameNames;
        @JsonProperty(value="pathRouteSetName")
        private String pathRouteSetName;
        @JsonProperty(value="routingPolicyName")
        private String routingPolicyName;
        @JsonProperty(value="sslConfiguration")
        private SSLConfigurationDetails sslConfiguration;
        @JsonProperty(value="connectionConfiguration")
        private ConnectionConfiguration connectionConfiguration;
        @JsonProperty(value="ruleSetNames")
        private List<String> ruleSetNames;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder defaultBackendSetName(String defaultBackendSetName) {
            this.defaultBackendSetName = defaultBackendSetName;
            this.__explicitlySet__.add("defaultBackendSetName");
            return this;
        }

        public Builder port(Integer port) {
            this.port = port;
            this.__explicitlySet__.add("port");
            return this;
        }

        public Builder protocol(String protocol) {
            this.protocol = protocol;
            this.__explicitlySet__.add("protocol");
            return this;
        }

        public Builder hostnameNames(List<String> hostnameNames) {
            this.hostnameNames = hostnameNames;
            this.__explicitlySet__.add("hostnameNames");
            return this;
        }

        public Builder pathRouteSetName(String pathRouteSetName) {
            this.pathRouteSetName = pathRouteSetName;
            this.__explicitlySet__.add("pathRouteSetName");
            return this;
        }

        public Builder routingPolicyName(String routingPolicyName) {
            this.routingPolicyName = routingPolicyName;
            this.__explicitlySet__.add("routingPolicyName");
            return this;
        }

        public Builder sslConfiguration(SSLConfigurationDetails sslConfiguration) {
            this.sslConfiguration = sslConfiguration;
            this.__explicitlySet__.add("sslConfiguration");
            return this;
        }

        public Builder connectionConfiguration(ConnectionConfiguration connectionConfiguration) {
            this.connectionConfiguration = connectionConfiguration;
            this.__explicitlySet__.add("connectionConfiguration");
            return this;
        }

        public Builder ruleSetNames(List<String> ruleSetNames) {
            this.ruleSetNames = ruleSetNames;
            this.__explicitlySet__.add("ruleSetNames");
            return this;
        }

        public UpdateListenerDetails build() {
            UpdateListenerDetails model = new UpdateListenerDetails(this.defaultBackendSetName, this.port, this.protocol, this.hostnameNames, this.pathRouteSetName, this.routingPolicyName, this.sslConfiguration, this.connectionConfiguration, this.ruleSetNames);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(UpdateListenerDetails model) {
            if (model.wasPropertyExplicitlySet("defaultBackendSetName")) {
                this.defaultBackendSetName(model.getDefaultBackendSetName());
            }
            if (model.wasPropertyExplicitlySet("port")) {
                this.port(model.getPort());
            }
            if (model.wasPropertyExplicitlySet("protocol")) {
                this.protocol(model.getProtocol());
            }
            if (model.wasPropertyExplicitlySet("hostnameNames")) {
                this.hostnameNames(model.getHostnameNames());
            }
            if (model.wasPropertyExplicitlySet("pathRouteSetName")) {
                this.pathRouteSetName(model.getPathRouteSetName());
            }
            if (model.wasPropertyExplicitlySet("routingPolicyName")) {
                this.routingPolicyName(model.getRoutingPolicyName());
            }
            if (model.wasPropertyExplicitlySet("sslConfiguration")) {
                this.sslConfiguration(model.getSslConfiguration());
            }
            if (model.wasPropertyExplicitlySet("connectionConfiguration")) {
                this.connectionConfiguration(model.getConnectionConfiguration());
            }
            if (model.wasPropertyExplicitlySet("ruleSetNames")) {
                this.ruleSetNames(model.getRuleSetNames());
            }
            return this;
        }
    }
}

