/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.loadbalancer;

import com.oracle.bmc.ClientConfiguration;
import com.oracle.bmc.Region;
import com.oracle.bmc.Service;
import com.oracle.bmc.Services;
import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.auth.BasicAuthenticationDetailsProvider;
import com.oracle.bmc.common.ClientBuilderBase;
import com.oracle.bmc.common.RegionalClientBuilder;
import com.oracle.bmc.http.ClientConfigurator;
import com.oracle.bmc.http.client.Method;
import com.oracle.bmc.http.internal.BaseAsyncClient;
import com.oracle.bmc.http.internal.BmcEnum;
import com.oracle.bmc.http.signing.RequestSignerFactory;
import com.oracle.bmc.http.signing.SigningStrategy;
import com.oracle.bmc.http.signing.internal.DefaultRequestSignerFactory;
import com.oracle.bmc.internal.Alloy;
import com.oracle.bmc.loadbalancer.LoadBalancerAsync;
import com.oracle.bmc.loadbalancer.model.Backend;
import com.oracle.bmc.loadbalancer.model.BackendHealth;
import com.oracle.bmc.loadbalancer.model.BackendSet;
import com.oracle.bmc.loadbalancer.model.BackendSetHealth;
import com.oracle.bmc.loadbalancer.model.Certificate;
import com.oracle.bmc.loadbalancer.model.HealthChecker;
import com.oracle.bmc.loadbalancer.model.Hostname;
import com.oracle.bmc.loadbalancer.model.ListenerRuleSummary;
import com.oracle.bmc.loadbalancer.model.LoadBalancer;
import com.oracle.bmc.loadbalancer.model.LoadBalancerHealth;
import com.oracle.bmc.loadbalancer.model.LoadBalancerHealthSummary;
import com.oracle.bmc.loadbalancer.model.LoadBalancerPolicy;
import com.oracle.bmc.loadbalancer.model.LoadBalancerProtocol;
import com.oracle.bmc.loadbalancer.model.LoadBalancerShape;
import com.oracle.bmc.loadbalancer.model.PathRouteSet;
import com.oracle.bmc.loadbalancer.model.RoutingPolicy;
import com.oracle.bmc.loadbalancer.model.RuleSet;
import com.oracle.bmc.loadbalancer.model.SSLCipherSuite;
import com.oracle.bmc.loadbalancer.model.WorkRequest;
import com.oracle.bmc.loadbalancer.requests.ChangeLoadBalancerCompartmentRequest;
import com.oracle.bmc.loadbalancer.requests.CreateBackendRequest;
import com.oracle.bmc.loadbalancer.requests.CreateBackendSetRequest;
import com.oracle.bmc.loadbalancer.requests.CreateCertificateRequest;
import com.oracle.bmc.loadbalancer.requests.CreateHostnameRequest;
import com.oracle.bmc.loadbalancer.requests.CreateListenerRequest;
import com.oracle.bmc.loadbalancer.requests.CreateLoadBalancerRequest;
import com.oracle.bmc.loadbalancer.requests.CreatePathRouteSetRequest;
import com.oracle.bmc.loadbalancer.requests.CreateRoutingPolicyRequest;
import com.oracle.bmc.loadbalancer.requests.CreateRuleSetRequest;
import com.oracle.bmc.loadbalancer.requests.CreateSSLCipherSuiteRequest;
import com.oracle.bmc.loadbalancer.requests.DeleteBackendRequest;
import com.oracle.bmc.loadbalancer.requests.DeleteBackendSetRequest;
import com.oracle.bmc.loadbalancer.requests.DeleteCertificateRequest;
import com.oracle.bmc.loadbalancer.requests.DeleteHostnameRequest;
import com.oracle.bmc.loadbalancer.requests.DeleteListenerRequest;
import com.oracle.bmc.loadbalancer.requests.DeleteLoadBalancerRequest;
import com.oracle.bmc.loadbalancer.requests.DeletePathRouteSetRequest;
import com.oracle.bmc.loadbalancer.requests.DeleteRoutingPolicyRequest;
import com.oracle.bmc.loadbalancer.requests.DeleteRuleSetRequest;
import com.oracle.bmc.loadbalancer.requests.DeleteSSLCipherSuiteRequest;
import com.oracle.bmc.loadbalancer.requests.GetBackendHealthRequest;
import com.oracle.bmc.loadbalancer.requests.GetBackendRequest;
import com.oracle.bmc.loadbalancer.requests.GetBackendSetHealthRequest;
import com.oracle.bmc.loadbalancer.requests.GetBackendSetRequest;
import com.oracle.bmc.loadbalancer.requests.GetHealthCheckerRequest;
import com.oracle.bmc.loadbalancer.requests.GetHostnameRequest;
import com.oracle.bmc.loadbalancer.requests.GetLoadBalancerHealthRequest;
import com.oracle.bmc.loadbalancer.requests.GetLoadBalancerRequest;
import com.oracle.bmc.loadbalancer.requests.GetPathRouteSetRequest;
import com.oracle.bmc.loadbalancer.requests.GetRoutingPolicyRequest;
import com.oracle.bmc.loadbalancer.requests.GetRuleSetRequest;
import com.oracle.bmc.loadbalancer.requests.GetSSLCipherSuiteRequest;
import com.oracle.bmc.loadbalancer.requests.GetWorkRequestRequest;
import com.oracle.bmc.loadbalancer.requests.ListBackendSetsRequest;
import com.oracle.bmc.loadbalancer.requests.ListBackendsRequest;
import com.oracle.bmc.loadbalancer.requests.ListCertificatesRequest;
import com.oracle.bmc.loadbalancer.requests.ListHostnamesRequest;
import com.oracle.bmc.loadbalancer.requests.ListListenerRulesRequest;
import com.oracle.bmc.loadbalancer.requests.ListLoadBalancerHealthsRequest;
import com.oracle.bmc.loadbalancer.requests.ListLoadBalancersRequest;
import com.oracle.bmc.loadbalancer.requests.ListPathRouteSetsRequest;
import com.oracle.bmc.loadbalancer.requests.ListPoliciesRequest;
import com.oracle.bmc.loadbalancer.requests.ListProtocolsRequest;
import com.oracle.bmc.loadbalancer.requests.ListRoutingPoliciesRequest;
import com.oracle.bmc.loadbalancer.requests.ListRuleSetsRequest;
import com.oracle.bmc.loadbalancer.requests.ListSSLCipherSuitesRequest;
import com.oracle.bmc.loadbalancer.requests.ListShapesRequest;
import com.oracle.bmc.loadbalancer.requests.ListWorkRequestsRequest;
import com.oracle.bmc.loadbalancer.requests.UpdateBackendRequest;
import com.oracle.bmc.loadbalancer.requests.UpdateBackendSetRequest;
import com.oracle.bmc.loadbalancer.requests.UpdateHealthCheckerRequest;
import com.oracle.bmc.loadbalancer.requests.UpdateHostnameRequest;
import com.oracle.bmc.loadbalancer.requests.UpdateListenerRequest;
import com.oracle.bmc.loadbalancer.requests.UpdateLoadBalancerRequest;
import com.oracle.bmc.loadbalancer.requests.UpdateLoadBalancerShapeRequest;
import com.oracle.bmc.loadbalancer.requests.UpdateNetworkSecurityGroupsRequest;
import com.oracle.bmc.loadbalancer.requests.UpdatePathRouteSetRequest;
import com.oracle.bmc.loadbalancer.requests.UpdateRoutingPolicyRequest;
import com.oracle.bmc.loadbalancer.requests.UpdateRuleSetRequest;
import com.oracle.bmc.loadbalancer.requests.UpdateSSLCipherSuiteRequest;
import com.oracle.bmc.loadbalancer.responses.ChangeLoadBalancerCompartmentResponse;
import com.oracle.bmc.loadbalancer.responses.CreateBackendResponse;
import com.oracle.bmc.loadbalancer.responses.CreateBackendSetResponse;
import com.oracle.bmc.loadbalancer.responses.CreateCertificateResponse;
import com.oracle.bmc.loadbalancer.responses.CreateHostnameResponse;
import com.oracle.bmc.loadbalancer.responses.CreateListenerResponse;
import com.oracle.bmc.loadbalancer.responses.CreateLoadBalancerResponse;
import com.oracle.bmc.loadbalancer.responses.CreatePathRouteSetResponse;
import com.oracle.bmc.loadbalancer.responses.CreateRoutingPolicyResponse;
import com.oracle.bmc.loadbalancer.responses.CreateRuleSetResponse;
import com.oracle.bmc.loadbalancer.responses.CreateSSLCipherSuiteResponse;
import com.oracle.bmc.loadbalancer.responses.DeleteBackendResponse;
import com.oracle.bmc.loadbalancer.responses.DeleteBackendSetResponse;
import com.oracle.bmc.loadbalancer.responses.DeleteCertificateResponse;
import com.oracle.bmc.loadbalancer.responses.DeleteHostnameResponse;
import com.oracle.bmc.loadbalancer.responses.DeleteListenerResponse;
import com.oracle.bmc.loadbalancer.responses.DeleteLoadBalancerResponse;
import com.oracle.bmc.loadbalancer.responses.DeletePathRouteSetResponse;
import com.oracle.bmc.loadbalancer.responses.DeleteRoutingPolicyResponse;
import com.oracle.bmc.loadbalancer.responses.DeleteRuleSetResponse;
import com.oracle.bmc.loadbalancer.responses.DeleteSSLCipherSuiteResponse;
import com.oracle.bmc.loadbalancer.responses.GetBackendHealthResponse;
import com.oracle.bmc.loadbalancer.responses.GetBackendResponse;
import com.oracle.bmc.loadbalancer.responses.GetBackendSetHealthResponse;
import com.oracle.bmc.loadbalancer.responses.GetBackendSetResponse;
import com.oracle.bmc.loadbalancer.responses.GetHealthCheckerResponse;
import com.oracle.bmc.loadbalancer.responses.GetHostnameResponse;
import com.oracle.bmc.loadbalancer.responses.GetLoadBalancerHealthResponse;
import com.oracle.bmc.loadbalancer.responses.GetLoadBalancerResponse;
import com.oracle.bmc.loadbalancer.responses.GetPathRouteSetResponse;
import com.oracle.bmc.loadbalancer.responses.GetRoutingPolicyResponse;
import com.oracle.bmc.loadbalancer.responses.GetRuleSetResponse;
import com.oracle.bmc.loadbalancer.responses.GetSSLCipherSuiteResponse;
import com.oracle.bmc.loadbalancer.responses.GetWorkRequestResponse;
import com.oracle.bmc.loadbalancer.responses.ListBackendSetsResponse;
import com.oracle.bmc.loadbalancer.responses.ListBackendsResponse;
import com.oracle.bmc.loadbalancer.responses.ListCertificatesResponse;
import com.oracle.bmc.loadbalancer.responses.ListHostnamesResponse;
import com.oracle.bmc.loadbalancer.responses.ListListenerRulesResponse;
import com.oracle.bmc.loadbalancer.responses.ListLoadBalancerHealthsResponse;
import com.oracle.bmc.loadbalancer.responses.ListLoadBalancersResponse;
import com.oracle.bmc.loadbalancer.responses.ListPathRouteSetsResponse;
import com.oracle.bmc.loadbalancer.responses.ListPoliciesResponse;
import com.oracle.bmc.loadbalancer.responses.ListProtocolsResponse;
import com.oracle.bmc.loadbalancer.responses.ListRoutingPoliciesResponse;
import com.oracle.bmc.loadbalancer.responses.ListRuleSetsResponse;
import com.oracle.bmc.loadbalancer.responses.ListSSLCipherSuitesResponse;
import com.oracle.bmc.loadbalancer.responses.ListShapesResponse;
import com.oracle.bmc.loadbalancer.responses.ListWorkRequestsResponse;
import com.oracle.bmc.loadbalancer.responses.UpdateBackendResponse;
import com.oracle.bmc.loadbalancer.responses.UpdateBackendSetResponse;
import com.oracle.bmc.loadbalancer.responses.UpdateHealthCheckerResponse;
import com.oracle.bmc.loadbalancer.responses.UpdateHostnameResponse;
import com.oracle.bmc.loadbalancer.responses.UpdateListenerResponse;
import com.oracle.bmc.loadbalancer.responses.UpdateLoadBalancerResponse;
import com.oracle.bmc.loadbalancer.responses.UpdateLoadBalancerShapeResponse;
import com.oracle.bmc.loadbalancer.responses.UpdateNetworkSecurityGroupsResponse;
import com.oracle.bmc.loadbalancer.responses.UpdatePathRouteSetResponse;
import com.oracle.bmc.loadbalancer.responses.UpdateRoutingPolicyResponse;
import com.oracle.bmc.loadbalancer.responses.UpdateRuleSetResponse;
import com.oracle.bmc.loadbalancer.responses.UpdateSSLCipherSuiteResponse;
import com.oracle.bmc.responses.AsyncHandler;
import com.oracle.bmc.util.internal.Validate;
import jakarta.annotation.Nonnull;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Future;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoadBalancerAsyncClient
extends BaseAsyncClient
implements LoadBalancerAsync {
    public static final Service SERVICE = Services.serviceBuilder().serviceName("LOADBALANCER").serviceEndpointPrefix("iaas").serviceEndpointTemplate("https://iaas.{region}.{secondLevelDomain}").build();
    private static final Logger LOG = LoggerFactory.getLogger(LoadBalancerAsyncClient.class);

    LoadBalancerAsyncClient(ClientBuilderBase<?, ?> builder, AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
        super(builder, authenticationDetailsProvider);
    }

    public static Builder builder() {
        return new Builder(SERVICE);
    }

    @Override
    public void setRegion(Region region) {
        super.setRegion(region);
    }

    @Override
    public void setRegion(String regionId) {
        super.setRegion(regionId);
    }

    @Override
    public Future<ChangeLoadBalancerCompartmentResponse> changeLoadBalancerCompartment(ChangeLoadBalancerCompartmentRequest request, AsyncHandler<ChangeLoadBalancerCompartmentRequest, ChangeLoadBalancerCompartmentResponse> handler) {
        Validate.notBlank((String)request.getLoadBalancerId(), (String)"loadBalancerId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getChangeLoadBalancerCompartmentDetails(), "changeLoadBalancerCompartmentDetails is required");
        return this.clientCall(request, ChangeLoadBalancerCompartmentResponse::builder).logger(LOG, "changeLoadBalancerCompartment").serviceDetails("LoadBalancer", "ChangeLoadBalancerCompartment", "https://docs.oracle.com/iaas/api/#/en/loadbalancer/20170115/LoadBalancer/ChangeLoadBalancerCompartment").method(Method.POST).requestBuilder(ChangeLoadBalancerCompartmentRequest::builder).basePath("/20170115").appendPathParam("loadBalancers").appendPathParam(request.getLoadBalancerId()).appendPathParam("changeCompartment").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("if-match", request.getIfMatch()).hasBody().handleResponseHeaderString("opc-work-request-id", ChangeLoadBalancerCompartmentResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", ChangeLoadBalancerCompartmentResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<CreateBackendResponse> createBackend(CreateBackendRequest request, AsyncHandler<CreateBackendRequest, CreateBackendResponse> handler) {
        Objects.requireNonNull(request.getCreateBackendDetails(), "createBackendDetails is required");
        Validate.notBlank((String)request.getLoadBalancerId(), (String)"loadBalancerId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getBackendSetName(), (String)"backendSetName must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, CreateBackendResponse::builder).logger(LOG, "createBackend").serviceDetails("LoadBalancer", "CreateBackend", "").method(Method.POST).requestBuilder(CreateBackendRequest::builder).basePath("/20170115").appendPathParam("loadBalancers").appendPathParam(request.getLoadBalancerId()).appendPathParam("backendSets").appendPathParam(request.getBackendSetName()).appendPathParam("backends").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBody().handleResponseHeaderString("opc-work-request-id", CreateBackendResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", CreateBackendResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<CreateBackendSetResponse> createBackendSet(CreateBackendSetRequest request, AsyncHandler<CreateBackendSetRequest, CreateBackendSetResponse> handler) {
        Objects.requireNonNull(request.getCreateBackendSetDetails(), "createBackendSetDetails is required");
        Validate.notBlank((String)request.getLoadBalancerId(), (String)"loadBalancerId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, CreateBackendSetResponse::builder).logger(LOG, "createBackendSet").serviceDetails("LoadBalancer", "CreateBackendSet", "").method(Method.POST).requestBuilder(CreateBackendSetRequest::builder).basePath("/20170115").appendPathParam("loadBalancers").appendPathParam(request.getLoadBalancerId()).appendPathParam("backendSets").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("if-match", request.getIfMatch()).hasBody().handleResponseHeaderString("opc-work-request-id", CreateBackendSetResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", CreateBackendSetResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<CreateCertificateResponse> createCertificate(CreateCertificateRequest request, AsyncHandler<CreateCertificateRequest, CreateCertificateResponse> handler) {
        Objects.requireNonNull(request.getCreateCertificateDetails(), "createCertificateDetails is required");
        Validate.notBlank((String)request.getLoadBalancerId(), (String)"loadBalancerId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, CreateCertificateResponse::builder).logger(LOG, "createCertificate").serviceDetails("LoadBalancer", "CreateCertificate", "").method(Method.POST).requestBuilder(CreateCertificateRequest::builder).basePath("/20170115").appendPathParam("loadBalancers").appendPathParam(request.getLoadBalancerId()).appendPathParam("certificates").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("if-match", request.getIfMatch()).hasBody().handleResponseHeaderString("opc-work-request-id", CreateCertificateResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", CreateCertificateResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<CreateHostnameResponse> createHostname(CreateHostnameRequest request, AsyncHandler<CreateHostnameRequest, CreateHostnameResponse> handler) {
        Objects.requireNonNull(request.getCreateHostnameDetails(), "createHostnameDetails is required");
        Validate.notBlank((String)request.getLoadBalancerId(), (String)"loadBalancerId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, CreateHostnameResponse::builder).logger(LOG, "createHostname").serviceDetails("LoadBalancer", "CreateHostname", "").method(Method.POST).requestBuilder(CreateHostnameRequest::builder).basePath("/20170115").appendPathParam("loadBalancers").appendPathParam(request.getLoadBalancerId()).appendPathParam("hostnames").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBody().handleResponseHeaderString("opc-work-request-id", CreateHostnameResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", CreateHostnameResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<CreateListenerResponse> createListener(CreateListenerRequest request, AsyncHandler<CreateListenerRequest, CreateListenerResponse> handler) {
        Objects.requireNonNull(request.getCreateListenerDetails(), "createListenerDetails is required");
        Validate.notBlank((String)request.getLoadBalancerId(), (String)"loadBalancerId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, CreateListenerResponse::builder).logger(LOG, "createListener").serviceDetails("LoadBalancer", "CreateListener", "").method(Method.POST).requestBuilder(CreateListenerRequest::builder).basePath("/20170115").appendPathParam("loadBalancers").appendPathParam(request.getLoadBalancerId()).appendPathParam("listeners").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("if-match", request.getIfMatch()).hasBody().handleResponseHeaderString("opc-work-request-id", CreateListenerResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", CreateListenerResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<CreateLoadBalancerResponse> createLoadBalancer(CreateLoadBalancerRequest request, AsyncHandler<CreateLoadBalancerRequest, CreateLoadBalancerResponse> handler) {
        Objects.requireNonNull(request.getCreateLoadBalancerDetails(), "createLoadBalancerDetails is required");
        return this.clientCall(request, CreateLoadBalancerResponse::builder).logger(LOG, "createLoadBalancer").serviceDetails("LoadBalancer", "CreateLoadBalancer", "").method(Method.POST).requestBuilder(CreateLoadBalancerRequest::builder).basePath("/20170115").appendPathParam("loadBalancers").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBody().handleResponseHeaderString("opc-work-request-id", CreateLoadBalancerResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", CreateLoadBalancerResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<CreatePathRouteSetResponse> createPathRouteSet(CreatePathRouteSetRequest request, AsyncHandler<CreatePathRouteSetRequest, CreatePathRouteSetResponse> handler) {
        Objects.requireNonNull(request.getCreatePathRouteSetDetails(), "createPathRouteSetDetails is required");
        Validate.notBlank((String)request.getLoadBalancerId(), (String)"loadBalancerId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, CreatePathRouteSetResponse::builder).logger(LOG, "createPathRouteSet").serviceDetails("LoadBalancer", "CreatePathRouteSet", "").method(Method.POST).requestBuilder(CreatePathRouteSetRequest::builder).basePath("/20170115").appendPathParam("loadBalancers").appendPathParam(request.getLoadBalancerId()).appendPathParam("pathRouteSets").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("if-match", request.getIfMatch()).hasBody().handleResponseHeaderString("opc-work-request-id", CreatePathRouteSetResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", CreatePathRouteSetResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<CreateRoutingPolicyResponse> createRoutingPolicy(CreateRoutingPolicyRequest request, AsyncHandler<CreateRoutingPolicyRequest, CreateRoutingPolicyResponse> handler) {
        Objects.requireNonNull(request.getCreateRoutingPolicyDetails(), "createRoutingPolicyDetails is required");
        Validate.notBlank((String)request.getLoadBalancerId(), (String)"loadBalancerId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, CreateRoutingPolicyResponse::builder).logger(LOG, "createRoutingPolicy").serviceDetails("LoadBalancer", "CreateRoutingPolicy", "").method(Method.POST).requestBuilder(CreateRoutingPolicyRequest::builder).basePath("/20170115").appendPathParam("loadBalancers").appendPathParam(request.getLoadBalancerId()).appendPathParam("routingPolicies").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("if-match", request.getIfMatch()).hasBody().handleResponseHeaderString("opc-work-request-id", CreateRoutingPolicyResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", CreateRoutingPolicyResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<CreateRuleSetResponse> createRuleSet(CreateRuleSetRequest request, AsyncHandler<CreateRuleSetRequest, CreateRuleSetResponse> handler) {
        Validate.notBlank((String)request.getLoadBalancerId(), (String)"loadBalancerId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getCreateRuleSetDetails(), "createRuleSetDetails is required");
        return this.clientCall(request, CreateRuleSetResponse::builder).logger(LOG, "createRuleSet").serviceDetails("LoadBalancer", "CreateRuleSet", "").method(Method.POST).requestBuilder(CreateRuleSetRequest::builder).basePath("/20170115").appendPathParam("loadBalancers").appendPathParam(request.getLoadBalancerId()).appendPathParam("ruleSets").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("if-match", request.getIfMatch()).hasBody().handleResponseHeaderString("opc-work-request-id", CreateRuleSetResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", CreateRuleSetResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<CreateSSLCipherSuiteResponse> createSSLCipherSuite(CreateSSLCipherSuiteRequest request, AsyncHandler<CreateSSLCipherSuiteRequest, CreateSSLCipherSuiteResponse> handler) {
        Objects.requireNonNull(request.getCreateSSLCipherSuiteDetails(), "createSSLCipherSuiteDetails is required");
        Validate.notBlank((String)request.getLoadBalancerId(), (String)"loadBalancerId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, CreateSSLCipherSuiteResponse::builder).logger(LOG, "createSSLCipherSuite").serviceDetails("LoadBalancer", "CreateSSLCipherSuite", "").method(Method.POST).requestBuilder(CreateSSLCipherSuiteRequest::builder).basePath("/20170115").appendPathParam("loadBalancers").appendPathParam(request.getLoadBalancerId()).appendPathParam("sslCipherSuites").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("if-match", request.getIfMatch()).hasBody().handleResponseHeaderString("opc-work-request-id", CreateSSLCipherSuiteResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", CreateSSLCipherSuiteResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<DeleteBackendResponse> deleteBackend(DeleteBackendRequest request, AsyncHandler<DeleteBackendRequest, DeleteBackendResponse> handler) {
        Validate.notBlank((String)request.getLoadBalancerId(), (String)"loadBalancerId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getBackendSetName(), (String)"backendSetName must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getBackendName(), (String)"backendName must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, DeleteBackendResponse::builder).logger(LOG, "deleteBackend").serviceDetails("LoadBalancer", "DeleteBackend", "").method(Method.DELETE).requestBuilder(DeleteBackendRequest::builder).basePath("/20170115").appendPathParam("loadBalancers").appendPathParam(request.getLoadBalancerId()).appendPathParam("backendSets").appendPathParam(request.getBackendSetName()).appendPathParam("backends").appendPathParam(request.getBackendName()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("if-match", request.getIfMatch()).handleResponseHeaderString("opc-work-request-id", DeleteBackendResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", DeleteBackendResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<DeleteBackendSetResponse> deleteBackendSet(DeleteBackendSetRequest request, AsyncHandler<DeleteBackendSetRequest, DeleteBackendSetResponse> handler) {
        Validate.notBlank((String)request.getLoadBalancerId(), (String)"loadBalancerId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getBackendSetName(), (String)"backendSetName must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, DeleteBackendSetResponse::builder).logger(LOG, "deleteBackendSet").serviceDetails("LoadBalancer", "DeleteBackendSet", "").method(Method.DELETE).requestBuilder(DeleteBackendSetRequest::builder).basePath("/20170115").appendPathParam("loadBalancers").appendPathParam(request.getLoadBalancerId()).appendPathParam("backendSets").appendPathParam(request.getBackendSetName()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("if-match", request.getIfMatch()).handleResponseHeaderString("opc-work-request-id", DeleteBackendSetResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", DeleteBackendSetResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<DeleteCertificateResponse> deleteCertificate(DeleteCertificateRequest request, AsyncHandler<DeleteCertificateRequest, DeleteCertificateResponse> handler) {
        Validate.notBlank((String)request.getLoadBalancerId(), (String)"loadBalancerId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getCertificateName(), (String)"certificateName must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, DeleteCertificateResponse::builder).logger(LOG, "deleteCertificate").serviceDetails("LoadBalancer", "DeleteCertificate", "").method(Method.DELETE).requestBuilder(DeleteCertificateRequest::builder).basePath("/20170115").appendPathParam("loadBalancers").appendPathParam(request.getLoadBalancerId()).appendPathParam("certificates").appendPathParam(request.getCertificateName()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("if-match", request.getIfMatch()).handleResponseHeaderString("opc-work-request-id", DeleteCertificateResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", DeleteCertificateResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<DeleteHostnameResponse> deleteHostname(DeleteHostnameRequest request, AsyncHandler<DeleteHostnameRequest, DeleteHostnameResponse> handler) {
        Validate.notBlank((String)request.getLoadBalancerId(), (String)"loadBalancerId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getName(), (String)"name must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, DeleteHostnameResponse::builder).logger(LOG, "deleteHostname").serviceDetails("LoadBalancer", "DeleteHostname", "").method(Method.DELETE).requestBuilder(DeleteHostnameRequest::builder).basePath("/20170115").appendPathParam("loadBalancers").appendPathParam(request.getLoadBalancerId()).appendPathParam("hostnames").appendPathParam(request.getName()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("if-match", request.getIfMatch()).handleResponseHeaderString("opc-work-request-id", DeleteHostnameResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", DeleteHostnameResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<DeleteListenerResponse> deleteListener(DeleteListenerRequest request, AsyncHandler<DeleteListenerRequest, DeleteListenerResponse> handler) {
        Validate.notBlank((String)request.getLoadBalancerId(), (String)"loadBalancerId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getListenerName(), (String)"listenerName must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, DeleteListenerResponse::builder).logger(LOG, "deleteListener").serviceDetails("LoadBalancer", "DeleteListener", "").method(Method.DELETE).requestBuilder(DeleteListenerRequest::builder).basePath("/20170115").appendPathParam("loadBalancers").appendPathParam(request.getLoadBalancerId()).appendPathParam("listeners").appendPathParam(request.getListenerName()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("if-match", request.getIfMatch()).handleResponseHeaderString("opc-work-request-id", DeleteListenerResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", DeleteListenerResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<DeleteLoadBalancerResponse> deleteLoadBalancer(DeleteLoadBalancerRequest request, AsyncHandler<DeleteLoadBalancerRequest, DeleteLoadBalancerResponse> handler) {
        Validate.notBlank((String)request.getLoadBalancerId(), (String)"loadBalancerId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, DeleteLoadBalancerResponse::builder).logger(LOG, "deleteLoadBalancer").serviceDetails("LoadBalancer", "DeleteLoadBalancer", "").method(Method.DELETE).requestBuilder(DeleteLoadBalancerRequest::builder).basePath("/20170115").appendPathParam("loadBalancers").appendPathParam(request.getLoadBalancerId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("if-match", request.getIfMatch()).handleResponseHeaderString("opc-work-request-id", DeleteLoadBalancerResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", DeleteLoadBalancerResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<DeletePathRouteSetResponse> deletePathRouteSet(DeletePathRouteSetRequest request, AsyncHandler<DeletePathRouteSetRequest, DeletePathRouteSetResponse> handler) {
        Validate.notBlank((String)request.getLoadBalancerId(), (String)"loadBalancerId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getPathRouteSetName(), (String)"pathRouteSetName must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, DeletePathRouteSetResponse::builder).logger(LOG, "deletePathRouteSet").serviceDetails("LoadBalancer", "DeletePathRouteSet", "").method(Method.DELETE).requestBuilder(DeletePathRouteSetRequest::builder).basePath("/20170115").appendPathParam("loadBalancers").appendPathParam(request.getLoadBalancerId()).appendPathParam("pathRouteSets").appendPathParam(request.getPathRouteSetName()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("if-match", request.getIfMatch()).handleResponseHeaderString("opc-work-request-id", DeletePathRouteSetResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", DeletePathRouteSetResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<DeleteRoutingPolicyResponse> deleteRoutingPolicy(DeleteRoutingPolicyRequest request, AsyncHandler<DeleteRoutingPolicyRequest, DeleteRoutingPolicyResponse> handler) {
        Validate.notBlank((String)request.getLoadBalancerId(), (String)"loadBalancerId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getRoutingPolicyName(), (String)"routingPolicyName must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, DeleteRoutingPolicyResponse::builder).logger(LOG, "deleteRoutingPolicy").serviceDetails("LoadBalancer", "DeleteRoutingPolicy", "").method(Method.DELETE).requestBuilder(DeleteRoutingPolicyRequest::builder).basePath("/20170115").appendPathParam("loadBalancers").appendPathParam(request.getLoadBalancerId()).appendPathParam("routingPolicies").appendPathParam(request.getRoutingPolicyName()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("if-match", request.getIfMatch()).handleResponseHeaderString("opc-work-request-id", DeleteRoutingPolicyResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", DeleteRoutingPolicyResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<DeleteRuleSetResponse> deleteRuleSet(DeleteRuleSetRequest request, AsyncHandler<DeleteRuleSetRequest, DeleteRuleSetResponse> handler) {
        Validate.notBlank((String)request.getLoadBalancerId(), (String)"loadBalancerId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getRuleSetName(), (String)"ruleSetName must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, DeleteRuleSetResponse::builder).logger(LOG, "deleteRuleSet").serviceDetails("LoadBalancer", "DeleteRuleSet", "").method(Method.DELETE).requestBuilder(DeleteRuleSetRequest::builder).basePath("/20170115").appendPathParam("loadBalancers").appendPathParam(request.getLoadBalancerId()).appendPathParam("ruleSets").appendPathParam(request.getRuleSetName()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("if-match", request.getIfMatch()).handleResponseHeaderString("opc-work-request-id", DeleteRuleSetResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", DeleteRuleSetResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<DeleteSSLCipherSuiteResponse> deleteSSLCipherSuite(DeleteSSLCipherSuiteRequest request, AsyncHandler<DeleteSSLCipherSuiteRequest, DeleteSSLCipherSuiteResponse> handler) {
        Validate.notBlank((String)request.getLoadBalancerId(), (String)"loadBalancerId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getName(), (String)"name must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, DeleteSSLCipherSuiteResponse::builder).logger(LOG, "deleteSSLCipherSuite").serviceDetails("LoadBalancer", "DeleteSSLCipherSuite", "").method(Method.DELETE).requestBuilder(DeleteSSLCipherSuiteRequest::builder).basePath("/20170115").appendPathParam("loadBalancers").appendPathParam(request.getLoadBalancerId()).appendPathParam("sslCipherSuites").appendPathParam(request.getName()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("if-match", request.getIfMatch()).handleResponseHeaderString("opc-work-request-id", DeleteSSLCipherSuiteResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", DeleteSSLCipherSuiteResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<GetBackendResponse> getBackend(GetBackendRequest request, AsyncHandler<GetBackendRequest, GetBackendResponse> handler) {
        Validate.notBlank((String)request.getLoadBalancerId(), (String)"loadBalancerId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getBackendSetName(), (String)"backendSetName must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getBackendName(), (String)"backendName must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, GetBackendResponse::builder).logger(LOG, "getBackend").serviceDetails("LoadBalancer", "GetBackend", "https://docs.oracle.com/iaas/api/#/en/loadbalancer/20170115/Backend/GetBackend").method(Method.GET).requestBuilder(GetBackendRequest::builder).basePath("/20170115").appendPathParam("loadBalancers").appendPathParam(request.getLoadBalancerId()).appendPathParam("backendSets").appendPathParam(request.getBackendSetName()).appendPathParam("backends").appendPathParam(request.getBackendName()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("if-match", request.getIfMatch()).handleBody(Backend.class, GetBackendResponse.Builder::backend).handleResponseHeaderString("opc-request-id", GetBackendResponse.Builder::opcRequestId).handleResponseHeaderString("eTag", GetBackendResponse.Builder::eTag).callAsync(handler);
    }

    @Override
    public Future<GetBackendHealthResponse> getBackendHealth(GetBackendHealthRequest request, AsyncHandler<GetBackendHealthRequest, GetBackendHealthResponse> handler) {
        Validate.notBlank((String)request.getLoadBalancerId(), (String)"loadBalancerId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getBackendSetName(), (String)"backendSetName must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getBackendName(), (String)"backendName must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, GetBackendHealthResponse::builder).logger(LOG, "getBackendHealth").serviceDetails("LoadBalancer", "GetBackendHealth", "https://docs.oracle.com/iaas/api/#/en/loadbalancer/20170115/BackendHealth/GetBackendHealth").method(Method.GET).requestBuilder(GetBackendHealthRequest::builder).basePath("/20170115").appendPathParam("loadBalancers").appendPathParam(request.getLoadBalancerId()).appendPathParam("backendSets").appendPathParam(request.getBackendSetName()).appendPathParam("backends").appendPathParam(request.getBackendName()).appendPathParam("health").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("if-match", request.getIfMatch()).handleBody(BackendHealth.class, GetBackendHealthResponse.Builder::backendHealth).handleResponseHeaderString("opc-request-id", GetBackendHealthResponse.Builder::opcRequestId).handleResponseHeaderString("eTag", GetBackendHealthResponse.Builder::eTag).callAsync(handler);
    }

    @Override
    public Future<GetBackendSetResponse> getBackendSet(GetBackendSetRequest request, AsyncHandler<GetBackendSetRequest, GetBackendSetResponse> handler) {
        Validate.notBlank((String)request.getLoadBalancerId(), (String)"loadBalancerId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getBackendSetName(), (String)"backendSetName must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, GetBackendSetResponse::builder).logger(LOG, "getBackendSet").serviceDetails("LoadBalancer", "GetBackendSet", "https://docs.oracle.com/iaas/api/#/en/loadbalancer/20170115/BackendSet/GetBackendSet").method(Method.GET).requestBuilder(GetBackendSetRequest::builder).basePath("/20170115").appendPathParam("loadBalancers").appendPathParam(request.getLoadBalancerId()).appendPathParam("backendSets").appendPathParam(request.getBackendSetName()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("if-match", request.getIfMatch()).handleBody(BackendSet.class, GetBackendSetResponse.Builder::backendSet).handleResponseHeaderString("opc-request-id", GetBackendSetResponse.Builder::opcRequestId).handleResponseHeaderString("eTag", GetBackendSetResponse.Builder::eTag).callAsync(handler);
    }

    @Override
    public Future<GetBackendSetHealthResponse> getBackendSetHealth(GetBackendSetHealthRequest request, AsyncHandler<GetBackendSetHealthRequest, GetBackendSetHealthResponse> handler) {
        Validate.notBlank((String)request.getLoadBalancerId(), (String)"loadBalancerId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getBackendSetName(), (String)"backendSetName must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, GetBackendSetHealthResponse::builder).logger(LOG, "getBackendSetHealth").serviceDetails("LoadBalancer", "GetBackendSetHealth", "https://docs.oracle.com/iaas/api/#/en/loadbalancer/20170115/BackendSetHealth/GetBackendSetHealth").method(Method.GET).requestBuilder(GetBackendSetHealthRequest::builder).basePath("/20170115").appendPathParam("loadBalancers").appendPathParam(request.getLoadBalancerId()).appendPathParam("backendSets").appendPathParam(request.getBackendSetName()).appendPathParam("health").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("if-match", request.getIfMatch()).handleBody(BackendSetHealth.class, GetBackendSetHealthResponse.Builder::backendSetHealth).handleResponseHeaderString("opc-request-id", GetBackendSetHealthResponse.Builder::opcRequestId).handleResponseHeaderString("eTag", GetBackendSetHealthResponse.Builder::eTag).callAsync(handler);
    }

    @Override
    public Future<GetHealthCheckerResponse> getHealthChecker(GetHealthCheckerRequest request, AsyncHandler<GetHealthCheckerRequest, GetHealthCheckerResponse> handler) {
        Validate.notBlank((String)request.getLoadBalancerId(), (String)"loadBalancerId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getBackendSetName(), (String)"backendSetName must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, GetHealthCheckerResponse::builder).logger(LOG, "getHealthChecker").serviceDetails("LoadBalancer", "GetHealthChecker", "https://docs.oracle.com/iaas/api/#/en/loadbalancer/20170115/HealthChecker/GetHealthChecker").method(Method.GET).requestBuilder(GetHealthCheckerRequest::builder).basePath("/20170115").appendPathParam("loadBalancers").appendPathParam(request.getLoadBalancerId()).appendPathParam("backendSets").appendPathParam(request.getBackendSetName()).appendPathParam("healthChecker").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("if-match", request.getIfMatch()).handleBody(HealthChecker.class, GetHealthCheckerResponse.Builder::healthChecker).handleResponseHeaderString("opc-request-id", GetHealthCheckerResponse.Builder::opcRequestId).handleResponseHeaderString("eTag", GetHealthCheckerResponse.Builder::eTag).callAsync(handler);
    }

    @Override
    public Future<GetHostnameResponse> getHostname(GetHostnameRequest request, AsyncHandler<GetHostnameRequest, GetHostnameResponse> handler) {
        Validate.notBlank((String)request.getLoadBalancerId(), (String)"loadBalancerId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getName(), (String)"name must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, GetHostnameResponse::builder).logger(LOG, "getHostname").serviceDetails("LoadBalancer", "GetHostname", "https://docs.oracle.com/iaas/api/#/en/loadbalancer/20170115/Hostname/GetHostname").method(Method.GET).requestBuilder(GetHostnameRequest::builder).basePath("/20170115").appendPathParam("loadBalancers").appendPathParam(request.getLoadBalancerId()).appendPathParam("hostnames").appendPathParam(request.getName()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("if-match", request.getIfMatch()).handleBody(Hostname.class, GetHostnameResponse.Builder::hostname).handleResponseHeaderString("opc-request-id", GetHostnameResponse.Builder::opcRequestId).handleResponseHeaderString("eTag", GetHostnameResponse.Builder::eTag).callAsync(handler);
    }

    @Override
    public Future<GetLoadBalancerResponse> getLoadBalancer(GetLoadBalancerRequest request, AsyncHandler<GetLoadBalancerRequest, GetLoadBalancerResponse> handler) {
        Validate.notBlank((String)request.getLoadBalancerId(), (String)"loadBalancerId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, GetLoadBalancerResponse::builder).logger(LOG, "getLoadBalancer").serviceDetails("LoadBalancer", "GetLoadBalancer", "https://docs.oracle.com/iaas/api/#/en/loadbalancer/20170115/LoadBalancer/GetLoadBalancer").method(Method.GET).requestBuilder(GetLoadBalancerRequest::builder).basePath("/20170115").appendPathParam("loadBalancers").appendPathParam(request.getLoadBalancerId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("if-match", request.getIfMatch()).handleBody(LoadBalancer.class, GetLoadBalancerResponse.Builder::loadBalancer).handleResponseHeaderString("opc-request-id", GetLoadBalancerResponse.Builder::opcRequestId).handleResponseHeaderString("eTag", GetLoadBalancerResponse.Builder::eTag).callAsync(handler);
    }

    @Override
    public Future<GetLoadBalancerHealthResponse> getLoadBalancerHealth(GetLoadBalancerHealthRequest request, AsyncHandler<GetLoadBalancerHealthRequest, GetLoadBalancerHealthResponse> handler) {
        Validate.notBlank((String)request.getLoadBalancerId(), (String)"loadBalancerId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, GetLoadBalancerHealthResponse::builder).logger(LOG, "getLoadBalancerHealth").serviceDetails("LoadBalancer", "GetLoadBalancerHealth", "https://docs.oracle.com/iaas/api/#/en/loadbalancer/20170115/LoadBalancerHealth/GetLoadBalancerHealth").method(Method.GET).requestBuilder(GetLoadBalancerHealthRequest::builder).basePath("/20170115").appendPathParam("loadBalancers").appendPathParam(request.getLoadBalancerId()).appendPathParam("health").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("if-match", request.getIfMatch()).handleBody(LoadBalancerHealth.class, GetLoadBalancerHealthResponse.Builder::loadBalancerHealth).handleResponseHeaderString("opc-request-id", GetLoadBalancerHealthResponse.Builder::opcRequestId).handleResponseHeaderString("eTag", GetLoadBalancerHealthResponse.Builder::eTag).callAsync(handler);
    }

    @Override
    public Future<GetPathRouteSetResponse> getPathRouteSet(GetPathRouteSetRequest request, AsyncHandler<GetPathRouteSetRequest, GetPathRouteSetResponse> handler) {
        Validate.notBlank((String)request.getLoadBalancerId(), (String)"loadBalancerId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getPathRouteSetName(), (String)"pathRouteSetName must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, GetPathRouteSetResponse::builder).logger(LOG, "getPathRouteSet").serviceDetails("LoadBalancer", "GetPathRouteSet", "https://docs.oracle.com/iaas/api/#/en/loadbalancer/20170115/PathRouteSet/GetPathRouteSet").method(Method.GET).requestBuilder(GetPathRouteSetRequest::builder).basePath("/20170115").appendPathParam("loadBalancers").appendPathParam(request.getLoadBalancerId()).appendPathParam("pathRouteSets").appendPathParam(request.getPathRouteSetName()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("if-match", request.getIfMatch()).handleBody(PathRouteSet.class, GetPathRouteSetResponse.Builder::pathRouteSet).handleResponseHeaderString("opc-request-id", GetPathRouteSetResponse.Builder::opcRequestId).handleResponseHeaderString("eTag", GetPathRouteSetResponse.Builder::eTag).callAsync(handler);
    }

    @Override
    public Future<GetRoutingPolicyResponse> getRoutingPolicy(GetRoutingPolicyRequest request, AsyncHandler<GetRoutingPolicyRequest, GetRoutingPolicyResponse> handler) {
        Validate.notBlank((String)request.getLoadBalancerId(), (String)"loadBalancerId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getRoutingPolicyName(), (String)"routingPolicyName must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, GetRoutingPolicyResponse::builder).logger(LOG, "getRoutingPolicy").serviceDetails("LoadBalancer", "GetRoutingPolicy", "https://docs.oracle.com/iaas/api/#/en/loadbalancer/20170115/RoutingPolicy/GetRoutingPolicy").method(Method.GET).requestBuilder(GetRoutingPolicyRequest::builder).basePath("/20170115").appendPathParam("loadBalancers").appendPathParam(request.getLoadBalancerId()).appendPathParam("routingPolicies").appendPathParam(request.getRoutingPolicyName()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("if-match", request.getIfMatch()).handleBody(RoutingPolicy.class, GetRoutingPolicyResponse.Builder::routingPolicy).handleResponseHeaderString("opc-request-id", GetRoutingPolicyResponse.Builder::opcRequestId).handleResponseHeaderString("eTag", GetRoutingPolicyResponse.Builder::eTag).callAsync(handler);
    }

    @Override
    public Future<GetRuleSetResponse> getRuleSet(GetRuleSetRequest request, AsyncHandler<GetRuleSetRequest, GetRuleSetResponse> handler) {
        Validate.notBlank((String)request.getLoadBalancerId(), (String)"loadBalancerId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getRuleSetName(), (String)"ruleSetName must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, GetRuleSetResponse::builder).logger(LOG, "getRuleSet").serviceDetails("LoadBalancer", "GetRuleSet", "https://docs.oracle.com/iaas/api/#/en/loadbalancer/20170115/RuleSet/GetRuleSet").method(Method.GET).requestBuilder(GetRuleSetRequest::builder).basePath("/20170115").appendPathParam("loadBalancers").appendPathParam(request.getLoadBalancerId()).appendPathParam("ruleSets").appendPathParam(request.getRuleSetName()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("if-match", request.getIfMatch()).handleBody(RuleSet.class, GetRuleSetResponse.Builder::ruleSet).handleResponseHeaderString("opc-request-id", GetRuleSetResponse.Builder::opcRequestId).handleResponseHeaderString("eTag", GetRuleSetResponse.Builder::eTag).callAsync(handler);
    }

    @Override
    public Future<GetSSLCipherSuiteResponse> getSSLCipherSuite(GetSSLCipherSuiteRequest request, AsyncHandler<GetSSLCipherSuiteRequest, GetSSLCipherSuiteResponse> handler) {
        Validate.notBlank((String)request.getLoadBalancerId(), (String)"loadBalancerId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getName(), (String)"name must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, GetSSLCipherSuiteResponse::builder).logger(LOG, "getSSLCipherSuite").serviceDetails("LoadBalancer", "GetSSLCipherSuite", "https://docs.oracle.com/iaas/api/#/en/loadbalancer/20170115/SSLCipherSuite/GetSSLCipherSuite").method(Method.GET).requestBuilder(GetSSLCipherSuiteRequest::builder).basePath("/20170115").appendPathParam("loadBalancers").appendPathParam(request.getLoadBalancerId()).appendPathParam("sslCipherSuites").appendPathParam(request.getName()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("if-match", request.getIfMatch()).handleBody(SSLCipherSuite.class, GetSSLCipherSuiteResponse.Builder::sSLCipherSuite).handleResponseHeaderString("opc-request-id", GetSSLCipherSuiteResponse.Builder::opcRequestId).handleResponseHeaderString("eTag", GetSSLCipherSuiteResponse.Builder::eTag).callAsync(handler);
    }

    @Override
    public Future<GetWorkRequestResponse> getWorkRequest(GetWorkRequestRequest request, AsyncHandler<GetWorkRequestRequest, GetWorkRequestResponse> handler) {
        Validate.notBlank((String)request.getWorkRequestId(), (String)"workRequestId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, GetWorkRequestResponse::builder).logger(LOG, "getWorkRequest").serviceDetails("LoadBalancer", "GetWorkRequest", "https://docs.oracle.com/iaas/api/#/en/loadbalancer/20170115/WorkRequest/GetWorkRequest").method(Method.GET).requestBuilder(GetWorkRequestRequest::builder).basePath("/20170115").appendPathParam("loadBalancerWorkRequests").appendPathParam(request.getWorkRequestId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(WorkRequest.class, GetWorkRequestResponse.Builder::workRequest).handleResponseHeaderString("opc-request-id", GetWorkRequestResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<ListBackendSetsResponse> listBackendSets(ListBackendSetsRequest request, AsyncHandler<ListBackendSetsRequest, ListBackendSetsResponse> handler) {
        Validate.notBlank((String)request.getLoadBalancerId(), (String)"loadBalancerId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, ListBackendSetsResponse::builder).logger(LOG, "listBackendSets").serviceDetails("LoadBalancer", "ListBackendSets", "https://docs.oracle.com/iaas/api/#/en/loadbalancer/20170115/BackendSet/ListBackendSets").method(Method.GET).requestBuilder(ListBackendSetsRequest::builder).basePath("/20170115").appendPathParam("loadBalancers").appendPathParam(request.getLoadBalancerId()).appendPathParam("backendSets").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("if-match", request.getIfMatch()).handleBodyList(BackendSet.class, ListBackendSetsResponse.Builder::items).handleResponseHeaderString("opc-request-id", ListBackendSetsResponse.Builder::opcRequestId).handleResponseHeaderString("eTag", ListBackendSetsResponse.Builder::eTag).callAsync(handler);
    }

    @Override
    public Future<ListBackendsResponse> listBackends(ListBackendsRequest request, AsyncHandler<ListBackendsRequest, ListBackendsResponse> handler) {
        Validate.notBlank((String)request.getLoadBalancerId(), (String)"loadBalancerId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getBackendSetName(), (String)"backendSetName must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, ListBackendsResponse::builder).logger(LOG, "listBackends").serviceDetails("LoadBalancer", "ListBackends", "https://docs.oracle.com/iaas/api/#/en/loadbalancer/20170115/Backend/ListBackends").method(Method.GET).requestBuilder(ListBackendsRequest::builder).basePath("/20170115").appendPathParam("loadBalancers").appendPathParam(request.getLoadBalancerId()).appendPathParam("backendSets").appendPathParam(request.getBackendSetName()).appendPathParam("backends").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("if-match", request.getIfMatch()).handleBodyList(Backend.class, ListBackendsResponse.Builder::items).handleResponseHeaderString("opc-request-id", ListBackendsResponse.Builder::opcRequestId).handleResponseHeaderString("eTag", ListBackendsResponse.Builder::eTag).callAsync(handler);
    }

    @Override
    public Future<ListCertificatesResponse> listCertificates(ListCertificatesRequest request, AsyncHandler<ListCertificatesRequest, ListCertificatesResponse> handler) {
        Validate.notBlank((String)request.getLoadBalancerId(), (String)"loadBalancerId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, ListCertificatesResponse::builder).logger(LOG, "listCertificates").serviceDetails("LoadBalancer", "ListCertificates", "https://docs.oracle.com/iaas/api/#/en/loadbalancer/20170115/Certificate/ListCertificates").method(Method.GET).requestBuilder(ListCertificatesRequest::builder).basePath("/20170115").appendPathParam("loadBalancers").appendPathParam(request.getLoadBalancerId()).appendPathParam("certificates").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("if-match", request.getIfMatch()).handleBodyList(Certificate.class, ListCertificatesResponse.Builder::items).handleResponseHeaderString("opc-request-id", ListCertificatesResponse.Builder::opcRequestId).handleResponseHeaderString("eTag", ListCertificatesResponse.Builder::eTag).callAsync(handler);
    }

    @Override
    public Future<ListHostnamesResponse> listHostnames(ListHostnamesRequest request, AsyncHandler<ListHostnamesRequest, ListHostnamesResponse> handler) {
        Validate.notBlank((String)request.getLoadBalancerId(), (String)"loadBalancerId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, ListHostnamesResponse::builder).logger(LOG, "listHostnames").serviceDetails("LoadBalancer", "ListHostnames", "https://docs.oracle.com/iaas/api/#/en/loadbalancer/20170115/Hostname/ListHostnames").method(Method.GET).requestBuilder(ListHostnamesRequest::builder).basePath("/20170115").appendPathParam("loadBalancers").appendPathParam(request.getLoadBalancerId()).appendPathParam("hostnames").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("if-match", request.getIfMatch()).handleBodyList(Hostname.class, ListHostnamesResponse.Builder::items).handleResponseHeaderString("opc-request-id", ListHostnamesResponse.Builder::opcRequestId).handleResponseHeaderString("eTag", ListHostnamesResponse.Builder::eTag).callAsync(handler);
    }

    @Override
    public Future<ListListenerRulesResponse> listListenerRules(ListListenerRulesRequest request, AsyncHandler<ListListenerRulesRequest, ListListenerRulesResponse> handler) {
        Validate.notBlank((String)request.getLoadBalancerId(), (String)"loadBalancerId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getListenerName(), (String)"listenerName must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, ListListenerRulesResponse::builder).logger(LOG, "listListenerRules").serviceDetails("LoadBalancer", "ListListenerRules", "https://docs.oracle.com/iaas/api/#/en/loadbalancer/20170115/ListenerRuleSummary/ListListenerRules").method(Method.GET).requestBuilder(ListListenerRulesRequest::builder).basePath("/20170115").appendPathParam("loadBalancers").appendPathParam(request.getLoadBalancerId()).appendPathParam("listeners").appendPathParam(request.getListenerName()).appendPathParam("rules").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("if-match", request.getIfMatch()).handleBodyList(ListenerRuleSummary.class, ListListenerRulesResponse.Builder::items).handleResponseHeaderString("opc-request-id", ListListenerRulesResponse.Builder::opcRequestId).handleResponseHeaderString("eTag", ListListenerRulesResponse.Builder::eTag).callAsync(handler);
    }

    @Override
    public Future<ListLoadBalancerHealthsResponse> listLoadBalancerHealths(ListLoadBalancerHealthsRequest request, AsyncHandler<ListLoadBalancerHealthsRequest, ListLoadBalancerHealthsResponse> handler) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return this.clientCall(request, ListLoadBalancerHealthsResponse::builder).logger(LOG, "listLoadBalancerHealths").serviceDetails("LoadBalancer", "ListLoadBalancerHealths", "https://docs.oracle.com/iaas/api/#/en/loadbalancer/20170115/LoadBalancerHealthSummary/ListLoadBalancerHealths").method(Method.GET).requestBuilder(ListLoadBalancerHealthsRequest::builder).basePath("/20170115").appendPathParam("loadBalancerHealths").appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendQueryParam("compartmentId", (Object)request.getCompartmentId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBodyList(LoadBalancerHealthSummary.class, ListLoadBalancerHealthsResponse.Builder::items).handleResponseHeaderString("opc-next-page", ListLoadBalancerHealthsResponse.Builder::opcNextPage).handleResponseHeaderString("opc-request-id", ListLoadBalancerHealthsResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<ListLoadBalancersResponse> listLoadBalancers(ListLoadBalancersRequest request, AsyncHandler<ListLoadBalancersRequest, ListLoadBalancersResponse> handler) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return this.clientCall(request, ListLoadBalancersResponse::builder).logger(LOG, "listLoadBalancers").serviceDetails("LoadBalancer", "ListLoadBalancers", "https://docs.oracle.com/iaas/api/#/en/loadbalancer/20170115/LoadBalancer/ListLoadBalancers").method(Method.GET).requestBuilder(ListLoadBalancersRequest::builder).basePath("/20170115").appendPathParam("loadBalancers").appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("detail", (Object)request.getDetail()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendQueryParam("displayName", (Object)request.getDisplayName()).appendEnumQueryParam("lifecycleState", (BmcEnum)request.getLifecycleState()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBodyList(LoadBalancer.class, ListLoadBalancersResponse.Builder::items).handleResponseHeaderString("opc-next-page", ListLoadBalancersResponse.Builder::opcNextPage).handleResponseHeaderString("opc-request-id", ListLoadBalancersResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<ListPathRouteSetsResponse> listPathRouteSets(ListPathRouteSetsRequest request, AsyncHandler<ListPathRouteSetsRequest, ListPathRouteSetsResponse> handler) {
        Validate.notBlank((String)request.getLoadBalancerId(), (String)"loadBalancerId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, ListPathRouteSetsResponse::builder).logger(LOG, "listPathRouteSets").serviceDetails("LoadBalancer", "ListPathRouteSets", "https://docs.oracle.com/iaas/api/#/en/loadbalancer/20170115/PathRouteSet/ListPathRouteSets").method(Method.GET).requestBuilder(ListPathRouteSetsRequest::builder).basePath("/20170115").appendPathParam("loadBalancers").appendPathParam(request.getLoadBalancerId()).appendPathParam("pathRouteSets").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("if-match", request.getIfMatch()).handleBodyList(PathRouteSet.class, ListPathRouteSetsResponse.Builder::items).handleResponseHeaderString("opc-request-id", ListPathRouteSetsResponse.Builder::opcRequestId).handleResponseHeaderString("eTag", ListPathRouteSetsResponse.Builder::eTag).callAsync(handler);
    }

    @Override
    public Future<ListPoliciesResponse> listPolicies(ListPoliciesRequest request, AsyncHandler<ListPoliciesRequest, ListPoliciesResponse> handler) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return this.clientCall(request, ListPoliciesResponse::builder).logger(LOG, "listPolicies").serviceDetails("LoadBalancer", "ListPolicies", "https://docs.oracle.com/iaas/api/#/en/loadbalancer/20170115/LoadBalancerPolicy/ListPolicies").method(Method.GET).requestBuilder(ListPoliciesRequest::builder).basePath("/20170115").appendPathParam("loadBalancerPolicies").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBodyList(LoadBalancerPolicy.class, ListPoliciesResponse.Builder::items).handleResponseHeaderString("opc-next-page", ListPoliciesResponse.Builder::opcNextPage).handleResponseHeaderString("opc-request-id", ListPoliciesResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<ListProtocolsResponse> listProtocols(ListProtocolsRequest request, AsyncHandler<ListProtocolsRequest, ListProtocolsResponse> handler) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return this.clientCall(request, ListProtocolsResponse::builder).logger(LOG, "listProtocols").serviceDetails("LoadBalancer", "ListProtocols", "https://docs.oracle.com/iaas/api/#/en/loadbalancer/20170115/LoadBalancerProtocol/ListProtocols").method(Method.GET).requestBuilder(ListProtocolsRequest::builder).basePath("/20170115").appendPathParam("loadBalancerProtocols").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBodyList(LoadBalancerProtocol.class, ListProtocolsResponse.Builder::items).handleResponseHeaderString("opc-next-page", ListProtocolsResponse.Builder::opcNextPage).handleResponseHeaderString("opc-request-id", ListProtocolsResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<ListRoutingPoliciesResponse> listRoutingPolicies(ListRoutingPoliciesRequest request, AsyncHandler<ListRoutingPoliciesRequest, ListRoutingPoliciesResponse> handler) {
        Validate.notBlank((String)request.getLoadBalancerId(), (String)"loadBalancerId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, ListRoutingPoliciesResponse::builder).logger(LOG, "listRoutingPolicies").serviceDetails("LoadBalancer", "ListRoutingPolicies", "https://docs.oracle.com/iaas/api/#/en/loadbalancer/20170115/RoutingPolicy/ListRoutingPolicies").method(Method.GET).requestBuilder(ListRoutingPoliciesRequest::builder).basePath("/20170115").appendPathParam("loadBalancers").appendPathParam(request.getLoadBalancerId()).appendPathParam("routingPolicies").appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("if-match", request.getIfMatch()).handleBodyList(RoutingPolicy.class, ListRoutingPoliciesResponse.Builder::items).handleResponseHeaderString("opc-request-id", ListRoutingPoliciesResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListRoutingPoliciesResponse.Builder::opcNextPage).handleResponseHeaderString("eTag", ListRoutingPoliciesResponse.Builder::eTag).callAsync(handler);
    }

    @Override
    public Future<ListRuleSetsResponse> listRuleSets(ListRuleSetsRequest request, AsyncHandler<ListRuleSetsRequest, ListRuleSetsResponse> handler) {
        Validate.notBlank((String)request.getLoadBalancerId(), (String)"loadBalancerId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, ListRuleSetsResponse::builder).logger(LOG, "listRuleSets").serviceDetails("LoadBalancer", "ListRuleSets", "https://docs.oracle.com/iaas/api/#/en/loadbalancer/20170115/RuleSet/ListRuleSets").method(Method.GET).requestBuilder(ListRuleSetsRequest::builder).basePath("/20170115").appendPathParam("loadBalancers").appendPathParam(request.getLoadBalancerId()).appendPathParam("ruleSets").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("if-match", request.getIfMatch()).handleBodyList(RuleSet.class, ListRuleSetsResponse.Builder::items).handleResponseHeaderString("opc-request-id", ListRuleSetsResponse.Builder::opcRequestId).handleResponseHeaderString("eTag", ListRuleSetsResponse.Builder::eTag).callAsync(handler);
    }

    @Override
    public Future<ListSSLCipherSuitesResponse> listSSLCipherSuites(ListSSLCipherSuitesRequest request, AsyncHandler<ListSSLCipherSuitesRequest, ListSSLCipherSuitesResponse> handler) {
        Validate.notBlank((String)request.getLoadBalancerId(), (String)"loadBalancerId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, ListSSLCipherSuitesResponse::builder).logger(LOG, "listSSLCipherSuites").serviceDetails("LoadBalancer", "ListSSLCipherSuites", "https://docs.oracle.com/iaas/api/#/en/loadbalancer/20170115/SSLCipherSuite/ListSSLCipherSuites").method(Method.GET).requestBuilder(ListSSLCipherSuitesRequest::builder).basePath("/20170115").appendPathParam("loadBalancers").appendPathParam(request.getLoadBalancerId()).appendPathParam("sslCipherSuites").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("if-match", request.getIfMatch()).handleBodyList(SSLCipherSuite.class, ListSSLCipherSuitesResponse.Builder::items).handleResponseHeaderString("opc-request-id", ListSSLCipherSuitesResponse.Builder::opcRequestId).handleResponseHeaderString("eTag", ListSSLCipherSuitesResponse.Builder::eTag).callAsync(handler);
    }

    @Override
    public Future<ListShapesResponse> listShapes(ListShapesRequest request, AsyncHandler<ListShapesRequest, ListShapesResponse> handler) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return this.clientCall(request, ListShapesResponse::builder).logger(LOG, "listShapes").serviceDetails("LoadBalancer", "ListShapes", "https://docs.oracle.com/iaas/api/#/en/loadbalancer/20170115/LoadBalancerShape/ListShapes").method(Method.GET).requestBuilder(ListShapesRequest::builder).basePath("/20170115").appendPathParam("loadBalancerShapes").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBodyList(LoadBalancerShape.class, ListShapesResponse.Builder::items).handleResponseHeaderString("opc-next-page", ListShapesResponse.Builder::opcNextPage).handleResponseHeaderString("opc-request-id", ListShapesResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<ListWorkRequestsResponse> listWorkRequests(ListWorkRequestsRequest request, AsyncHandler<ListWorkRequestsRequest, ListWorkRequestsResponse> handler) {
        Validate.notBlank((String)request.getLoadBalancerId(), (String)"loadBalancerId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, ListWorkRequestsResponse::builder).logger(LOG, "listWorkRequests").serviceDetails("LoadBalancer", "ListWorkRequests", "https://docs.oracle.com/iaas/api/#/en/loadbalancer/20170115/WorkRequest/ListWorkRequests").method(Method.GET).requestBuilder(ListWorkRequestsRequest::builder).basePath("/20170115").appendPathParam("loadBalancers").appendPathParam(request.getLoadBalancerId()).appendPathParam("workRequests").appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBodyList(WorkRequest.class, ListWorkRequestsResponse.Builder::items).handleResponseHeaderString("opc-next-page", ListWorkRequestsResponse.Builder::opcNextPage).handleResponseHeaderString("opc-request-id", ListWorkRequestsResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<UpdateBackendResponse> updateBackend(UpdateBackendRequest request, AsyncHandler<UpdateBackendRequest, UpdateBackendResponse> handler) {
        Objects.requireNonNull(request.getUpdateBackendDetails(), "updateBackendDetails is required");
        Validate.notBlank((String)request.getLoadBalancerId(), (String)"loadBalancerId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getBackendSetName(), (String)"backendSetName must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getBackendName(), (String)"backendName must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, UpdateBackendResponse::builder).logger(LOG, "updateBackend").serviceDetails("LoadBalancer", "UpdateBackend", "").method(Method.PUT).requestBuilder(UpdateBackendRequest::builder).basePath("/20170115").appendPathParam("loadBalancers").appendPathParam(request.getLoadBalancerId()).appendPathParam("backendSets").appendPathParam(request.getBackendSetName()).appendPathParam("backends").appendPathParam(request.getBackendName()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("if-match", request.getIfMatch()).hasBody().handleResponseHeaderString("opc-work-request-id", UpdateBackendResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", UpdateBackendResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<UpdateBackendSetResponse> updateBackendSet(UpdateBackendSetRequest request, AsyncHandler<UpdateBackendSetRequest, UpdateBackendSetResponse> handler) {
        Objects.requireNonNull(request.getUpdateBackendSetDetails(), "updateBackendSetDetails is required");
        Validate.notBlank((String)request.getLoadBalancerId(), (String)"loadBalancerId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getBackendSetName(), (String)"backendSetName must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, UpdateBackendSetResponse::builder).logger(LOG, "updateBackendSet").serviceDetails("LoadBalancer", "UpdateBackendSet", "").method(Method.PUT).requestBuilder(UpdateBackendSetRequest::builder).basePath("/20170115").appendPathParam("loadBalancers").appendPathParam(request.getLoadBalancerId()).appendPathParam("backendSets").appendPathParam(request.getBackendSetName()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("if-match", request.getIfMatch()).hasBody().handleResponseHeaderString("opc-work-request-id", UpdateBackendSetResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", UpdateBackendSetResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<UpdateHealthCheckerResponse> updateHealthChecker(UpdateHealthCheckerRequest request, AsyncHandler<UpdateHealthCheckerRequest, UpdateHealthCheckerResponse> handler) {
        Objects.requireNonNull(request.getHealthChecker(), "healthChecker is required");
        Validate.notBlank((String)request.getLoadBalancerId(), (String)"loadBalancerId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getBackendSetName(), (String)"backendSetName must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, UpdateHealthCheckerResponse::builder).logger(LOG, "updateHealthChecker").serviceDetails("LoadBalancer", "UpdateHealthChecker", "").method(Method.PUT).requestBuilder(UpdateHealthCheckerRequest::builder).basePath("/20170115").appendPathParam("loadBalancers").appendPathParam(request.getLoadBalancerId()).appendPathParam("backendSets").appendPathParam(request.getBackendSetName()).appendPathParam("healthChecker").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("if-match", request.getIfMatch()).hasBody().handleResponseHeaderString("opc-work-request-id", UpdateHealthCheckerResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", UpdateHealthCheckerResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<UpdateHostnameResponse> updateHostname(UpdateHostnameRequest request, AsyncHandler<UpdateHostnameRequest, UpdateHostnameResponse> handler) {
        Objects.requireNonNull(request.getUpdateHostnameDetails(), "updateHostnameDetails is required");
        Validate.notBlank((String)request.getLoadBalancerId(), (String)"loadBalancerId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getName(), (String)"name must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, UpdateHostnameResponse::builder).logger(LOG, "updateHostname").serviceDetails("LoadBalancer", "UpdateHostname", "").method(Method.PUT).requestBuilder(UpdateHostnameRequest::builder).basePath("/20170115").appendPathParam("loadBalancers").appendPathParam(request.getLoadBalancerId()).appendPathParam("hostnames").appendPathParam(request.getName()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("if-match", request.getIfMatch()).hasBody().handleResponseHeaderString("opc-work-request-id", UpdateHostnameResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", UpdateHostnameResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<UpdateListenerResponse> updateListener(UpdateListenerRequest request, AsyncHandler<UpdateListenerRequest, UpdateListenerResponse> handler) {
        Objects.requireNonNull(request.getUpdateListenerDetails(), "updateListenerDetails is required");
        Validate.notBlank((String)request.getLoadBalancerId(), (String)"loadBalancerId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getListenerName(), (String)"listenerName must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, UpdateListenerResponse::builder).logger(LOG, "updateListener").serviceDetails("LoadBalancer", "UpdateListener", "").method(Method.PUT).requestBuilder(UpdateListenerRequest::builder).basePath("/20170115").appendPathParam("loadBalancers").appendPathParam(request.getLoadBalancerId()).appendPathParam("listeners").appendPathParam(request.getListenerName()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("if-match", request.getIfMatch()).hasBody().handleResponseHeaderString("opc-work-request-id", UpdateListenerResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", UpdateListenerResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<UpdateLoadBalancerResponse> updateLoadBalancer(UpdateLoadBalancerRequest request, AsyncHandler<UpdateLoadBalancerRequest, UpdateLoadBalancerResponse> handler) {
        Objects.requireNonNull(request.getUpdateLoadBalancerDetails(), "updateLoadBalancerDetails is required");
        Validate.notBlank((String)request.getLoadBalancerId(), (String)"loadBalancerId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, UpdateLoadBalancerResponse::builder).logger(LOG, "updateLoadBalancer").serviceDetails("LoadBalancer", "UpdateLoadBalancer", "").method(Method.PUT).requestBuilder(UpdateLoadBalancerRequest::builder).basePath("/20170115").appendPathParam("loadBalancers").appendPathParam(request.getLoadBalancerId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBody().handleResponseHeaderString("opc-work-request-id", UpdateLoadBalancerResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", UpdateLoadBalancerResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<UpdateLoadBalancerShapeResponse> updateLoadBalancerShape(UpdateLoadBalancerShapeRequest request, AsyncHandler<UpdateLoadBalancerShapeRequest, UpdateLoadBalancerShapeResponse> handler) {
        Validate.notBlank((String)request.getLoadBalancerId(), (String)"loadBalancerId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdateLoadBalancerShapeDetails(), "updateLoadBalancerShapeDetails is required");
        return this.clientCall(request, UpdateLoadBalancerShapeResponse::builder).logger(LOG, "updateLoadBalancerShape").serviceDetails("LoadBalancer", "UpdateLoadBalancerShape", "https://docs.oracle.com/iaas/api/#/en/loadbalancer/20170115/LoadBalancer/UpdateLoadBalancerShape").method(Method.PUT).requestBuilder(UpdateLoadBalancerShapeRequest::builder).basePath("/20170115").appendPathParam("loadBalancers").appendPathParam(request.getLoadBalancerId()).appendPathParam("updateShape").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("if-match", request.getIfMatch()).hasBody().handleResponseHeaderString("opc-work-request-id", UpdateLoadBalancerShapeResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", UpdateLoadBalancerShapeResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<UpdateNetworkSecurityGroupsResponse> updateNetworkSecurityGroups(UpdateNetworkSecurityGroupsRequest request, AsyncHandler<UpdateNetworkSecurityGroupsRequest, UpdateNetworkSecurityGroupsResponse> handler) {
        Objects.requireNonNull(request.getUpdateNetworkSecurityGroupsDetails(), "updateNetworkSecurityGroupsDetails is required");
        Validate.notBlank((String)request.getLoadBalancerId(), (String)"loadBalancerId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, UpdateNetworkSecurityGroupsResponse::builder).logger(LOG, "updateNetworkSecurityGroups").serviceDetails("LoadBalancer", "UpdateNetworkSecurityGroups", "https://docs.oracle.com/iaas/api/#/en/loadbalancer/20170115/NetworkSecurityGroups/UpdateNetworkSecurityGroups").method(Method.PUT).requestBuilder(UpdateNetworkSecurityGroupsRequest::builder).basePath("/20170115").appendPathParam("loadBalancers").appendPathParam(request.getLoadBalancerId()).appendPathParam("networkSecurityGroups").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("if-match", request.getIfMatch()).hasBody().handleResponseHeaderString("opc-work-request-id", UpdateNetworkSecurityGroupsResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", UpdateNetworkSecurityGroupsResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<UpdatePathRouteSetResponse> updatePathRouteSet(UpdatePathRouteSetRequest request, AsyncHandler<UpdatePathRouteSetRequest, UpdatePathRouteSetResponse> handler) {
        Objects.requireNonNull(request.getUpdatePathRouteSetDetails(), "updatePathRouteSetDetails is required");
        Validate.notBlank((String)request.getLoadBalancerId(), (String)"loadBalancerId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getPathRouteSetName(), (String)"pathRouteSetName must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, UpdatePathRouteSetResponse::builder).logger(LOG, "updatePathRouteSet").serviceDetails("LoadBalancer", "UpdatePathRouteSet", "").method(Method.PUT).requestBuilder(UpdatePathRouteSetRequest::builder).basePath("/20170115").appendPathParam("loadBalancers").appendPathParam(request.getLoadBalancerId()).appendPathParam("pathRouteSets").appendPathParam(request.getPathRouteSetName()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBody().handleResponseHeaderString("opc-work-request-id", UpdatePathRouteSetResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", UpdatePathRouteSetResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<UpdateRoutingPolicyResponse> updateRoutingPolicy(UpdateRoutingPolicyRequest request, AsyncHandler<UpdateRoutingPolicyRequest, UpdateRoutingPolicyResponse> handler) {
        Objects.requireNonNull(request.getUpdateRoutingPolicyDetails(), "updateRoutingPolicyDetails is required");
        Validate.notBlank((String)request.getLoadBalancerId(), (String)"loadBalancerId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getRoutingPolicyName(), (String)"routingPolicyName must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, UpdateRoutingPolicyResponse::builder).logger(LOG, "updateRoutingPolicy").serviceDetails("LoadBalancer", "UpdateRoutingPolicy", "").method(Method.PUT).requestBuilder(UpdateRoutingPolicyRequest::builder).basePath("/20170115").appendPathParam("loadBalancers").appendPathParam(request.getLoadBalancerId()).appendPathParam("routingPolicies").appendPathParam(request.getRoutingPolicyName()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBody().handleResponseHeaderString("opc-work-request-id", UpdateRoutingPolicyResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", UpdateRoutingPolicyResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<UpdateRuleSetResponse> updateRuleSet(UpdateRuleSetRequest request, AsyncHandler<UpdateRuleSetRequest, UpdateRuleSetResponse> handler) {
        Validate.notBlank((String)request.getLoadBalancerId(), (String)"loadBalancerId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getRuleSetName(), (String)"ruleSetName must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdateRuleSetDetails(), "updateRuleSetDetails is required");
        return this.clientCall(request, UpdateRuleSetResponse::builder).logger(LOG, "updateRuleSet").serviceDetails("LoadBalancer", "UpdateRuleSet", "").method(Method.PUT).requestBuilder(UpdateRuleSetRequest::builder).basePath("/20170115").appendPathParam("loadBalancers").appendPathParam(request.getLoadBalancerId()).appendPathParam("ruleSets").appendPathParam(request.getRuleSetName()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("if-match", request.getIfMatch()).hasBody().handleResponseHeaderString("opc-work-request-id", UpdateRuleSetResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", UpdateRuleSetResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<UpdateSSLCipherSuiteResponse> updateSSLCipherSuite(UpdateSSLCipherSuiteRequest request, AsyncHandler<UpdateSSLCipherSuiteRequest, UpdateSSLCipherSuiteResponse> handler) {
        Objects.requireNonNull(request.getUpdateSSLCipherSuiteDetails(), "updateSSLCipherSuiteDetails is required");
        Validate.notBlank((String)request.getLoadBalancerId(), (String)"loadBalancerId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getName(), (String)"name must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, UpdateSSLCipherSuiteResponse::builder).logger(LOG, "updateSSLCipherSuite").serviceDetails("LoadBalancer", "UpdateSSLCipherSuite", "").method(Method.PUT).requestBuilder(UpdateSSLCipherSuiteRequest::builder).basePath("/20170115").appendPathParam("loadBalancers").appendPathParam(request.getLoadBalancerId()).appendPathParam("sslCipherSuites").appendPathParam(request.getName()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("if-match", request.getIfMatch()).hasBody().handleResponseHeaderString("opc-work-request-id", UpdateSSLCipherSuiteResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", UpdateSSLCipherSuiteResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Deprecated
    public LoadBalancerAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider) {
        this((ClientBuilderBase<?, ?>)LoadBalancerAsyncClient.builder(), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider);
    }

    @Deprecated
    public LoadBalancerAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration) {
        this(LoadBalancerAsyncClient.builder().configuration(configuration), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider);
    }

    @Deprecated
    public LoadBalancerAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator) {
        this(((Builder)LoadBalancerAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider);
    }

    @Deprecated
    public LoadBalancerAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory) {
        this(((Builder)((Builder)LoadBalancerAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory), authenticationDetailsProvider);
    }

    @Deprecated
    public LoadBalancerAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators) {
        this(((Builder)((Builder)((Builder)LoadBalancerAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators), authenticationDetailsProvider);
    }

    @Deprecated
    public LoadBalancerAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(((Builder)((Builder)((Builder)((Builder)LoadBalancerAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint), authenticationDetailsProvider);
    }

    @Deprecated
    public LoadBalancerAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(((Builder)((Builder)((Builder)((Builder)((Builder)LoadBalancerAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint)).signingStrategyRequestSignerFactories(signingStrategyRequestSignerFactories), authenticationDetailsProvider);
    }

    public static class Builder
    extends RegionalClientBuilder<Builder, LoadBalancerAsyncClient> {
        private Builder(Service service) {
            super(service);
            String packageName = "loadbalancer";
            Alloy.throwDisabledServiceExceptionIfAppropriate((String)"loadbalancer");
            this.requestSignerFactory = new DefaultRequestSignerFactory(SigningStrategy.STANDARD);
        }

        public LoadBalancerAsyncClient build(@Nonnull AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
            return new LoadBalancerAsyncClient((ClientBuilderBase<?, ?>)this, authenticationDetailsProvider);
        }
    }
}

