/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.loadbalancer;

import com.oracle.bmc.ClientConfiguration;
import com.oracle.bmc.Region;
import com.oracle.bmc.Service;
import com.oracle.bmc.Services;
import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.auth.BasicAuthenticationDetailsProvider;
import com.oracle.bmc.common.ClientBuilderBase;
import com.oracle.bmc.common.RegionalClientBuilder;
import com.oracle.bmc.http.ClientConfigurator;
import com.oracle.bmc.http.client.Method;
import com.oracle.bmc.http.internal.BaseSyncClient;
import com.oracle.bmc.http.internal.BmcEnum;
import com.oracle.bmc.http.signing.RequestSignerFactory;
import com.oracle.bmc.http.signing.SigningStrategy;
import com.oracle.bmc.http.signing.internal.DefaultRequestSignerFactory;
import com.oracle.bmc.internal.Alloy;
import com.oracle.bmc.internal.ClientThreadFactory;
import com.oracle.bmc.loadbalancer.LoadBalancer;
import com.oracle.bmc.loadbalancer.LoadBalancerPaginators;
import com.oracle.bmc.loadbalancer.LoadBalancerWaiters;
import com.oracle.bmc.loadbalancer.model.Backend;
import com.oracle.bmc.loadbalancer.model.BackendHealth;
import com.oracle.bmc.loadbalancer.model.BackendSet;
import com.oracle.bmc.loadbalancer.model.BackendSetHealth;
import com.oracle.bmc.loadbalancer.model.Certificate;
import com.oracle.bmc.loadbalancer.model.HealthChecker;
import com.oracle.bmc.loadbalancer.model.Hostname;
import com.oracle.bmc.loadbalancer.model.ListenerRuleSummary;
import com.oracle.bmc.loadbalancer.model.LoadBalancerHealth;
import com.oracle.bmc.loadbalancer.model.LoadBalancerHealthSummary;
import com.oracle.bmc.loadbalancer.model.LoadBalancerPolicy;
import com.oracle.bmc.loadbalancer.model.LoadBalancerProtocol;
import com.oracle.bmc.loadbalancer.model.LoadBalancerShape;
import com.oracle.bmc.loadbalancer.model.PathRouteSet;
import com.oracle.bmc.loadbalancer.model.RoutingPolicy;
import com.oracle.bmc.loadbalancer.model.RuleSet;
import com.oracle.bmc.loadbalancer.model.SSLCipherSuite;
import com.oracle.bmc.loadbalancer.model.WorkRequest;
import com.oracle.bmc.loadbalancer.requests.ChangeLoadBalancerCompartmentRequest;
import com.oracle.bmc.loadbalancer.requests.CreateBackendRequest;
import com.oracle.bmc.loadbalancer.requests.CreateBackendSetRequest;
import com.oracle.bmc.loadbalancer.requests.CreateCertificateRequest;
import com.oracle.bmc.loadbalancer.requests.CreateHostnameRequest;
import com.oracle.bmc.loadbalancer.requests.CreateListenerRequest;
import com.oracle.bmc.loadbalancer.requests.CreateLoadBalancerRequest;
import com.oracle.bmc.loadbalancer.requests.CreatePathRouteSetRequest;
import com.oracle.bmc.loadbalancer.requests.CreateRoutingPolicyRequest;
import com.oracle.bmc.loadbalancer.requests.CreateRuleSetRequest;
import com.oracle.bmc.loadbalancer.requests.CreateSSLCipherSuiteRequest;
import com.oracle.bmc.loadbalancer.requests.DeleteBackendRequest;
import com.oracle.bmc.loadbalancer.requests.DeleteBackendSetRequest;
import com.oracle.bmc.loadbalancer.requests.DeleteCertificateRequest;
import com.oracle.bmc.loadbalancer.requests.DeleteHostnameRequest;
import com.oracle.bmc.loadbalancer.requests.DeleteListenerRequest;
import com.oracle.bmc.loadbalancer.requests.DeleteLoadBalancerRequest;
import com.oracle.bmc.loadbalancer.requests.DeletePathRouteSetRequest;
import com.oracle.bmc.loadbalancer.requests.DeleteRoutingPolicyRequest;
import com.oracle.bmc.loadbalancer.requests.DeleteRuleSetRequest;
import com.oracle.bmc.loadbalancer.requests.DeleteSSLCipherSuiteRequest;
import com.oracle.bmc.loadbalancer.requests.GetBackendHealthRequest;
import com.oracle.bmc.loadbalancer.requests.GetBackendRequest;
import com.oracle.bmc.loadbalancer.requests.GetBackendSetHealthRequest;
import com.oracle.bmc.loadbalancer.requests.GetBackendSetRequest;
import com.oracle.bmc.loadbalancer.requests.GetHealthCheckerRequest;
import com.oracle.bmc.loadbalancer.requests.GetHostnameRequest;
import com.oracle.bmc.loadbalancer.requests.GetLoadBalancerHealthRequest;
import com.oracle.bmc.loadbalancer.requests.GetLoadBalancerRequest;
import com.oracle.bmc.loadbalancer.requests.GetPathRouteSetRequest;
import com.oracle.bmc.loadbalancer.requests.GetRoutingPolicyRequest;
import com.oracle.bmc.loadbalancer.requests.GetRuleSetRequest;
import com.oracle.bmc.loadbalancer.requests.GetSSLCipherSuiteRequest;
import com.oracle.bmc.loadbalancer.requests.GetWorkRequestRequest;
import com.oracle.bmc.loadbalancer.requests.ListBackendSetsRequest;
import com.oracle.bmc.loadbalancer.requests.ListBackendsRequest;
import com.oracle.bmc.loadbalancer.requests.ListCertificatesRequest;
import com.oracle.bmc.loadbalancer.requests.ListHostnamesRequest;
import com.oracle.bmc.loadbalancer.requests.ListListenerRulesRequest;
import com.oracle.bmc.loadbalancer.requests.ListLoadBalancerHealthsRequest;
import com.oracle.bmc.loadbalancer.requests.ListLoadBalancersRequest;
import com.oracle.bmc.loadbalancer.requests.ListPathRouteSetsRequest;
import com.oracle.bmc.loadbalancer.requests.ListPoliciesRequest;
import com.oracle.bmc.loadbalancer.requests.ListProtocolsRequest;
import com.oracle.bmc.loadbalancer.requests.ListRoutingPoliciesRequest;
import com.oracle.bmc.loadbalancer.requests.ListRuleSetsRequest;
import com.oracle.bmc.loadbalancer.requests.ListSSLCipherSuitesRequest;
import com.oracle.bmc.loadbalancer.requests.ListShapesRequest;
import com.oracle.bmc.loadbalancer.requests.ListWorkRequestsRequest;
import com.oracle.bmc.loadbalancer.requests.UpdateBackendRequest;
import com.oracle.bmc.loadbalancer.requests.UpdateBackendSetRequest;
import com.oracle.bmc.loadbalancer.requests.UpdateHealthCheckerRequest;
import com.oracle.bmc.loadbalancer.requests.UpdateHostnameRequest;
import com.oracle.bmc.loadbalancer.requests.UpdateListenerRequest;
import com.oracle.bmc.loadbalancer.requests.UpdateLoadBalancerRequest;
import com.oracle.bmc.loadbalancer.requests.UpdateLoadBalancerShapeRequest;
import com.oracle.bmc.loadbalancer.requests.UpdateNetworkSecurityGroupsRequest;
import com.oracle.bmc.loadbalancer.requests.UpdatePathRouteSetRequest;
import com.oracle.bmc.loadbalancer.requests.UpdateRoutingPolicyRequest;
import com.oracle.bmc.loadbalancer.requests.UpdateRuleSetRequest;
import com.oracle.bmc.loadbalancer.requests.UpdateSSLCipherSuiteRequest;
import com.oracle.bmc.loadbalancer.responses.ChangeLoadBalancerCompartmentResponse;
import com.oracle.bmc.loadbalancer.responses.CreateBackendResponse;
import com.oracle.bmc.loadbalancer.responses.CreateBackendSetResponse;
import com.oracle.bmc.loadbalancer.responses.CreateCertificateResponse;
import com.oracle.bmc.loadbalancer.responses.CreateHostnameResponse;
import com.oracle.bmc.loadbalancer.responses.CreateListenerResponse;
import com.oracle.bmc.loadbalancer.responses.CreateLoadBalancerResponse;
import com.oracle.bmc.loadbalancer.responses.CreatePathRouteSetResponse;
import com.oracle.bmc.loadbalancer.responses.CreateRoutingPolicyResponse;
import com.oracle.bmc.loadbalancer.responses.CreateRuleSetResponse;
import com.oracle.bmc.loadbalancer.responses.CreateSSLCipherSuiteResponse;
import com.oracle.bmc.loadbalancer.responses.DeleteBackendResponse;
import com.oracle.bmc.loadbalancer.responses.DeleteBackendSetResponse;
import com.oracle.bmc.loadbalancer.responses.DeleteCertificateResponse;
import com.oracle.bmc.loadbalancer.responses.DeleteHostnameResponse;
import com.oracle.bmc.loadbalancer.responses.DeleteListenerResponse;
import com.oracle.bmc.loadbalancer.responses.DeleteLoadBalancerResponse;
import com.oracle.bmc.loadbalancer.responses.DeletePathRouteSetResponse;
import com.oracle.bmc.loadbalancer.responses.DeleteRoutingPolicyResponse;
import com.oracle.bmc.loadbalancer.responses.DeleteRuleSetResponse;
import com.oracle.bmc.loadbalancer.responses.DeleteSSLCipherSuiteResponse;
import com.oracle.bmc.loadbalancer.responses.GetBackendHealthResponse;
import com.oracle.bmc.loadbalancer.responses.GetBackendResponse;
import com.oracle.bmc.loadbalancer.responses.GetBackendSetHealthResponse;
import com.oracle.bmc.loadbalancer.responses.GetBackendSetResponse;
import com.oracle.bmc.loadbalancer.responses.GetHealthCheckerResponse;
import com.oracle.bmc.loadbalancer.responses.GetHostnameResponse;
import com.oracle.bmc.loadbalancer.responses.GetLoadBalancerHealthResponse;
import com.oracle.bmc.loadbalancer.responses.GetLoadBalancerResponse;
import com.oracle.bmc.loadbalancer.responses.GetPathRouteSetResponse;
import com.oracle.bmc.loadbalancer.responses.GetRoutingPolicyResponse;
import com.oracle.bmc.loadbalancer.responses.GetRuleSetResponse;
import com.oracle.bmc.loadbalancer.responses.GetSSLCipherSuiteResponse;
import com.oracle.bmc.loadbalancer.responses.GetWorkRequestResponse;
import com.oracle.bmc.loadbalancer.responses.ListBackendSetsResponse;
import com.oracle.bmc.loadbalancer.responses.ListBackendsResponse;
import com.oracle.bmc.loadbalancer.responses.ListCertificatesResponse;
import com.oracle.bmc.loadbalancer.responses.ListHostnamesResponse;
import com.oracle.bmc.loadbalancer.responses.ListListenerRulesResponse;
import com.oracle.bmc.loadbalancer.responses.ListLoadBalancerHealthsResponse;
import com.oracle.bmc.loadbalancer.responses.ListLoadBalancersResponse;
import com.oracle.bmc.loadbalancer.responses.ListPathRouteSetsResponse;
import com.oracle.bmc.loadbalancer.responses.ListPoliciesResponse;
import com.oracle.bmc.loadbalancer.responses.ListProtocolsResponse;
import com.oracle.bmc.loadbalancer.responses.ListRoutingPoliciesResponse;
import com.oracle.bmc.loadbalancer.responses.ListRuleSetsResponse;
import com.oracle.bmc.loadbalancer.responses.ListSSLCipherSuitesResponse;
import com.oracle.bmc.loadbalancer.responses.ListShapesResponse;
import com.oracle.bmc.loadbalancer.responses.ListWorkRequestsResponse;
import com.oracle.bmc.loadbalancer.responses.UpdateBackendResponse;
import com.oracle.bmc.loadbalancer.responses.UpdateBackendSetResponse;
import com.oracle.bmc.loadbalancer.responses.UpdateHealthCheckerResponse;
import com.oracle.bmc.loadbalancer.responses.UpdateHostnameResponse;
import com.oracle.bmc.loadbalancer.responses.UpdateListenerResponse;
import com.oracle.bmc.loadbalancer.responses.UpdateLoadBalancerResponse;
import com.oracle.bmc.loadbalancer.responses.UpdateLoadBalancerShapeResponse;
import com.oracle.bmc.loadbalancer.responses.UpdateNetworkSecurityGroupsResponse;
import com.oracle.bmc.loadbalancer.responses.UpdatePathRouteSetResponse;
import com.oracle.bmc.loadbalancer.responses.UpdateRoutingPolicyResponse;
import com.oracle.bmc.loadbalancer.responses.UpdateRuleSetResponse;
import com.oracle.bmc.loadbalancer.responses.UpdateSSLCipherSuiteResponse;
import com.oracle.bmc.util.CircuitBreakerUtils;
import com.oracle.bmc.util.internal.Validate;
import jakarta.annotation.Nonnull;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoadBalancerClient
extends BaseSyncClient
implements LoadBalancer {
    public static final Service SERVICE = Services.serviceBuilder().serviceName("LOADBALANCER").serviceEndpointPrefix("iaas").serviceEndpointTemplate("https://iaas.{region}.{secondLevelDomain}").build();
    private static final Logger LOG = LoggerFactory.getLogger(LoadBalancerClient.class);
    private final LoadBalancerWaiters waiters;
    private final LoadBalancerPaginators paginators;

    LoadBalancerClient(ClientBuilderBase<?, ?> builder, AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ExecutorService executorService) {
        super(builder, authenticationDetailsProvider, CircuitBreakerUtils.DEFAULT_CIRCUIT_BREAKER_CONFIGURATION);
        if (executorService == null) {
            ThreadPoolExecutor threadPoolExecutor = new ThreadPoolExecutor(50, 50, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), (ThreadFactory)ClientThreadFactory.builder().isDaemon(true).nameFormat("LoadBalancer-waiters-%d").build());
            threadPoolExecutor.allowCoreThreadTimeOut(true);
            executorService = threadPoolExecutor;
        }
        this.waiters = new LoadBalancerWaiters(executorService, this);
        this.paginators = new LoadBalancerPaginators(this);
    }

    public static Builder builder() {
        return new Builder(SERVICE);
    }

    @Override
    public void setRegion(Region region) {
        super.setRegion(region);
    }

    @Override
    public void setRegion(String regionId) {
        super.setRegion(regionId);
    }

    @Override
    public ChangeLoadBalancerCompartmentResponse changeLoadBalancerCompartment(ChangeLoadBalancerCompartmentRequest request) {
        Validate.notBlank((String)request.getLoadBalancerId(), (String)"loadBalancerId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getChangeLoadBalancerCompartmentDetails(), "changeLoadBalancerCompartmentDetails is required");
        return (ChangeLoadBalancerCompartmentResponse)this.clientCall(request, ChangeLoadBalancerCompartmentResponse::builder).logger(LOG, "changeLoadBalancerCompartment").serviceDetails("LoadBalancer", "ChangeLoadBalancerCompartment", "https://docs.oracle.com/iaas/api/#/en/loadbalancer/20170115/LoadBalancer/ChangeLoadBalancerCompartment").method(Method.POST).requestBuilder(ChangeLoadBalancerCompartmentRequest::builder).basePath("/20170115").appendPathParam("loadBalancers").appendPathParam(request.getLoadBalancerId()).appendPathParam("changeCompartment").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("if-match", request.getIfMatch()).hasBody().handleResponseHeaderString("opc-work-request-id", ChangeLoadBalancerCompartmentResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", ChangeLoadBalancerCompartmentResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public CreateBackendResponse createBackend(CreateBackendRequest request) {
        Objects.requireNonNull(request.getCreateBackendDetails(), "createBackendDetails is required");
        Validate.notBlank((String)request.getLoadBalancerId(), (String)"loadBalancerId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getBackendSetName(), (String)"backendSetName must not be blank", (Object[])new Object[0]);
        return (CreateBackendResponse)this.clientCall(request, CreateBackendResponse::builder).logger(LOG, "createBackend").serviceDetails("LoadBalancer", "CreateBackend", "").method(Method.POST).requestBuilder(CreateBackendRequest::builder).basePath("/20170115").appendPathParam("loadBalancers").appendPathParam(request.getLoadBalancerId()).appendPathParam("backendSets").appendPathParam(request.getBackendSetName()).appendPathParam("backends").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBody().handleResponseHeaderString("opc-work-request-id", CreateBackendResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", CreateBackendResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public CreateBackendSetResponse createBackendSet(CreateBackendSetRequest request) {
        Objects.requireNonNull(request.getCreateBackendSetDetails(), "createBackendSetDetails is required");
        Validate.notBlank((String)request.getLoadBalancerId(), (String)"loadBalancerId must not be blank", (Object[])new Object[0]);
        return (CreateBackendSetResponse)this.clientCall(request, CreateBackendSetResponse::builder).logger(LOG, "createBackendSet").serviceDetails("LoadBalancer", "CreateBackendSet", "").method(Method.POST).requestBuilder(CreateBackendSetRequest::builder).basePath("/20170115").appendPathParam("loadBalancers").appendPathParam(request.getLoadBalancerId()).appendPathParam("backendSets").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("if-match", request.getIfMatch()).hasBody().handleResponseHeaderString("opc-work-request-id", CreateBackendSetResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", CreateBackendSetResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public CreateCertificateResponse createCertificate(CreateCertificateRequest request) {
        Objects.requireNonNull(request.getCreateCertificateDetails(), "createCertificateDetails is required");
        Validate.notBlank((String)request.getLoadBalancerId(), (String)"loadBalancerId must not be blank", (Object[])new Object[0]);
        return (CreateCertificateResponse)this.clientCall(request, CreateCertificateResponse::builder).logger(LOG, "createCertificate").serviceDetails("LoadBalancer", "CreateCertificate", "").method(Method.POST).requestBuilder(CreateCertificateRequest::builder).basePath("/20170115").appendPathParam("loadBalancers").appendPathParam(request.getLoadBalancerId()).appendPathParam("certificates").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("if-match", request.getIfMatch()).hasBody().handleResponseHeaderString("opc-work-request-id", CreateCertificateResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", CreateCertificateResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public CreateHostnameResponse createHostname(CreateHostnameRequest request) {
        Objects.requireNonNull(request.getCreateHostnameDetails(), "createHostnameDetails is required");
        Validate.notBlank((String)request.getLoadBalancerId(), (String)"loadBalancerId must not be blank", (Object[])new Object[0]);
        return (CreateHostnameResponse)this.clientCall(request, CreateHostnameResponse::builder).logger(LOG, "createHostname").serviceDetails("LoadBalancer", "CreateHostname", "").method(Method.POST).requestBuilder(CreateHostnameRequest::builder).basePath("/20170115").appendPathParam("loadBalancers").appendPathParam(request.getLoadBalancerId()).appendPathParam("hostnames").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBody().handleResponseHeaderString("opc-work-request-id", CreateHostnameResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", CreateHostnameResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public CreateListenerResponse createListener(CreateListenerRequest request) {
        Objects.requireNonNull(request.getCreateListenerDetails(), "createListenerDetails is required");
        Validate.notBlank((String)request.getLoadBalancerId(), (String)"loadBalancerId must not be blank", (Object[])new Object[0]);
        return (CreateListenerResponse)this.clientCall(request, CreateListenerResponse::builder).logger(LOG, "createListener").serviceDetails("LoadBalancer", "CreateListener", "").method(Method.POST).requestBuilder(CreateListenerRequest::builder).basePath("/20170115").appendPathParam("loadBalancers").appendPathParam(request.getLoadBalancerId()).appendPathParam("listeners").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("if-match", request.getIfMatch()).hasBody().handleResponseHeaderString("opc-work-request-id", CreateListenerResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", CreateListenerResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public CreateLoadBalancerResponse createLoadBalancer(CreateLoadBalancerRequest request) {
        Objects.requireNonNull(request.getCreateLoadBalancerDetails(), "createLoadBalancerDetails is required");
        return (CreateLoadBalancerResponse)this.clientCall(request, CreateLoadBalancerResponse::builder).logger(LOG, "createLoadBalancer").serviceDetails("LoadBalancer", "CreateLoadBalancer", "").method(Method.POST).requestBuilder(CreateLoadBalancerRequest::builder).basePath("/20170115").appendPathParam("loadBalancers").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBody().handleResponseHeaderString("opc-work-request-id", CreateLoadBalancerResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", CreateLoadBalancerResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public CreatePathRouteSetResponse createPathRouteSet(CreatePathRouteSetRequest request) {
        Objects.requireNonNull(request.getCreatePathRouteSetDetails(), "createPathRouteSetDetails is required");
        Validate.notBlank((String)request.getLoadBalancerId(), (String)"loadBalancerId must not be blank", (Object[])new Object[0]);
        return (CreatePathRouteSetResponse)this.clientCall(request, CreatePathRouteSetResponse::builder).logger(LOG, "createPathRouteSet").serviceDetails("LoadBalancer", "CreatePathRouteSet", "").method(Method.POST).requestBuilder(CreatePathRouteSetRequest::builder).basePath("/20170115").appendPathParam("loadBalancers").appendPathParam(request.getLoadBalancerId()).appendPathParam("pathRouteSets").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("if-match", request.getIfMatch()).hasBody().handleResponseHeaderString("opc-work-request-id", CreatePathRouteSetResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", CreatePathRouteSetResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public CreateRoutingPolicyResponse createRoutingPolicy(CreateRoutingPolicyRequest request) {
        Objects.requireNonNull(request.getCreateRoutingPolicyDetails(), "createRoutingPolicyDetails is required");
        Validate.notBlank((String)request.getLoadBalancerId(), (String)"loadBalancerId must not be blank", (Object[])new Object[0]);
        return (CreateRoutingPolicyResponse)this.clientCall(request, CreateRoutingPolicyResponse::builder).logger(LOG, "createRoutingPolicy").serviceDetails("LoadBalancer", "CreateRoutingPolicy", "").method(Method.POST).requestBuilder(CreateRoutingPolicyRequest::builder).basePath("/20170115").appendPathParam("loadBalancers").appendPathParam(request.getLoadBalancerId()).appendPathParam("routingPolicies").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("if-match", request.getIfMatch()).hasBody().handleResponseHeaderString("opc-work-request-id", CreateRoutingPolicyResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", CreateRoutingPolicyResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public CreateRuleSetResponse createRuleSet(CreateRuleSetRequest request) {
        Validate.notBlank((String)request.getLoadBalancerId(), (String)"loadBalancerId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getCreateRuleSetDetails(), "createRuleSetDetails is required");
        return (CreateRuleSetResponse)this.clientCall(request, CreateRuleSetResponse::builder).logger(LOG, "createRuleSet").serviceDetails("LoadBalancer", "CreateRuleSet", "").method(Method.POST).requestBuilder(CreateRuleSetRequest::builder).basePath("/20170115").appendPathParam("loadBalancers").appendPathParam(request.getLoadBalancerId()).appendPathParam("ruleSets").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("if-match", request.getIfMatch()).hasBody().handleResponseHeaderString("opc-work-request-id", CreateRuleSetResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", CreateRuleSetResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public CreateSSLCipherSuiteResponse createSSLCipherSuite(CreateSSLCipherSuiteRequest request) {
        Objects.requireNonNull(request.getCreateSSLCipherSuiteDetails(), "createSSLCipherSuiteDetails is required");
        Validate.notBlank((String)request.getLoadBalancerId(), (String)"loadBalancerId must not be blank", (Object[])new Object[0]);
        return (CreateSSLCipherSuiteResponse)this.clientCall(request, CreateSSLCipherSuiteResponse::builder).logger(LOG, "createSSLCipherSuite").serviceDetails("LoadBalancer", "CreateSSLCipherSuite", "").method(Method.POST).requestBuilder(CreateSSLCipherSuiteRequest::builder).basePath("/20170115").appendPathParam("loadBalancers").appendPathParam(request.getLoadBalancerId()).appendPathParam("sslCipherSuites").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("if-match", request.getIfMatch()).hasBody().handleResponseHeaderString("opc-work-request-id", CreateSSLCipherSuiteResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", CreateSSLCipherSuiteResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public DeleteBackendResponse deleteBackend(DeleteBackendRequest request) {
        Validate.notBlank((String)request.getLoadBalancerId(), (String)"loadBalancerId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getBackendSetName(), (String)"backendSetName must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getBackendName(), (String)"backendName must not be blank", (Object[])new Object[0]);
        return (DeleteBackendResponse)this.clientCall(request, DeleteBackendResponse::builder).logger(LOG, "deleteBackend").serviceDetails("LoadBalancer", "DeleteBackend", "").method(Method.DELETE).requestBuilder(DeleteBackendRequest::builder).basePath("/20170115").appendPathParam("loadBalancers").appendPathParam(request.getLoadBalancerId()).appendPathParam("backendSets").appendPathParam(request.getBackendSetName()).appendPathParam("backends").appendPathParam(request.getBackendName()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("if-match", request.getIfMatch()).handleResponseHeaderString("opc-work-request-id", DeleteBackendResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", DeleteBackendResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public DeleteBackendSetResponse deleteBackendSet(DeleteBackendSetRequest request) {
        Validate.notBlank((String)request.getLoadBalancerId(), (String)"loadBalancerId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getBackendSetName(), (String)"backendSetName must not be blank", (Object[])new Object[0]);
        return (DeleteBackendSetResponse)this.clientCall(request, DeleteBackendSetResponse::builder).logger(LOG, "deleteBackendSet").serviceDetails("LoadBalancer", "DeleteBackendSet", "").method(Method.DELETE).requestBuilder(DeleteBackendSetRequest::builder).basePath("/20170115").appendPathParam("loadBalancers").appendPathParam(request.getLoadBalancerId()).appendPathParam("backendSets").appendPathParam(request.getBackendSetName()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("if-match", request.getIfMatch()).handleResponseHeaderString("opc-work-request-id", DeleteBackendSetResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", DeleteBackendSetResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public DeleteCertificateResponse deleteCertificate(DeleteCertificateRequest request) {
        Validate.notBlank((String)request.getLoadBalancerId(), (String)"loadBalancerId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getCertificateName(), (String)"certificateName must not be blank", (Object[])new Object[0]);
        return (DeleteCertificateResponse)this.clientCall(request, DeleteCertificateResponse::builder).logger(LOG, "deleteCertificate").serviceDetails("LoadBalancer", "DeleteCertificate", "").method(Method.DELETE).requestBuilder(DeleteCertificateRequest::builder).basePath("/20170115").appendPathParam("loadBalancers").appendPathParam(request.getLoadBalancerId()).appendPathParam("certificates").appendPathParam(request.getCertificateName()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("if-match", request.getIfMatch()).handleResponseHeaderString("opc-work-request-id", DeleteCertificateResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", DeleteCertificateResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public DeleteHostnameResponse deleteHostname(DeleteHostnameRequest request) {
        Validate.notBlank((String)request.getLoadBalancerId(), (String)"loadBalancerId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getName(), (String)"name must not be blank", (Object[])new Object[0]);
        return (DeleteHostnameResponse)this.clientCall(request, DeleteHostnameResponse::builder).logger(LOG, "deleteHostname").serviceDetails("LoadBalancer", "DeleteHostname", "").method(Method.DELETE).requestBuilder(DeleteHostnameRequest::builder).basePath("/20170115").appendPathParam("loadBalancers").appendPathParam(request.getLoadBalancerId()).appendPathParam("hostnames").appendPathParam(request.getName()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("if-match", request.getIfMatch()).handleResponseHeaderString("opc-work-request-id", DeleteHostnameResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", DeleteHostnameResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public DeleteListenerResponse deleteListener(DeleteListenerRequest request) {
        Validate.notBlank((String)request.getLoadBalancerId(), (String)"loadBalancerId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getListenerName(), (String)"listenerName must not be blank", (Object[])new Object[0]);
        return (DeleteListenerResponse)this.clientCall(request, DeleteListenerResponse::builder).logger(LOG, "deleteListener").serviceDetails("LoadBalancer", "DeleteListener", "").method(Method.DELETE).requestBuilder(DeleteListenerRequest::builder).basePath("/20170115").appendPathParam("loadBalancers").appendPathParam(request.getLoadBalancerId()).appendPathParam("listeners").appendPathParam(request.getListenerName()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("if-match", request.getIfMatch()).handleResponseHeaderString("opc-work-request-id", DeleteListenerResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", DeleteListenerResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public DeleteLoadBalancerResponse deleteLoadBalancer(DeleteLoadBalancerRequest request) {
        Validate.notBlank((String)request.getLoadBalancerId(), (String)"loadBalancerId must not be blank", (Object[])new Object[0]);
        return (DeleteLoadBalancerResponse)this.clientCall(request, DeleteLoadBalancerResponse::builder).logger(LOG, "deleteLoadBalancer").serviceDetails("LoadBalancer", "DeleteLoadBalancer", "").method(Method.DELETE).requestBuilder(DeleteLoadBalancerRequest::builder).basePath("/20170115").appendPathParam("loadBalancers").appendPathParam(request.getLoadBalancerId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("if-match", request.getIfMatch()).handleResponseHeaderString("opc-work-request-id", DeleteLoadBalancerResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", DeleteLoadBalancerResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public DeletePathRouteSetResponse deletePathRouteSet(DeletePathRouteSetRequest request) {
        Validate.notBlank((String)request.getLoadBalancerId(), (String)"loadBalancerId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getPathRouteSetName(), (String)"pathRouteSetName must not be blank", (Object[])new Object[0]);
        return (DeletePathRouteSetResponse)this.clientCall(request, DeletePathRouteSetResponse::builder).logger(LOG, "deletePathRouteSet").serviceDetails("LoadBalancer", "DeletePathRouteSet", "").method(Method.DELETE).requestBuilder(DeletePathRouteSetRequest::builder).basePath("/20170115").appendPathParam("loadBalancers").appendPathParam(request.getLoadBalancerId()).appendPathParam("pathRouteSets").appendPathParam(request.getPathRouteSetName()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("if-match", request.getIfMatch()).handleResponseHeaderString("opc-work-request-id", DeletePathRouteSetResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", DeletePathRouteSetResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public DeleteRoutingPolicyResponse deleteRoutingPolicy(DeleteRoutingPolicyRequest request) {
        Validate.notBlank((String)request.getLoadBalancerId(), (String)"loadBalancerId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getRoutingPolicyName(), (String)"routingPolicyName must not be blank", (Object[])new Object[0]);
        return (DeleteRoutingPolicyResponse)this.clientCall(request, DeleteRoutingPolicyResponse::builder).logger(LOG, "deleteRoutingPolicy").serviceDetails("LoadBalancer", "DeleteRoutingPolicy", "").method(Method.DELETE).requestBuilder(DeleteRoutingPolicyRequest::builder).basePath("/20170115").appendPathParam("loadBalancers").appendPathParam(request.getLoadBalancerId()).appendPathParam("routingPolicies").appendPathParam(request.getRoutingPolicyName()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("if-match", request.getIfMatch()).handleResponseHeaderString("opc-work-request-id", DeleteRoutingPolicyResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", DeleteRoutingPolicyResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public DeleteRuleSetResponse deleteRuleSet(DeleteRuleSetRequest request) {
        Validate.notBlank((String)request.getLoadBalancerId(), (String)"loadBalancerId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getRuleSetName(), (String)"ruleSetName must not be blank", (Object[])new Object[0]);
        return (DeleteRuleSetResponse)this.clientCall(request, DeleteRuleSetResponse::builder).logger(LOG, "deleteRuleSet").serviceDetails("LoadBalancer", "DeleteRuleSet", "").method(Method.DELETE).requestBuilder(DeleteRuleSetRequest::builder).basePath("/20170115").appendPathParam("loadBalancers").appendPathParam(request.getLoadBalancerId()).appendPathParam("ruleSets").appendPathParam(request.getRuleSetName()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("if-match", request.getIfMatch()).handleResponseHeaderString("opc-work-request-id", DeleteRuleSetResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", DeleteRuleSetResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public DeleteSSLCipherSuiteResponse deleteSSLCipherSuite(DeleteSSLCipherSuiteRequest request) {
        Validate.notBlank((String)request.getLoadBalancerId(), (String)"loadBalancerId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getName(), (String)"name must not be blank", (Object[])new Object[0]);
        return (DeleteSSLCipherSuiteResponse)this.clientCall(request, DeleteSSLCipherSuiteResponse::builder).logger(LOG, "deleteSSLCipherSuite").serviceDetails("LoadBalancer", "DeleteSSLCipherSuite", "").method(Method.DELETE).requestBuilder(DeleteSSLCipherSuiteRequest::builder).basePath("/20170115").appendPathParam("loadBalancers").appendPathParam(request.getLoadBalancerId()).appendPathParam("sslCipherSuites").appendPathParam(request.getName()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("if-match", request.getIfMatch()).handleResponseHeaderString("opc-work-request-id", DeleteSSLCipherSuiteResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", DeleteSSLCipherSuiteResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public GetBackendResponse getBackend(GetBackendRequest request) {
        Validate.notBlank((String)request.getLoadBalancerId(), (String)"loadBalancerId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getBackendSetName(), (String)"backendSetName must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getBackendName(), (String)"backendName must not be blank", (Object[])new Object[0]);
        return (GetBackendResponse)this.clientCall(request, GetBackendResponse::builder).logger(LOG, "getBackend").serviceDetails("LoadBalancer", "GetBackend", "https://docs.oracle.com/iaas/api/#/en/loadbalancer/20170115/Backend/GetBackend").method(Method.GET).requestBuilder(GetBackendRequest::builder).basePath("/20170115").appendPathParam("loadBalancers").appendPathParam(request.getLoadBalancerId()).appendPathParam("backendSets").appendPathParam(request.getBackendSetName()).appendPathParam("backends").appendPathParam(request.getBackendName()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("if-match", request.getIfMatch()).handleBody(Backend.class, GetBackendResponse.Builder::backend).handleResponseHeaderString("opc-request-id", GetBackendResponse.Builder::opcRequestId).handleResponseHeaderString("eTag", GetBackendResponse.Builder::eTag).callSync();
    }

    @Override
    public GetBackendHealthResponse getBackendHealth(GetBackendHealthRequest request) {
        Validate.notBlank((String)request.getLoadBalancerId(), (String)"loadBalancerId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getBackendSetName(), (String)"backendSetName must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getBackendName(), (String)"backendName must not be blank", (Object[])new Object[0]);
        return (GetBackendHealthResponse)this.clientCall(request, GetBackendHealthResponse::builder).logger(LOG, "getBackendHealth").serviceDetails("LoadBalancer", "GetBackendHealth", "https://docs.oracle.com/iaas/api/#/en/loadbalancer/20170115/BackendHealth/GetBackendHealth").method(Method.GET).requestBuilder(GetBackendHealthRequest::builder).basePath("/20170115").appendPathParam("loadBalancers").appendPathParam(request.getLoadBalancerId()).appendPathParam("backendSets").appendPathParam(request.getBackendSetName()).appendPathParam("backends").appendPathParam(request.getBackendName()).appendPathParam("health").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("if-match", request.getIfMatch()).handleBody(BackendHealth.class, GetBackendHealthResponse.Builder::backendHealth).handleResponseHeaderString("opc-request-id", GetBackendHealthResponse.Builder::opcRequestId).handleResponseHeaderString("eTag", GetBackendHealthResponse.Builder::eTag).callSync();
    }

    @Override
    public GetBackendSetResponse getBackendSet(GetBackendSetRequest request) {
        Validate.notBlank((String)request.getLoadBalancerId(), (String)"loadBalancerId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getBackendSetName(), (String)"backendSetName must not be blank", (Object[])new Object[0]);
        return (GetBackendSetResponse)this.clientCall(request, GetBackendSetResponse::builder).logger(LOG, "getBackendSet").serviceDetails("LoadBalancer", "GetBackendSet", "https://docs.oracle.com/iaas/api/#/en/loadbalancer/20170115/BackendSet/GetBackendSet").method(Method.GET).requestBuilder(GetBackendSetRequest::builder).basePath("/20170115").appendPathParam("loadBalancers").appendPathParam(request.getLoadBalancerId()).appendPathParam("backendSets").appendPathParam(request.getBackendSetName()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("if-match", request.getIfMatch()).handleBody(BackendSet.class, GetBackendSetResponse.Builder::backendSet).handleResponseHeaderString("opc-request-id", GetBackendSetResponse.Builder::opcRequestId).handleResponseHeaderString("eTag", GetBackendSetResponse.Builder::eTag).callSync();
    }

    @Override
    public GetBackendSetHealthResponse getBackendSetHealth(GetBackendSetHealthRequest request) {
        Validate.notBlank((String)request.getLoadBalancerId(), (String)"loadBalancerId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getBackendSetName(), (String)"backendSetName must not be blank", (Object[])new Object[0]);
        return (GetBackendSetHealthResponse)this.clientCall(request, GetBackendSetHealthResponse::builder).logger(LOG, "getBackendSetHealth").serviceDetails("LoadBalancer", "GetBackendSetHealth", "https://docs.oracle.com/iaas/api/#/en/loadbalancer/20170115/BackendSetHealth/GetBackendSetHealth").method(Method.GET).requestBuilder(GetBackendSetHealthRequest::builder).basePath("/20170115").appendPathParam("loadBalancers").appendPathParam(request.getLoadBalancerId()).appendPathParam("backendSets").appendPathParam(request.getBackendSetName()).appendPathParam("health").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("if-match", request.getIfMatch()).handleBody(BackendSetHealth.class, GetBackendSetHealthResponse.Builder::backendSetHealth).handleResponseHeaderString("opc-request-id", GetBackendSetHealthResponse.Builder::opcRequestId).handleResponseHeaderString("eTag", GetBackendSetHealthResponse.Builder::eTag).callSync();
    }

    @Override
    public GetHealthCheckerResponse getHealthChecker(GetHealthCheckerRequest request) {
        Validate.notBlank((String)request.getLoadBalancerId(), (String)"loadBalancerId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getBackendSetName(), (String)"backendSetName must not be blank", (Object[])new Object[0]);
        return (GetHealthCheckerResponse)this.clientCall(request, GetHealthCheckerResponse::builder).logger(LOG, "getHealthChecker").serviceDetails("LoadBalancer", "GetHealthChecker", "https://docs.oracle.com/iaas/api/#/en/loadbalancer/20170115/HealthChecker/GetHealthChecker").method(Method.GET).requestBuilder(GetHealthCheckerRequest::builder).basePath("/20170115").appendPathParam("loadBalancers").appendPathParam(request.getLoadBalancerId()).appendPathParam("backendSets").appendPathParam(request.getBackendSetName()).appendPathParam("healthChecker").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("if-match", request.getIfMatch()).handleBody(HealthChecker.class, GetHealthCheckerResponse.Builder::healthChecker).handleResponseHeaderString("opc-request-id", GetHealthCheckerResponse.Builder::opcRequestId).handleResponseHeaderString("eTag", GetHealthCheckerResponse.Builder::eTag).callSync();
    }

    @Override
    public GetHostnameResponse getHostname(GetHostnameRequest request) {
        Validate.notBlank((String)request.getLoadBalancerId(), (String)"loadBalancerId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getName(), (String)"name must not be blank", (Object[])new Object[0]);
        return (GetHostnameResponse)this.clientCall(request, GetHostnameResponse::builder).logger(LOG, "getHostname").serviceDetails("LoadBalancer", "GetHostname", "https://docs.oracle.com/iaas/api/#/en/loadbalancer/20170115/Hostname/GetHostname").method(Method.GET).requestBuilder(GetHostnameRequest::builder).basePath("/20170115").appendPathParam("loadBalancers").appendPathParam(request.getLoadBalancerId()).appendPathParam("hostnames").appendPathParam(request.getName()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("if-match", request.getIfMatch()).handleBody(Hostname.class, GetHostnameResponse.Builder::hostname).handleResponseHeaderString("opc-request-id", GetHostnameResponse.Builder::opcRequestId).handleResponseHeaderString("eTag", GetHostnameResponse.Builder::eTag).callSync();
    }

    @Override
    public GetLoadBalancerResponse getLoadBalancer(GetLoadBalancerRequest request) {
        Validate.notBlank((String)request.getLoadBalancerId(), (String)"loadBalancerId must not be blank", (Object[])new Object[0]);
        return (GetLoadBalancerResponse)this.clientCall(request, GetLoadBalancerResponse::builder).logger(LOG, "getLoadBalancer").serviceDetails("LoadBalancer", "GetLoadBalancer", "https://docs.oracle.com/iaas/api/#/en/loadbalancer/20170115/LoadBalancer/GetLoadBalancer").method(Method.GET).requestBuilder(GetLoadBalancerRequest::builder).basePath("/20170115").appendPathParam("loadBalancers").appendPathParam(request.getLoadBalancerId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("if-match", request.getIfMatch()).handleBody(com.oracle.bmc.loadbalancer.model.LoadBalancer.class, GetLoadBalancerResponse.Builder::loadBalancer).handleResponseHeaderString("opc-request-id", GetLoadBalancerResponse.Builder::opcRequestId).handleResponseHeaderString("eTag", GetLoadBalancerResponse.Builder::eTag).callSync();
    }

    @Override
    public GetLoadBalancerHealthResponse getLoadBalancerHealth(GetLoadBalancerHealthRequest request) {
        Validate.notBlank((String)request.getLoadBalancerId(), (String)"loadBalancerId must not be blank", (Object[])new Object[0]);
        return (GetLoadBalancerHealthResponse)this.clientCall(request, GetLoadBalancerHealthResponse::builder).logger(LOG, "getLoadBalancerHealth").serviceDetails("LoadBalancer", "GetLoadBalancerHealth", "https://docs.oracle.com/iaas/api/#/en/loadbalancer/20170115/LoadBalancerHealth/GetLoadBalancerHealth").method(Method.GET).requestBuilder(GetLoadBalancerHealthRequest::builder).basePath("/20170115").appendPathParam("loadBalancers").appendPathParam(request.getLoadBalancerId()).appendPathParam("health").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("if-match", request.getIfMatch()).handleBody(LoadBalancerHealth.class, GetLoadBalancerHealthResponse.Builder::loadBalancerHealth).handleResponseHeaderString("opc-request-id", GetLoadBalancerHealthResponse.Builder::opcRequestId).handleResponseHeaderString("eTag", GetLoadBalancerHealthResponse.Builder::eTag).callSync();
    }

    @Override
    public GetPathRouteSetResponse getPathRouteSet(GetPathRouteSetRequest request) {
        Validate.notBlank((String)request.getLoadBalancerId(), (String)"loadBalancerId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getPathRouteSetName(), (String)"pathRouteSetName must not be blank", (Object[])new Object[0]);
        return (GetPathRouteSetResponse)this.clientCall(request, GetPathRouteSetResponse::builder).logger(LOG, "getPathRouteSet").serviceDetails("LoadBalancer", "GetPathRouteSet", "https://docs.oracle.com/iaas/api/#/en/loadbalancer/20170115/PathRouteSet/GetPathRouteSet").method(Method.GET).requestBuilder(GetPathRouteSetRequest::builder).basePath("/20170115").appendPathParam("loadBalancers").appendPathParam(request.getLoadBalancerId()).appendPathParam("pathRouteSets").appendPathParam(request.getPathRouteSetName()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("if-match", request.getIfMatch()).handleBody(PathRouteSet.class, GetPathRouteSetResponse.Builder::pathRouteSet).handleResponseHeaderString("opc-request-id", GetPathRouteSetResponse.Builder::opcRequestId).handleResponseHeaderString("eTag", GetPathRouteSetResponse.Builder::eTag).callSync();
    }

    @Override
    public GetRoutingPolicyResponse getRoutingPolicy(GetRoutingPolicyRequest request) {
        Validate.notBlank((String)request.getLoadBalancerId(), (String)"loadBalancerId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getRoutingPolicyName(), (String)"routingPolicyName must not be blank", (Object[])new Object[0]);
        return (GetRoutingPolicyResponse)this.clientCall(request, GetRoutingPolicyResponse::builder).logger(LOG, "getRoutingPolicy").serviceDetails("LoadBalancer", "GetRoutingPolicy", "https://docs.oracle.com/iaas/api/#/en/loadbalancer/20170115/RoutingPolicy/GetRoutingPolicy").method(Method.GET).requestBuilder(GetRoutingPolicyRequest::builder).basePath("/20170115").appendPathParam("loadBalancers").appendPathParam(request.getLoadBalancerId()).appendPathParam("routingPolicies").appendPathParam(request.getRoutingPolicyName()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("if-match", request.getIfMatch()).handleBody(RoutingPolicy.class, GetRoutingPolicyResponse.Builder::routingPolicy).handleResponseHeaderString("opc-request-id", GetRoutingPolicyResponse.Builder::opcRequestId).handleResponseHeaderString("eTag", GetRoutingPolicyResponse.Builder::eTag).callSync();
    }

    @Override
    public GetRuleSetResponse getRuleSet(GetRuleSetRequest request) {
        Validate.notBlank((String)request.getLoadBalancerId(), (String)"loadBalancerId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getRuleSetName(), (String)"ruleSetName must not be blank", (Object[])new Object[0]);
        return (GetRuleSetResponse)this.clientCall(request, GetRuleSetResponse::builder).logger(LOG, "getRuleSet").serviceDetails("LoadBalancer", "GetRuleSet", "https://docs.oracle.com/iaas/api/#/en/loadbalancer/20170115/RuleSet/GetRuleSet").method(Method.GET).requestBuilder(GetRuleSetRequest::builder).basePath("/20170115").appendPathParam("loadBalancers").appendPathParam(request.getLoadBalancerId()).appendPathParam("ruleSets").appendPathParam(request.getRuleSetName()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("if-match", request.getIfMatch()).handleBody(RuleSet.class, GetRuleSetResponse.Builder::ruleSet).handleResponseHeaderString("opc-request-id", GetRuleSetResponse.Builder::opcRequestId).handleResponseHeaderString("eTag", GetRuleSetResponse.Builder::eTag).callSync();
    }

    @Override
    public GetSSLCipherSuiteResponse getSSLCipherSuite(GetSSLCipherSuiteRequest request) {
        Validate.notBlank((String)request.getLoadBalancerId(), (String)"loadBalancerId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getName(), (String)"name must not be blank", (Object[])new Object[0]);
        return (GetSSLCipherSuiteResponse)this.clientCall(request, GetSSLCipherSuiteResponse::builder).logger(LOG, "getSSLCipherSuite").serviceDetails("LoadBalancer", "GetSSLCipherSuite", "https://docs.oracle.com/iaas/api/#/en/loadbalancer/20170115/SSLCipherSuite/GetSSLCipherSuite").method(Method.GET).requestBuilder(GetSSLCipherSuiteRequest::builder).basePath("/20170115").appendPathParam("loadBalancers").appendPathParam(request.getLoadBalancerId()).appendPathParam("sslCipherSuites").appendPathParam(request.getName()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("if-match", request.getIfMatch()).handleBody(SSLCipherSuite.class, GetSSLCipherSuiteResponse.Builder::sSLCipherSuite).handleResponseHeaderString("opc-request-id", GetSSLCipherSuiteResponse.Builder::opcRequestId).handleResponseHeaderString("eTag", GetSSLCipherSuiteResponse.Builder::eTag).callSync();
    }

    @Override
    public GetWorkRequestResponse getWorkRequest(GetWorkRequestRequest request) {
        Validate.notBlank((String)request.getWorkRequestId(), (String)"workRequestId must not be blank", (Object[])new Object[0]);
        return (GetWorkRequestResponse)this.clientCall(request, GetWorkRequestResponse::builder).logger(LOG, "getWorkRequest").serviceDetails("LoadBalancer", "GetWorkRequest", "https://docs.oracle.com/iaas/api/#/en/loadbalancer/20170115/WorkRequest/GetWorkRequest").method(Method.GET).requestBuilder(GetWorkRequestRequest::builder).basePath("/20170115").appendPathParam("loadBalancerWorkRequests").appendPathParam(request.getWorkRequestId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(WorkRequest.class, GetWorkRequestResponse.Builder::workRequest).handleResponseHeaderString("opc-request-id", GetWorkRequestResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public ListBackendSetsResponse listBackendSets(ListBackendSetsRequest request) {
        Validate.notBlank((String)request.getLoadBalancerId(), (String)"loadBalancerId must not be blank", (Object[])new Object[0]);
        return (ListBackendSetsResponse)this.clientCall(request, ListBackendSetsResponse::builder).logger(LOG, "listBackendSets").serviceDetails("LoadBalancer", "ListBackendSets", "https://docs.oracle.com/iaas/api/#/en/loadbalancer/20170115/BackendSet/ListBackendSets").method(Method.GET).requestBuilder(ListBackendSetsRequest::builder).basePath("/20170115").appendPathParam("loadBalancers").appendPathParam(request.getLoadBalancerId()).appendPathParam("backendSets").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("if-match", request.getIfMatch()).handleBodyList(BackendSet.class, ListBackendSetsResponse.Builder::items).handleResponseHeaderString("opc-request-id", ListBackendSetsResponse.Builder::opcRequestId).handleResponseHeaderString("eTag", ListBackendSetsResponse.Builder::eTag).callSync();
    }

    @Override
    public ListBackendsResponse listBackends(ListBackendsRequest request) {
        Validate.notBlank((String)request.getLoadBalancerId(), (String)"loadBalancerId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getBackendSetName(), (String)"backendSetName must not be blank", (Object[])new Object[0]);
        return (ListBackendsResponse)this.clientCall(request, ListBackendsResponse::builder).logger(LOG, "listBackends").serviceDetails("LoadBalancer", "ListBackends", "https://docs.oracle.com/iaas/api/#/en/loadbalancer/20170115/Backend/ListBackends").method(Method.GET).requestBuilder(ListBackendsRequest::builder).basePath("/20170115").appendPathParam("loadBalancers").appendPathParam(request.getLoadBalancerId()).appendPathParam("backendSets").appendPathParam(request.getBackendSetName()).appendPathParam("backends").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("if-match", request.getIfMatch()).handleBodyList(Backend.class, ListBackendsResponse.Builder::items).handleResponseHeaderString("opc-request-id", ListBackendsResponse.Builder::opcRequestId).handleResponseHeaderString("eTag", ListBackendsResponse.Builder::eTag).callSync();
    }

    @Override
    public ListCertificatesResponse listCertificates(ListCertificatesRequest request) {
        Validate.notBlank((String)request.getLoadBalancerId(), (String)"loadBalancerId must not be blank", (Object[])new Object[0]);
        return (ListCertificatesResponse)this.clientCall(request, ListCertificatesResponse::builder).logger(LOG, "listCertificates").serviceDetails("LoadBalancer", "ListCertificates", "https://docs.oracle.com/iaas/api/#/en/loadbalancer/20170115/Certificate/ListCertificates").method(Method.GET).requestBuilder(ListCertificatesRequest::builder).basePath("/20170115").appendPathParam("loadBalancers").appendPathParam(request.getLoadBalancerId()).appendPathParam("certificates").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("if-match", request.getIfMatch()).handleBodyList(Certificate.class, ListCertificatesResponse.Builder::items).handleResponseHeaderString("opc-request-id", ListCertificatesResponse.Builder::opcRequestId).handleResponseHeaderString("eTag", ListCertificatesResponse.Builder::eTag).callSync();
    }

    @Override
    public ListHostnamesResponse listHostnames(ListHostnamesRequest request) {
        Validate.notBlank((String)request.getLoadBalancerId(), (String)"loadBalancerId must not be blank", (Object[])new Object[0]);
        return (ListHostnamesResponse)this.clientCall(request, ListHostnamesResponse::builder).logger(LOG, "listHostnames").serviceDetails("LoadBalancer", "ListHostnames", "https://docs.oracle.com/iaas/api/#/en/loadbalancer/20170115/Hostname/ListHostnames").method(Method.GET).requestBuilder(ListHostnamesRequest::builder).basePath("/20170115").appendPathParam("loadBalancers").appendPathParam(request.getLoadBalancerId()).appendPathParam("hostnames").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("if-match", request.getIfMatch()).handleBodyList(Hostname.class, ListHostnamesResponse.Builder::items).handleResponseHeaderString("opc-request-id", ListHostnamesResponse.Builder::opcRequestId).handleResponseHeaderString("eTag", ListHostnamesResponse.Builder::eTag).callSync();
    }

    @Override
    public ListListenerRulesResponse listListenerRules(ListListenerRulesRequest request) {
        Validate.notBlank((String)request.getLoadBalancerId(), (String)"loadBalancerId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getListenerName(), (String)"listenerName must not be blank", (Object[])new Object[0]);
        return (ListListenerRulesResponse)this.clientCall(request, ListListenerRulesResponse::builder).logger(LOG, "listListenerRules").serviceDetails("LoadBalancer", "ListListenerRules", "https://docs.oracle.com/iaas/api/#/en/loadbalancer/20170115/ListenerRuleSummary/ListListenerRules").method(Method.GET).requestBuilder(ListListenerRulesRequest::builder).basePath("/20170115").appendPathParam("loadBalancers").appendPathParam(request.getLoadBalancerId()).appendPathParam("listeners").appendPathParam(request.getListenerName()).appendPathParam("rules").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("if-match", request.getIfMatch()).handleBodyList(ListenerRuleSummary.class, ListListenerRulesResponse.Builder::items).handleResponseHeaderString("opc-request-id", ListListenerRulesResponse.Builder::opcRequestId).handleResponseHeaderString("eTag", ListListenerRulesResponse.Builder::eTag).callSync();
    }

    @Override
    public ListLoadBalancerHealthsResponse listLoadBalancerHealths(ListLoadBalancerHealthsRequest request) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return (ListLoadBalancerHealthsResponse)this.clientCall(request, ListLoadBalancerHealthsResponse::builder).logger(LOG, "listLoadBalancerHealths").serviceDetails("LoadBalancer", "ListLoadBalancerHealths", "https://docs.oracle.com/iaas/api/#/en/loadbalancer/20170115/LoadBalancerHealthSummary/ListLoadBalancerHealths").method(Method.GET).requestBuilder(ListLoadBalancerHealthsRequest::builder).basePath("/20170115").appendPathParam("loadBalancerHealths").appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendQueryParam("compartmentId", (Object)request.getCompartmentId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBodyList(LoadBalancerHealthSummary.class, ListLoadBalancerHealthsResponse.Builder::items).handleResponseHeaderString("opc-next-page", ListLoadBalancerHealthsResponse.Builder::opcNextPage).handleResponseHeaderString("opc-request-id", ListLoadBalancerHealthsResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public ListLoadBalancersResponse listLoadBalancers(ListLoadBalancersRequest request) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return (ListLoadBalancersResponse)this.clientCall(request, ListLoadBalancersResponse::builder).logger(LOG, "listLoadBalancers").serviceDetails("LoadBalancer", "ListLoadBalancers", "https://docs.oracle.com/iaas/api/#/en/loadbalancer/20170115/LoadBalancer/ListLoadBalancers").method(Method.GET).requestBuilder(ListLoadBalancersRequest::builder).basePath("/20170115").appendPathParam("loadBalancers").appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("detail", (Object)request.getDetail()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendQueryParam("displayName", (Object)request.getDisplayName()).appendEnumQueryParam("lifecycleState", (BmcEnum)request.getLifecycleState()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBodyList(com.oracle.bmc.loadbalancer.model.LoadBalancer.class, ListLoadBalancersResponse.Builder::items).handleResponseHeaderString("opc-next-page", ListLoadBalancersResponse.Builder::opcNextPage).handleResponseHeaderString("opc-request-id", ListLoadBalancersResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public ListPathRouteSetsResponse listPathRouteSets(ListPathRouteSetsRequest request) {
        Validate.notBlank((String)request.getLoadBalancerId(), (String)"loadBalancerId must not be blank", (Object[])new Object[0]);
        return (ListPathRouteSetsResponse)this.clientCall(request, ListPathRouteSetsResponse::builder).logger(LOG, "listPathRouteSets").serviceDetails("LoadBalancer", "ListPathRouteSets", "https://docs.oracle.com/iaas/api/#/en/loadbalancer/20170115/PathRouteSet/ListPathRouteSets").method(Method.GET).requestBuilder(ListPathRouteSetsRequest::builder).basePath("/20170115").appendPathParam("loadBalancers").appendPathParam(request.getLoadBalancerId()).appendPathParam("pathRouteSets").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("if-match", request.getIfMatch()).handleBodyList(PathRouteSet.class, ListPathRouteSetsResponse.Builder::items).handleResponseHeaderString("opc-request-id", ListPathRouteSetsResponse.Builder::opcRequestId).handleResponseHeaderString("eTag", ListPathRouteSetsResponse.Builder::eTag).callSync();
    }

    @Override
    public ListPoliciesResponse listPolicies(ListPoliciesRequest request) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return (ListPoliciesResponse)this.clientCall(request, ListPoliciesResponse::builder).logger(LOG, "listPolicies").serviceDetails("LoadBalancer", "ListPolicies", "https://docs.oracle.com/iaas/api/#/en/loadbalancer/20170115/LoadBalancerPolicy/ListPolicies").method(Method.GET).requestBuilder(ListPoliciesRequest::builder).basePath("/20170115").appendPathParam("loadBalancerPolicies").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBodyList(LoadBalancerPolicy.class, ListPoliciesResponse.Builder::items).handleResponseHeaderString("opc-next-page", ListPoliciesResponse.Builder::opcNextPage).handleResponseHeaderString("opc-request-id", ListPoliciesResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public ListProtocolsResponse listProtocols(ListProtocolsRequest request) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return (ListProtocolsResponse)this.clientCall(request, ListProtocolsResponse::builder).logger(LOG, "listProtocols").serviceDetails("LoadBalancer", "ListProtocols", "https://docs.oracle.com/iaas/api/#/en/loadbalancer/20170115/LoadBalancerProtocol/ListProtocols").method(Method.GET).requestBuilder(ListProtocolsRequest::builder).basePath("/20170115").appendPathParam("loadBalancerProtocols").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBodyList(LoadBalancerProtocol.class, ListProtocolsResponse.Builder::items).handleResponseHeaderString("opc-next-page", ListProtocolsResponse.Builder::opcNextPage).handleResponseHeaderString("opc-request-id", ListProtocolsResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public ListRoutingPoliciesResponse listRoutingPolicies(ListRoutingPoliciesRequest request) {
        Validate.notBlank((String)request.getLoadBalancerId(), (String)"loadBalancerId must not be blank", (Object[])new Object[0]);
        return (ListRoutingPoliciesResponse)this.clientCall(request, ListRoutingPoliciesResponse::builder).logger(LOG, "listRoutingPolicies").serviceDetails("LoadBalancer", "ListRoutingPolicies", "https://docs.oracle.com/iaas/api/#/en/loadbalancer/20170115/RoutingPolicy/ListRoutingPolicies").method(Method.GET).requestBuilder(ListRoutingPoliciesRequest::builder).basePath("/20170115").appendPathParam("loadBalancers").appendPathParam(request.getLoadBalancerId()).appendPathParam("routingPolicies").appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("if-match", request.getIfMatch()).handleBodyList(RoutingPolicy.class, ListRoutingPoliciesResponse.Builder::items).handleResponseHeaderString("opc-request-id", ListRoutingPoliciesResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListRoutingPoliciesResponse.Builder::opcNextPage).handleResponseHeaderString("eTag", ListRoutingPoliciesResponse.Builder::eTag).callSync();
    }

    @Override
    public ListRuleSetsResponse listRuleSets(ListRuleSetsRequest request) {
        Validate.notBlank((String)request.getLoadBalancerId(), (String)"loadBalancerId must not be blank", (Object[])new Object[0]);
        return (ListRuleSetsResponse)this.clientCall(request, ListRuleSetsResponse::builder).logger(LOG, "listRuleSets").serviceDetails("LoadBalancer", "ListRuleSets", "https://docs.oracle.com/iaas/api/#/en/loadbalancer/20170115/RuleSet/ListRuleSets").method(Method.GET).requestBuilder(ListRuleSetsRequest::builder).basePath("/20170115").appendPathParam("loadBalancers").appendPathParam(request.getLoadBalancerId()).appendPathParam("ruleSets").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("if-match", request.getIfMatch()).handleBodyList(RuleSet.class, ListRuleSetsResponse.Builder::items).handleResponseHeaderString("opc-request-id", ListRuleSetsResponse.Builder::opcRequestId).handleResponseHeaderString("eTag", ListRuleSetsResponse.Builder::eTag).callSync();
    }

    @Override
    public ListSSLCipherSuitesResponse listSSLCipherSuites(ListSSLCipherSuitesRequest request) {
        Validate.notBlank((String)request.getLoadBalancerId(), (String)"loadBalancerId must not be blank", (Object[])new Object[0]);
        return (ListSSLCipherSuitesResponse)this.clientCall(request, ListSSLCipherSuitesResponse::builder).logger(LOG, "listSSLCipherSuites").serviceDetails("LoadBalancer", "ListSSLCipherSuites", "https://docs.oracle.com/iaas/api/#/en/loadbalancer/20170115/SSLCipherSuite/ListSSLCipherSuites").method(Method.GET).requestBuilder(ListSSLCipherSuitesRequest::builder).basePath("/20170115").appendPathParam("loadBalancers").appendPathParam(request.getLoadBalancerId()).appendPathParam("sslCipherSuites").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("if-match", request.getIfMatch()).handleBodyList(SSLCipherSuite.class, ListSSLCipherSuitesResponse.Builder::items).handleResponseHeaderString("opc-request-id", ListSSLCipherSuitesResponse.Builder::opcRequestId).handleResponseHeaderString("eTag", ListSSLCipherSuitesResponse.Builder::eTag).callSync();
    }

    @Override
    public ListShapesResponse listShapes(ListShapesRequest request) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return (ListShapesResponse)this.clientCall(request, ListShapesResponse::builder).logger(LOG, "listShapes").serviceDetails("LoadBalancer", "ListShapes", "https://docs.oracle.com/iaas/api/#/en/loadbalancer/20170115/LoadBalancerShape/ListShapes").method(Method.GET).requestBuilder(ListShapesRequest::builder).basePath("/20170115").appendPathParam("loadBalancerShapes").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBodyList(LoadBalancerShape.class, ListShapesResponse.Builder::items).handleResponseHeaderString("opc-next-page", ListShapesResponse.Builder::opcNextPage).handleResponseHeaderString("opc-request-id", ListShapesResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public ListWorkRequestsResponse listWorkRequests(ListWorkRequestsRequest request) {
        Validate.notBlank((String)request.getLoadBalancerId(), (String)"loadBalancerId must not be blank", (Object[])new Object[0]);
        return (ListWorkRequestsResponse)this.clientCall(request, ListWorkRequestsResponse::builder).logger(LOG, "listWorkRequests").serviceDetails("LoadBalancer", "ListWorkRequests", "https://docs.oracle.com/iaas/api/#/en/loadbalancer/20170115/WorkRequest/ListWorkRequests").method(Method.GET).requestBuilder(ListWorkRequestsRequest::builder).basePath("/20170115").appendPathParam("loadBalancers").appendPathParam(request.getLoadBalancerId()).appendPathParam("workRequests").appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBodyList(WorkRequest.class, ListWorkRequestsResponse.Builder::items).handleResponseHeaderString("opc-next-page", ListWorkRequestsResponse.Builder::opcNextPage).handleResponseHeaderString("opc-request-id", ListWorkRequestsResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public UpdateBackendResponse updateBackend(UpdateBackendRequest request) {
        Objects.requireNonNull(request.getUpdateBackendDetails(), "updateBackendDetails is required");
        Validate.notBlank((String)request.getLoadBalancerId(), (String)"loadBalancerId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getBackendSetName(), (String)"backendSetName must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getBackendName(), (String)"backendName must not be blank", (Object[])new Object[0]);
        return (UpdateBackendResponse)this.clientCall(request, UpdateBackendResponse::builder).logger(LOG, "updateBackend").serviceDetails("LoadBalancer", "UpdateBackend", "").method(Method.PUT).requestBuilder(UpdateBackendRequest::builder).basePath("/20170115").appendPathParam("loadBalancers").appendPathParam(request.getLoadBalancerId()).appendPathParam("backendSets").appendPathParam(request.getBackendSetName()).appendPathParam("backends").appendPathParam(request.getBackendName()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("if-match", request.getIfMatch()).hasBody().handleResponseHeaderString("opc-work-request-id", UpdateBackendResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", UpdateBackendResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public UpdateBackendSetResponse updateBackendSet(UpdateBackendSetRequest request) {
        Objects.requireNonNull(request.getUpdateBackendSetDetails(), "updateBackendSetDetails is required");
        Validate.notBlank((String)request.getLoadBalancerId(), (String)"loadBalancerId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getBackendSetName(), (String)"backendSetName must not be blank", (Object[])new Object[0]);
        return (UpdateBackendSetResponse)this.clientCall(request, UpdateBackendSetResponse::builder).logger(LOG, "updateBackendSet").serviceDetails("LoadBalancer", "UpdateBackendSet", "").method(Method.PUT).requestBuilder(UpdateBackendSetRequest::builder).basePath("/20170115").appendPathParam("loadBalancers").appendPathParam(request.getLoadBalancerId()).appendPathParam("backendSets").appendPathParam(request.getBackendSetName()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("if-match", request.getIfMatch()).hasBody().handleResponseHeaderString("opc-work-request-id", UpdateBackendSetResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", UpdateBackendSetResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public UpdateHealthCheckerResponse updateHealthChecker(UpdateHealthCheckerRequest request) {
        Objects.requireNonNull(request.getHealthChecker(), "healthChecker is required");
        Validate.notBlank((String)request.getLoadBalancerId(), (String)"loadBalancerId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getBackendSetName(), (String)"backendSetName must not be blank", (Object[])new Object[0]);
        return (UpdateHealthCheckerResponse)this.clientCall(request, UpdateHealthCheckerResponse::builder).logger(LOG, "updateHealthChecker").serviceDetails("LoadBalancer", "UpdateHealthChecker", "").method(Method.PUT).requestBuilder(UpdateHealthCheckerRequest::builder).basePath("/20170115").appendPathParam("loadBalancers").appendPathParam(request.getLoadBalancerId()).appendPathParam("backendSets").appendPathParam(request.getBackendSetName()).appendPathParam("healthChecker").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("if-match", request.getIfMatch()).hasBody().handleResponseHeaderString("opc-work-request-id", UpdateHealthCheckerResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", UpdateHealthCheckerResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public UpdateHostnameResponse updateHostname(UpdateHostnameRequest request) {
        Objects.requireNonNull(request.getUpdateHostnameDetails(), "updateHostnameDetails is required");
        Validate.notBlank((String)request.getLoadBalancerId(), (String)"loadBalancerId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getName(), (String)"name must not be blank", (Object[])new Object[0]);
        return (UpdateHostnameResponse)this.clientCall(request, UpdateHostnameResponse::builder).logger(LOG, "updateHostname").serviceDetails("LoadBalancer", "UpdateHostname", "").method(Method.PUT).requestBuilder(UpdateHostnameRequest::builder).basePath("/20170115").appendPathParam("loadBalancers").appendPathParam(request.getLoadBalancerId()).appendPathParam("hostnames").appendPathParam(request.getName()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("if-match", request.getIfMatch()).hasBody().handleResponseHeaderString("opc-work-request-id", UpdateHostnameResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", UpdateHostnameResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public UpdateListenerResponse updateListener(UpdateListenerRequest request) {
        Objects.requireNonNull(request.getUpdateListenerDetails(), "updateListenerDetails is required");
        Validate.notBlank((String)request.getLoadBalancerId(), (String)"loadBalancerId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getListenerName(), (String)"listenerName must not be blank", (Object[])new Object[0]);
        return (UpdateListenerResponse)this.clientCall(request, UpdateListenerResponse::builder).logger(LOG, "updateListener").serviceDetails("LoadBalancer", "UpdateListener", "").method(Method.PUT).requestBuilder(UpdateListenerRequest::builder).basePath("/20170115").appendPathParam("loadBalancers").appendPathParam(request.getLoadBalancerId()).appendPathParam("listeners").appendPathParam(request.getListenerName()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("if-match", request.getIfMatch()).hasBody().handleResponseHeaderString("opc-work-request-id", UpdateListenerResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", UpdateListenerResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public UpdateLoadBalancerResponse updateLoadBalancer(UpdateLoadBalancerRequest request) {
        Objects.requireNonNull(request.getUpdateLoadBalancerDetails(), "updateLoadBalancerDetails is required");
        Validate.notBlank((String)request.getLoadBalancerId(), (String)"loadBalancerId must not be blank", (Object[])new Object[0]);
        return (UpdateLoadBalancerResponse)this.clientCall(request, UpdateLoadBalancerResponse::builder).logger(LOG, "updateLoadBalancer").serviceDetails("LoadBalancer", "UpdateLoadBalancer", "").method(Method.PUT).requestBuilder(UpdateLoadBalancerRequest::builder).basePath("/20170115").appendPathParam("loadBalancers").appendPathParam(request.getLoadBalancerId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBody().handleResponseHeaderString("opc-work-request-id", UpdateLoadBalancerResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", UpdateLoadBalancerResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public UpdateLoadBalancerShapeResponse updateLoadBalancerShape(UpdateLoadBalancerShapeRequest request) {
        Validate.notBlank((String)request.getLoadBalancerId(), (String)"loadBalancerId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdateLoadBalancerShapeDetails(), "updateLoadBalancerShapeDetails is required");
        return (UpdateLoadBalancerShapeResponse)this.clientCall(request, UpdateLoadBalancerShapeResponse::builder).logger(LOG, "updateLoadBalancerShape").serviceDetails("LoadBalancer", "UpdateLoadBalancerShape", "https://docs.oracle.com/iaas/api/#/en/loadbalancer/20170115/LoadBalancer/UpdateLoadBalancerShape").method(Method.PUT).requestBuilder(UpdateLoadBalancerShapeRequest::builder).basePath("/20170115").appendPathParam("loadBalancers").appendPathParam(request.getLoadBalancerId()).appendPathParam("updateShape").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("if-match", request.getIfMatch()).hasBody().handleResponseHeaderString("opc-work-request-id", UpdateLoadBalancerShapeResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", UpdateLoadBalancerShapeResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public UpdateNetworkSecurityGroupsResponse updateNetworkSecurityGroups(UpdateNetworkSecurityGroupsRequest request) {
        Objects.requireNonNull(request.getUpdateNetworkSecurityGroupsDetails(), "updateNetworkSecurityGroupsDetails is required");
        Validate.notBlank((String)request.getLoadBalancerId(), (String)"loadBalancerId must not be blank", (Object[])new Object[0]);
        return (UpdateNetworkSecurityGroupsResponse)this.clientCall(request, UpdateNetworkSecurityGroupsResponse::builder).logger(LOG, "updateNetworkSecurityGroups").serviceDetails("LoadBalancer", "UpdateNetworkSecurityGroups", "https://docs.oracle.com/iaas/api/#/en/loadbalancer/20170115/NetworkSecurityGroups/UpdateNetworkSecurityGroups").method(Method.PUT).requestBuilder(UpdateNetworkSecurityGroupsRequest::builder).basePath("/20170115").appendPathParam("loadBalancers").appendPathParam(request.getLoadBalancerId()).appendPathParam("networkSecurityGroups").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("if-match", request.getIfMatch()).hasBody().handleResponseHeaderString("opc-work-request-id", UpdateNetworkSecurityGroupsResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", UpdateNetworkSecurityGroupsResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public UpdatePathRouteSetResponse updatePathRouteSet(UpdatePathRouteSetRequest request) {
        Objects.requireNonNull(request.getUpdatePathRouteSetDetails(), "updatePathRouteSetDetails is required");
        Validate.notBlank((String)request.getLoadBalancerId(), (String)"loadBalancerId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getPathRouteSetName(), (String)"pathRouteSetName must not be blank", (Object[])new Object[0]);
        return (UpdatePathRouteSetResponse)this.clientCall(request, UpdatePathRouteSetResponse::builder).logger(LOG, "updatePathRouteSet").serviceDetails("LoadBalancer", "UpdatePathRouteSet", "").method(Method.PUT).requestBuilder(UpdatePathRouteSetRequest::builder).basePath("/20170115").appendPathParam("loadBalancers").appendPathParam(request.getLoadBalancerId()).appendPathParam("pathRouteSets").appendPathParam(request.getPathRouteSetName()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBody().handleResponseHeaderString("opc-work-request-id", UpdatePathRouteSetResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", UpdatePathRouteSetResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public UpdateRoutingPolicyResponse updateRoutingPolicy(UpdateRoutingPolicyRequest request) {
        Objects.requireNonNull(request.getUpdateRoutingPolicyDetails(), "updateRoutingPolicyDetails is required");
        Validate.notBlank((String)request.getLoadBalancerId(), (String)"loadBalancerId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getRoutingPolicyName(), (String)"routingPolicyName must not be blank", (Object[])new Object[0]);
        return (UpdateRoutingPolicyResponse)this.clientCall(request, UpdateRoutingPolicyResponse::builder).logger(LOG, "updateRoutingPolicy").serviceDetails("LoadBalancer", "UpdateRoutingPolicy", "").method(Method.PUT).requestBuilder(UpdateRoutingPolicyRequest::builder).basePath("/20170115").appendPathParam("loadBalancers").appendPathParam(request.getLoadBalancerId()).appendPathParam("routingPolicies").appendPathParam(request.getRoutingPolicyName()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBody().handleResponseHeaderString("opc-work-request-id", UpdateRoutingPolicyResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", UpdateRoutingPolicyResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public UpdateRuleSetResponse updateRuleSet(UpdateRuleSetRequest request) {
        Validate.notBlank((String)request.getLoadBalancerId(), (String)"loadBalancerId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getRuleSetName(), (String)"ruleSetName must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdateRuleSetDetails(), "updateRuleSetDetails is required");
        return (UpdateRuleSetResponse)this.clientCall(request, UpdateRuleSetResponse::builder).logger(LOG, "updateRuleSet").serviceDetails("LoadBalancer", "UpdateRuleSet", "").method(Method.PUT).requestBuilder(UpdateRuleSetRequest::builder).basePath("/20170115").appendPathParam("loadBalancers").appendPathParam(request.getLoadBalancerId()).appendPathParam("ruleSets").appendPathParam(request.getRuleSetName()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("if-match", request.getIfMatch()).hasBody().handleResponseHeaderString("opc-work-request-id", UpdateRuleSetResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", UpdateRuleSetResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public UpdateSSLCipherSuiteResponse updateSSLCipherSuite(UpdateSSLCipherSuiteRequest request) {
        Objects.requireNonNull(request.getUpdateSSLCipherSuiteDetails(), "updateSSLCipherSuiteDetails is required");
        Validate.notBlank((String)request.getLoadBalancerId(), (String)"loadBalancerId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getName(), (String)"name must not be blank", (Object[])new Object[0]);
        return (UpdateSSLCipherSuiteResponse)this.clientCall(request, UpdateSSLCipherSuiteResponse::builder).logger(LOG, "updateSSLCipherSuite").serviceDetails("LoadBalancer", "UpdateSSLCipherSuite", "").method(Method.PUT).requestBuilder(UpdateSSLCipherSuiteRequest::builder).basePath("/20170115").appendPathParam("loadBalancers").appendPathParam(request.getLoadBalancerId()).appendPathParam("sslCipherSuites").appendPathParam(request.getName()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("if-match", request.getIfMatch()).hasBody().handleResponseHeaderString("opc-work-request-id", UpdateSSLCipherSuiteResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", UpdateSSLCipherSuiteResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public LoadBalancerWaiters getWaiters() {
        return this.waiters;
    }

    @Override
    public LoadBalancerPaginators getPaginators() {
        return this.paginators;
    }

    @Deprecated
    public LoadBalancerClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider) {
        this((ClientBuilderBase<?, ?>)LoadBalancerClient.builder(), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider, null);
    }

    @Deprecated
    public LoadBalancerClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration) {
        this(LoadBalancerClient.builder().configuration(configuration), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider, null);
    }

    @Deprecated
    public LoadBalancerClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator) {
        this(((Builder)LoadBalancerClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider, null);
    }

    @Deprecated
    public LoadBalancerClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory) {
        this(((Builder)((Builder)LoadBalancerClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory), authenticationDetailsProvider, null);
    }

    @Deprecated
    public LoadBalancerClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators) {
        this(((Builder)((Builder)((Builder)LoadBalancerClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators), authenticationDetailsProvider, null);
    }

    @Deprecated
    public LoadBalancerClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(((Builder)((Builder)((Builder)((Builder)LoadBalancerClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint), authenticationDetailsProvider, null);
    }

    @Deprecated
    public LoadBalancerClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(((Builder)((Builder)((Builder)((Builder)((Builder)LoadBalancerClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint)).signingStrategyRequestSignerFactories(signingStrategyRequestSignerFactories), authenticationDetailsProvider, null);
    }

    @Deprecated
    public LoadBalancerClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint, ExecutorService executorService) {
        this(((Builder)((Builder)((Builder)((Builder)((Builder)LoadBalancerClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint)).signingStrategyRequestSignerFactories(signingStrategyRequestSignerFactories), authenticationDetailsProvider, executorService);
    }

    public static class Builder
    extends RegionalClientBuilder<Builder, LoadBalancerClient> {
        private ExecutorService executorService;

        private Builder(Service service) {
            super(service);
            String packageName = "loadbalancer";
            Alloy.throwDisabledServiceExceptionIfAppropriate((String)"loadbalancer");
            this.requestSignerFactory = new DefaultRequestSignerFactory(SigningStrategy.STANDARD);
        }

        public Builder executorService(ExecutorService executorService) {
            this.executorService = executorService;
            return this;
        }

        public LoadBalancerClient build(@Nonnull AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
            return new LoadBalancerClient((ClientBuilderBase<?, ?>)this, authenticationDetailsProvider, this.executorService);
        }
    }
}

