/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.loadbalancer.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.http.internal.BmcEnum;
import java.beans.ConstructorProperties;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class ConnectionConfiguration
extends ExplicitlySetBmcModel {
    @JsonProperty(value="idleTimeout")
    private final Long idleTimeout;
    @JsonProperty(value="backendTcpProxyProtocolVersion")
    private final Integer backendTcpProxyProtocolVersion;
    @JsonProperty(value="backendTcpProxyProtocolOptions")
    private final List<BackendTcpProxyProtocolOptions> backendTcpProxyProtocolOptions;

    @Deprecated
    @ConstructorProperties(value={"idleTimeout", "backendTcpProxyProtocolVersion", "backendTcpProxyProtocolOptions"})
    public ConnectionConfiguration(Long idleTimeout, Integer backendTcpProxyProtocolVersion, List<BackendTcpProxyProtocolOptions> backendTcpProxyProtocolOptions) {
        this.idleTimeout = idleTimeout;
        this.backendTcpProxyProtocolVersion = backendTcpProxyProtocolVersion;
        this.backendTcpProxyProtocolOptions = backendTcpProxyProtocolOptions;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public Long getIdleTimeout() {
        return this.idleTimeout;
    }

    public Integer getBackendTcpProxyProtocolVersion() {
        return this.backendTcpProxyProtocolVersion;
    }

    public List<BackendTcpProxyProtocolOptions> getBackendTcpProxyProtocolOptions() {
        return this.backendTcpProxyProtocolOptions;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("ConnectionConfiguration(");
        sb.append("super=").append(super.toString());
        sb.append("idleTimeout=").append(String.valueOf(this.idleTimeout));
        sb.append(", backendTcpProxyProtocolVersion=").append(String.valueOf(this.backendTcpProxyProtocolVersion));
        sb.append(", backendTcpProxyProtocolOptions=").append(String.valueOf(this.backendTcpProxyProtocolOptions));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ConnectionConfiguration)) {
            return false;
        }
        ConnectionConfiguration other = (ConnectionConfiguration)((Object)o);
        return Objects.equals(this.idleTimeout, other.idleTimeout) && Objects.equals(this.backendTcpProxyProtocolVersion, other.backendTcpProxyProtocolVersion) && Objects.equals(this.backendTcpProxyProtocolOptions, other.backendTcpProxyProtocolOptions) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.idleTimeout == null ? 43 : this.idleTimeout.hashCode());
        result = result * 59 + (this.backendTcpProxyProtocolVersion == null ? 43 : this.backendTcpProxyProtocolVersion.hashCode());
        result = result * 59 + (this.backendTcpProxyProtocolOptions == null ? 43 : this.backendTcpProxyProtocolOptions.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    public static enum BackendTcpProxyProtocolOptions implements BmcEnum
    {
        Pp2TypeAuthority("PP2_TYPE_AUTHORITY"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, BackendTcpProxyProtocolOptions> map;

        private BackendTcpProxyProtocolOptions(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static BackendTcpProxyProtocolOptions create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'BackendTcpProxyProtocolOptions', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(BackendTcpProxyProtocolOptions.class);
            map = new HashMap<String, BackendTcpProxyProtocolOptions>();
            for (BackendTcpProxyProtocolOptions v : BackendTcpProxyProtocolOptions.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="idleTimeout")
        private Long idleTimeout;
        @JsonProperty(value="backendTcpProxyProtocolVersion")
        private Integer backendTcpProxyProtocolVersion;
        @JsonProperty(value="backendTcpProxyProtocolOptions")
        private List<BackendTcpProxyProtocolOptions> backendTcpProxyProtocolOptions;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder idleTimeout(Long idleTimeout) {
            this.idleTimeout = idleTimeout;
            this.__explicitlySet__.add("idleTimeout");
            return this;
        }

        public Builder backendTcpProxyProtocolVersion(Integer backendTcpProxyProtocolVersion) {
            this.backendTcpProxyProtocolVersion = backendTcpProxyProtocolVersion;
            this.__explicitlySet__.add("backendTcpProxyProtocolVersion");
            return this;
        }

        public Builder backendTcpProxyProtocolOptions(List<BackendTcpProxyProtocolOptions> backendTcpProxyProtocolOptions) {
            this.backendTcpProxyProtocolOptions = backendTcpProxyProtocolOptions;
            this.__explicitlySet__.add("backendTcpProxyProtocolOptions");
            return this;
        }

        public ConnectionConfiguration build() {
            ConnectionConfiguration model = new ConnectionConfiguration(this.idleTimeout, this.backendTcpProxyProtocolVersion, this.backendTcpProxyProtocolOptions);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(ConnectionConfiguration model) {
            if (model.wasPropertyExplicitlySet("idleTimeout")) {
                this.idleTimeout(model.getIdleTimeout());
            }
            if (model.wasPropertyExplicitlySet("backendTcpProxyProtocolVersion")) {
                this.backendTcpProxyProtocolVersion(model.getBackendTcpProxyProtocolVersion());
            }
            if (model.wasPropertyExplicitlySet("backendTcpProxyProtocolOptions")) {
                this.backendTcpProxyProtocolOptions(model.getBackendTcpProxyProtocolOptions());
            }
            return this;
        }
    }
}

