/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.loadbalancer.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.http.internal.BmcEnum;
import com.oracle.bmc.loadbalancer.model.BackendSetDetails;
import com.oracle.bmc.loadbalancer.model.CertificateDetails;
import com.oracle.bmc.loadbalancer.model.HostnameDetails;
import com.oracle.bmc.loadbalancer.model.ListenerDetails;
import com.oracle.bmc.loadbalancer.model.PathRouteSetDetails;
import com.oracle.bmc.loadbalancer.model.ReservedIP;
import com.oracle.bmc.loadbalancer.model.RuleSetDetails;
import com.oracle.bmc.loadbalancer.model.SSLCipherSuiteDetails;
import com.oracle.bmc.loadbalancer.model.ShapeDetails;
import java.beans.ConstructorProperties;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class CreateLoadBalancerDetails
extends ExplicitlySetBmcModel {
    @JsonProperty(value="compartmentId")
    private final String compartmentId;
    @JsonProperty(value="displayName")
    private final String displayName;
    @JsonProperty(value="shapeName")
    private final String shapeName;
    @JsonProperty(value="shapeDetails")
    private final ShapeDetails shapeDetails;
    @JsonProperty(value="isPrivate")
    private final Boolean isPrivate;
    @JsonProperty(value="isDeleteProtectionEnabled")
    private final Boolean isDeleteProtectionEnabled;
    @JsonProperty(value="ipMode")
    private final IpMode ipMode;
    @JsonProperty(value="isRequestIdEnabled")
    private final Boolean isRequestIdEnabled;
    @JsonProperty(value="requestIdHeader")
    private final String requestIdHeader;
    @JsonProperty(value="reservedIps")
    private final List<ReservedIP> reservedIps;
    @JsonProperty(value="listeners")
    private final Map<String, ListenerDetails> listeners;
    @JsonProperty(value="hostnames")
    private final Map<String, HostnameDetails> hostnames;
    @JsonProperty(value="backendSets")
    private final Map<String, BackendSetDetails> backendSets;
    @JsonProperty(value="networkSecurityGroupIds")
    private final List<String> networkSecurityGroupIds;
    @JsonProperty(value="subnetIds")
    private final List<String> subnetIds;
    @JsonProperty(value="certificates")
    private final Map<String, CertificateDetails> certificates;
    @JsonProperty(value="sslCipherSuites")
    private final Map<String, SSLCipherSuiteDetails> sslCipherSuites;
    @JsonProperty(value="pathRouteSets")
    private final Map<String, PathRouteSetDetails> pathRouteSets;
    @JsonProperty(value="freeformTags")
    private final Map<String, String> freeformTags;
    @JsonProperty(value="definedTags")
    private final Map<String, Map<String, Object>> definedTags;
    @JsonProperty(value="zprTags")
    private final Map<String, Map<String, Object>> zprTags;
    @JsonProperty(value="ruleSets")
    private final Map<String, RuleSetDetails> ruleSets;

    @Deprecated
    @ConstructorProperties(value={"compartmentId", "displayName", "shapeName", "shapeDetails", "isPrivate", "isDeleteProtectionEnabled", "ipMode", "isRequestIdEnabled", "requestIdHeader", "reservedIps", "listeners", "hostnames", "backendSets", "networkSecurityGroupIds", "subnetIds", "certificates", "sslCipherSuites", "pathRouteSets", "freeformTags", "definedTags", "zprTags", "ruleSets"})
    public CreateLoadBalancerDetails(String compartmentId, String displayName, String shapeName, ShapeDetails shapeDetails, Boolean isPrivate, Boolean isDeleteProtectionEnabled, IpMode ipMode, Boolean isRequestIdEnabled, String requestIdHeader, List<ReservedIP> reservedIps, Map<String, ListenerDetails> listeners, Map<String, HostnameDetails> hostnames, Map<String, BackendSetDetails> backendSets, List<String> networkSecurityGroupIds, List<String> subnetIds, Map<String, CertificateDetails> certificates, Map<String, SSLCipherSuiteDetails> sslCipherSuites, Map<String, PathRouteSetDetails> pathRouteSets, Map<String, String> freeformTags, Map<String, Map<String, Object>> definedTags, Map<String, Map<String, Object>> zprTags, Map<String, RuleSetDetails> ruleSets) {
        this.compartmentId = compartmentId;
        this.displayName = displayName;
        this.shapeName = shapeName;
        this.shapeDetails = shapeDetails;
        this.isPrivate = isPrivate;
        this.isDeleteProtectionEnabled = isDeleteProtectionEnabled;
        this.ipMode = ipMode;
        this.isRequestIdEnabled = isRequestIdEnabled;
        this.requestIdHeader = requestIdHeader;
        this.reservedIps = reservedIps;
        this.listeners = listeners;
        this.hostnames = hostnames;
        this.backendSets = backendSets;
        this.networkSecurityGroupIds = networkSecurityGroupIds;
        this.subnetIds = subnetIds;
        this.certificates = certificates;
        this.sslCipherSuites = sslCipherSuites;
        this.pathRouteSets = pathRouteSets;
        this.freeformTags = freeformTags;
        this.definedTags = definedTags;
        this.zprTags = zprTags;
        this.ruleSets = ruleSets;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getCompartmentId() {
        return this.compartmentId;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getShapeName() {
        return this.shapeName;
    }

    public ShapeDetails getShapeDetails() {
        return this.shapeDetails;
    }

    public Boolean getIsPrivate() {
        return this.isPrivate;
    }

    public Boolean getIsDeleteProtectionEnabled() {
        return this.isDeleteProtectionEnabled;
    }

    public IpMode getIpMode() {
        return this.ipMode;
    }

    public Boolean getIsRequestIdEnabled() {
        return this.isRequestIdEnabled;
    }

    public String getRequestIdHeader() {
        return this.requestIdHeader;
    }

    public List<ReservedIP> getReservedIps() {
        return this.reservedIps;
    }

    public Map<String, ListenerDetails> getListeners() {
        return this.listeners;
    }

    public Map<String, HostnameDetails> getHostnames() {
        return this.hostnames;
    }

    public Map<String, BackendSetDetails> getBackendSets() {
        return this.backendSets;
    }

    public List<String> getNetworkSecurityGroupIds() {
        return this.networkSecurityGroupIds;
    }

    public List<String> getSubnetIds() {
        return this.subnetIds;
    }

    public Map<String, CertificateDetails> getCertificates() {
        return this.certificates;
    }

    public Map<String, SSLCipherSuiteDetails> getSslCipherSuites() {
        return this.sslCipherSuites;
    }

    public Map<String, PathRouteSetDetails> getPathRouteSets() {
        return this.pathRouteSets;
    }

    public Map<String, String> getFreeformTags() {
        return this.freeformTags;
    }

    public Map<String, Map<String, Object>> getDefinedTags() {
        return this.definedTags;
    }

    public Map<String, Map<String, Object>> getZprTags() {
        return this.zprTags;
    }

    public Map<String, RuleSetDetails> getRuleSets() {
        return this.ruleSets;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("CreateLoadBalancerDetails(");
        sb.append("super=").append(super.toString());
        sb.append("compartmentId=").append(String.valueOf(this.compartmentId));
        sb.append(", displayName=").append(String.valueOf(this.displayName));
        sb.append(", shapeName=").append(String.valueOf(this.shapeName));
        sb.append(", shapeDetails=").append(String.valueOf((Object)this.shapeDetails));
        sb.append(", isPrivate=").append(String.valueOf(this.isPrivate));
        sb.append(", isDeleteProtectionEnabled=").append(String.valueOf(this.isDeleteProtectionEnabled));
        sb.append(", ipMode=").append(String.valueOf((Object)this.ipMode));
        sb.append(", isRequestIdEnabled=").append(String.valueOf(this.isRequestIdEnabled));
        sb.append(", requestIdHeader=").append(String.valueOf(this.requestIdHeader));
        sb.append(", reservedIps=").append(String.valueOf(this.reservedIps));
        sb.append(", listeners=").append(String.valueOf(this.listeners));
        sb.append(", hostnames=").append(String.valueOf(this.hostnames));
        sb.append(", backendSets=").append(String.valueOf(this.backendSets));
        sb.append(", networkSecurityGroupIds=").append(String.valueOf(this.networkSecurityGroupIds));
        sb.append(", subnetIds=").append(String.valueOf(this.subnetIds));
        sb.append(", certificates=").append(String.valueOf(this.certificates));
        sb.append(", sslCipherSuites=").append(String.valueOf(this.sslCipherSuites));
        sb.append(", pathRouteSets=").append(String.valueOf(this.pathRouteSets));
        sb.append(", freeformTags=").append(String.valueOf(this.freeformTags));
        sb.append(", definedTags=").append(String.valueOf(this.definedTags));
        sb.append(", zprTags=").append(String.valueOf(this.zprTags));
        sb.append(", ruleSets=").append(String.valueOf(this.ruleSets));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CreateLoadBalancerDetails)) {
            return false;
        }
        CreateLoadBalancerDetails other = (CreateLoadBalancerDetails)((Object)o);
        return Objects.equals(this.compartmentId, other.compartmentId) && Objects.equals(this.displayName, other.displayName) && Objects.equals(this.shapeName, other.shapeName) && Objects.equals((Object)this.shapeDetails, (Object)other.shapeDetails) && Objects.equals(this.isPrivate, other.isPrivate) && Objects.equals(this.isDeleteProtectionEnabled, other.isDeleteProtectionEnabled) && Objects.equals((Object)this.ipMode, (Object)other.ipMode) && Objects.equals(this.isRequestIdEnabled, other.isRequestIdEnabled) && Objects.equals(this.requestIdHeader, other.requestIdHeader) && Objects.equals(this.reservedIps, other.reservedIps) && Objects.equals(this.listeners, other.listeners) && Objects.equals(this.hostnames, other.hostnames) && Objects.equals(this.backendSets, other.backendSets) && Objects.equals(this.networkSecurityGroupIds, other.networkSecurityGroupIds) && Objects.equals(this.subnetIds, other.subnetIds) && Objects.equals(this.certificates, other.certificates) && Objects.equals(this.sslCipherSuites, other.sslCipherSuites) && Objects.equals(this.pathRouteSets, other.pathRouteSets) && Objects.equals(this.freeformTags, other.freeformTags) && Objects.equals(this.definedTags, other.definedTags) && Objects.equals(this.zprTags, other.zprTags) && Objects.equals(this.ruleSets, other.ruleSets) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.compartmentId == null ? 43 : this.compartmentId.hashCode());
        result = result * 59 + (this.displayName == null ? 43 : this.displayName.hashCode());
        result = result * 59 + (this.shapeName == null ? 43 : this.shapeName.hashCode());
        result = result * 59 + (this.shapeDetails == null ? 43 : this.shapeDetails.hashCode());
        result = result * 59 + (this.isPrivate == null ? 43 : this.isPrivate.hashCode());
        result = result * 59 + (this.isDeleteProtectionEnabled == null ? 43 : this.isDeleteProtectionEnabled.hashCode());
        result = result * 59 + (this.ipMode == null ? 43 : this.ipMode.hashCode());
        result = result * 59 + (this.isRequestIdEnabled == null ? 43 : this.isRequestIdEnabled.hashCode());
        result = result * 59 + (this.requestIdHeader == null ? 43 : this.requestIdHeader.hashCode());
        result = result * 59 + (this.reservedIps == null ? 43 : this.reservedIps.hashCode());
        result = result * 59 + (this.listeners == null ? 43 : this.listeners.hashCode());
        result = result * 59 + (this.hostnames == null ? 43 : this.hostnames.hashCode());
        result = result * 59 + (this.backendSets == null ? 43 : this.backendSets.hashCode());
        result = result * 59 + (this.networkSecurityGroupIds == null ? 43 : this.networkSecurityGroupIds.hashCode());
        result = result * 59 + (this.subnetIds == null ? 43 : this.subnetIds.hashCode());
        result = result * 59 + (this.certificates == null ? 43 : this.certificates.hashCode());
        result = result * 59 + (this.sslCipherSuites == null ? 43 : this.sslCipherSuites.hashCode());
        result = result * 59 + (this.pathRouteSets == null ? 43 : this.pathRouteSets.hashCode());
        result = result * 59 + (this.freeformTags == null ? 43 : this.freeformTags.hashCode());
        result = result * 59 + (this.definedTags == null ? 43 : this.definedTags.hashCode());
        result = result * 59 + (this.zprTags == null ? 43 : this.zprTags.hashCode());
        result = result * 59 + (this.ruleSets == null ? 43 : this.ruleSets.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    public static enum IpMode implements BmcEnum
    {
        Ipv4("IPV4"),
        Ipv6("IPV6");

        private final String value;
        private static Map<String, IpMode> map;

        private IpMode(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static IpMode create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid IpMode: " + key);
        }

        static {
            map = new HashMap<String, IpMode>();
            for (IpMode v : IpMode.values()) {
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="compartmentId")
        private String compartmentId;
        @JsonProperty(value="displayName")
        private String displayName;
        @JsonProperty(value="shapeName")
        private String shapeName;
        @JsonProperty(value="shapeDetails")
        private ShapeDetails shapeDetails;
        @JsonProperty(value="isPrivate")
        private Boolean isPrivate;
        @JsonProperty(value="isDeleteProtectionEnabled")
        private Boolean isDeleteProtectionEnabled;
        @JsonProperty(value="ipMode")
        private IpMode ipMode;
        @JsonProperty(value="isRequestIdEnabled")
        private Boolean isRequestIdEnabled;
        @JsonProperty(value="requestIdHeader")
        private String requestIdHeader;
        @JsonProperty(value="reservedIps")
        private List<ReservedIP> reservedIps;
        @JsonProperty(value="listeners")
        private Map<String, ListenerDetails> listeners;
        @JsonProperty(value="hostnames")
        private Map<String, HostnameDetails> hostnames;
        @JsonProperty(value="backendSets")
        private Map<String, BackendSetDetails> backendSets;
        @JsonProperty(value="networkSecurityGroupIds")
        private List<String> networkSecurityGroupIds;
        @JsonProperty(value="subnetIds")
        private List<String> subnetIds;
        @JsonProperty(value="certificates")
        private Map<String, CertificateDetails> certificates;
        @JsonProperty(value="sslCipherSuites")
        private Map<String, SSLCipherSuiteDetails> sslCipherSuites;
        @JsonProperty(value="pathRouteSets")
        private Map<String, PathRouteSetDetails> pathRouteSets;
        @JsonProperty(value="freeformTags")
        private Map<String, String> freeformTags;
        @JsonProperty(value="definedTags")
        private Map<String, Map<String, Object>> definedTags;
        @JsonProperty(value="zprTags")
        private Map<String, Map<String, Object>> zprTags;
        @JsonProperty(value="ruleSets")
        private Map<String, RuleSetDetails> ruleSets;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            this.__explicitlySet__.add("compartmentId");
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.__explicitlySet__.add("displayName");
            return this;
        }

        public Builder shapeName(String shapeName) {
            this.shapeName = shapeName;
            this.__explicitlySet__.add("shapeName");
            return this;
        }

        public Builder shapeDetails(ShapeDetails shapeDetails) {
            this.shapeDetails = shapeDetails;
            this.__explicitlySet__.add("shapeDetails");
            return this;
        }

        public Builder isPrivate(Boolean isPrivate) {
            this.isPrivate = isPrivate;
            this.__explicitlySet__.add("isPrivate");
            return this;
        }

        public Builder isDeleteProtectionEnabled(Boolean isDeleteProtectionEnabled) {
            this.isDeleteProtectionEnabled = isDeleteProtectionEnabled;
            this.__explicitlySet__.add("isDeleteProtectionEnabled");
            return this;
        }

        public Builder ipMode(IpMode ipMode) {
            this.ipMode = ipMode;
            this.__explicitlySet__.add("ipMode");
            return this;
        }

        public Builder isRequestIdEnabled(Boolean isRequestIdEnabled) {
            this.isRequestIdEnabled = isRequestIdEnabled;
            this.__explicitlySet__.add("isRequestIdEnabled");
            return this;
        }

        public Builder requestIdHeader(String requestIdHeader) {
            this.requestIdHeader = requestIdHeader;
            this.__explicitlySet__.add("requestIdHeader");
            return this;
        }

        public Builder reservedIps(List<ReservedIP> reservedIps) {
            this.reservedIps = reservedIps;
            this.__explicitlySet__.add("reservedIps");
            return this;
        }

        public Builder listeners(Map<String, ListenerDetails> listeners) {
            this.listeners = listeners;
            this.__explicitlySet__.add("listeners");
            return this;
        }

        public Builder hostnames(Map<String, HostnameDetails> hostnames) {
            this.hostnames = hostnames;
            this.__explicitlySet__.add("hostnames");
            return this;
        }

        public Builder backendSets(Map<String, BackendSetDetails> backendSets) {
            this.backendSets = backendSets;
            this.__explicitlySet__.add("backendSets");
            return this;
        }

        public Builder networkSecurityGroupIds(List<String> networkSecurityGroupIds) {
            this.networkSecurityGroupIds = networkSecurityGroupIds;
            this.__explicitlySet__.add("networkSecurityGroupIds");
            return this;
        }

        public Builder subnetIds(List<String> subnetIds) {
            this.subnetIds = subnetIds;
            this.__explicitlySet__.add("subnetIds");
            return this;
        }

        public Builder certificates(Map<String, CertificateDetails> certificates) {
            this.certificates = certificates;
            this.__explicitlySet__.add("certificates");
            return this;
        }

        public Builder sslCipherSuites(Map<String, SSLCipherSuiteDetails> sslCipherSuites) {
            this.sslCipherSuites = sslCipherSuites;
            this.__explicitlySet__.add("sslCipherSuites");
            return this;
        }

        public Builder pathRouteSets(Map<String, PathRouteSetDetails> pathRouteSets) {
            this.pathRouteSets = pathRouteSets;
            this.__explicitlySet__.add("pathRouteSets");
            return this;
        }

        public Builder freeformTags(Map<String, String> freeformTags) {
            this.freeformTags = freeformTags;
            this.__explicitlySet__.add("freeformTags");
            return this;
        }

        public Builder definedTags(Map<String, Map<String, Object>> definedTags) {
            this.definedTags = definedTags;
            this.__explicitlySet__.add("definedTags");
            return this;
        }

        public Builder zprTags(Map<String, Map<String, Object>> zprTags) {
            this.zprTags = zprTags;
            this.__explicitlySet__.add("zprTags");
            return this;
        }

        public Builder ruleSets(Map<String, RuleSetDetails> ruleSets) {
            this.ruleSets = ruleSets;
            this.__explicitlySet__.add("ruleSets");
            return this;
        }

        public CreateLoadBalancerDetails build() {
            CreateLoadBalancerDetails model = new CreateLoadBalancerDetails(this.compartmentId, this.displayName, this.shapeName, this.shapeDetails, this.isPrivate, this.isDeleteProtectionEnabled, this.ipMode, this.isRequestIdEnabled, this.requestIdHeader, this.reservedIps, this.listeners, this.hostnames, this.backendSets, this.networkSecurityGroupIds, this.subnetIds, this.certificates, this.sslCipherSuites, this.pathRouteSets, this.freeformTags, this.definedTags, this.zprTags, this.ruleSets);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(CreateLoadBalancerDetails model) {
            if (model.wasPropertyExplicitlySet("compartmentId")) {
                this.compartmentId(model.getCompartmentId());
            }
            if (model.wasPropertyExplicitlySet("displayName")) {
                this.displayName(model.getDisplayName());
            }
            if (model.wasPropertyExplicitlySet("shapeName")) {
                this.shapeName(model.getShapeName());
            }
            if (model.wasPropertyExplicitlySet("shapeDetails")) {
                this.shapeDetails(model.getShapeDetails());
            }
            if (model.wasPropertyExplicitlySet("isPrivate")) {
                this.isPrivate(model.getIsPrivate());
            }
            if (model.wasPropertyExplicitlySet("isDeleteProtectionEnabled")) {
                this.isDeleteProtectionEnabled(model.getIsDeleteProtectionEnabled());
            }
            if (model.wasPropertyExplicitlySet("ipMode")) {
                this.ipMode(model.getIpMode());
            }
            if (model.wasPropertyExplicitlySet("isRequestIdEnabled")) {
                this.isRequestIdEnabled(model.getIsRequestIdEnabled());
            }
            if (model.wasPropertyExplicitlySet("requestIdHeader")) {
                this.requestIdHeader(model.getRequestIdHeader());
            }
            if (model.wasPropertyExplicitlySet("reservedIps")) {
                this.reservedIps(model.getReservedIps());
            }
            if (model.wasPropertyExplicitlySet("listeners")) {
                this.listeners(model.getListeners());
            }
            if (model.wasPropertyExplicitlySet("hostnames")) {
                this.hostnames(model.getHostnames());
            }
            if (model.wasPropertyExplicitlySet("backendSets")) {
                this.backendSets(model.getBackendSets());
            }
            if (model.wasPropertyExplicitlySet("networkSecurityGroupIds")) {
                this.networkSecurityGroupIds(model.getNetworkSecurityGroupIds());
            }
            if (model.wasPropertyExplicitlySet("subnetIds")) {
                this.subnetIds(model.getSubnetIds());
            }
            if (model.wasPropertyExplicitlySet("certificates")) {
                this.certificates(model.getCertificates());
            }
            if (model.wasPropertyExplicitlySet("sslCipherSuites")) {
                this.sslCipherSuites(model.getSslCipherSuites());
            }
            if (model.wasPropertyExplicitlySet("pathRouteSets")) {
                this.pathRouteSets(model.getPathRouteSets());
            }
            if (model.wasPropertyExplicitlySet("freeformTags")) {
                this.freeformTags(model.getFreeformTags());
            }
            if (model.wasPropertyExplicitlySet("definedTags")) {
                this.definedTags(model.getDefinedTags());
            }
            if (model.wasPropertyExplicitlySet("zprTags")) {
                this.zprTags(model.getZprTags());
            }
            if (model.wasPropertyExplicitlySet("ruleSets")) {
                this.ruleSets(model.getRuleSets());
            }
            return this;
        }
    }
}

