/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.loadbalancer.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.loadbalancer.model.IpMaxConnections;
import com.oracle.bmc.loadbalancer.model.Rule;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="action")
@JsonFilter(value="explicitlySetFilter")
public final class IpBasedMaxConnectionsRule
extends Rule {
    @JsonProperty(value="defaultMaxConnections")
    private final Integer defaultMaxConnections;
    @JsonProperty(value="ipMaxConnections")
    private final List<IpMaxConnections> ipMaxConnections;

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    @Deprecated
    public IpBasedMaxConnectionsRule(Integer defaultMaxConnections, List<IpMaxConnections> ipMaxConnections) {
        this.defaultMaxConnections = defaultMaxConnections;
        this.ipMaxConnections = ipMaxConnections;
    }

    public Integer getDefaultMaxConnections() {
        return this.defaultMaxConnections;
    }

    public List<IpMaxConnections> getIpMaxConnections() {
        return this.ipMaxConnections;
    }

    @Override
    public String toString() {
        return this.toString(true);
    }

    @Override
    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("IpBasedMaxConnectionsRule(");
        sb.append("super=").append(super.toString(includeByteArrayContents));
        sb.append(", defaultMaxConnections=").append(String.valueOf(this.defaultMaxConnections));
        sb.append(", ipMaxConnections=").append(String.valueOf(this.ipMaxConnections));
        sb.append(")");
        return sb.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof IpBasedMaxConnectionsRule)) {
            return false;
        }
        IpBasedMaxConnectionsRule other = (IpBasedMaxConnectionsRule)((Object)o);
        return Objects.equals(this.defaultMaxConnections, other.defaultMaxConnections) && Objects.equals(this.ipMaxConnections, other.ipMaxConnections) && super.equals((Object)other);
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.defaultMaxConnections == null ? 43 : this.defaultMaxConnections.hashCode());
        result = result * 59 + (this.ipMaxConnections == null ? 43 : this.ipMaxConnections.hashCode());
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="defaultMaxConnections")
        private Integer defaultMaxConnections;
        @JsonProperty(value="ipMaxConnections")
        private List<IpMaxConnections> ipMaxConnections;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder defaultMaxConnections(Integer defaultMaxConnections) {
            this.defaultMaxConnections = defaultMaxConnections;
            this.__explicitlySet__.add("defaultMaxConnections");
            return this;
        }

        public Builder ipMaxConnections(List<IpMaxConnections> ipMaxConnections) {
            this.ipMaxConnections = ipMaxConnections;
            this.__explicitlySet__.add("ipMaxConnections");
            return this;
        }

        public IpBasedMaxConnectionsRule build() {
            IpBasedMaxConnectionsRule model = new IpBasedMaxConnectionsRule(this.defaultMaxConnections, this.ipMaxConnections);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(IpBasedMaxConnectionsRule model) {
            if (model.wasPropertyExplicitlySet("defaultMaxConnections")) {
                this.defaultMaxConnections(model.getDefaultMaxConnections());
            }
            if (model.wasPropertyExplicitlySet("ipMaxConnections")) {
                this.ipMaxConnections(model.getIpMaxConnections());
            }
            return this;
        }
    }
}

