/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.loadbalancer.requests;

import com.oracle.bmc.InternalSdk;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.loadbalancer.model.CreateBackendDetails;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class CreateBackendRequest
extends BmcRequest<CreateBackendDetails> {
    private CreateBackendDetails createBackendDetails;
    private String loadBalancerId;
    private String backendSetName;
    private String opcRequestId;
    private String ifMatch;
    private String opcRetryToken;

    public CreateBackendDetails getCreateBackendDetails() {
        return this.createBackendDetails;
    }

    public String getLoadBalancerId() {
        return this.loadBalancerId;
    }

    public String getBackendSetName() {
        return this.backendSetName;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public String getIfMatch() {
        return this.ifMatch;
    }

    public String getOpcRetryToken() {
        return this.opcRetryToken;
    }

    @InternalSdk
    public CreateBackendDetails getBody$() {
        return this.createBackendDetails;
    }

    public Builder toBuilder() {
        return new Builder().createBackendDetails(this.createBackendDetails).loadBalancerId(this.loadBalancerId).backendSetName(this.backendSetName).opcRequestId(this.opcRequestId).ifMatch(this.ifMatch).opcRetryToken(this.opcRetryToken);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",createBackendDetails=").append(String.valueOf((Object)this.createBackendDetails));
        sb.append(",loadBalancerId=").append(String.valueOf(this.loadBalancerId));
        sb.append(",backendSetName=").append(String.valueOf(this.backendSetName));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(",ifMatch=").append(String.valueOf(this.ifMatch));
        sb.append(",opcRetryToken=").append(String.valueOf(this.opcRetryToken));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CreateBackendRequest)) {
            return false;
        }
        CreateBackendRequest other = (CreateBackendRequest)((Object)o);
        return super.equals(o) && Objects.equals((Object)this.createBackendDetails, (Object)other.createBackendDetails) && Objects.equals(this.loadBalancerId, other.loadBalancerId) && Objects.equals(this.backendSetName, other.backendSetName) && Objects.equals(this.opcRequestId, other.opcRequestId) && Objects.equals(this.ifMatch, other.ifMatch) && Objects.equals(this.opcRetryToken, other.opcRetryToken);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.createBackendDetails == null ? 43 : this.createBackendDetails.hashCode());
        result = result * 59 + (this.loadBalancerId == null ? 43 : this.loadBalancerId.hashCode());
        result = result * 59 + (this.backendSetName == null ? 43 : this.backendSetName.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        result = result * 59 + (this.ifMatch == null ? 43 : this.ifMatch.hashCode());
        result = result * 59 + (this.opcRetryToken == null ? 43 : this.opcRetryToken.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<CreateBackendRequest, CreateBackendDetails> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private CreateBackendDetails createBackendDetails = null;
        private String loadBalancerId = null;
        private String backendSetName = null;
        private String opcRequestId = null;
        private String ifMatch = null;
        private String opcRetryToken = null;

        public Builder createBackendDetails(CreateBackendDetails createBackendDetails) {
            this.createBackendDetails = createBackendDetails;
            return this;
        }

        public Builder loadBalancerId(String loadBalancerId) {
            this.loadBalancerId = loadBalancerId;
            return this;
        }

        public Builder backendSetName(String backendSetName) {
            this.backendSetName = backendSetName;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        public Builder opcRetryToken(String opcRetryToken) {
            this.opcRetryToken = opcRetryToken;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(CreateBackendRequest o) {
            this.createBackendDetails(o.getCreateBackendDetails());
            this.loadBalancerId(o.getLoadBalancerId());
            this.backendSetName(o.getBackendSetName());
            this.opcRequestId(o.getOpcRequestId());
            this.ifMatch(o.getIfMatch());
            this.opcRetryToken(o.getOpcRetryToken());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public CreateBackendRequest build() {
            CreateBackendRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        @InternalSdk
        public Builder body$(CreateBackendDetails body) {
            this.createBackendDetails(body);
            return this;
        }

        public CreateBackendRequest buildWithoutInvocationCallback() {
            CreateBackendRequest request = new CreateBackendRequest();
            request.createBackendDetails = this.createBackendDetails;
            request.loadBalancerId = this.loadBalancerId;
            request.backendSetName = this.backendSetName;
            request.opcRequestId = this.opcRequestId;
            request.ifMatch = this.ifMatch;
            request.opcRetryToken = this.opcRetryToken;
            return request;
        }
    }
}

