/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.loadbalancer.requests;

import com.oracle.bmc.InternalSdk;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.loadbalancer.model.UpdateRuleSetDetails;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class UpdateRuleSetRequest
extends BmcRequest<UpdateRuleSetDetails> {
    private String loadBalancerId;
    private String ruleSetName;
    private UpdateRuleSetDetails updateRuleSetDetails;
    private String opcRequestId;
    private String opcRetryToken;
    private String ifMatch;

    public String getLoadBalancerId() {
        return this.loadBalancerId;
    }

    public String getRuleSetName() {
        return this.ruleSetName;
    }

    public UpdateRuleSetDetails getUpdateRuleSetDetails() {
        return this.updateRuleSetDetails;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public String getOpcRetryToken() {
        return this.opcRetryToken;
    }

    public String getIfMatch() {
        return this.ifMatch;
    }

    @InternalSdk
    public UpdateRuleSetDetails getBody$() {
        return this.updateRuleSetDetails;
    }

    public Builder toBuilder() {
        return new Builder().loadBalancerId(this.loadBalancerId).ruleSetName(this.ruleSetName).updateRuleSetDetails(this.updateRuleSetDetails).opcRequestId(this.opcRequestId).opcRetryToken(this.opcRetryToken).ifMatch(this.ifMatch);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",loadBalancerId=").append(String.valueOf(this.loadBalancerId));
        sb.append(",ruleSetName=").append(String.valueOf(this.ruleSetName));
        sb.append(",updateRuleSetDetails=").append(String.valueOf((Object)this.updateRuleSetDetails));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(",opcRetryToken=").append(String.valueOf(this.opcRetryToken));
        sb.append(",ifMatch=").append(String.valueOf(this.ifMatch));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof UpdateRuleSetRequest)) {
            return false;
        }
        UpdateRuleSetRequest other = (UpdateRuleSetRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.loadBalancerId, other.loadBalancerId) && Objects.equals(this.ruleSetName, other.ruleSetName) && Objects.equals((Object)this.updateRuleSetDetails, (Object)other.updateRuleSetDetails) && Objects.equals(this.opcRequestId, other.opcRequestId) && Objects.equals(this.opcRetryToken, other.opcRetryToken) && Objects.equals(this.ifMatch, other.ifMatch);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.loadBalancerId == null ? 43 : this.loadBalancerId.hashCode());
        result = result * 59 + (this.ruleSetName == null ? 43 : this.ruleSetName.hashCode());
        result = result * 59 + (this.updateRuleSetDetails == null ? 43 : this.updateRuleSetDetails.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        result = result * 59 + (this.opcRetryToken == null ? 43 : this.opcRetryToken.hashCode());
        result = result * 59 + (this.ifMatch == null ? 43 : this.ifMatch.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<UpdateRuleSetRequest, UpdateRuleSetDetails> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String loadBalancerId = null;
        private String ruleSetName = null;
        private UpdateRuleSetDetails updateRuleSetDetails = null;
        private String opcRequestId = null;
        private String opcRetryToken = null;
        private String ifMatch = null;

        public Builder loadBalancerId(String loadBalancerId) {
            this.loadBalancerId = loadBalancerId;
            return this;
        }

        public Builder ruleSetName(String ruleSetName) {
            this.ruleSetName = ruleSetName;
            return this;
        }

        public Builder updateRuleSetDetails(UpdateRuleSetDetails updateRuleSetDetails) {
            this.updateRuleSetDetails = updateRuleSetDetails;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder opcRetryToken(String opcRetryToken) {
            this.opcRetryToken = opcRetryToken;
            return this;
        }

        public Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(UpdateRuleSetRequest o) {
            this.loadBalancerId(o.getLoadBalancerId());
            this.ruleSetName(o.getRuleSetName());
            this.updateRuleSetDetails(o.getUpdateRuleSetDetails());
            this.opcRequestId(o.getOpcRequestId());
            this.opcRetryToken(o.getOpcRetryToken());
            this.ifMatch(o.getIfMatch());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public UpdateRuleSetRequest build() {
            UpdateRuleSetRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        @InternalSdk
        public Builder body$(UpdateRuleSetDetails body) {
            this.updateRuleSetDetails(body);
            return this;
        }

        public UpdateRuleSetRequest buildWithoutInvocationCallback() {
            UpdateRuleSetRequest request = new UpdateRuleSetRequest();
            request.loadBalancerId = this.loadBalancerId;
            request.ruleSetName = this.ruleSetName;
            request.updateRuleSetDetails = this.updateRuleSetDetails;
            request.opcRequestId = this.opcRequestId;
            request.opcRetryToken = this.opcRetryToken;
            request.ifMatch = this.ifMatch;
            return request;
        }
    }
}

