/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.lockbox.requests;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.http.internal.BmcEnum;
import com.oracle.bmc.lockbox.model.AccessRequest;
import com.oracle.bmc.lockbox.model.LockboxPartner;
import com.oracle.bmc.lockbox.model.SortOrder;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public class ListAccessRequestsRequest
extends BmcRequest<Void> {
    private String opcRequestId;
    private String lockboxId;
    private String id;
    private String displayName;
    private AccessRequest.LifecycleState lifecycleState;
    private LockboxPartner lockboxPartner;
    private String partnerId;
    private String requestorId;
    private Integer limit;
    private String page;
    private SortOrder sortOrder;
    private SortBy sortBy;
    private Date timeCreatedAfter;
    private Date timeCreatedBefore;

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public String getLockboxId() {
        return this.lockboxId;
    }

    public String getId() {
        return this.id;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public AccessRequest.LifecycleState getLifecycleState() {
        return this.lifecycleState;
    }

    public LockboxPartner getLockboxPartner() {
        return this.lockboxPartner;
    }

    public String getPartnerId() {
        return this.partnerId;
    }

    public String getRequestorId() {
        return this.requestorId;
    }

    public Integer getLimit() {
        return this.limit;
    }

    public String getPage() {
        return this.page;
    }

    public SortOrder getSortOrder() {
        return this.sortOrder;
    }

    public SortBy getSortBy() {
        return this.sortBy;
    }

    public Date getTimeCreatedAfter() {
        return this.timeCreatedAfter;
    }

    public Date getTimeCreatedBefore() {
        return this.timeCreatedBefore;
    }

    public Builder toBuilder() {
        return new Builder().opcRequestId(this.opcRequestId).lockboxId(this.lockboxId).id(this.id).displayName(this.displayName).lifecycleState(this.lifecycleState).lockboxPartner(this.lockboxPartner).partnerId(this.partnerId).requestorId(this.requestorId).limit(this.limit).page(this.page).sortOrder(this.sortOrder).sortBy(this.sortBy).timeCreatedAfter(this.timeCreatedAfter).timeCreatedBefore(this.timeCreatedBefore);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(",lockboxId=").append(String.valueOf(this.lockboxId));
        sb.append(",id=").append(String.valueOf(this.id));
        sb.append(",displayName=").append(String.valueOf(this.displayName));
        sb.append(",lifecycleState=").append(String.valueOf((Object)this.lifecycleState));
        sb.append(",lockboxPartner=").append(String.valueOf((Object)this.lockboxPartner));
        sb.append(",partnerId=").append(String.valueOf(this.partnerId));
        sb.append(",requestorId=").append(String.valueOf(this.requestorId));
        sb.append(",limit=").append(String.valueOf(this.limit));
        sb.append(",page=").append(String.valueOf(this.page));
        sb.append(",sortOrder=").append(String.valueOf((Object)this.sortOrder));
        sb.append(",sortBy=").append(String.valueOf((Object)this.sortBy));
        sb.append(",timeCreatedAfter=").append(String.valueOf(this.timeCreatedAfter));
        sb.append(",timeCreatedBefore=").append(String.valueOf(this.timeCreatedBefore));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ListAccessRequestsRequest)) {
            return false;
        }
        ListAccessRequestsRequest other = (ListAccessRequestsRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.opcRequestId, other.opcRequestId) && Objects.equals(this.lockboxId, other.lockboxId) && Objects.equals(this.id, other.id) && Objects.equals(this.displayName, other.displayName) && Objects.equals((Object)this.lifecycleState, (Object)other.lifecycleState) && Objects.equals((Object)this.lockboxPartner, (Object)other.lockboxPartner) && Objects.equals(this.partnerId, other.partnerId) && Objects.equals(this.requestorId, other.requestorId) && Objects.equals(this.limit, other.limit) && Objects.equals(this.page, other.page) && Objects.equals((Object)this.sortOrder, (Object)other.sortOrder) && Objects.equals((Object)this.sortBy, (Object)other.sortBy) && Objects.equals(this.timeCreatedAfter, other.timeCreatedAfter) && Objects.equals(this.timeCreatedBefore, other.timeCreatedBefore);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        result = result * 59 + (this.lockboxId == null ? 43 : this.lockboxId.hashCode());
        result = result * 59 + (this.id == null ? 43 : this.id.hashCode());
        result = result * 59 + (this.displayName == null ? 43 : this.displayName.hashCode());
        result = result * 59 + (this.lifecycleState == null ? 43 : this.lifecycleState.hashCode());
        result = result * 59 + (this.lockboxPartner == null ? 43 : this.lockboxPartner.hashCode());
        result = result * 59 + (this.partnerId == null ? 43 : this.partnerId.hashCode());
        result = result * 59 + (this.requestorId == null ? 43 : this.requestorId.hashCode());
        result = result * 59 + (this.limit == null ? 43 : this.limit.hashCode());
        result = result * 59 + (this.page == null ? 43 : this.page.hashCode());
        result = result * 59 + (this.sortOrder == null ? 43 : this.sortOrder.hashCode());
        result = result * 59 + (this.sortBy == null ? 43 : this.sortBy.hashCode());
        result = result * 59 + (this.timeCreatedAfter == null ? 43 : this.timeCreatedAfter.hashCode());
        result = result * 59 + (this.timeCreatedBefore == null ? 43 : this.timeCreatedBefore.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<ListAccessRequestsRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String opcRequestId = null;
        private String lockboxId = null;
        private String id = null;
        private String displayName = null;
        private AccessRequest.LifecycleState lifecycleState = null;
        private LockboxPartner lockboxPartner = null;
        private String partnerId = null;
        private String requestorId = null;
        private Integer limit = null;
        private String page = null;
        private SortOrder sortOrder = null;
        private SortBy sortBy = null;
        private Date timeCreatedAfter = null;
        private Date timeCreatedBefore = null;

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder lockboxId(String lockboxId) {
            this.lockboxId = lockboxId;
            return this;
        }

        public Builder id(String id) {
            this.id = id;
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        public Builder lifecycleState(AccessRequest.LifecycleState lifecycleState) {
            this.lifecycleState = lifecycleState;
            return this;
        }

        public Builder lockboxPartner(LockboxPartner lockboxPartner) {
            this.lockboxPartner = lockboxPartner;
            return this;
        }

        public Builder partnerId(String partnerId) {
            this.partnerId = partnerId;
            return this;
        }

        public Builder requestorId(String requestorId) {
            this.requestorId = requestorId;
            return this;
        }

        public Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public Builder page(String page) {
            this.page = page;
            return this;
        }

        public Builder sortOrder(SortOrder sortOrder) {
            this.sortOrder = sortOrder;
            return this;
        }

        public Builder sortBy(SortBy sortBy) {
            this.sortBy = sortBy;
            return this;
        }

        public Builder timeCreatedAfter(Date timeCreatedAfter) {
            this.timeCreatedAfter = timeCreatedAfter;
            return this;
        }

        public Builder timeCreatedBefore(Date timeCreatedBefore) {
            this.timeCreatedBefore = timeCreatedBefore;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(ListAccessRequestsRequest o) {
            this.opcRequestId(o.getOpcRequestId());
            this.lockboxId(o.getLockboxId());
            this.id(o.getId());
            this.displayName(o.getDisplayName());
            this.lifecycleState(o.getLifecycleState());
            this.lockboxPartner(o.getLockboxPartner());
            this.partnerId(o.getPartnerId());
            this.requestorId(o.getRequestorId());
            this.limit(o.getLimit());
            this.page(o.getPage());
            this.sortOrder(o.getSortOrder());
            this.sortBy(o.getSortBy());
            this.timeCreatedAfter(o.getTimeCreatedAfter());
            this.timeCreatedBefore(o.getTimeCreatedBefore());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public ListAccessRequestsRequest build() {
            ListAccessRequestsRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public ListAccessRequestsRequest buildWithoutInvocationCallback() {
            ListAccessRequestsRequest request = new ListAccessRequestsRequest();
            request.opcRequestId = this.opcRequestId;
            request.lockboxId = this.lockboxId;
            request.id = this.id;
            request.displayName = this.displayName;
            request.lifecycleState = this.lifecycleState;
            request.lockboxPartner = this.lockboxPartner;
            request.partnerId = this.partnerId;
            request.requestorId = this.requestorId;
            request.limit = this.limit;
            request.page = this.page;
            request.sortOrder = this.sortOrder;
            request.sortBy = this.sortBy;
            request.timeCreatedAfter = this.timeCreatedAfter;
            request.timeCreatedBefore = this.timeCreatedBefore;
            return request;
        }
    }

    public static enum SortBy implements BmcEnum
    {
        TimeCreated("timeCreated"),
        DisplayName("displayName"),
        Id("id");

        private final String value;
        private static Map<String, SortBy> map;

        private SortBy(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static SortBy create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid SortBy: " + key);
        }

        static {
            map = new HashMap<String, SortBy>();
            for (SortBy v : SortBy.values()) {
                map.put(v.getValue(), v);
            }
        }
    }
}

