/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.lockbox;

import com.oracle.bmc.ClientConfiguration;
import com.oracle.bmc.Region;
import com.oracle.bmc.Service;
import com.oracle.bmc.Services;
import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.auth.BasicAuthenticationDetailsProvider;
import com.oracle.bmc.common.ClientBuilderBase;
import com.oracle.bmc.common.RegionalClientBuilder;
import com.oracle.bmc.http.ClientConfigurator;
import com.oracle.bmc.http.client.Method;
import com.oracle.bmc.http.internal.BaseSyncClient;
import com.oracle.bmc.http.internal.BmcEnum;
import com.oracle.bmc.http.signing.RequestSignerFactory;
import com.oracle.bmc.http.signing.SigningStrategy;
import com.oracle.bmc.http.signing.internal.DefaultRequestSignerFactory;
import com.oracle.bmc.internal.Alloy;
import com.oracle.bmc.internal.ClientThreadFactory;
import com.oracle.bmc.lockbox.LockboxPaginators;
import com.oracle.bmc.lockbox.LockboxWaiters;
import com.oracle.bmc.lockbox.model.AccessMaterials;
import com.oracle.bmc.lockbox.model.AccessRequest;
import com.oracle.bmc.lockbox.model.AccessRequestCollection;
import com.oracle.bmc.lockbox.model.AccessRequestExt;
import com.oracle.bmc.lockbox.model.ApprovalTemplate;
import com.oracle.bmc.lockbox.model.ApprovalTemplateCollection;
import com.oracle.bmc.lockbox.model.Lockbox;
import com.oracle.bmc.lockbox.model.LockboxCollection;
import com.oracle.bmc.lockbox.model.WorkRequest;
import com.oracle.bmc.lockbox.model.WorkRequestErrorCollection;
import com.oracle.bmc.lockbox.model.WorkRequestLogEntryCollection;
import com.oracle.bmc.lockbox.model.WorkRequestSummaryCollection;
import com.oracle.bmc.lockbox.requests.CancelWorkRequestRequest;
import com.oracle.bmc.lockbox.requests.ChangeApprovalTemplateCompartmentRequest;
import com.oracle.bmc.lockbox.requests.ChangeLockboxCompartmentRequest;
import com.oracle.bmc.lockbox.requests.CreateAccessRequestRequest;
import com.oracle.bmc.lockbox.requests.CreateApprovalTemplateRequest;
import com.oracle.bmc.lockbox.requests.CreateLockboxRequest;
import com.oracle.bmc.lockbox.requests.DeleteApprovalTemplateRequest;
import com.oracle.bmc.lockbox.requests.DeleteLockboxRequest;
import com.oracle.bmc.lockbox.requests.ExportAccessRequestsRequest;
import com.oracle.bmc.lockbox.requests.GetAccessMaterialsRequest;
import com.oracle.bmc.lockbox.requests.GetAccessRequestInternalRequest;
import com.oracle.bmc.lockbox.requests.GetAccessRequestRequest;
import com.oracle.bmc.lockbox.requests.GetApprovalTemplateRequest;
import com.oracle.bmc.lockbox.requests.GetLockboxRequest;
import com.oracle.bmc.lockbox.requests.GetWorkRequestRequest;
import com.oracle.bmc.lockbox.requests.HandleAccessRequestRequest;
import com.oracle.bmc.lockbox.requests.ListAccessRequestsRequest;
import com.oracle.bmc.lockbox.requests.ListApprovalTemplatesRequest;
import com.oracle.bmc.lockbox.requests.ListLockboxesRequest;
import com.oracle.bmc.lockbox.requests.ListWorkRequestErrorsRequest;
import com.oracle.bmc.lockbox.requests.ListWorkRequestLogsRequest;
import com.oracle.bmc.lockbox.requests.ListWorkRequestsRequest;
import com.oracle.bmc.lockbox.requests.UpdateApprovalTemplateRequest;
import com.oracle.bmc.lockbox.requests.UpdateLockboxRequest;
import com.oracle.bmc.lockbox.responses.CancelWorkRequestResponse;
import com.oracle.bmc.lockbox.responses.ChangeApprovalTemplateCompartmentResponse;
import com.oracle.bmc.lockbox.responses.ChangeLockboxCompartmentResponse;
import com.oracle.bmc.lockbox.responses.CreateAccessRequestResponse;
import com.oracle.bmc.lockbox.responses.CreateApprovalTemplateResponse;
import com.oracle.bmc.lockbox.responses.CreateLockboxResponse;
import com.oracle.bmc.lockbox.responses.DeleteApprovalTemplateResponse;
import com.oracle.bmc.lockbox.responses.DeleteLockboxResponse;
import com.oracle.bmc.lockbox.responses.ExportAccessRequestsResponse;
import com.oracle.bmc.lockbox.responses.GetAccessMaterialsResponse;
import com.oracle.bmc.lockbox.responses.GetAccessRequestInternalResponse;
import com.oracle.bmc.lockbox.responses.GetAccessRequestResponse;
import com.oracle.bmc.lockbox.responses.GetApprovalTemplateResponse;
import com.oracle.bmc.lockbox.responses.GetLockboxResponse;
import com.oracle.bmc.lockbox.responses.GetWorkRequestResponse;
import com.oracle.bmc.lockbox.responses.HandleAccessRequestResponse;
import com.oracle.bmc.lockbox.responses.ListAccessRequestsResponse;
import com.oracle.bmc.lockbox.responses.ListApprovalTemplatesResponse;
import com.oracle.bmc.lockbox.responses.ListLockboxesResponse;
import com.oracle.bmc.lockbox.responses.ListWorkRequestErrorsResponse;
import com.oracle.bmc.lockbox.responses.ListWorkRequestLogsResponse;
import com.oracle.bmc.lockbox.responses.ListWorkRequestsResponse;
import com.oracle.bmc.lockbox.responses.UpdateApprovalTemplateResponse;
import com.oracle.bmc.lockbox.responses.UpdateLockboxResponse;
import com.oracle.bmc.util.CircuitBreakerUtils;
import com.oracle.bmc.util.StreamUtils;
import com.oracle.bmc.util.internal.Validate;
import jakarta.annotation.Nonnull;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LockboxClient
extends BaseSyncClient
implements com.oracle.bmc.lockbox.Lockbox {
    public static final Service SERVICE = Services.serviceBuilder().serviceName("LOCKBOX").serviceEndpointPrefix("").serviceEndpointTemplate("https://managed-access.{region}.oci.{secondLevelDomain}").build();
    private static final Logger LOG = LoggerFactory.getLogger(LockboxClient.class);
    private final LockboxWaiters waiters;
    private final LockboxPaginators paginators;

    LockboxClient(ClientBuilderBase<?, ?> builder, AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ExecutorService executorService) {
        this(builder, authenticationDetailsProvider, executorService, true);
    }

    LockboxClient(ClientBuilderBase<?, ?> builder, AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ExecutorService executorService, boolean isStreamWarningEnabled) {
        super(builder, authenticationDetailsProvider, CircuitBreakerUtils.DEFAULT_CIRCUIT_BREAKER_CONFIGURATION);
        if (executorService == null) {
            ThreadPoolExecutor threadPoolExecutor = new ThreadPoolExecutor(50, 50, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), (ThreadFactory)ClientThreadFactory.builder().isDaemon(true).nameFormat("Lockbox-waiters-%d").build());
            threadPoolExecutor.allowCoreThreadTimeOut(true);
            executorService = threadPoolExecutor;
        }
        this.waiters = new LockboxWaiters(executorService, this);
        this.paginators = new LockboxPaginators(this);
        if (isStreamWarningEnabled && StreamUtils.isExtraStreamLogsEnabled()) {
            LOG.warn(StreamUtils.getStreamWarningMessage((String)"LockboxClient", (String)"exportAccessRequests"));
        }
    }

    public static Builder builder() {
        return new Builder(SERVICE);
    }

    @Override
    public void setRegion(Region region) {
        super.setRegion(region);
    }

    @Override
    public void setRegion(String regionId) {
        super.setRegion(regionId);
    }

    @Override
    public CancelWorkRequestResponse cancelWorkRequest(CancelWorkRequestRequest request) {
        Validate.notBlank((String)request.getWorkRequestId(), (String)"workRequestId must not be blank", (Object[])new Object[0]);
        return (CancelWorkRequestResponse)this.clientCall(request, CancelWorkRequestResponse::builder).logger(LOG, "cancelWorkRequest").serviceDetails("Lockbox", "CancelWorkRequest", "https://docs.oracle.com/iaas/api/#/en/managed-access/20220126/WorkRequest/CancelWorkRequest").method(Method.DELETE).requestBuilder(CancelWorkRequestRequest::builder).basePath("/20220126").appendPathParam("workRequests").appendPathParam(request.getWorkRequestId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleResponseHeaderString("opc-request-id", CancelWorkRequestResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public ChangeApprovalTemplateCompartmentResponse changeApprovalTemplateCompartment(ChangeApprovalTemplateCompartmentRequest request) {
        Validate.notBlank((String)request.getApprovalTemplateId(), (String)"approvalTemplateId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getChangeApprovalTemplateCompartmentDetails(), "changeApprovalTemplateCompartmentDetails is required");
        return (ChangeApprovalTemplateCompartmentResponse)this.clientCall(request, ChangeApprovalTemplateCompartmentResponse::builder).logger(LOG, "changeApprovalTemplateCompartment").serviceDetails("Lockbox", "ChangeApprovalTemplateCompartment", "https://docs.oracle.com/iaas/api/#/en/managed-access/20220126/ApprovalTemplate/ChangeApprovalTemplateCompartment").method(Method.POST).requestBuilder(ChangeApprovalTemplateCompartmentRequest::builder).basePath("/20220126").appendPathParam("approvalTemplates").appendPathParam(request.getApprovalTemplateId()).appendPathParam("actions").appendPathParam("changeCompartment").accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).operationUsesDefaultRetries().hasBody().handleResponseHeaderString("opc-request-id", ChangeApprovalTemplateCompartmentResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public ChangeLockboxCompartmentResponse changeLockboxCompartment(ChangeLockboxCompartmentRequest request) {
        Validate.notBlank((String)request.getLockboxId(), (String)"lockboxId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getChangeLockboxCompartmentDetails(), "changeLockboxCompartmentDetails is required");
        return (ChangeLockboxCompartmentResponse)this.clientCall(request, ChangeLockboxCompartmentResponse::builder).logger(LOG, "changeLockboxCompartment").serviceDetails("Lockbox", "ChangeLockboxCompartment", "https://docs.oracle.com/iaas/api/#/en/managed-access/20220126/Lockbox/ChangeLockboxCompartment").method(Method.POST).requestBuilder(ChangeLockboxCompartmentRequest::builder).basePath("/20220126").appendPathParam("lockboxes").appendPathParam(request.getLockboxId()).appendPathParam("actions").appendPathParam("changeCompartment").accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).operationUsesDefaultRetries().hasBody().handleResponseHeaderString("opc-request-id", ChangeLockboxCompartmentResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public CreateAccessRequestResponse createAccessRequest(CreateAccessRequestRequest request) {
        Objects.requireNonNull(request.getCreateAccessRequestDetails(), "createAccessRequestDetails is required");
        return (CreateAccessRequestResponse)this.clientCall(request, CreateAccessRequestResponse::builder).logger(LOG, "createAccessRequest").serviceDetails("Lockbox", "CreateAccessRequest", "https://docs.oracle.com/iaas/api/#/en/managed-access/20220126/AccessRequest/CreateAccessRequest").method(Method.POST).requestBuilder(CreateAccessRequestRequest::builder).basePath("/20220126").appendPathParam("accessRequests").accept(new String[]{"application/json"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().hasBody().handleBody(AccessRequest.class, CreateAccessRequestResponse.Builder::accessRequest).handleResponseHeaderString("opc-work-request-id", CreateAccessRequestResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", CreateAccessRequestResponse.Builder::opcRequestId).handleResponseHeaderString("location", CreateAccessRequestResponse.Builder::location).handleResponseHeaderString("etag", CreateAccessRequestResponse.Builder::etag).callSync();
    }

    @Override
    public CreateApprovalTemplateResponse createApprovalTemplate(CreateApprovalTemplateRequest request) {
        Objects.requireNonNull(request.getCreateApprovalTemplateDetails(), "createApprovalTemplateDetails is required");
        return (CreateApprovalTemplateResponse)this.clientCall(request, CreateApprovalTemplateResponse::builder).logger(LOG, "createApprovalTemplate").serviceDetails("Lockbox", "CreateApprovalTemplate", "https://docs.oracle.com/iaas/api/#/en/managed-access/20220126/ApprovalTemplate/CreateApprovalTemplate").method(Method.POST).requestBuilder(CreateApprovalTemplateRequest::builder).basePath("/20220126").appendPathParam("approvalTemplates").accept(new String[]{"application/json"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().hasBody().handleBody(ApprovalTemplate.class, CreateApprovalTemplateResponse.Builder::approvalTemplate).handleResponseHeaderString("opc-request-id", CreateApprovalTemplateResponse.Builder::opcRequestId).handleResponseHeaderString("location", CreateApprovalTemplateResponse.Builder::location).handleResponseHeaderString("etag", CreateApprovalTemplateResponse.Builder::etag).callSync();
    }

    @Override
    public CreateLockboxResponse createLockbox(CreateLockboxRequest request) {
        Objects.requireNonNull(request.getCreateLockboxDetails(), "createLockboxDetails is required");
        return (CreateLockboxResponse)this.clientCall(request, CreateLockboxResponse::builder).logger(LOG, "createLockbox").serviceDetails("Lockbox", "CreateLockbox", "https://docs.oracle.com/iaas/api/#/en/managed-access/20220126/Lockbox/CreateLockbox").method(Method.POST).requestBuilder(CreateLockboxRequest::builder).basePath("/20220126").appendPathParam("lockboxes").accept(new String[]{"application/json"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().hasBody().handleBody(Lockbox.class, CreateLockboxResponse.Builder::lockbox).handleResponseHeaderString("opc-request-id", CreateLockboxResponse.Builder::opcRequestId).handleResponseHeaderString("location", CreateLockboxResponse.Builder::location).handleResponseHeaderString("etag", CreateLockboxResponse.Builder::etag).callSync();
    }

    @Override
    public DeleteApprovalTemplateResponse deleteApprovalTemplate(DeleteApprovalTemplateRequest request) {
        Validate.notBlank((String)request.getApprovalTemplateId(), (String)"approvalTemplateId must not be blank", (Object[])new Object[0]);
        return (DeleteApprovalTemplateResponse)this.clientCall(request, DeleteApprovalTemplateResponse::builder).logger(LOG, "deleteApprovalTemplate").serviceDetails("Lockbox", "DeleteApprovalTemplate", "https://docs.oracle.com/iaas/api/#/en/managed-access/20220126/ApprovalTemplate/DeleteApprovalTemplate").method(Method.DELETE).requestBuilder(DeleteApprovalTemplateRequest::builder).basePath("/20220126").appendPathParam("approvalTemplates").appendPathParam(request.getApprovalTemplateId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleResponseHeaderString("opc-request-id", DeleteApprovalTemplateResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public DeleteLockboxResponse deleteLockbox(DeleteLockboxRequest request) {
        Validate.notBlank((String)request.getLockboxId(), (String)"lockboxId must not be blank", (Object[])new Object[0]);
        return (DeleteLockboxResponse)this.clientCall(request, DeleteLockboxResponse::builder).logger(LOG, "deleteLockbox").serviceDetails("Lockbox", "DeleteLockbox", "https://docs.oracle.com/iaas/api/#/en/managed-access/20220126/Lockbox/DeleteLockbox").method(Method.DELETE).requestBuilder(DeleteLockboxRequest::builder).basePath("/20220126").appendPathParam("lockboxes").appendPathParam(request.getLockboxId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).operationUsesDefaultRetries().handleResponseHeaderString("opc-request-id", DeleteLockboxResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public ExportAccessRequestsResponse exportAccessRequests(ExportAccessRequestsRequest request) {
        Objects.requireNonNull(request.getExportAccessRequestsDetails(), "exportAccessRequestsDetails is required");
        return (ExportAccessRequestsResponse)this.clientCall(request, ExportAccessRequestsResponse::builder).logger(LOG, "exportAccessRequests").serviceDetails("Lockbox", "ExportAccessRequests", "https://docs.oracle.com/iaas/api/#/en/managed-access/20220126/AccessRequestCollection/ExportAccessRequests").method(Method.POST).requestBuilder(ExportAccessRequestsRequest::builder).basePath("/20220126").appendPathParam("accessRequests").appendPathParam("actions").appendPathParam("export").appendQueryParam("id", (Object)request.getId()).appendQueryParam("displayName", (Object)request.getDisplayName()).appendEnumQueryParam("lifecycleState", (BmcEnum)request.getLifecycleState()).appendEnumQueryParam("lockboxPartner", (BmcEnum)request.getLockboxPartner()).appendQueryParam("partnerId", (Object)request.getPartnerId()).appendQueryParam("requestorId", (Object)request.getRequestorId()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).accept(new String[]{"text/csv"}).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().hasBody().handleBody(InputStream.class, ExportAccessRequestsResponse.Builder::inputStream).handleResponseHeaderString("opc-request-id", ExportAccessRequestsResponse.Builder::opcRequestId).handleResponseHeaderString("etag", ExportAccessRequestsResponse.Builder::etag).callSync();
    }

    @Override
    public GetAccessMaterialsResponse getAccessMaterials(GetAccessMaterialsRequest request) {
        Validate.notBlank((String)request.getAccessRequestId(), (String)"accessRequestId must not be blank", (Object[])new Object[0]);
        return (GetAccessMaterialsResponse)this.clientCall(request, GetAccessMaterialsResponse::builder).logger(LOG, "getAccessMaterials").serviceDetails("Lockbox", "GetAccessMaterials", "https://docs.oracle.com/iaas/api/#/en/managed-access/20220126/AccessMaterials/GetAccessMaterials").method(Method.GET).requestBuilder(GetAccessMaterialsRequest::builder).basePath("/20220126").appendPathParam("accessRequests").appendPathParam(request.getAccessRequestId()).appendPathParam("accessMaterials").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleBody(AccessMaterials.class, GetAccessMaterialsResponse.Builder::accessMaterials).handleResponseHeaderString("opc-request-id", GetAccessMaterialsResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public GetAccessRequestResponse getAccessRequest(GetAccessRequestRequest request) {
        Validate.notBlank((String)request.getAccessRequestId(), (String)"accessRequestId must not be blank", (Object[])new Object[0]);
        return (GetAccessRequestResponse)this.clientCall(request, GetAccessRequestResponse::builder).logger(LOG, "getAccessRequest").serviceDetails("Lockbox", "GetAccessRequest", "https://docs.oracle.com/iaas/api/#/en/managed-access/20220126/AccessRequest/GetAccessRequest").method(Method.GET).requestBuilder(GetAccessRequestRequest::builder).basePath("/20220126").appendPathParam("accessRequests").appendPathParam(request.getAccessRequestId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleBody(AccessRequest.class, GetAccessRequestResponse.Builder::accessRequest).handleResponseHeaderString("etag", GetAccessRequestResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetAccessRequestResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public GetAccessRequestInternalResponse getAccessRequestInternal(GetAccessRequestInternalRequest request) {
        Validate.notBlank((String)request.getAccessRequestId(), (String)"accessRequestId must not be blank", (Object[])new Object[0]);
        return (GetAccessRequestInternalResponse)this.clientCall(request, GetAccessRequestInternalResponse::builder).logger(LOG, "getAccessRequestInternal").serviceDetails("Lockbox", "GetAccessRequestInternal", "https://docs.oracle.com/iaas/api/#/en/managed-access/20220126/AccessRequestExt/GetAccessRequestInternal").method(Method.GET).requestBuilder(GetAccessRequestInternalRequest::builder).basePath("/20220126").appendPathParam("accessRequests").appendPathParam(request.getAccessRequestId()).appendPathParam("internal").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleBody(AccessRequestExt.class, GetAccessRequestInternalResponse.Builder::accessRequestExt).handleResponseHeaderString("etag", GetAccessRequestInternalResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetAccessRequestInternalResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public GetApprovalTemplateResponse getApprovalTemplate(GetApprovalTemplateRequest request) {
        Validate.notBlank((String)request.getApprovalTemplateId(), (String)"approvalTemplateId must not be blank", (Object[])new Object[0]);
        return (GetApprovalTemplateResponse)this.clientCall(request, GetApprovalTemplateResponse::builder).logger(LOG, "getApprovalTemplate").serviceDetails("Lockbox", "GetApprovalTemplate", "https://docs.oracle.com/iaas/api/#/en/managed-access/20220126/ApprovalTemplate/GetApprovalTemplate").method(Method.GET).requestBuilder(GetApprovalTemplateRequest::builder).basePath("/20220126").appendPathParam("approvalTemplates").appendPathParam(request.getApprovalTemplateId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleBody(ApprovalTemplate.class, GetApprovalTemplateResponse.Builder::approvalTemplate).handleResponseHeaderString("etag", GetApprovalTemplateResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetApprovalTemplateResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public GetLockboxResponse getLockbox(GetLockboxRequest request) {
        Validate.notBlank((String)request.getLockboxId(), (String)"lockboxId must not be blank", (Object[])new Object[0]);
        return (GetLockboxResponse)this.clientCall(request, GetLockboxResponse::builder).logger(LOG, "getLockbox").serviceDetails("Lockbox", "GetLockbox", "https://docs.oracle.com/iaas/api/#/en/managed-access/20220126/Lockbox/GetLockbox").method(Method.GET).requestBuilder(GetLockboxRequest::builder).basePath("/20220126").appendPathParam("lockboxes").appendPathParam(request.getLockboxId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleBody(Lockbox.class, GetLockboxResponse.Builder::lockbox).handleResponseHeaderString("etag", GetLockboxResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetLockboxResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public GetWorkRequestResponse getWorkRequest(GetWorkRequestRequest request) {
        Validate.notBlank((String)request.getWorkRequestId(), (String)"workRequestId must not be blank", (Object[])new Object[0]);
        return (GetWorkRequestResponse)this.clientCall(request, GetWorkRequestResponse::builder).logger(LOG, "getWorkRequest").serviceDetails("Lockbox", "GetWorkRequest", "https://docs.oracle.com/iaas/api/#/en/managed-access/20220126/WorkRequest/GetWorkRequest").method(Method.GET).requestBuilder(GetWorkRequestRequest::builder).basePath("/20220126").appendPathParam("workRequests").appendPathParam(request.getWorkRequestId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleBody(WorkRequest.class, GetWorkRequestResponse.Builder::workRequest).handleResponseHeaderString("etag", GetWorkRequestResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetWorkRequestResponse.Builder::opcRequestId).handleResponseHeaderInteger("retry-after", GetWorkRequestResponse.Builder::retryAfter).callSync();
    }

    @Override
    public HandleAccessRequestResponse handleAccessRequest(HandleAccessRequestRequest request) {
        Validate.notBlank((String)request.getAccessRequestId(), (String)"accessRequestId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getHandleAccessRequestDetails(), "handleAccessRequestDetails is required");
        return (HandleAccessRequestResponse)this.clientCall(request, HandleAccessRequestResponse::builder).logger(LOG, "handleAccessRequest").serviceDetails("Lockbox", "HandleAccessRequest", "https://docs.oracle.com/iaas/api/#/en/managed-access/20220126/AccessRequest/HandleAccessRequest").method(Method.POST).requestBuilder(HandleAccessRequestRequest::builder).basePath("/20220126").appendPathParam("accessRequests").appendPathParam(request.getAccessRequestId()).appendPathParam("actions").appendPathParam("handle").accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().hasBody().handleResponseHeaderString("opc-work-request-id", HandleAccessRequestResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", HandleAccessRequestResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public ListAccessRequestsResponse listAccessRequests(ListAccessRequestsRequest request) {
        return (ListAccessRequestsResponse)this.clientCall(request, ListAccessRequestsResponse::builder).logger(LOG, "listAccessRequests").serviceDetails("Lockbox", "ListAccessRequests", "https://docs.oracle.com/iaas/api/#/en/managed-access/20220126/AccessRequestCollection/ListAccessRequests").method(Method.GET).requestBuilder(ListAccessRequestsRequest::builder).basePath("/20220126").appendPathParam("accessRequests").appendQueryParam("lockboxId", (Object)request.getLockboxId()).appendQueryParam("id", (Object)request.getId()).appendQueryParam("displayName", (Object)request.getDisplayName()).appendEnumQueryParam("lifecycleState", (BmcEnum)request.getLifecycleState()).appendEnumQueryParam("lockboxPartner", (BmcEnum)request.getLockboxPartner()).appendQueryParam("partnerId", (Object)request.getPartnerId()).appendQueryParam("requestorId", (Object)request.getRequestorId()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendQueryParam("timeCreatedAfter", (Object)request.getTimeCreatedAfter()).appendQueryParam("timeCreatedBefore", (Object)request.getTimeCreatedBefore()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleBody(AccessRequestCollection.class, ListAccessRequestsResponse.Builder::accessRequestCollection).handleResponseHeaderString("opc-request-id", ListAccessRequestsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListAccessRequestsResponse.Builder::opcNextPage).callSync();
    }

    @Override
    public ListApprovalTemplatesResponse listApprovalTemplates(ListApprovalTemplatesRequest request) {
        return (ListApprovalTemplatesResponse)this.clientCall(request, ListApprovalTemplatesResponse::builder).logger(LOG, "listApprovalTemplates").serviceDetails("Lockbox", "ListApprovalTemplates", "https://docs.oracle.com/iaas/api/#/en/managed-access/20220126/ApprovalTemplateCollection/ListApprovalTemplates").method(Method.GET).requestBuilder(ListApprovalTemplatesRequest::builder).basePath("/20220126").appendPathParam("approvalTemplates").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("id", (Object)request.getId()).appendQueryParam("displayName", (Object)request.getDisplayName()).appendEnumQueryParam("lifecycleState", (BmcEnum)request.getLifecycleState()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleBody(ApprovalTemplateCollection.class, ListApprovalTemplatesResponse.Builder::approvalTemplateCollection).handleResponseHeaderString("opc-request-id", ListApprovalTemplatesResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListApprovalTemplatesResponse.Builder::opcNextPage).callSync();
    }

    @Override
    public ListLockboxesResponse listLockboxes(ListLockboxesRequest request) {
        return (ListLockboxesResponse)this.clientCall(request, ListLockboxesResponse::builder).logger(LOG, "listLockboxes").serviceDetails("Lockbox", "ListLockboxes", "https://docs.oracle.com/iaas/api/#/en/managed-access/20220126/LockboxCollection/ListLockboxes").method(Method.GET).requestBuilder(ListLockboxesRequest::builder).basePath("/20220126").appendPathParam("lockboxes").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendEnumQueryParam("lifecycleState", (BmcEnum)request.getLifecycleState()).appendQueryParam("displayName", (Object)request.getDisplayName()).appendQueryParam("id", (Object)request.getId()).appendQueryParam("resourceId", (Object)request.getResourceId()).appendEnumQueryParam("lockboxPartner", (BmcEnum)request.getLockboxPartner()).appendQueryParam("partnerId", (Object)request.getPartnerId()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleBody(LockboxCollection.class, ListLockboxesResponse.Builder::lockboxCollection).handleResponseHeaderString("opc-request-id", ListLockboxesResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListLockboxesResponse.Builder::opcNextPage).callSync();
    }

    @Override
    public ListWorkRequestErrorsResponse listWorkRequestErrors(ListWorkRequestErrorsRequest request) {
        Validate.notBlank((String)request.getWorkRequestId(), (String)"workRequestId must not be blank", (Object[])new Object[0]);
        return (ListWorkRequestErrorsResponse)this.clientCall(request, ListWorkRequestErrorsResponse::builder).logger(LOG, "listWorkRequestErrors").serviceDetails("Lockbox", "ListWorkRequestErrors", "https://docs.oracle.com/iaas/api/#/en/managed-access/20220126/WorkRequestError/ListWorkRequestErrors").method(Method.GET).requestBuilder(ListWorkRequestErrorsRequest::builder).basePath("/20220126").appendPathParam("workRequests").appendPathParam(request.getWorkRequestId()).appendPathParam("errors").appendQueryParam("page", (Object)request.getPage()).appendQueryParam("limit", (Object)request.getLimit()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleBody(WorkRequestErrorCollection.class, ListWorkRequestErrorsResponse.Builder::workRequestErrorCollection).handleResponseHeaderString("opc-next-page", ListWorkRequestErrorsResponse.Builder::opcNextPage).handleResponseHeaderString("opc-request-id", ListWorkRequestErrorsResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public ListWorkRequestLogsResponse listWorkRequestLogs(ListWorkRequestLogsRequest request) {
        Validate.notBlank((String)request.getWorkRequestId(), (String)"workRequestId must not be blank", (Object[])new Object[0]);
        return (ListWorkRequestLogsResponse)this.clientCall(request, ListWorkRequestLogsResponse::builder).logger(LOG, "listWorkRequestLogs").serviceDetails("Lockbox", "ListWorkRequestLogs", "https://docs.oracle.com/iaas/api/#/en/managed-access/20220126/WorkRequestLogEntry/ListWorkRequestLogs").method(Method.GET).requestBuilder(ListWorkRequestLogsRequest::builder).basePath("/20220126").appendPathParam("workRequests").appendPathParam(request.getWorkRequestId()).appendPathParam("logs").appendQueryParam("page", (Object)request.getPage()).appendQueryParam("limit", (Object)request.getLimit()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleBody(WorkRequestLogEntryCollection.class, ListWorkRequestLogsResponse.Builder::workRequestLogEntryCollection).handleResponseHeaderString("opc-next-page", ListWorkRequestLogsResponse.Builder::opcNextPage).handleResponseHeaderString("opc-request-id", ListWorkRequestLogsResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public ListWorkRequestsResponse listWorkRequests(ListWorkRequestsRequest request) {
        return (ListWorkRequestsResponse)this.clientCall(request, ListWorkRequestsResponse::builder).logger(LOG, "listWorkRequests").serviceDetails("Lockbox", "ListWorkRequests", "https://docs.oracle.com/iaas/api/#/en/managed-access/20220126/WorkRequest/ListWorkRequests").method(Method.GET).requestBuilder(ListWorkRequestsRequest::builder).basePath("/20220126").appendPathParam("workRequests").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("workRequestId", (Object)request.getWorkRequestId()).appendEnumQueryParam("status", (BmcEnum)request.getStatus()).appendQueryParam("resourceId", (Object)request.getResourceId()).appendQueryParam("page", (Object)request.getPage()).appendQueryParam("limit", (Object)request.getLimit()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleBody(WorkRequestSummaryCollection.class, ListWorkRequestsResponse.Builder::workRequestSummaryCollection).handleResponseHeaderString("opc-request-id", ListWorkRequestsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListWorkRequestsResponse.Builder::opcNextPage).callSync();
    }

    @Override
    public UpdateApprovalTemplateResponse updateApprovalTemplate(UpdateApprovalTemplateRequest request) {
        Validate.notBlank((String)request.getApprovalTemplateId(), (String)"approvalTemplateId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdateApprovalTemplateDetails(), "updateApprovalTemplateDetails is required");
        return (UpdateApprovalTemplateResponse)this.clientCall(request, UpdateApprovalTemplateResponse::builder).logger(LOG, "updateApprovalTemplate").serviceDetails("Lockbox", "UpdateApprovalTemplate", "https://docs.oracle.com/iaas/api/#/en/managed-access/20220126/ApprovalTemplate/UpdateApprovalTemplate").method(Method.PUT).requestBuilder(UpdateApprovalTemplateRequest::builder).basePath("/20220126").appendPathParam("approvalTemplates").appendPathParam(request.getApprovalTemplateId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().hasBody().handleBody(ApprovalTemplate.class, UpdateApprovalTemplateResponse.Builder::approvalTemplate).handleResponseHeaderString("opc-request-id", UpdateApprovalTemplateResponse.Builder::opcRequestId).handleResponseHeaderString("etag", UpdateApprovalTemplateResponse.Builder::etag).callSync();
    }

    @Override
    public UpdateLockboxResponse updateLockbox(UpdateLockboxRequest request) {
        Validate.notBlank((String)request.getLockboxId(), (String)"lockboxId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdateLockboxDetails(), "updateLockboxDetails is required");
        return (UpdateLockboxResponse)this.clientCall(request, UpdateLockboxResponse::builder).logger(LOG, "updateLockbox").serviceDetails("Lockbox", "UpdateLockbox", "https://docs.oracle.com/iaas/api/#/en/managed-access/20220126/Lockbox/UpdateLockbox").method(Method.PUT).requestBuilder(UpdateLockboxRequest::builder).basePath("/20220126").appendPathParam("lockboxes").appendPathParam(request.getLockboxId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().hasBody().handleBody(Lockbox.class, UpdateLockboxResponse.Builder::lockbox).handleResponseHeaderString("opc-request-id", UpdateLockboxResponse.Builder::opcRequestId).handleResponseHeaderString("etag", UpdateLockboxResponse.Builder::etag).callSync();
    }

    @Override
    public LockboxWaiters getWaiters() {
        return this.waiters;
    }

    @Override
    public LockboxPaginators getPaginators() {
        return this.paginators;
    }

    @Deprecated
    public LockboxClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider) {
        this((ClientBuilderBase<?, ?>)LockboxClient.builder(), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider, null);
    }

    @Deprecated
    public LockboxClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration) {
        this(LockboxClient.builder().configuration(configuration), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider, null);
    }

    @Deprecated
    public LockboxClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator) {
        this(((Builder)LockboxClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider, null);
    }

    @Deprecated
    public LockboxClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory) {
        this(((Builder)((Builder)LockboxClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory), authenticationDetailsProvider, null);
    }

    @Deprecated
    public LockboxClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators) {
        this(((Builder)((Builder)((Builder)LockboxClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators), authenticationDetailsProvider, null);
    }

    @Deprecated
    public LockboxClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(((Builder)((Builder)((Builder)((Builder)LockboxClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint), authenticationDetailsProvider, null);
    }

    @Deprecated
    public LockboxClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(((Builder)((Builder)((Builder)((Builder)((Builder)LockboxClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint)).signingStrategyRequestSignerFactories(signingStrategyRequestSignerFactories), authenticationDetailsProvider, null);
    }

    @Deprecated
    public LockboxClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint, ExecutorService executorService) {
        this(((Builder)((Builder)((Builder)((Builder)((Builder)LockboxClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint)).signingStrategyRequestSignerFactories(signingStrategyRequestSignerFactories), authenticationDetailsProvider, executorService);
    }

    public static class Builder
    extends RegionalClientBuilder<Builder, LockboxClient> {
        private boolean isStreamWarningEnabled = true;
        private ExecutorService executorService;

        private Builder(Service service) {
            super(service);
            String packageName = "lockbox";
            Alloy.throwDisabledServiceExceptionIfAppropriate((String)"lockbox");
            this.requestSignerFactory = new DefaultRequestSignerFactory(SigningStrategy.STANDARD);
        }

        public Builder executorService(ExecutorService executorService) {
            this.executorService = executorService;
            return this;
        }

        public Builder isStreamWarningEnabled(boolean isStreamWarningEnabled) {
            this.isStreamWarningEnabled = isStreamWarningEnabled;
            return this;
        }

        public LockboxClient build(@Nonnull AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
            return new LockboxClient((ClientBuilderBase<?, ?>)this, authenticationDetailsProvider, this.executorService, this.isStreamWarningEnabled);
        }
    }
}

