/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.lockbox.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import java.beans.ConstructorProperties;
import java.util.Date;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class ExportAccessRequestsDetails
extends ExplicitlySetBmcModel {
    @JsonProperty(value="lockboxId")
    private final String lockboxId;
    @JsonProperty(value="timeCreatedAfter")
    private final Date timeCreatedAfter;
    @JsonProperty(value="timeCreatedBefore")
    private final Date timeCreatedBefore;

    @Deprecated
    @ConstructorProperties(value={"lockboxId", "timeCreatedAfter", "timeCreatedBefore"})
    public ExportAccessRequestsDetails(String lockboxId, Date timeCreatedAfter, Date timeCreatedBefore) {
        this.lockboxId = lockboxId;
        this.timeCreatedAfter = timeCreatedAfter;
        this.timeCreatedBefore = timeCreatedBefore;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getLockboxId() {
        return this.lockboxId;
    }

    public Date getTimeCreatedAfter() {
        return this.timeCreatedAfter;
    }

    public Date getTimeCreatedBefore() {
        return this.timeCreatedBefore;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("ExportAccessRequestsDetails(");
        sb.append("super=").append(super.toString());
        sb.append("lockboxId=").append(String.valueOf(this.lockboxId));
        sb.append(", timeCreatedAfter=").append(String.valueOf(this.timeCreatedAfter));
        sb.append(", timeCreatedBefore=").append(String.valueOf(this.timeCreatedBefore));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ExportAccessRequestsDetails)) {
            return false;
        }
        ExportAccessRequestsDetails other = (ExportAccessRequestsDetails)((Object)o);
        return Objects.equals(this.lockboxId, other.lockboxId) && Objects.equals(this.timeCreatedAfter, other.timeCreatedAfter) && Objects.equals(this.timeCreatedBefore, other.timeCreatedBefore) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.lockboxId == null ? 43 : this.lockboxId.hashCode());
        result = result * 59 + (this.timeCreatedAfter == null ? 43 : this.timeCreatedAfter.hashCode());
        result = result * 59 + (this.timeCreatedBefore == null ? 43 : this.timeCreatedBefore.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="lockboxId")
        private String lockboxId;
        @JsonProperty(value="timeCreatedAfter")
        private Date timeCreatedAfter;
        @JsonProperty(value="timeCreatedBefore")
        private Date timeCreatedBefore;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder lockboxId(String lockboxId) {
            this.lockboxId = lockboxId;
            this.__explicitlySet__.add("lockboxId");
            return this;
        }

        public Builder timeCreatedAfter(Date timeCreatedAfter) {
            this.timeCreatedAfter = timeCreatedAfter;
            this.__explicitlySet__.add("timeCreatedAfter");
            return this;
        }

        public Builder timeCreatedBefore(Date timeCreatedBefore) {
            this.timeCreatedBefore = timeCreatedBefore;
            this.__explicitlySet__.add("timeCreatedBefore");
            return this;
        }

        public ExportAccessRequestsDetails build() {
            ExportAccessRequestsDetails model = new ExportAccessRequestsDetails(this.lockboxId, this.timeCreatedAfter, this.timeCreatedBefore);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(ExportAccessRequestsDetails model) {
            if (model.wasPropertyExplicitlySet("lockboxId")) {
                this.lockboxId(model.getLockboxId());
            }
            if (model.wasPropertyExplicitlySet("timeCreatedAfter")) {
                this.timeCreatedAfter(model.getTimeCreatedAfter());
            }
            if (model.wasPropertyExplicitlySet("timeCreatedBefore")) {
                this.timeCreatedBefore(model.getTimeCreatedBefore());
            }
            return this;
        }
    }
}

