/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.loganalytics;

import com.oracle.bmc.ClientConfiguration;
import com.oracle.bmc.Region;
import com.oracle.bmc.Service;
import com.oracle.bmc.Services;
import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.auth.BasicAuthenticationDetailsProvider;
import com.oracle.bmc.common.ClientBuilderBase;
import com.oracle.bmc.common.RegionalClientBuilder;
import com.oracle.bmc.http.ClientConfigurator;
import com.oracle.bmc.http.client.Method;
import com.oracle.bmc.http.internal.BaseSyncClient;
import com.oracle.bmc.http.internal.BmcEnum;
import com.oracle.bmc.http.signing.RequestSignerFactory;
import com.oracle.bmc.http.signing.SigningStrategy;
import com.oracle.bmc.http.signing.internal.DefaultRequestSignerFactory;
import com.oracle.bmc.internal.ClientThreadFactory;
import com.oracle.bmc.loganalytics.LogAnalytics;
import com.oracle.bmc.loganalytics.LogAnalyticsPaginators;
import com.oracle.bmc.loganalytics.LogAnalyticsWaiters;
import com.oracle.bmc.loganalytics.model.AssociableEntityCollection;
import com.oracle.bmc.loganalytics.model.AssociationSummaryReport;
import com.oracle.bmc.loganalytics.model.AutoAssociationCollection;
import com.oracle.bmc.loganalytics.model.CharEncodingCollection;
import com.oracle.bmc.loganalytics.model.ColumnNameCollection;
import com.oracle.bmc.loganalytics.model.CompareContentResult;
import com.oracle.bmc.loganalytics.model.EncryptionKeyInfoCollection;
import com.oracle.bmc.loganalytics.model.EstimatePurgeDataSizeResult;
import com.oracle.bmc.loganalytics.model.EstimateRecallDataSizeResult;
import com.oracle.bmc.loganalytics.model.EstimateReleaseDataSizeResult;
import com.oracle.bmc.loganalytics.model.EventTypeCollection;
import com.oracle.bmc.loganalytics.model.ExtendedFieldsValidationResult;
import com.oracle.bmc.loganalytics.model.ExtractLogFieldResults;
import com.oracle.bmc.loganalytics.model.ExtractLogHeaderResults;
import com.oracle.bmc.loganalytics.model.FieldSummaryReport;
import com.oracle.bmc.loganalytics.model.FileValidationResponse;
import com.oracle.bmc.loganalytics.model.FilterOutput;
import com.oracle.bmc.loganalytics.model.IngestTimeRule;
import com.oracle.bmc.loganalytics.model.IngestTimeRuleSummaryCollection;
import com.oracle.bmc.loganalytics.model.LabelPriorityCollection;
import com.oracle.bmc.loganalytics.model.LabelSourceCollection;
import com.oracle.bmc.loganalytics.model.LabelSummaryReport;
import com.oracle.bmc.loganalytics.model.LogAnalyticsAssociatedEntityCollection;
import com.oracle.bmc.loganalytics.model.LogAnalyticsAssociationCollection;
import com.oracle.bmc.loganalytics.model.LogAnalyticsAssociationParameterCollection;
import com.oracle.bmc.loganalytics.model.LogAnalyticsCategory;
import com.oracle.bmc.loganalytics.model.LogAnalyticsCategoryCollection;
import com.oracle.bmc.loganalytics.model.LogAnalyticsConfigWorkRequest;
import com.oracle.bmc.loganalytics.model.LogAnalyticsConfigWorkRequestCollection;
import com.oracle.bmc.loganalytics.model.LogAnalyticsEmBridge;
import com.oracle.bmc.loganalytics.model.LogAnalyticsEmBridgeCollection;
import com.oracle.bmc.loganalytics.model.LogAnalyticsEmBridgeSummaryReport;
import com.oracle.bmc.loganalytics.model.LogAnalyticsEntity;
import com.oracle.bmc.loganalytics.model.LogAnalyticsEntityCollection;
import com.oracle.bmc.loganalytics.model.LogAnalyticsEntitySummaryReport;
import com.oracle.bmc.loganalytics.model.LogAnalyticsEntityTopologyCollection;
import com.oracle.bmc.loganalytics.model.LogAnalyticsEntityType;
import com.oracle.bmc.loganalytics.model.LogAnalyticsEntityTypeCollection;
import com.oracle.bmc.loganalytics.model.LogAnalyticsField;
import com.oracle.bmc.loganalytics.model.LogAnalyticsFieldCollection;
import com.oracle.bmc.loganalytics.model.LogAnalyticsImportCustomContent;
import com.oracle.bmc.loganalytics.model.LogAnalyticsLabel;
import com.oracle.bmc.loganalytics.model.LogAnalyticsLabelCollection;
import com.oracle.bmc.loganalytics.model.LogAnalyticsLabelOperatorCollection;
import com.oracle.bmc.loganalytics.model.LogAnalyticsLogGroup;
import com.oracle.bmc.loganalytics.model.LogAnalyticsLogGroupSummaryCollection;
import com.oracle.bmc.loganalytics.model.LogAnalyticsLookup;
import com.oracle.bmc.loganalytics.model.LogAnalyticsLookupCollection;
import com.oracle.bmc.loganalytics.model.LogAnalyticsMetaFunctionCollection;
import com.oracle.bmc.loganalytics.model.LogAnalyticsMetaSourceTypeCollection;
import com.oracle.bmc.loganalytics.model.LogAnalyticsObjectCollectionRule;
import com.oracle.bmc.loganalytics.model.LogAnalyticsObjectCollectionRuleCollection;
import com.oracle.bmc.loganalytics.model.LogAnalyticsParser;
import com.oracle.bmc.loganalytics.model.LogAnalyticsParserCollection;
import com.oracle.bmc.loganalytics.model.LogAnalyticsParserFunctionCollection;
import com.oracle.bmc.loganalytics.model.LogAnalyticsParserMetaPluginCollection;
import com.oracle.bmc.loganalytics.model.LogAnalyticsPreferenceCollection;
import com.oracle.bmc.loganalytics.model.LogAnalyticsResourceCategoryCollection;
import com.oracle.bmc.loganalytics.model.LogAnalyticsSource;
import com.oracle.bmc.loganalytics.model.LogAnalyticsSourceCollection;
import com.oracle.bmc.loganalytics.model.LogAnalyticsSourceExtendedFieldDefinitionCollection;
import com.oracle.bmc.loganalytics.model.LogAnalyticsSourcePatternCollection;
import com.oracle.bmc.loganalytics.model.LogAnalyticsWarningCollection;
import com.oracle.bmc.loganalytics.model.LogGroupSummaryReport;
import com.oracle.bmc.loganalytics.model.LogSetCollection;
import com.oracle.bmc.loganalytics.model.LogSetsCount;
import com.oracle.bmc.loganalytics.model.LookupSummaryReport;
import com.oracle.bmc.loganalytics.model.Namespace;
import com.oracle.bmc.loganalytics.model.NamespaceCollection;
import com.oracle.bmc.loganalytics.model.ParseQueryOutput;
import com.oracle.bmc.loganalytics.model.ParserSummaryReport;
import com.oracle.bmc.loganalytics.model.ParserTestResult;
import com.oracle.bmc.loganalytics.model.QueryAggregation;
import com.oracle.bmc.loganalytics.model.QueryWorkRequest;
import com.oracle.bmc.loganalytics.model.QueryWorkRequestCollection;
import com.oracle.bmc.loganalytics.model.RecalledDataCollection;
import com.oracle.bmc.loganalytics.model.RuleSummaryCollection;
import com.oracle.bmc.loganalytics.model.ScheduledTask;
import com.oracle.bmc.loganalytics.model.ScheduledTaskCollection;
import com.oracle.bmc.loganalytics.model.SourceMappingResponse;
import com.oracle.bmc.loganalytics.model.SourceSummaryReport;
import com.oracle.bmc.loganalytics.model.SourceValidateResults;
import com.oracle.bmc.loganalytics.model.Storage;
import com.oracle.bmc.loganalytics.model.StorageUsage;
import com.oracle.bmc.loganalytics.model.StorageWorkRequest;
import com.oracle.bmc.loganalytics.model.StorageWorkRequestCollection;
import com.oracle.bmc.loganalytics.model.Success;
import com.oracle.bmc.loganalytics.model.SuggestOutput;
import com.oracle.bmc.loganalytics.model.TimezoneCollection;
import com.oracle.bmc.loganalytics.model.UnprocessedDataBucket;
import com.oracle.bmc.loganalytics.model.Upload;
import com.oracle.bmc.loganalytics.model.UploadCollection;
import com.oracle.bmc.loganalytics.model.UploadFileCollection;
import com.oracle.bmc.loganalytics.model.UploadWarningCollection;
import com.oracle.bmc.loganalytics.model.VerifyOutput;
import com.oracle.bmc.loganalytics.model.WorkRequest;
import com.oracle.bmc.loganalytics.model.WorkRequestCollection;
import com.oracle.bmc.loganalytics.model.WorkRequestErrorCollection;
import com.oracle.bmc.loganalytics.model.WorkRequestLogCollection;
import com.oracle.bmc.loganalytics.requests.AddEntityAssociationRequest;
import com.oracle.bmc.loganalytics.requests.AddSourceEventTypesRequest;
import com.oracle.bmc.loganalytics.requests.AppendLookupDataRequest;
import com.oracle.bmc.loganalytics.requests.AssignEncryptionKeyRequest;
import com.oracle.bmc.loganalytics.requests.BatchGetBasicInfoRequest;
import com.oracle.bmc.loganalytics.requests.CancelQueryWorkRequestRequest;
import com.oracle.bmc.loganalytics.requests.ChangeIngestTimeRuleCompartmentRequest;
import com.oracle.bmc.loganalytics.requests.ChangeLogAnalyticsEmBridgeCompartmentRequest;
import com.oracle.bmc.loganalytics.requests.ChangeLogAnalyticsEntityCompartmentRequest;
import com.oracle.bmc.loganalytics.requests.ChangeLogAnalyticsLogGroupCompartmentRequest;
import com.oracle.bmc.loganalytics.requests.ChangeLogAnalyticsObjectCollectionRuleCompartmentRequest;
import com.oracle.bmc.loganalytics.requests.ChangeScheduledTaskCompartmentRequest;
import com.oracle.bmc.loganalytics.requests.CleanRequest;
import com.oracle.bmc.loganalytics.requests.CompareContentRequest;
import com.oracle.bmc.loganalytics.requests.CreateIngestTimeRuleRequest;
import com.oracle.bmc.loganalytics.requests.CreateLogAnalyticsEmBridgeRequest;
import com.oracle.bmc.loganalytics.requests.CreateLogAnalyticsEntityRequest;
import com.oracle.bmc.loganalytics.requests.CreateLogAnalyticsEntityTypeRequest;
import com.oracle.bmc.loganalytics.requests.CreateLogAnalyticsLogGroupRequest;
import com.oracle.bmc.loganalytics.requests.CreateLogAnalyticsObjectCollectionRuleRequest;
import com.oracle.bmc.loganalytics.requests.CreateScheduledTaskRequest;
import com.oracle.bmc.loganalytics.requests.DeleteAssociationsRequest;
import com.oracle.bmc.loganalytics.requests.DeleteFieldRequest;
import com.oracle.bmc.loganalytics.requests.DeleteIngestTimeRuleRequest;
import com.oracle.bmc.loganalytics.requests.DeleteLabelRequest;
import com.oracle.bmc.loganalytics.requests.DeleteLogAnalyticsEmBridgeRequest;
import com.oracle.bmc.loganalytics.requests.DeleteLogAnalyticsEntityRequest;
import com.oracle.bmc.loganalytics.requests.DeleteLogAnalyticsEntityTypeRequest;
import com.oracle.bmc.loganalytics.requests.DeleteLogAnalyticsLogGroupRequest;
import com.oracle.bmc.loganalytics.requests.DeleteLogAnalyticsObjectCollectionRuleRequest;
import com.oracle.bmc.loganalytics.requests.DeleteLookupRequest;
import com.oracle.bmc.loganalytics.requests.DeleteParserRequest;
import com.oracle.bmc.loganalytics.requests.DeleteScheduledTaskRequest;
import com.oracle.bmc.loganalytics.requests.DeleteSourceRequest;
import com.oracle.bmc.loganalytics.requests.DeleteUploadFileRequest;
import com.oracle.bmc.loganalytics.requests.DeleteUploadRequest;
import com.oracle.bmc.loganalytics.requests.DeleteUploadWarningRequest;
import com.oracle.bmc.loganalytics.requests.DisableArchivingRequest;
import com.oracle.bmc.loganalytics.requests.DisableAutoAssociationRequest;
import com.oracle.bmc.loganalytics.requests.DisableIngestTimeRuleRequest;
import com.oracle.bmc.loganalytics.requests.DisableSourceEventTypesRequest;
import com.oracle.bmc.loganalytics.requests.EnableArchivingRequest;
import com.oracle.bmc.loganalytics.requests.EnableAutoAssociationRequest;
import com.oracle.bmc.loganalytics.requests.EnableIngestTimeRuleRequest;
import com.oracle.bmc.loganalytics.requests.EnableSourceEventTypesRequest;
import com.oracle.bmc.loganalytics.requests.EstimatePurgeDataSizeRequest;
import com.oracle.bmc.loganalytics.requests.EstimateRecallDataSizeRequest;
import com.oracle.bmc.loganalytics.requests.EstimateReleaseDataSizeRequest;
import com.oracle.bmc.loganalytics.requests.ExportCustomContentRequest;
import com.oracle.bmc.loganalytics.requests.ExportQueryResultRequest;
import com.oracle.bmc.loganalytics.requests.ExtractStructuredLogFieldPathsRequest;
import com.oracle.bmc.loganalytics.requests.ExtractStructuredLogHeaderPathsRequest;
import com.oracle.bmc.loganalytics.requests.FilterRequest;
import com.oracle.bmc.loganalytics.requests.GetAssociationSummaryRequest;
import com.oracle.bmc.loganalytics.requests.GetCategoryRequest;
import com.oracle.bmc.loganalytics.requests.GetColumnNamesRequest;
import com.oracle.bmc.loganalytics.requests.GetConfigWorkRequestRequest;
import com.oracle.bmc.loganalytics.requests.GetFieldRequest;
import com.oracle.bmc.loganalytics.requests.GetFieldsSummaryRequest;
import com.oracle.bmc.loganalytics.requests.GetIngestTimeRuleRequest;
import com.oracle.bmc.loganalytics.requests.GetLabelRequest;
import com.oracle.bmc.loganalytics.requests.GetLabelSummaryRequest;
import com.oracle.bmc.loganalytics.requests.GetLogAnalyticsEmBridgeRequest;
import com.oracle.bmc.loganalytics.requests.GetLogAnalyticsEmBridgeSummaryRequest;
import com.oracle.bmc.loganalytics.requests.GetLogAnalyticsEntitiesSummaryRequest;
import com.oracle.bmc.loganalytics.requests.GetLogAnalyticsEntityRequest;
import com.oracle.bmc.loganalytics.requests.GetLogAnalyticsEntityTypeRequest;
import com.oracle.bmc.loganalytics.requests.GetLogAnalyticsLogGroupRequest;
import com.oracle.bmc.loganalytics.requests.GetLogAnalyticsLogGroupsSummaryRequest;
import com.oracle.bmc.loganalytics.requests.GetLogAnalyticsObjectCollectionRuleRequest;
import com.oracle.bmc.loganalytics.requests.GetLogSetsCountRequest;
import com.oracle.bmc.loganalytics.requests.GetLookupRequest;
import com.oracle.bmc.loganalytics.requests.GetLookupSummaryRequest;
import com.oracle.bmc.loganalytics.requests.GetNamespaceRequest;
import com.oracle.bmc.loganalytics.requests.GetParserRequest;
import com.oracle.bmc.loganalytics.requests.GetParserSummaryRequest;
import com.oracle.bmc.loganalytics.requests.GetPreferencesRequest;
import com.oracle.bmc.loganalytics.requests.GetQueryResultRequest;
import com.oracle.bmc.loganalytics.requests.GetQueryWorkRequestRequest;
import com.oracle.bmc.loganalytics.requests.GetScheduledTaskRequest;
import com.oracle.bmc.loganalytics.requests.GetSourceRequest;
import com.oracle.bmc.loganalytics.requests.GetSourceSummaryRequest;
import com.oracle.bmc.loganalytics.requests.GetStorageRequest;
import com.oracle.bmc.loganalytics.requests.GetStorageUsageRequest;
import com.oracle.bmc.loganalytics.requests.GetStorageWorkRequestRequest;
import com.oracle.bmc.loganalytics.requests.GetUnprocessedDataBucketRequest;
import com.oracle.bmc.loganalytics.requests.GetUploadRequest;
import com.oracle.bmc.loganalytics.requests.GetWorkRequestRequest;
import com.oracle.bmc.loganalytics.requests.ImportCustomContentRequest;
import com.oracle.bmc.loganalytics.requests.ListAssociableEntitiesRequest;
import com.oracle.bmc.loganalytics.requests.ListAssociatedEntitiesRequest;
import com.oracle.bmc.loganalytics.requests.ListAutoAssociationsRequest;
import com.oracle.bmc.loganalytics.requests.ListCategoriesRequest;
import com.oracle.bmc.loganalytics.requests.ListConfigWorkRequestsRequest;
import com.oracle.bmc.loganalytics.requests.ListEncryptionKeyInfoRequest;
import com.oracle.bmc.loganalytics.requests.ListEntityAssociationsRequest;
import com.oracle.bmc.loganalytics.requests.ListEntitySourceAssociationsRequest;
import com.oracle.bmc.loganalytics.requests.ListFieldsRequest;
import com.oracle.bmc.loganalytics.requests.ListIngestTimeRulesRequest;
import com.oracle.bmc.loganalytics.requests.ListLabelPrioritiesRequest;
import com.oracle.bmc.loganalytics.requests.ListLabelSourceDetailsRequest;
import com.oracle.bmc.loganalytics.requests.ListLabelsRequest;
import com.oracle.bmc.loganalytics.requests.ListLogAnalyticsEmBridgesRequest;
import com.oracle.bmc.loganalytics.requests.ListLogAnalyticsEntitiesRequest;
import com.oracle.bmc.loganalytics.requests.ListLogAnalyticsEntityTopologyRequest;
import com.oracle.bmc.loganalytics.requests.ListLogAnalyticsEntityTypesRequest;
import com.oracle.bmc.loganalytics.requests.ListLogAnalyticsLogGroupsRequest;
import com.oracle.bmc.loganalytics.requests.ListLogAnalyticsObjectCollectionRulesRequest;
import com.oracle.bmc.loganalytics.requests.ListLogSetsRequest;
import com.oracle.bmc.loganalytics.requests.ListLookupsRequest;
import com.oracle.bmc.loganalytics.requests.ListMetaSourceTypesRequest;
import com.oracle.bmc.loganalytics.requests.ListNamespacesRequest;
import com.oracle.bmc.loganalytics.requests.ListParserFunctionsRequest;
import com.oracle.bmc.loganalytics.requests.ListParserMetaPluginsRequest;
import com.oracle.bmc.loganalytics.requests.ListParsersRequest;
import com.oracle.bmc.loganalytics.requests.ListQueryWorkRequestsRequest;
import com.oracle.bmc.loganalytics.requests.ListRecalledDataRequest;
import com.oracle.bmc.loganalytics.requests.ListResourceCategoriesRequest;
import com.oracle.bmc.loganalytics.requests.ListRulesRequest;
import com.oracle.bmc.loganalytics.requests.ListScheduledTasksRequest;
import com.oracle.bmc.loganalytics.requests.ListSourceAssociationsRequest;
import com.oracle.bmc.loganalytics.requests.ListSourceEventTypesRequest;
import com.oracle.bmc.loganalytics.requests.ListSourceExtendedFieldDefinitionsRequest;
import com.oracle.bmc.loganalytics.requests.ListSourceLabelOperatorsRequest;
import com.oracle.bmc.loganalytics.requests.ListSourceMetaFunctionsRequest;
import com.oracle.bmc.loganalytics.requests.ListSourcePatternsRequest;
import com.oracle.bmc.loganalytics.requests.ListSourcesRequest;
import com.oracle.bmc.loganalytics.requests.ListStorageWorkRequestErrorsRequest;
import com.oracle.bmc.loganalytics.requests.ListStorageWorkRequestsRequest;
import com.oracle.bmc.loganalytics.requests.ListSupportedCharEncodingsRequest;
import com.oracle.bmc.loganalytics.requests.ListSupportedTimezonesRequest;
import com.oracle.bmc.loganalytics.requests.ListUploadFilesRequest;
import com.oracle.bmc.loganalytics.requests.ListUploadWarningsRequest;
import com.oracle.bmc.loganalytics.requests.ListUploadsRequest;
import com.oracle.bmc.loganalytics.requests.ListWarningsRequest;
import com.oracle.bmc.loganalytics.requests.ListWorkRequestErrorsRequest;
import com.oracle.bmc.loganalytics.requests.ListWorkRequestLogsRequest;
import com.oracle.bmc.loganalytics.requests.ListWorkRequestsRequest;
import com.oracle.bmc.loganalytics.requests.OffboardNamespaceRequest;
import com.oracle.bmc.loganalytics.requests.OnboardNamespaceRequest;
import com.oracle.bmc.loganalytics.requests.ParseQueryRequest;
import com.oracle.bmc.loganalytics.requests.PauseScheduledTaskRequest;
import com.oracle.bmc.loganalytics.requests.PurgeStorageDataRequest;
import com.oracle.bmc.loganalytics.requests.PutQueryWorkRequestBackgroundRequest;
import com.oracle.bmc.loganalytics.requests.QueryRequest;
import com.oracle.bmc.loganalytics.requests.RecallArchivedDataRequest;
import com.oracle.bmc.loganalytics.requests.RegisterLookupRequest;
import com.oracle.bmc.loganalytics.requests.ReleaseRecalledDataRequest;
import com.oracle.bmc.loganalytics.requests.RemoveEntityAssociationsRequest;
import com.oracle.bmc.loganalytics.requests.RemovePreferencesRequest;
import com.oracle.bmc.loganalytics.requests.RemoveResourceCategoriesRequest;
import com.oracle.bmc.loganalytics.requests.RemoveSourceEventTypesRequest;
import com.oracle.bmc.loganalytics.requests.ResumeScheduledTaskRequest;
import com.oracle.bmc.loganalytics.requests.RunRequest;
import com.oracle.bmc.loganalytics.requests.SetUnprocessedDataBucketRequest;
import com.oracle.bmc.loganalytics.requests.SuggestRequest;
import com.oracle.bmc.loganalytics.requests.SuppressWarningRequest;
import com.oracle.bmc.loganalytics.requests.TestParserRequest;
import com.oracle.bmc.loganalytics.requests.UnsuppressWarningRequest;
import com.oracle.bmc.loganalytics.requests.UpdateIngestTimeRuleRequest;
import com.oracle.bmc.loganalytics.requests.UpdateLogAnalyticsEmBridgeRequest;
import com.oracle.bmc.loganalytics.requests.UpdateLogAnalyticsEntityRequest;
import com.oracle.bmc.loganalytics.requests.UpdateLogAnalyticsEntityTypeRequest;
import com.oracle.bmc.loganalytics.requests.UpdateLogAnalyticsLogGroupRequest;
import com.oracle.bmc.loganalytics.requests.UpdateLogAnalyticsObjectCollectionRuleRequest;
import com.oracle.bmc.loganalytics.requests.UpdateLookupDataRequest;
import com.oracle.bmc.loganalytics.requests.UpdateLookupRequest;
import com.oracle.bmc.loganalytics.requests.UpdatePreferencesRequest;
import com.oracle.bmc.loganalytics.requests.UpdateResourceCategoriesRequest;
import com.oracle.bmc.loganalytics.requests.UpdateScheduledTaskRequest;
import com.oracle.bmc.loganalytics.requests.UpdateStorageRequest;
import com.oracle.bmc.loganalytics.requests.UploadLogEventsFileRequest;
import com.oracle.bmc.loganalytics.requests.UploadLogFileRequest;
import com.oracle.bmc.loganalytics.requests.UpsertAssociationsRequest;
import com.oracle.bmc.loganalytics.requests.UpsertFieldRequest;
import com.oracle.bmc.loganalytics.requests.UpsertLabelRequest;
import com.oracle.bmc.loganalytics.requests.UpsertParserRequest;
import com.oracle.bmc.loganalytics.requests.UpsertSourceRequest;
import com.oracle.bmc.loganalytics.requests.ValidateAssociationParametersRequest;
import com.oracle.bmc.loganalytics.requests.ValidateFileRequest;
import com.oracle.bmc.loganalytics.requests.ValidateSourceExtendedFieldDetailsRequest;
import com.oracle.bmc.loganalytics.requests.ValidateSourceMappingRequest;
import com.oracle.bmc.loganalytics.requests.ValidateSourceRequest;
import com.oracle.bmc.loganalytics.requests.VerifyRequest;
import com.oracle.bmc.loganalytics.responses.AddEntityAssociationResponse;
import com.oracle.bmc.loganalytics.responses.AddSourceEventTypesResponse;
import com.oracle.bmc.loganalytics.responses.AppendLookupDataResponse;
import com.oracle.bmc.loganalytics.responses.AssignEncryptionKeyResponse;
import com.oracle.bmc.loganalytics.responses.BatchGetBasicInfoResponse;
import com.oracle.bmc.loganalytics.responses.CancelQueryWorkRequestResponse;
import com.oracle.bmc.loganalytics.responses.ChangeIngestTimeRuleCompartmentResponse;
import com.oracle.bmc.loganalytics.responses.ChangeLogAnalyticsEmBridgeCompartmentResponse;
import com.oracle.bmc.loganalytics.responses.ChangeLogAnalyticsEntityCompartmentResponse;
import com.oracle.bmc.loganalytics.responses.ChangeLogAnalyticsLogGroupCompartmentResponse;
import com.oracle.bmc.loganalytics.responses.ChangeLogAnalyticsObjectCollectionRuleCompartmentResponse;
import com.oracle.bmc.loganalytics.responses.ChangeScheduledTaskCompartmentResponse;
import com.oracle.bmc.loganalytics.responses.CleanResponse;
import com.oracle.bmc.loganalytics.responses.CompareContentResponse;
import com.oracle.bmc.loganalytics.responses.CreateIngestTimeRuleResponse;
import com.oracle.bmc.loganalytics.responses.CreateLogAnalyticsEmBridgeResponse;
import com.oracle.bmc.loganalytics.responses.CreateLogAnalyticsEntityResponse;
import com.oracle.bmc.loganalytics.responses.CreateLogAnalyticsEntityTypeResponse;
import com.oracle.bmc.loganalytics.responses.CreateLogAnalyticsLogGroupResponse;
import com.oracle.bmc.loganalytics.responses.CreateLogAnalyticsObjectCollectionRuleResponse;
import com.oracle.bmc.loganalytics.responses.CreateScheduledTaskResponse;
import com.oracle.bmc.loganalytics.responses.DeleteAssociationsResponse;
import com.oracle.bmc.loganalytics.responses.DeleteFieldResponse;
import com.oracle.bmc.loganalytics.responses.DeleteIngestTimeRuleResponse;
import com.oracle.bmc.loganalytics.responses.DeleteLabelResponse;
import com.oracle.bmc.loganalytics.responses.DeleteLogAnalyticsEmBridgeResponse;
import com.oracle.bmc.loganalytics.responses.DeleteLogAnalyticsEntityResponse;
import com.oracle.bmc.loganalytics.responses.DeleteLogAnalyticsEntityTypeResponse;
import com.oracle.bmc.loganalytics.responses.DeleteLogAnalyticsLogGroupResponse;
import com.oracle.bmc.loganalytics.responses.DeleteLogAnalyticsObjectCollectionRuleResponse;
import com.oracle.bmc.loganalytics.responses.DeleteLookupResponse;
import com.oracle.bmc.loganalytics.responses.DeleteParserResponse;
import com.oracle.bmc.loganalytics.responses.DeleteScheduledTaskResponse;
import com.oracle.bmc.loganalytics.responses.DeleteSourceResponse;
import com.oracle.bmc.loganalytics.responses.DeleteUploadFileResponse;
import com.oracle.bmc.loganalytics.responses.DeleteUploadResponse;
import com.oracle.bmc.loganalytics.responses.DeleteUploadWarningResponse;
import com.oracle.bmc.loganalytics.responses.DisableArchivingResponse;
import com.oracle.bmc.loganalytics.responses.DisableAutoAssociationResponse;
import com.oracle.bmc.loganalytics.responses.DisableIngestTimeRuleResponse;
import com.oracle.bmc.loganalytics.responses.DisableSourceEventTypesResponse;
import com.oracle.bmc.loganalytics.responses.EnableArchivingResponse;
import com.oracle.bmc.loganalytics.responses.EnableAutoAssociationResponse;
import com.oracle.bmc.loganalytics.responses.EnableIngestTimeRuleResponse;
import com.oracle.bmc.loganalytics.responses.EnableSourceEventTypesResponse;
import com.oracle.bmc.loganalytics.responses.EstimatePurgeDataSizeResponse;
import com.oracle.bmc.loganalytics.responses.EstimateRecallDataSizeResponse;
import com.oracle.bmc.loganalytics.responses.EstimateReleaseDataSizeResponse;
import com.oracle.bmc.loganalytics.responses.ExportCustomContentResponse;
import com.oracle.bmc.loganalytics.responses.ExportQueryResultResponse;
import com.oracle.bmc.loganalytics.responses.ExtractStructuredLogFieldPathsResponse;
import com.oracle.bmc.loganalytics.responses.ExtractStructuredLogHeaderPathsResponse;
import com.oracle.bmc.loganalytics.responses.FilterResponse;
import com.oracle.bmc.loganalytics.responses.GetAssociationSummaryResponse;
import com.oracle.bmc.loganalytics.responses.GetCategoryResponse;
import com.oracle.bmc.loganalytics.responses.GetColumnNamesResponse;
import com.oracle.bmc.loganalytics.responses.GetConfigWorkRequestResponse;
import com.oracle.bmc.loganalytics.responses.GetFieldResponse;
import com.oracle.bmc.loganalytics.responses.GetFieldsSummaryResponse;
import com.oracle.bmc.loganalytics.responses.GetIngestTimeRuleResponse;
import com.oracle.bmc.loganalytics.responses.GetLabelResponse;
import com.oracle.bmc.loganalytics.responses.GetLabelSummaryResponse;
import com.oracle.bmc.loganalytics.responses.GetLogAnalyticsEmBridgeResponse;
import com.oracle.bmc.loganalytics.responses.GetLogAnalyticsEmBridgeSummaryResponse;
import com.oracle.bmc.loganalytics.responses.GetLogAnalyticsEntitiesSummaryResponse;
import com.oracle.bmc.loganalytics.responses.GetLogAnalyticsEntityResponse;
import com.oracle.bmc.loganalytics.responses.GetLogAnalyticsEntityTypeResponse;
import com.oracle.bmc.loganalytics.responses.GetLogAnalyticsLogGroupResponse;
import com.oracle.bmc.loganalytics.responses.GetLogAnalyticsLogGroupsSummaryResponse;
import com.oracle.bmc.loganalytics.responses.GetLogAnalyticsObjectCollectionRuleResponse;
import com.oracle.bmc.loganalytics.responses.GetLogSetsCountResponse;
import com.oracle.bmc.loganalytics.responses.GetLookupResponse;
import com.oracle.bmc.loganalytics.responses.GetLookupSummaryResponse;
import com.oracle.bmc.loganalytics.responses.GetNamespaceResponse;
import com.oracle.bmc.loganalytics.responses.GetParserResponse;
import com.oracle.bmc.loganalytics.responses.GetParserSummaryResponse;
import com.oracle.bmc.loganalytics.responses.GetPreferencesResponse;
import com.oracle.bmc.loganalytics.responses.GetQueryResultResponse;
import com.oracle.bmc.loganalytics.responses.GetQueryWorkRequestResponse;
import com.oracle.bmc.loganalytics.responses.GetScheduledTaskResponse;
import com.oracle.bmc.loganalytics.responses.GetSourceResponse;
import com.oracle.bmc.loganalytics.responses.GetSourceSummaryResponse;
import com.oracle.bmc.loganalytics.responses.GetStorageResponse;
import com.oracle.bmc.loganalytics.responses.GetStorageUsageResponse;
import com.oracle.bmc.loganalytics.responses.GetStorageWorkRequestResponse;
import com.oracle.bmc.loganalytics.responses.GetUnprocessedDataBucketResponse;
import com.oracle.bmc.loganalytics.responses.GetUploadResponse;
import com.oracle.bmc.loganalytics.responses.GetWorkRequestResponse;
import com.oracle.bmc.loganalytics.responses.ImportCustomContentResponse;
import com.oracle.bmc.loganalytics.responses.ListAssociableEntitiesResponse;
import com.oracle.bmc.loganalytics.responses.ListAssociatedEntitiesResponse;
import com.oracle.bmc.loganalytics.responses.ListAutoAssociationsResponse;
import com.oracle.bmc.loganalytics.responses.ListCategoriesResponse;
import com.oracle.bmc.loganalytics.responses.ListConfigWorkRequestsResponse;
import com.oracle.bmc.loganalytics.responses.ListEncryptionKeyInfoResponse;
import com.oracle.bmc.loganalytics.responses.ListEntityAssociationsResponse;
import com.oracle.bmc.loganalytics.responses.ListEntitySourceAssociationsResponse;
import com.oracle.bmc.loganalytics.responses.ListFieldsResponse;
import com.oracle.bmc.loganalytics.responses.ListIngestTimeRulesResponse;
import com.oracle.bmc.loganalytics.responses.ListLabelPrioritiesResponse;
import com.oracle.bmc.loganalytics.responses.ListLabelSourceDetailsResponse;
import com.oracle.bmc.loganalytics.responses.ListLabelsResponse;
import com.oracle.bmc.loganalytics.responses.ListLogAnalyticsEmBridgesResponse;
import com.oracle.bmc.loganalytics.responses.ListLogAnalyticsEntitiesResponse;
import com.oracle.bmc.loganalytics.responses.ListLogAnalyticsEntityTopologyResponse;
import com.oracle.bmc.loganalytics.responses.ListLogAnalyticsEntityTypesResponse;
import com.oracle.bmc.loganalytics.responses.ListLogAnalyticsLogGroupsResponse;
import com.oracle.bmc.loganalytics.responses.ListLogAnalyticsObjectCollectionRulesResponse;
import com.oracle.bmc.loganalytics.responses.ListLogSetsResponse;
import com.oracle.bmc.loganalytics.responses.ListLookupsResponse;
import com.oracle.bmc.loganalytics.responses.ListMetaSourceTypesResponse;
import com.oracle.bmc.loganalytics.responses.ListNamespacesResponse;
import com.oracle.bmc.loganalytics.responses.ListParserFunctionsResponse;
import com.oracle.bmc.loganalytics.responses.ListParserMetaPluginsResponse;
import com.oracle.bmc.loganalytics.responses.ListParsersResponse;
import com.oracle.bmc.loganalytics.responses.ListQueryWorkRequestsResponse;
import com.oracle.bmc.loganalytics.responses.ListRecalledDataResponse;
import com.oracle.bmc.loganalytics.responses.ListResourceCategoriesResponse;
import com.oracle.bmc.loganalytics.responses.ListRulesResponse;
import com.oracle.bmc.loganalytics.responses.ListScheduledTasksResponse;
import com.oracle.bmc.loganalytics.responses.ListSourceAssociationsResponse;
import com.oracle.bmc.loganalytics.responses.ListSourceEventTypesResponse;
import com.oracle.bmc.loganalytics.responses.ListSourceExtendedFieldDefinitionsResponse;
import com.oracle.bmc.loganalytics.responses.ListSourceLabelOperatorsResponse;
import com.oracle.bmc.loganalytics.responses.ListSourceMetaFunctionsResponse;
import com.oracle.bmc.loganalytics.responses.ListSourcePatternsResponse;
import com.oracle.bmc.loganalytics.responses.ListSourcesResponse;
import com.oracle.bmc.loganalytics.responses.ListStorageWorkRequestErrorsResponse;
import com.oracle.bmc.loganalytics.responses.ListStorageWorkRequestsResponse;
import com.oracle.bmc.loganalytics.responses.ListSupportedCharEncodingsResponse;
import com.oracle.bmc.loganalytics.responses.ListSupportedTimezonesResponse;
import com.oracle.bmc.loganalytics.responses.ListUploadFilesResponse;
import com.oracle.bmc.loganalytics.responses.ListUploadWarningsResponse;
import com.oracle.bmc.loganalytics.responses.ListUploadsResponse;
import com.oracle.bmc.loganalytics.responses.ListWarningsResponse;
import com.oracle.bmc.loganalytics.responses.ListWorkRequestErrorsResponse;
import com.oracle.bmc.loganalytics.responses.ListWorkRequestLogsResponse;
import com.oracle.bmc.loganalytics.responses.ListWorkRequestsResponse;
import com.oracle.bmc.loganalytics.responses.OffboardNamespaceResponse;
import com.oracle.bmc.loganalytics.responses.OnboardNamespaceResponse;
import com.oracle.bmc.loganalytics.responses.ParseQueryResponse;
import com.oracle.bmc.loganalytics.responses.PauseScheduledTaskResponse;
import com.oracle.bmc.loganalytics.responses.PurgeStorageDataResponse;
import com.oracle.bmc.loganalytics.responses.PutQueryWorkRequestBackgroundResponse;
import com.oracle.bmc.loganalytics.responses.QueryResponse;
import com.oracle.bmc.loganalytics.responses.RecallArchivedDataResponse;
import com.oracle.bmc.loganalytics.responses.RegisterLookupResponse;
import com.oracle.bmc.loganalytics.responses.ReleaseRecalledDataResponse;
import com.oracle.bmc.loganalytics.responses.RemoveEntityAssociationsResponse;
import com.oracle.bmc.loganalytics.responses.RemovePreferencesResponse;
import com.oracle.bmc.loganalytics.responses.RemoveResourceCategoriesResponse;
import com.oracle.bmc.loganalytics.responses.RemoveSourceEventTypesResponse;
import com.oracle.bmc.loganalytics.responses.ResumeScheduledTaskResponse;
import com.oracle.bmc.loganalytics.responses.RunResponse;
import com.oracle.bmc.loganalytics.responses.SetUnprocessedDataBucketResponse;
import com.oracle.bmc.loganalytics.responses.SuggestResponse;
import com.oracle.bmc.loganalytics.responses.SuppressWarningResponse;
import com.oracle.bmc.loganalytics.responses.TestParserResponse;
import com.oracle.bmc.loganalytics.responses.UnsuppressWarningResponse;
import com.oracle.bmc.loganalytics.responses.UpdateIngestTimeRuleResponse;
import com.oracle.bmc.loganalytics.responses.UpdateLogAnalyticsEmBridgeResponse;
import com.oracle.bmc.loganalytics.responses.UpdateLogAnalyticsEntityResponse;
import com.oracle.bmc.loganalytics.responses.UpdateLogAnalyticsEntityTypeResponse;
import com.oracle.bmc.loganalytics.responses.UpdateLogAnalyticsLogGroupResponse;
import com.oracle.bmc.loganalytics.responses.UpdateLogAnalyticsObjectCollectionRuleResponse;
import com.oracle.bmc.loganalytics.responses.UpdateLookupDataResponse;
import com.oracle.bmc.loganalytics.responses.UpdateLookupResponse;
import com.oracle.bmc.loganalytics.responses.UpdatePreferencesResponse;
import com.oracle.bmc.loganalytics.responses.UpdateResourceCategoriesResponse;
import com.oracle.bmc.loganalytics.responses.UpdateScheduledTaskResponse;
import com.oracle.bmc.loganalytics.responses.UpdateStorageResponse;
import com.oracle.bmc.loganalytics.responses.UploadLogEventsFileResponse;
import com.oracle.bmc.loganalytics.responses.UploadLogFileResponse;
import com.oracle.bmc.loganalytics.responses.UpsertAssociationsResponse;
import com.oracle.bmc.loganalytics.responses.UpsertFieldResponse;
import com.oracle.bmc.loganalytics.responses.UpsertLabelResponse;
import com.oracle.bmc.loganalytics.responses.UpsertParserResponse;
import com.oracle.bmc.loganalytics.responses.UpsertSourceResponse;
import com.oracle.bmc.loganalytics.responses.ValidateAssociationParametersResponse;
import com.oracle.bmc.loganalytics.responses.ValidateFileResponse;
import com.oracle.bmc.loganalytics.responses.ValidateSourceExtendedFieldDetailsResponse;
import com.oracle.bmc.loganalytics.responses.ValidateSourceMappingResponse;
import com.oracle.bmc.loganalytics.responses.ValidateSourceResponse;
import com.oracle.bmc.loganalytics.responses.VerifyResponse;
import com.oracle.bmc.util.CircuitBreakerUtils;
import com.oracle.bmc.util.StreamUtils;
import com.oracle.bmc.util.internal.CollectionFormatType;
import com.oracle.bmc.util.internal.Validate;
import jakarta.annotation.Nonnull;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LogAnalyticsClient
extends BaseSyncClient
implements LogAnalytics {
    public static final Service SERVICE = Services.serviceBuilder().serviceName("LOGANALYTICS").serviceEndpointPrefix("").serviceEndpointTemplate("https://loganalytics.{region}.oci.{secondLevelDomain}").build();
    private static final Logger LOG = LoggerFactory.getLogger(LogAnalyticsClient.class);
    private final LogAnalyticsWaiters waiters;
    private final LogAnalyticsPaginators paginators;

    LogAnalyticsClient(ClientBuilderBase<?, ?> builder, AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ExecutorService executorService) {
        this(builder, authenticationDetailsProvider, executorService, true);
    }

    LogAnalyticsClient(ClientBuilderBase<?, ?> builder, AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ExecutorService executorService, boolean isStreamWarningEnabled) {
        super(builder, authenticationDetailsProvider, CircuitBreakerUtils.DEFAULT_CIRCUIT_BREAKER_CONFIGURATION);
        if (executorService == null) {
            ThreadPoolExecutor threadPoolExecutor = new ThreadPoolExecutor(50, 50, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), (ThreadFactory)ClientThreadFactory.builder().isDaemon(true).nameFormat("LogAnalytics-waiters-%d").build());
            threadPoolExecutor.allowCoreThreadTimeOut(true);
            executorService = threadPoolExecutor;
        }
        this.waiters = new LogAnalyticsWaiters(executorService, this);
        this.paginators = new LogAnalyticsPaginators(this);
        if (isStreamWarningEnabled && StreamUtils.isExtraStreamLogsEnabled()) {
            LOG.warn(StreamUtils.getStreamWarningMessage((String)"LogAnalyticsClient", (String)"exportCustomContent,exportQueryResult"));
        }
    }

    public static Builder builder() {
        return new Builder(SERVICE);
    }

    @Override
    public void setRegion(Region region) {
        super.setRegion(region);
    }

    @Override
    public void setRegion(String regionId) {
        super.setRegion(regionId);
    }

    @Override
    public AddEntityAssociationResponse addEntityAssociation(AddEntityAssociationRequest request) {
        Validate.notBlank((String)request.getNamespaceName(), (String)"namespaceName must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getLogAnalyticsEntityId(), (String)"logAnalyticsEntityId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getAddEntityAssociationDetails(), "addEntityAssociationDetails is required");
        return (AddEntityAssociationResponse)this.clientCall(request, AddEntityAssociationResponse::builder).logger(LOG, "addEntityAssociation").serviceDetails("LogAnalytics", "AddEntityAssociation", "https://docs.oracle.com/iaas/api/#/en/logan-api-spec/20200601/LogAnalyticsEntity/AddEntityAssociation").method(Method.POST).requestBuilder(AddEntityAssociationRequest::builder).basePath("/20200601").appendPathParam("namespaces").appendPathParam(request.getNamespaceName()).appendPathParam("logAnalyticsEntities").appendPathParam(request.getLogAnalyticsEntityId()).appendPathParam("actions").appendPathParam("addEntityAssociations").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("if-match", request.getIfMatch()).hasBody().handleResponseHeaderString("opc-request-id", AddEntityAssociationResponse.Builder::opcRequestId).operationUsesDefaultRetries().callSync();
    }

    @Override
    public AddSourceEventTypesResponse addSourceEventTypes(AddSourceEventTypesRequest request) {
        Validate.notBlank((String)request.getNamespaceName(), (String)"namespaceName must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getSourceName(), (String)"sourceName must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getAddEventTypeDetails(), "addEventTypeDetails is required");
        return (AddSourceEventTypesResponse)this.clientCall(request, AddSourceEventTypesResponse::builder).logger(LOG, "addSourceEventTypes").serviceDetails("LogAnalytics", "AddSourceEventTypes", "https://docs.oracle.com/iaas/api/#/en/logan-api-spec/20200601/LogAnalyticsSource/AddSourceEventTypes").method(Method.POST).requestBuilder(AddSourceEventTypesRequest::builder).basePath("/20200601").appendPathParam("namespaces").appendPathParam(request.getNamespaceName()).appendPathParam("sources").appendPathParam(request.getSourceName()).appendPathParam("actions").appendPathParam("addEventTypes").accept(new String[]{"application/json"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleResponseHeaderString("opc-request-id", AddSourceEventTypesResponse.Builder::opcRequestId).operationUsesDefaultRetries().callSync();
    }

    @Override
    public AppendLookupDataResponse appendLookupData(AppendLookupDataRequest request) {
        Validate.notBlank((String)request.getNamespaceName(), (String)"namespaceName must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getLookupName(), (String)"lookupName must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getAppendLookupFileBody(), "appendLookupFileBody is required");
        return (AppendLookupDataResponse)this.clientCall(request, AppendLookupDataResponse::builder).logger(LOG, "appendLookupData").serviceDetails("LogAnalytics", "AppendLookupData", "https://docs.oracle.com/iaas/api/#/en/logan-api-spec/20200601/LogAnalyticsLookup/AppendLookupData").method(Method.POST).requestBuilder(AppendLookupDataRequest::builder).basePath("/20200601").appendPathParam("namespaces").appendPathParam(request.getNamespaceName()).appendPathParam("lookups").appendPathParam(request.getLookupName()).appendPathParam("actions").appendPathParam("appendData").appendQueryParam("isForce", (Object)request.getIsForce()).appendQueryParam("charEncoding", (Object)request.getCharEncoding()).accept(new String[]{"application/json"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("if-match", request.getIfMatch()).appendHeader("expect", request.getExpect()).hasBinaryRequestBody().hasBody().handleResponseHeaderString("opc-work-request-id", AppendLookupDataResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", AppendLookupDataResponse.Builder::opcRequestId).operationUsesDefaultRetries().callSync();
    }

    @Override
    public AssignEncryptionKeyResponse assignEncryptionKey(AssignEncryptionKeyRequest request) {
        Validate.notBlank((String)request.getNamespaceName(), (String)"namespaceName must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getAssignEncryptionKeyDetails(), "assignEncryptionKeyDetails is required");
        return (AssignEncryptionKeyResponse)this.clientCall(request, AssignEncryptionKeyResponse::builder).logger(LOG, "assignEncryptionKey").serviceDetails("LogAnalytics", "AssignEncryptionKey", "https://docs.oracle.com/iaas/api/#/en/logan-api-spec/20200601/Storage/AssignEncryptionKey").method(Method.POST).requestBuilder(AssignEncryptionKeyRequest::builder).basePath("/20200601").appendPathParam("namespaces").appendPathParam(request.getNamespaceName()).appendPathParam("storage").appendPathParam("actions").appendPathParam("assignEncryptionKey").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("if-match", request.getIfMatch()).hasBody().handleResponseHeaderString("opc-request-id", AssignEncryptionKeyResponse.Builder::opcRequestId).handleResponseHeaderString("opc-work-request-id", AssignEncryptionKeyResponse.Builder::opcWorkRequestId).handleResponseHeaderString("location", AssignEncryptionKeyResponse.Builder::location).callSync();
    }

    @Override
    public BatchGetBasicInfoResponse batchGetBasicInfo(BatchGetBasicInfoRequest request) {
        Validate.notBlank((String)request.getNamespaceName(), (String)"namespaceName must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getBasicDetails(), "basicDetails is required");
        Objects.requireNonNull(request.getIsIncludeDeleted(), "isIncludeDeleted is required");
        return (BatchGetBasicInfoResponse)this.clientCall(request, BatchGetBasicInfoResponse::builder).logger(LOG, "batchGetBasicInfo").serviceDetails("LogAnalytics", "BatchGetBasicInfo", "https://docs.oracle.com/iaas/api/#/en/logan-api-spec/20200601/LogAnalyticsLabel/BatchGetBasicInfo").method(Method.POST).requestBuilder(BatchGetBasicInfoRequest::builder).basePath("/20200601").appendPathParam("namespaces").appendPathParam(request.getNamespaceName()).appendPathParam("labels").appendPathParam("actions").appendPathParam("basicInfo").appendQueryParam("isIncludeDeleted", (Object)request.getIsIncludeDeleted()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("basicLabelSortBy", (BmcEnum)request.getBasicLabelSortBy()).accept(new String[]{"application/json;charset=UTF-8"}).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleBody(LogAnalyticsLabelCollection.class, BatchGetBasicInfoResponse.Builder::logAnalyticsLabelCollection).handleResponseHeaderString("opc-prev-page", BatchGetBasicInfoResponse.Builder::opcPrevPage).handleResponseHeaderString("opc-next-page", BatchGetBasicInfoResponse.Builder::opcNextPage).handleResponseHeaderString("opc-request-id", BatchGetBasicInfoResponse.Builder::opcRequestId).operationUsesDefaultRetries().callSync();
    }

    @Override
    public CancelQueryWorkRequestResponse cancelQueryWorkRequest(CancelQueryWorkRequestRequest request) {
        Validate.notBlank((String)request.getNamespaceName(), (String)"namespaceName must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getWorkRequestId(), (String)"workRequestId must not be blank", (Object[])new Object[0]);
        return (CancelQueryWorkRequestResponse)this.clientCall(request, CancelQueryWorkRequestResponse::builder).logger(LOG, "cancelQueryWorkRequest").serviceDetails("LogAnalytics", "CancelQueryWorkRequest", "https://docs.oracle.com/iaas/api/#/en/logan-api-spec/20200601/QueryWorkRequest/CancelQueryWorkRequest").method(Method.DELETE).requestBuilder(CancelQueryWorkRequestRequest::builder).basePath("/20200601").appendPathParam("namespaces").appendPathParam(request.getNamespaceName()).appendPathParam("queryWorkRequests").appendPathParam(request.getWorkRequestId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("if-match", request.getIfMatch()).handleResponseHeaderString("opc-request-id", CancelQueryWorkRequestResponse.Builder::opcRequestId).operationUsesDefaultRetries().callSync();
    }

    @Override
    public ChangeIngestTimeRuleCompartmentResponse changeIngestTimeRuleCompartment(ChangeIngestTimeRuleCompartmentRequest request) {
        Validate.notBlank((String)request.getNamespaceName(), (String)"namespaceName must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getIngestTimeRuleId(), (String)"ingestTimeRuleId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getChangeIngestTimeRuleCompartmentDetails(), "changeIngestTimeRuleCompartmentDetails is required");
        return (ChangeIngestTimeRuleCompartmentResponse)this.clientCall(request, ChangeIngestTimeRuleCompartmentResponse::builder).logger(LOG, "changeIngestTimeRuleCompartment").serviceDetails("LogAnalytics", "ChangeIngestTimeRuleCompartment", "https://docs.oracle.com/iaas/api/#/en/logan-api-spec/20200601/IngestTimeRule/ChangeIngestTimeRuleCompartment").method(Method.POST).requestBuilder(ChangeIngestTimeRuleCompartmentRequest::builder).basePath("/20200601").appendPathParam("namespaces").appendPathParam(request.getNamespaceName()).appendPathParam("ingestTimeRules").appendPathParam(request.getIngestTimeRuleId()).appendPathParam("actions").appendPathParam("changeCompartment").accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBody().handleResponseHeaderString("opc-request-id", ChangeIngestTimeRuleCompartmentResponse.Builder::opcRequestId).operationUsesDefaultRetries().callSync();
    }

    @Override
    public ChangeLogAnalyticsEmBridgeCompartmentResponse changeLogAnalyticsEmBridgeCompartment(ChangeLogAnalyticsEmBridgeCompartmentRequest request) {
        Validate.notBlank((String)request.getNamespaceName(), (String)"namespaceName must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getLogAnalyticsEmBridgeId(), (String)"logAnalyticsEmBridgeId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getChangeLogAnalyticsEmBridgeCompartmentDetails(), "changeLogAnalyticsEmBridgeCompartmentDetails is required");
        return (ChangeLogAnalyticsEmBridgeCompartmentResponse)this.clientCall(request, ChangeLogAnalyticsEmBridgeCompartmentResponse::builder).logger(LOG, "changeLogAnalyticsEmBridgeCompartment").serviceDetails("LogAnalytics", "ChangeLogAnalyticsEmBridgeCompartment", "https://docs.oracle.com/iaas/api/#/en/logan-api-spec/20200601/LogAnalyticsEmBridge/ChangeLogAnalyticsEmBridgeCompartment").method(Method.POST).requestBuilder(ChangeLogAnalyticsEmBridgeCompartmentRequest::builder).basePath("/20200601").appendPathParam("namespaces").appendPathParam(request.getNamespaceName()).appendPathParam("logAnalyticsEmBridges").appendPathParam(request.getLogAnalyticsEmBridgeId()).appendPathParam("actions").appendPathParam("changeCompartment").accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBody().handleResponseHeaderString("opc-request-id", ChangeLogAnalyticsEmBridgeCompartmentResponse.Builder::opcRequestId).operationUsesDefaultRetries().callSync();
    }

    @Override
    public ChangeLogAnalyticsEntityCompartmentResponse changeLogAnalyticsEntityCompartment(ChangeLogAnalyticsEntityCompartmentRequest request) {
        Validate.notBlank((String)request.getNamespaceName(), (String)"namespaceName must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getLogAnalyticsEntityId(), (String)"logAnalyticsEntityId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getChangeLogAnalyticsEntityCompartmentDetails(), "changeLogAnalyticsEntityCompartmentDetails is required");
        return (ChangeLogAnalyticsEntityCompartmentResponse)this.clientCall(request, ChangeLogAnalyticsEntityCompartmentResponse::builder).logger(LOG, "changeLogAnalyticsEntityCompartment").serviceDetails("LogAnalytics", "ChangeLogAnalyticsEntityCompartment", "https://docs.oracle.com/iaas/api/#/en/logan-api-spec/20200601/LogAnalyticsEntity/ChangeLogAnalyticsEntityCompartment").method(Method.POST).requestBuilder(ChangeLogAnalyticsEntityCompartmentRequest::builder).basePath("/20200601").appendPathParam("namespaces").appendPathParam(request.getNamespaceName()).appendPathParam("logAnalyticsEntities").appendPathParam(request.getLogAnalyticsEntityId()).appendPathParam("actions").appendPathParam("changeCompartment").accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBody().handleResponseHeaderString("opc-request-id", ChangeLogAnalyticsEntityCompartmentResponse.Builder::opcRequestId).operationUsesDefaultRetries().callSync();
    }

    @Override
    public ChangeLogAnalyticsLogGroupCompartmentResponse changeLogAnalyticsLogGroupCompartment(ChangeLogAnalyticsLogGroupCompartmentRequest request) {
        Validate.notBlank((String)request.getNamespaceName(), (String)"namespaceName must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getLogAnalyticsLogGroupId(), (String)"logAnalyticsLogGroupId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getChangeLogAnalyticsLogGroupCompartmentDetails(), "changeLogAnalyticsLogGroupCompartmentDetails is required");
        return (ChangeLogAnalyticsLogGroupCompartmentResponse)this.clientCall(request, ChangeLogAnalyticsLogGroupCompartmentResponse::builder).logger(LOG, "changeLogAnalyticsLogGroupCompartment").serviceDetails("LogAnalytics", "ChangeLogAnalyticsLogGroupCompartment", "https://docs.oracle.com/iaas/api/#/en/logan-api-spec/20200601/LogAnalyticsLogGroup/ChangeLogAnalyticsLogGroupCompartment").method(Method.POST).requestBuilder(ChangeLogAnalyticsLogGroupCompartmentRequest::builder).basePath("/20200601").appendPathParam("namespaces").appendPathParam(request.getNamespaceName()).appendPathParam("logAnalyticsLogGroups").appendPathParam(request.getLogAnalyticsLogGroupId()).appendPathParam("actions").appendPathParam("changeCompartment").accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBody().handleResponseHeaderString("opc-request-id", ChangeLogAnalyticsLogGroupCompartmentResponse.Builder::opcRequestId).operationUsesDefaultRetries().callSync();
    }

    @Override
    public ChangeLogAnalyticsObjectCollectionRuleCompartmentResponse changeLogAnalyticsObjectCollectionRuleCompartment(ChangeLogAnalyticsObjectCollectionRuleCompartmentRequest request) {
        Validate.notBlank((String)request.getNamespaceName(), (String)"namespaceName must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getLogAnalyticsObjectCollectionRuleId(), (String)"logAnalyticsObjectCollectionRuleId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getChangeLogAnalyticsObjectCollectionRuleCompartmentDetails(), "changeLogAnalyticsObjectCollectionRuleCompartmentDetails is required");
        return (ChangeLogAnalyticsObjectCollectionRuleCompartmentResponse)this.clientCall(request, ChangeLogAnalyticsObjectCollectionRuleCompartmentResponse::builder).logger(LOG, "changeLogAnalyticsObjectCollectionRuleCompartment").serviceDetails("LogAnalytics", "ChangeLogAnalyticsObjectCollectionRuleCompartment", "https://docs.oracle.com/iaas/api/#/en/logan-api-spec/20200601/LogAnalyticsObjectCollectionRule/ChangeLogAnalyticsObjectCollectionRuleCompartment").method(Method.POST).requestBuilder(ChangeLogAnalyticsObjectCollectionRuleCompartmentRequest::builder).basePath("/20200601").appendPathParam("namespaces").appendPathParam(request.getNamespaceName()).appendPathParam("logAnalyticsObjectCollectionRules").appendPathParam(request.getLogAnalyticsObjectCollectionRuleId()).appendPathParam("actions").appendPathParam("changeCompartment").accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleResponseHeaderString("opc-request-id", ChangeLogAnalyticsObjectCollectionRuleCompartmentResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public ChangeScheduledTaskCompartmentResponse changeScheduledTaskCompartment(ChangeScheduledTaskCompartmentRequest request) {
        Validate.notBlank((String)request.getNamespaceName(), (String)"namespaceName must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getScheduledTaskId(), (String)"scheduledTaskId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getChangeScheduledTaskCompartmentDetails(), "changeScheduledTaskCompartmentDetails is required");
        return (ChangeScheduledTaskCompartmentResponse)this.clientCall(request, ChangeScheduledTaskCompartmentResponse::builder).logger(LOG, "changeScheduledTaskCompartment").serviceDetails("LogAnalytics", "ChangeScheduledTaskCompartment", "https://docs.oracle.com/iaas/api/#/en/logan-api-spec/20200601/ScheduledTask/ChangeScheduledTaskCompartment").method(Method.POST).requestBuilder(ChangeScheduledTaskCompartmentRequest::builder).basePath("/20200601").appendPathParam("namespaces").appendPathParam(request.getNamespaceName()).appendPathParam("scheduledTasks").appendPathParam(request.getScheduledTaskId()).appendPathParam("actions").appendPathParam("changeCompartment").accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBody().handleResponseHeaderString("opc-request-id", ChangeScheduledTaskCompartmentResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public CleanResponse clean(CleanRequest request) {
        Validate.notBlank((String)request.getNamespaceName(), (String)"namespaceName must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getScheduledTaskId(), (String)"scheduledTaskId must not be blank", (Object[])new Object[0]);
        return (CleanResponse)this.clientCall(request, CleanResponse::builder).logger(LOG, "clean").serviceDetails("LogAnalytics", "Clean", "https://docs.oracle.com/iaas/api/#/en/logan-api-spec/20200601/ScheduledTask/Clean").method(Method.POST).requestBuilder(CleanRequest::builder).basePath("/20200601").appendPathParam("namespaces").appendPathParam(request.getNamespaceName()).appendPathParam("scheduledTasks").appendPathParam(request.getScheduledTaskId()).appendPathParam("actions").appendPathParam("clean").appendQueryParam("timeStart", (Object)request.getTimeStart()).appendQueryParam("timeEnd", (Object)request.getTimeEnd()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).handleResponseHeaderString("opc-request-id", CleanResponse.Builder::opcRequestId).operationUsesDefaultRetries().callSync();
    }

    @Override
    public CompareContentResponse compareContent(CompareContentRequest request) {
        Validate.notBlank((String)request.getNamespaceName(), (String)"namespaceName must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getCompareContentDetails(), "compareContentDetails is required");
        return (CompareContentResponse)this.clientCall(request, CompareContentResponse::builder).logger(LOG, "compareContent").serviceDetails("LogAnalytics", "CompareContent", "https://docs.oracle.com/iaas/api/#/en/logan-api-spec/20200601/QueryDetails/CompareContent").method(Method.POST).requestBuilder(CompareContentRequest::builder).basePath("/20200601").appendPathParam("namespaces").appendPathParam(request.getNamespaceName()).appendPathParam("search").appendPathParam("actions").appendPathParam("compareContent").accept(new String[]{"application/json;charset=UTF-8"}).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleBody(CompareContentResult.class, CompareContentResponse.Builder::compareContentResult).handleResponseHeaderString("opc-request-id", CompareContentResponse.Builder::opcRequestId).operationUsesDefaultRetries().callSync();
    }

    @Override
    public CreateIngestTimeRuleResponse createIngestTimeRule(CreateIngestTimeRuleRequest request) {
        Validate.notBlank((String)request.getNamespaceName(), (String)"namespaceName must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getCreateIngestTimeRuleDetails(), "createIngestTimeRuleDetails is required");
        return (CreateIngestTimeRuleResponse)this.clientCall(request, CreateIngestTimeRuleResponse::builder).logger(LOG, "createIngestTimeRule").serviceDetails("LogAnalytics", "CreateIngestTimeRule", "https://docs.oracle.com/iaas/api/#/en/logan-api-spec/20200601/IngestTimeRule/CreateIngestTimeRule").method(Method.POST).requestBuilder(CreateIngestTimeRuleRequest::builder).basePath("/20200601").appendPathParam("namespaces").appendPathParam(request.getNamespaceName()).appendPathParam("ingestTimeRules").accept(new String[]{"application/json"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleBody(IngestTimeRule.class, CreateIngestTimeRuleResponse.Builder::ingestTimeRule).handleResponseHeaderString("etag", CreateIngestTimeRuleResponse.Builder::etag).handleResponseHeaderString("opc-request-id", CreateIngestTimeRuleResponse.Builder::opcRequestId).operationUsesDefaultRetries().callSync();
    }

    @Override
    public CreateLogAnalyticsEmBridgeResponse createLogAnalyticsEmBridge(CreateLogAnalyticsEmBridgeRequest request) {
        Validate.notBlank((String)request.getNamespaceName(), (String)"namespaceName must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getCreateLogAnalyticsEmBridgeDetails(), "createLogAnalyticsEmBridgeDetails is required");
        return (CreateLogAnalyticsEmBridgeResponse)this.clientCall(request, CreateLogAnalyticsEmBridgeResponse::builder).logger(LOG, "createLogAnalyticsEmBridge").serviceDetails("LogAnalytics", "CreateLogAnalyticsEmBridge", "https://docs.oracle.com/iaas/api/#/en/logan-api-spec/20200601/LogAnalyticsEmBridge/CreateLogAnalyticsEmBridge").method(Method.POST).requestBuilder(CreateLogAnalyticsEmBridgeRequest::builder).basePath("/20200601").appendPathParam("namespaces").appendPathParam(request.getNamespaceName()).appendPathParam("logAnalyticsEmBridges").accept(new String[]{"application/json"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleBody(LogAnalyticsEmBridge.class, CreateLogAnalyticsEmBridgeResponse.Builder::logAnalyticsEmBridge).handleResponseHeaderString("etag", CreateLogAnalyticsEmBridgeResponse.Builder::etag).handleResponseHeaderString("opc-request-id", CreateLogAnalyticsEmBridgeResponse.Builder::opcRequestId).operationUsesDefaultRetries().callSync();
    }

    @Override
    public CreateLogAnalyticsEntityResponse createLogAnalyticsEntity(CreateLogAnalyticsEntityRequest request) {
        Validate.notBlank((String)request.getNamespaceName(), (String)"namespaceName must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getCreateLogAnalyticsEntityDetails(), "createLogAnalyticsEntityDetails is required");
        return (CreateLogAnalyticsEntityResponse)this.clientCall(request, CreateLogAnalyticsEntityResponse::builder).logger(LOG, "createLogAnalyticsEntity").serviceDetails("LogAnalytics", "CreateLogAnalyticsEntity", "https://docs.oracle.com/iaas/api/#/en/logan-api-spec/20200601/LogAnalyticsEntity/CreateLogAnalyticsEntity").method(Method.POST).requestBuilder(CreateLogAnalyticsEntityRequest::builder).basePath("/20200601").appendPathParam("namespaces").appendPathParam(request.getNamespaceName()).appendPathParam("logAnalyticsEntities").accept(new String[]{"application/json"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleBody(LogAnalyticsEntity.class, CreateLogAnalyticsEntityResponse.Builder::logAnalyticsEntity).handleResponseHeaderString("etag", CreateLogAnalyticsEntityResponse.Builder::etag).handleResponseHeaderString("opc-request-id", CreateLogAnalyticsEntityResponse.Builder::opcRequestId).operationUsesDefaultRetries().callSync();
    }

    @Override
    public CreateLogAnalyticsEntityTypeResponse createLogAnalyticsEntityType(CreateLogAnalyticsEntityTypeRequest request) {
        Validate.notBlank((String)request.getNamespaceName(), (String)"namespaceName must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getCreateLogAnalyticsEntityTypeDetails(), "createLogAnalyticsEntityTypeDetails is required");
        return (CreateLogAnalyticsEntityTypeResponse)this.clientCall(request, CreateLogAnalyticsEntityTypeResponse::builder).logger(LOG, "createLogAnalyticsEntityType").serviceDetails("LogAnalytics", "CreateLogAnalyticsEntityType", "https://docs.oracle.com/iaas/api/#/en/logan-api-spec/20200601/LogAnalyticsEntityType/CreateLogAnalyticsEntityType").method(Method.POST).requestBuilder(CreateLogAnalyticsEntityTypeRequest::builder).basePath("/20200601").appendPathParam("namespaces").appendPathParam(request.getNamespaceName()).appendPathParam("logAnalyticsEntityTypes").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBody().handleResponseHeaderString("opc-request-id", CreateLogAnalyticsEntityTypeResponse.Builder::opcRequestId).operationUsesDefaultRetries().callSync();
    }

    @Override
    public CreateLogAnalyticsLogGroupResponse createLogAnalyticsLogGroup(CreateLogAnalyticsLogGroupRequest request) {
        Validate.notBlank((String)request.getNamespaceName(), (String)"namespaceName must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getCreateLogAnalyticsLogGroupDetails(), "createLogAnalyticsLogGroupDetails is required");
        return (CreateLogAnalyticsLogGroupResponse)this.clientCall(request, CreateLogAnalyticsLogGroupResponse::builder).logger(LOG, "createLogAnalyticsLogGroup").serviceDetails("LogAnalytics", "CreateLogAnalyticsLogGroup", "https://docs.oracle.com/iaas/api/#/en/logan-api-spec/20200601/LogAnalyticsLogGroup/CreateLogAnalyticsLogGroup").method(Method.POST).requestBuilder(CreateLogAnalyticsLogGroupRequest::builder).basePath("/20200601").appendPathParam("namespaces").appendPathParam(request.getNamespaceName()).appendPathParam("logAnalyticsLogGroups").accept(new String[]{"application/json"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleBody(LogAnalyticsLogGroup.class, CreateLogAnalyticsLogGroupResponse.Builder::logAnalyticsLogGroup).handleResponseHeaderString("etag", CreateLogAnalyticsLogGroupResponse.Builder::etag).handleResponseHeaderString("opc-request-id", CreateLogAnalyticsLogGroupResponse.Builder::opcRequestId).operationUsesDefaultRetries().callSync();
    }

    @Override
    public CreateLogAnalyticsObjectCollectionRuleResponse createLogAnalyticsObjectCollectionRule(CreateLogAnalyticsObjectCollectionRuleRequest request) {
        Validate.notBlank((String)request.getNamespaceName(), (String)"namespaceName must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getCreateLogAnalyticsObjectCollectionRuleDetails(), "createLogAnalyticsObjectCollectionRuleDetails is required");
        return (CreateLogAnalyticsObjectCollectionRuleResponse)this.clientCall(request, CreateLogAnalyticsObjectCollectionRuleResponse::builder).logger(LOG, "createLogAnalyticsObjectCollectionRule").serviceDetails("LogAnalytics", "CreateLogAnalyticsObjectCollectionRule", "https://docs.oracle.com/iaas/api/#/en/logan-api-spec/20200601/LogAnalyticsObjectCollectionRule/CreateLogAnalyticsObjectCollectionRule").method(Method.POST).requestBuilder(CreateLogAnalyticsObjectCollectionRuleRequest::builder).basePath("/20200601").appendPathParam("namespaces").appendPathParam(request.getNamespaceName()).appendPathParam("logAnalyticsObjectCollectionRules").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleBody(LogAnalyticsObjectCollectionRule.class, CreateLogAnalyticsObjectCollectionRuleResponse.Builder::logAnalyticsObjectCollectionRule).handleResponseHeaderString("etag", CreateLogAnalyticsObjectCollectionRuleResponse.Builder::etag).handleResponseHeaderString("opc-request-id", CreateLogAnalyticsObjectCollectionRuleResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public CreateScheduledTaskResponse createScheduledTask(CreateScheduledTaskRequest request) {
        Validate.notBlank((String)request.getNamespaceName(), (String)"namespaceName must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getCreateScheduledTaskDetails(), "createScheduledTaskDetails is required");
        return (CreateScheduledTaskResponse)this.clientCall(request, CreateScheduledTaskResponse::builder).logger(LOG, "createScheduledTask").serviceDetails("LogAnalytics", "CreateScheduledTask", "https://docs.oracle.com/iaas/api/#/en/logan-api-spec/20200601/ScheduledTask/CreateScheduledTask").method(Method.POST).requestBuilder(CreateScheduledTaskRequest::builder).basePath("/20200601").appendPathParam("namespaces").appendPathParam(request.getNamespaceName()).appendPathParam("scheduledTasks").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBody().handleBody(ScheduledTask.class, CreateScheduledTaskResponse.Builder::scheduledTask).handleResponseHeaderString("opc-request-id", CreateScheduledTaskResponse.Builder::opcRequestId).handleResponseHeaderString("etag", CreateScheduledTaskResponse.Builder::etag).callSync();
    }

    @Override
    public DeleteAssociationsResponse deleteAssociations(DeleteAssociationsRequest request) {
        Validate.notBlank((String)request.getNamespaceName(), (String)"namespaceName must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getDeleteLogAnalyticsAssociationDetails(), "deleteLogAnalyticsAssociationDetails is required");
        return (DeleteAssociationsResponse)this.clientCall(request, DeleteAssociationsResponse::builder).logger(LOG, "deleteAssociations").serviceDetails("LogAnalytics", "DeleteAssociations", "https://docs.oracle.com/iaas/api/#/en/logan-api-spec/20200601/LogAnalyticsAssociation/DeleteAssociations").method(Method.POST).requestBuilder(DeleteAssociationsRequest::builder).basePath("/20200601").appendPathParam("namespaces").appendPathParam(request.getNamespaceName()).appendPathParam("associations").appendPathParam("actions").appendPathParam("delete").accept(new String[]{"application/json;charset=UTF-8"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleResponseHeaderString("opc-work-request-id", DeleteAssociationsResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", DeleteAssociationsResponse.Builder::opcRequestId).operationUsesDefaultRetries().callSync();
    }

    @Override
    public DeleteFieldResponse deleteField(DeleteFieldRequest request) {
        Validate.notBlank((String)request.getNamespaceName(), (String)"namespaceName must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getFieldName(), (String)"fieldName must not be blank", (Object[])new Object[0]);
        return (DeleteFieldResponse)this.clientCall(request, DeleteFieldResponse::builder).logger(LOG, "deleteField").serviceDetails("LogAnalytics", "DeleteField", "https://docs.oracle.com/iaas/api/#/en/logan-api-spec/20200601/LogAnalyticsField/DeleteField").method(Method.DELETE).requestBuilder(DeleteFieldRequest::builder).basePath("/20200601").appendPathParam("namespaces").appendPathParam(request.getNamespaceName()).appendPathParam("fields").appendPathParam(request.getFieldName()).accept(new String[]{"application/json"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("if-match", request.getIfMatch()).handleResponseHeaderString("opc-request-id", DeleteFieldResponse.Builder::opcRequestId).operationUsesDefaultRetries().callSync();
    }

    @Override
    public DeleteIngestTimeRuleResponse deleteIngestTimeRule(DeleteIngestTimeRuleRequest request) {
        Validate.notBlank((String)request.getNamespaceName(), (String)"namespaceName must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getIngestTimeRuleId(), (String)"ingestTimeRuleId must not be blank", (Object[])new Object[0]);
        return (DeleteIngestTimeRuleResponse)this.clientCall(request, DeleteIngestTimeRuleResponse::builder).logger(LOG, "deleteIngestTimeRule").serviceDetails("LogAnalytics", "DeleteIngestTimeRule", "https://docs.oracle.com/iaas/api/#/en/logan-api-spec/20200601/IngestTimeRule/DeleteIngestTimeRule").method(Method.DELETE).requestBuilder(DeleteIngestTimeRuleRequest::builder).basePath("/20200601").appendPathParam("namespaces").appendPathParam(request.getNamespaceName()).appendPathParam("ingestTimeRules").appendPathParam(request.getIngestTimeRuleId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).handleResponseHeaderString("opc-request-id", DeleteIngestTimeRuleResponse.Builder::opcRequestId).operationUsesDefaultRetries().callSync();
    }

    @Override
    public DeleteLabelResponse deleteLabel(DeleteLabelRequest request) {
        Validate.notBlank((String)request.getNamespaceName(), (String)"namespaceName must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getLabelName(), (String)"labelName must not be blank", (Object[])new Object[0]);
        return (DeleteLabelResponse)this.clientCall(request, DeleteLabelResponse::builder).logger(LOG, "deleteLabel").serviceDetails("LogAnalytics", "DeleteLabel", "https://docs.oracle.com/iaas/api/#/en/logan-api-spec/20200601/LogAnalyticsLabel/DeleteLabel").method(Method.DELETE).requestBuilder(DeleteLabelRequest::builder).basePath("/20200601").appendPathParam("namespaces").appendPathParam(request.getNamespaceName()).appendPathParam("labels").appendPathParam(request.getLabelName()).accept(new String[]{"application/json;charset=UTF-8"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("if-match", request.getIfMatch()).handleResponseHeaderString("opc-request-id", DeleteLabelResponse.Builder::opcRequestId).operationUsesDefaultRetries().callSync();
    }

    @Override
    public DeleteLogAnalyticsEmBridgeResponse deleteLogAnalyticsEmBridge(DeleteLogAnalyticsEmBridgeRequest request) {
        Validate.notBlank((String)request.getNamespaceName(), (String)"namespaceName must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getLogAnalyticsEmBridgeId(), (String)"logAnalyticsEmBridgeId must not be blank", (Object[])new Object[0]);
        return (DeleteLogAnalyticsEmBridgeResponse)this.clientCall(request, DeleteLogAnalyticsEmBridgeResponse::builder).logger(LOG, "deleteLogAnalyticsEmBridge").serviceDetails("LogAnalytics", "DeleteLogAnalyticsEmBridge", "https://docs.oracle.com/iaas/api/#/en/logan-api-spec/20200601/LogAnalyticsEmBridge/DeleteLogAnalyticsEmBridge").method(Method.DELETE).requestBuilder(DeleteLogAnalyticsEmBridgeRequest::builder).basePath("/20200601").appendPathParam("namespaces").appendPathParam(request.getNamespaceName()).appendPathParam("logAnalyticsEmBridges").appendPathParam(request.getLogAnalyticsEmBridgeId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).handleResponseHeaderString("opc-request-id", DeleteLogAnalyticsEmBridgeResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public DeleteLogAnalyticsEntityResponse deleteLogAnalyticsEntity(DeleteLogAnalyticsEntityRequest request) {
        Validate.notBlank((String)request.getNamespaceName(), (String)"namespaceName must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getLogAnalyticsEntityId(), (String)"logAnalyticsEntityId must not be blank", (Object[])new Object[0]);
        return (DeleteLogAnalyticsEntityResponse)this.clientCall(request, DeleteLogAnalyticsEntityResponse::builder).logger(LOG, "deleteLogAnalyticsEntity").serviceDetails("LogAnalytics", "DeleteLogAnalyticsEntity", "https://docs.oracle.com/iaas/api/#/en/logan-api-spec/20200601/LogAnalyticsEntity/DeleteLogAnalyticsEntity").method(Method.DELETE).requestBuilder(DeleteLogAnalyticsEntityRequest::builder).basePath("/20200601").appendPathParam("namespaces").appendPathParam(request.getNamespaceName()).appendPathParam("logAnalyticsEntities").appendPathParam(request.getLogAnalyticsEntityId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).handleResponseHeaderString("opc-request-id", DeleteLogAnalyticsEntityResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public DeleteLogAnalyticsEntityTypeResponse deleteLogAnalyticsEntityType(DeleteLogAnalyticsEntityTypeRequest request) {
        Validate.notBlank((String)request.getNamespaceName(), (String)"namespaceName must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getEntityTypeName(), (String)"entityTypeName must not be blank", (Object[])new Object[0]);
        return (DeleteLogAnalyticsEntityTypeResponse)this.clientCall(request, DeleteLogAnalyticsEntityTypeResponse::builder).logger(LOG, "deleteLogAnalyticsEntityType").serviceDetails("LogAnalytics", "DeleteLogAnalyticsEntityType", "https://docs.oracle.com/iaas/api/#/en/logan-api-spec/20200601/LogAnalyticsEntityType/DeleteLogAnalyticsEntityType").method(Method.DELETE).requestBuilder(DeleteLogAnalyticsEntityTypeRequest::builder).basePath("/20200601").appendPathParam("namespaces").appendPathParam(request.getNamespaceName()).appendPathParam("logAnalyticsEntityTypes").appendPathParam(request.getEntityTypeName()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).handleResponseHeaderString("opc-request-id", DeleteLogAnalyticsEntityTypeResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public DeleteLogAnalyticsLogGroupResponse deleteLogAnalyticsLogGroup(DeleteLogAnalyticsLogGroupRequest request) {
        Validate.notBlank((String)request.getNamespaceName(), (String)"namespaceName must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getLogAnalyticsLogGroupId(), (String)"logAnalyticsLogGroupId must not be blank", (Object[])new Object[0]);
        return (DeleteLogAnalyticsLogGroupResponse)this.clientCall(request, DeleteLogAnalyticsLogGroupResponse::builder).logger(LOG, "deleteLogAnalyticsLogGroup").serviceDetails("LogAnalytics", "DeleteLogAnalyticsLogGroup", "https://docs.oracle.com/iaas/api/#/en/logan-api-spec/20200601/LogAnalyticsLogGroup/DeleteLogAnalyticsLogGroup").method(Method.DELETE).requestBuilder(DeleteLogAnalyticsLogGroupRequest::builder).basePath("/20200601").appendPathParam("namespaces").appendPathParam(request.getNamespaceName()).appendPathParam("logAnalyticsLogGroups").appendPathParam(request.getLogAnalyticsLogGroupId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).handleResponseHeaderString("opc-request-id", DeleteLogAnalyticsLogGroupResponse.Builder::opcRequestId).operationUsesDefaultRetries().callSync();
    }

    @Override
    public DeleteLogAnalyticsObjectCollectionRuleResponse deleteLogAnalyticsObjectCollectionRule(DeleteLogAnalyticsObjectCollectionRuleRequest request) {
        Validate.notBlank((String)request.getNamespaceName(), (String)"namespaceName must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getLogAnalyticsObjectCollectionRuleId(), (String)"logAnalyticsObjectCollectionRuleId must not be blank", (Object[])new Object[0]);
        return (DeleteLogAnalyticsObjectCollectionRuleResponse)this.clientCall(request, DeleteLogAnalyticsObjectCollectionRuleResponse::builder).logger(LOG, "deleteLogAnalyticsObjectCollectionRule").serviceDetails("LogAnalytics", "DeleteLogAnalyticsObjectCollectionRule", "https://docs.oracle.com/iaas/api/#/en/logan-api-spec/20200601/LogAnalyticsObjectCollectionRule/DeleteLogAnalyticsObjectCollectionRule").method(Method.DELETE).requestBuilder(DeleteLogAnalyticsObjectCollectionRuleRequest::builder).basePath("/20200601").appendPathParam("namespaces").appendPathParam(request.getNamespaceName()).appendPathParam("logAnalyticsObjectCollectionRules").appendPathParam(request.getLogAnalyticsObjectCollectionRuleId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("if-match", request.getIfMatch()).handleResponseHeaderString("opc-request-id", DeleteLogAnalyticsObjectCollectionRuleResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public DeleteLookupResponse deleteLookup(DeleteLookupRequest request) {
        Validate.notBlank((String)request.getNamespaceName(), (String)"namespaceName must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getLookupName(), (String)"lookupName must not be blank", (Object[])new Object[0]);
        return (DeleteLookupResponse)this.clientCall(request, DeleteLookupResponse::builder).logger(LOG, "deleteLookup").serviceDetails("LogAnalytics", "DeleteLookup", "https://docs.oracle.com/iaas/api/#/en/logan-api-spec/20200601/LogAnalyticsLookup/DeleteLookup").method(Method.DELETE).requestBuilder(DeleteLookupRequest::builder).basePath("/20200601").appendPathParam("namespaces").appendPathParam(request.getNamespaceName()).appendPathParam("lookups").appendPathParam(request.getLookupName()).appendQueryParam("isForce", (Object)request.getIsForce()).accept(new String[]{"application/json"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("if-match", request.getIfMatch()).handleResponseHeaderString("opc-work-request-id", DeleteLookupResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", DeleteLookupResponse.Builder::opcRequestId).operationUsesDefaultRetries().callSync();
    }

    @Override
    public DeleteParserResponse deleteParser(DeleteParserRequest request) {
        Validate.notBlank((String)request.getNamespaceName(), (String)"namespaceName must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getParserName(), (String)"parserName must not be blank", (Object[])new Object[0]);
        return (DeleteParserResponse)this.clientCall(request, DeleteParserResponse::builder).logger(LOG, "deleteParser").serviceDetails("LogAnalytics", "DeleteParser", "https://docs.oracle.com/iaas/api/#/en/logan-api-spec/20200601/LogAnalyticsParser/DeleteParser").method(Method.DELETE).requestBuilder(DeleteParserRequest::builder).basePath("/20200601").appendPathParam("namespaces").appendPathParam(request.getNamespaceName()).appendPathParam("parsers").appendPathParam(request.getParserName()).accept(new String[]{"application/json;charset=UTF-8"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("if-match", request.getIfMatch()).handleResponseHeaderString("opc-request-id", DeleteParserResponse.Builder::opcRequestId).operationUsesDefaultRetries().callSync();
    }

    @Override
    public DeleteScheduledTaskResponse deleteScheduledTask(DeleteScheduledTaskRequest request) {
        Validate.notBlank((String)request.getNamespaceName(), (String)"namespaceName must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getScheduledTaskId(), (String)"scheduledTaskId must not be blank", (Object[])new Object[0]);
        return (DeleteScheduledTaskResponse)this.clientCall(request, DeleteScheduledTaskResponse::builder).logger(LOG, "deleteScheduledTask").serviceDetails("LogAnalytics", "DeleteScheduledTask", "https://docs.oracle.com/iaas/api/#/en/logan-api-spec/20200601/ScheduledTask/DeleteScheduledTask").method(Method.DELETE).requestBuilder(DeleteScheduledTaskRequest::builder).basePath("/20200601").appendPathParam("namespaces").appendPathParam(request.getNamespaceName()).appendPathParam("scheduledTasks").appendPathParam(request.getScheduledTaskId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("if-match", request.getIfMatch()).handleResponseHeaderString("opc-request-id", DeleteScheduledTaskResponse.Builder::opcRequestId).operationUsesDefaultRetries().callSync();
    }

    @Override
    public DeleteSourceResponse deleteSource(DeleteSourceRequest request) {
        Validate.notBlank((String)request.getNamespaceName(), (String)"namespaceName must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getSourceName(), (String)"sourceName must not be blank", (Object[])new Object[0]);
        return (DeleteSourceResponse)this.clientCall(request, DeleteSourceResponse::builder).logger(LOG, "deleteSource").serviceDetails("LogAnalytics", "DeleteSource", "https://docs.oracle.com/iaas/api/#/en/logan-api-spec/20200601/LogAnalyticsSource/DeleteSource").method(Method.DELETE).requestBuilder(DeleteSourceRequest::builder).basePath("/20200601").appendPathParam("namespaces").appendPathParam(request.getNamespaceName()).appendPathParam("sources").appendPathParam(request.getSourceName()).accept(new String[]{"application/json"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("if-match", request.getIfMatch()).handleResponseHeaderString("opc-request-id", DeleteSourceResponse.Builder::opcRequestId).operationUsesDefaultRetries().callSync();
    }

    @Override
    public DeleteUploadResponse deleteUpload(DeleteUploadRequest request) {
        Validate.notBlank((String)request.getNamespaceName(), (String)"namespaceName must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getUploadReference(), (String)"uploadReference must not be blank", (Object[])new Object[0]);
        return (DeleteUploadResponse)this.clientCall(request, DeleteUploadResponse::builder).logger(LOG, "deleteUpload").serviceDetails("LogAnalytics", "DeleteUpload", "https://docs.oracle.com/iaas/api/#/en/logan-api-spec/20200601/Upload/DeleteUpload").method(Method.DELETE).requestBuilder(DeleteUploadRequest::builder).basePath("/20200601").appendPathParam("namespaces").appendPathParam(request.getNamespaceName()).appendPathParam("uploads").appendPathParam(request.getUploadReference()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).handleResponseHeaderString("opc-request-id", DeleteUploadResponse.Builder::opcRequestId).handleResponseHeaderLong("opc-deleted-log-count", DeleteUploadResponse.Builder::opcDeletedLogCount).handleResponseHeaderLong("opc-deleted-logfile-count", DeleteUploadResponse.Builder::opcDeletedLogfileCount).callSync();
    }

    @Override
    public DeleteUploadFileResponse deleteUploadFile(DeleteUploadFileRequest request) {
        Validate.notBlank((String)request.getNamespaceName(), (String)"namespaceName must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getUploadReference(), (String)"uploadReference must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getFileReference(), (String)"fileReference must not be blank", (Object[])new Object[0]);
        return (DeleteUploadFileResponse)this.clientCall(request, DeleteUploadFileResponse::builder).logger(LOG, "deleteUploadFile").serviceDetails("LogAnalytics", "DeleteUploadFile", "https://docs.oracle.com/iaas/api/#/en/logan-api-spec/20200601/Upload/DeleteUploadFile").method(Method.DELETE).requestBuilder(DeleteUploadFileRequest::builder).basePath("/20200601").appendPathParam("namespaces").appendPathParam(request.getNamespaceName()).appendPathParam("uploads").appendPathParam(request.getUploadReference()).appendPathParam("files").appendPathParam(request.getFileReference()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleResponseHeaderString("opc-request-id", DeleteUploadFileResponse.Builder::opcRequestId).handleResponseHeaderLong("opc-deleted-log-count", DeleteUploadFileResponse.Builder::opcDeletedLogCount).handleResponseHeaderLong("opc-deleted-logfile-count", DeleteUploadFileResponse.Builder::opcDeletedLogfileCount).callSync();
    }

    @Override
    public DeleteUploadWarningResponse deleteUploadWarning(DeleteUploadWarningRequest request) {
        Validate.notBlank((String)request.getNamespaceName(), (String)"namespaceName must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getUploadReference(), (String)"uploadReference must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getWarningReference(), (String)"warningReference must not be blank", (Object[])new Object[0]);
        return (DeleteUploadWarningResponse)this.clientCall(request, DeleteUploadWarningResponse::builder).logger(LOG, "deleteUploadWarning").serviceDetails("LogAnalytics", "DeleteUploadWarning", "https://docs.oracle.com/iaas/api/#/en/logan-api-spec/20200601/Upload/DeleteUploadWarning").method(Method.DELETE).requestBuilder(DeleteUploadWarningRequest::builder).basePath("/20200601").appendPathParam("namespaces").appendPathParam(request.getNamespaceName()).appendPathParam("uploads").appendPathParam(request.getUploadReference()).appendPathParam("warnings").appendPathParam(request.getWarningReference()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleResponseHeaderString("opc-request-id", DeleteUploadWarningResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public DisableArchivingResponse disableArchiving(DisableArchivingRequest request) {
        Validate.notBlank((String)request.getNamespaceName(), (String)"namespaceName must not be blank", (Object[])new Object[0]);
        return (DisableArchivingResponse)this.clientCall(request, DisableArchivingResponse::builder).logger(LOG, "disableArchiving").serviceDetails("LogAnalytics", "DisableArchiving", "https://docs.oracle.com/iaas/api/#/en/logan-api-spec/20200601/Storage/DisableArchiving").method(Method.POST).requestBuilder(DisableArchivingRequest::builder).basePath("/20200601").appendPathParam("namespaces").appendPathParam(request.getNamespaceName()).appendPathParam("storage").appendPathParam("actions").appendPathParam("disableArchiving").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("if-match", request.getIfMatch()).handleBody(Success.class, DisableArchivingResponse.Builder::success).handleResponseHeaderString("opc-request-id", DisableArchivingResponse.Builder::opcRequestId).handleResponseHeaderString("etag", DisableArchivingResponse.Builder::etag).operationUsesDefaultRetries().callSync();
    }

    @Override
    public DisableAutoAssociationResponse disableAutoAssociation(DisableAutoAssociationRequest request) {
        Validate.notBlank((String)request.getNamespaceName(), (String)"namespaceName must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getSourceName(), (String)"sourceName must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getDisableAutoAssociationDetails(), "disableAutoAssociationDetails is required");
        return (DisableAutoAssociationResponse)this.clientCall(request, DisableAutoAssociationResponse::builder).logger(LOG, "disableAutoAssociation").serviceDetails("LogAnalytics", "DisableAutoAssociation", "https://docs.oracle.com/iaas/api/#/en/logan-api-spec/20200601/LogAnalyticsSource/DisableAutoAssociation").method(Method.POST).requestBuilder(DisableAutoAssociationRequest::builder).basePath("/20200601").appendPathParam("namespaces").appendPathParam(request.getNamespaceName()).appendPathParam("sources").appendPathParam(request.getSourceName()).appendPathParam("actions").appendPathParam("disableAutoAssociation").accept(new String[]{"application/json"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleResponseHeaderString("opc-work-request-id", DisableAutoAssociationResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", DisableAutoAssociationResponse.Builder::opcRequestId).operationUsesDefaultRetries().callSync();
    }

    @Override
    public DisableIngestTimeRuleResponse disableIngestTimeRule(DisableIngestTimeRuleRequest request) {
        Validate.notBlank((String)request.getNamespaceName(), (String)"namespaceName must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getIngestTimeRuleId(), (String)"ingestTimeRuleId must not be blank", (Object[])new Object[0]);
        return (DisableIngestTimeRuleResponse)this.clientCall(request, DisableIngestTimeRuleResponse::builder).logger(LOG, "disableIngestTimeRule").serviceDetails("LogAnalytics", "DisableIngestTimeRule", "https://docs.oracle.com/iaas/api/#/en/logan-api-spec/20200601/IngestTimeRule/DisableIngestTimeRule").method(Method.POST).requestBuilder(DisableIngestTimeRuleRequest::builder).basePath("/20200601").appendPathParam("namespaces").appendPathParam(request.getNamespaceName()).appendPathParam("ingestTimeRules").appendPathParam(request.getIngestTimeRuleId()).appendPathParam("actions").appendPathParam("disableIngestTimeRule").accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).handleResponseHeaderString("opc-work-request-id", DisableIngestTimeRuleResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", DisableIngestTimeRuleResponse.Builder::opcRequestId).operationUsesDefaultRetries().callSync();
    }

    @Override
    public DisableSourceEventTypesResponse disableSourceEventTypes(DisableSourceEventTypesRequest request) {
        Validate.notBlank((String)request.getNamespaceName(), (String)"namespaceName must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getSourceName(), (String)"sourceName must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getDisableEventTypeDetails(), "disableEventTypeDetails is required");
        return (DisableSourceEventTypesResponse)this.clientCall(request, DisableSourceEventTypesResponse::builder).logger(LOG, "disableSourceEventTypes").serviceDetails("LogAnalytics", "DisableSourceEventTypes", "https://docs.oracle.com/iaas/api/#/en/logan-api-spec/20200601/LogAnalyticsSource/DisableSourceEventTypes").method(Method.POST).requestBuilder(DisableSourceEventTypesRequest::builder).basePath("/20200601").appendPathParam("namespaces").appendPathParam(request.getNamespaceName()).appendPathParam("sources").appendPathParam(request.getSourceName()).appendPathParam("actions").appendPathParam("disableEventTypes").accept(new String[]{"application/json"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleResponseHeaderString("opc-request-id", DisableSourceEventTypesResponse.Builder::opcRequestId).operationUsesDefaultRetries().callSync();
    }

    @Override
    public EnableArchivingResponse enableArchiving(EnableArchivingRequest request) {
        Validate.notBlank((String)request.getNamespaceName(), (String)"namespaceName must not be blank", (Object[])new Object[0]);
        return (EnableArchivingResponse)this.clientCall(request, EnableArchivingResponse::builder).logger(LOG, "enableArchiving").serviceDetails("LogAnalytics", "EnableArchiving", "https://docs.oracle.com/iaas/api/#/en/logan-api-spec/20200601/Storage/EnableArchiving").method(Method.POST).requestBuilder(EnableArchivingRequest::builder).basePath("/20200601").appendPathParam("namespaces").appendPathParam(request.getNamespaceName()).appendPathParam("storage").appendPathParam("actions").appendPathParam("enableArchiving").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("if-match", request.getIfMatch()).handleBody(Success.class, EnableArchivingResponse.Builder::success).handleResponseHeaderString("opc-request-id", EnableArchivingResponse.Builder::opcRequestId).handleResponseHeaderString("etag", EnableArchivingResponse.Builder::etag).operationUsesDefaultRetries().callSync();
    }

    @Override
    public EnableAutoAssociationResponse enableAutoAssociation(EnableAutoAssociationRequest request) {
        Validate.notBlank((String)request.getNamespaceName(), (String)"namespaceName must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getSourceName(), (String)"sourceName must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getEnableAutoAssociationDetails(), "enableAutoAssociationDetails is required");
        return (EnableAutoAssociationResponse)this.clientCall(request, EnableAutoAssociationResponse::builder).logger(LOG, "enableAutoAssociation").serviceDetails("LogAnalytics", "EnableAutoAssociation", "https://docs.oracle.com/iaas/api/#/en/logan-api-spec/20200601/LogAnalyticsSource/EnableAutoAssociation").method(Method.POST).requestBuilder(EnableAutoAssociationRequest::builder).basePath("/20200601").appendPathParam("namespaces").appendPathParam(request.getNamespaceName()).appendPathParam("sources").appendPathParam(request.getSourceName()).appendPathParam("actions").appendPathParam("enableAutoAssociation").accept(new String[]{"application/json"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleResponseHeaderString("opc-work-request-id", EnableAutoAssociationResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", EnableAutoAssociationResponse.Builder::opcRequestId).operationUsesDefaultRetries().callSync();
    }

    @Override
    public EnableIngestTimeRuleResponse enableIngestTimeRule(EnableIngestTimeRuleRequest request) {
        Validate.notBlank((String)request.getNamespaceName(), (String)"namespaceName must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getIngestTimeRuleId(), (String)"ingestTimeRuleId must not be blank", (Object[])new Object[0]);
        return (EnableIngestTimeRuleResponse)this.clientCall(request, EnableIngestTimeRuleResponse::builder).logger(LOG, "enableIngestTimeRule").serviceDetails("LogAnalytics", "EnableIngestTimeRule", "https://docs.oracle.com/iaas/api/#/en/logan-api-spec/20200601/IngestTimeRule/EnableIngestTimeRule").method(Method.POST).requestBuilder(EnableIngestTimeRuleRequest::builder).basePath("/20200601").appendPathParam("namespaces").appendPathParam(request.getNamespaceName()).appendPathParam("ingestTimeRules").appendPathParam(request.getIngestTimeRuleId()).appendPathParam("actions").appendPathParam("enableIngestTimeRule").accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).handleResponseHeaderString("opc-work-request-id", EnableIngestTimeRuleResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", EnableIngestTimeRuleResponse.Builder::opcRequestId).operationUsesDefaultRetries().callSync();
    }

    @Override
    public EnableSourceEventTypesResponse enableSourceEventTypes(EnableSourceEventTypesRequest request) {
        Validate.notBlank((String)request.getNamespaceName(), (String)"namespaceName must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getSourceName(), (String)"sourceName must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getEnableEventTypeDetails(), "enableEventTypeDetails is required");
        return (EnableSourceEventTypesResponse)this.clientCall(request, EnableSourceEventTypesResponse::builder).logger(LOG, "enableSourceEventTypes").serviceDetails("LogAnalytics", "EnableSourceEventTypes", "https://docs.oracle.com/iaas/api/#/en/logan-api-spec/20200601/LogAnalyticsSource/EnableSourceEventTypes").method(Method.POST).requestBuilder(EnableSourceEventTypesRequest::builder).basePath("/20200601").appendPathParam("namespaces").appendPathParam(request.getNamespaceName()).appendPathParam("sources").appendPathParam(request.getSourceName()).appendPathParam("actions").appendPathParam("enableEventTypes").accept(new String[]{"application/json"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleResponseHeaderString("opc-request-id", EnableSourceEventTypesResponse.Builder::opcRequestId).operationUsesDefaultRetries().callSync();
    }

    @Override
    public EstimatePurgeDataSizeResponse estimatePurgeDataSize(EstimatePurgeDataSizeRequest request) {
        Validate.notBlank((String)request.getNamespaceName(), (String)"namespaceName must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getEstimatePurgeDataSizeDetails(), "estimatePurgeDataSizeDetails is required");
        return (EstimatePurgeDataSizeResponse)this.clientCall(request, EstimatePurgeDataSizeResponse::builder).logger(LOG, "estimatePurgeDataSize").serviceDetails("LogAnalytics", "EstimatePurgeDataSize", "https://docs.oracle.com/iaas/api/#/en/logan-api-spec/20200601/Storage/EstimatePurgeDataSize").method(Method.POST).requestBuilder(EstimatePurgeDataSizeRequest::builder).basePath("/20200601").appendPathParam("namespaces").appendPathParam(request.getNamespaceName()).appendPathParam("storage").appendPathParam("actions").appendPathParam("estimatePurgeDataSize").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("if-match", request.getIfMatch()).hasBody().handleBody(EstimatePurgeDataSizeResult.class, EstimatePurgeDataSizeResponse.Builder::estimatePurgeDataSizeResult).handleResponseHeaderString("opc-request-id", EstimatePurgeDataSizeResponse.Builder::opcRequestId).handleResponseHeaderString("etag", EstimatePurgeDataSizeResponse.Builder::etag).operationUsesDefaultRetries().callSync();
    }

    @Override
    public EstimateRecallDataSizeResponse estimateRecallDataSize(EstimateRecallDataSizeRequest request) {
        Validate.notBlank((String)request.getNamespaceName(), (String)"namespaceName must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getEstimateRecallDataSizeDetails(), "estimateRecallDataSizeDetails is required");
        return (EstimateRecallDataSizeResponse)this.clientCall(request, EstimateRecallDataSizeResponse::builder).logger(LOG, "estimateRecallDataSize").serviceDetails("LogAnalytics", "EstimateRecallDataSize", "https://docs.oracle.com/iaas/api/#/en/logan-api-spec/20200601/Storage/EstimateRecallDataSize").method(Method.POST).requestBuilder(EstimateRecallDataSizeRequest::builder).basePath("/20200601").appendPathParam("namespaces").appendPathParam(request.getNamespaceName()).appendPathParam("storage").appendPathParam("actions").appendPathParam("estimateRecallDataSize").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleBody(EstimateRecallDataSizeResult.class, EstimateRecallDataSizeResponse.Builder::estimateRecallDataSizeResult).handleResponseHeaderString("opc-request-id", EstimateRecallDataSizeResponse.Builder::opcRequestId).operationUsesDefaultRetries().callSync();
    }

    @Override
    public EstimateReleaseDataSizeResponse estimateReleaseDataSize(EstimateReleaseDataSizeRequest request) {
        Validate.notBlank((String)request.getNamespaceName(), (String)"namespaceName must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getEstimateReleaseDataSizeDetails(), "estimateReleaseDataSizeDetails is required");
        return (EstimateReleaseDataSizeResponse)this.clientCall(request, EstimateReleaseDataSizeResponse::builder).logger(LOG, "estimateReleaseDataSize").serviceDetails("LogAnalytics", "EstimateReleaseDataSize", "https://docs.oracle.com/iaas/api/#/en/logan-api-spec/20200601/Storage/EstimateReleaseDataSize").method(Method.POST).requestBuilder(EstimateReleaseDataSizeRequest::builder).basePath("/20200601").appendPathParam("namespaces").appendPathParam(request.getNamespaceName()).appendPathParam("storage").appendPathParam("actions").appendPathParam("estimateReleaseDataSize").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleBody(EstimateReleaseDataSizeResult.class, EstimateReleaseDataSizeResponse.Builder::estimateReleaseDataSizeResult).handleResponseHeaderString("opc-request-id", EstimateReleaseDataSizeResponse.Builder::opcRequestId).operationUsesDefaultRetries().callSync();
    }

    @Override
    public ExportCustomContentResponse exportCustomContent(ExportCustomContentRequest request) {
        Validate.notBlank((String)request.getNamespaceName(), (String)"namespaceName must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getExportCustomContentDetails(), "exportCustomContentDetails is required");
        return (ExportCustomContentResponse)this.clientCall(request, ExportCustomContentResponse::builder).logger(LOG, "exportCustomContent").serviceDetails("LogAnalytics", "ExportCustomContent", "").method(Method.POST).requestBuilder(ExportCustomContentRequest::builder).basePath("/20200601").appendPathParam("namespaces").appendPathParam(request.getNamespaceName()).appendPathParam("contents").appendPathParam("actions").appendPathParam("exportCustomContent").accept(new String[]{"application/octet-stream"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleBody(InputStream.class, ExportCustomContentResponse.Builder::inputStream).handleResponseHeaderString("opc-request-id", ExportCustomContentResponse.Builder::opcRequestId).operationUsesDefaultRetries().callSync();
    }

    @Override
    public ExportQueryResultResponse exportQueryResult(ExportQueryResultRequest request) {
        Validate.notBlank((String)request.getNamespaceName(), (String)"namespaceName must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getExportDetails(), "exportDetails is required");
        return (ExportQueryResultResponse)this.clientCall(request, ExportQueryResultResponse::builder).logger(LOG, "exportQueryResult").serviceDetails("LogAnalytics", "ExportQueryResult", "https://docs.oracle.com/iaas/api/#/en/logan-api-spec/20200601/QueryDetails/ExportQueryResult").method(Method.POST).requestBuilder(ExportQueryResultRequest::builder).basePath("/20200601").appendPathParam("namespaces").appendPathParam(request.getNamespaceName()).appendPathParam("search").appendPathParam("actions").appendPathParam("export").accept(new String[]{"application/octet-stream"}).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleBody(InputStream.class, ExportQueryResultResponse.Builder::inputStream).handleResponseHeaderString("opc-request-id", ExportQueryResultResponse.Builder::opcRequestId).operationUsesDefaultRetries().callSync();
    }

    @Override
    public ExtractStructuredLogFieldPathsResponse extractStructuredLogFieldPaths(ExtractStructuredLogFieldPathsRequest request) {
        Validate.notBlank((String)request.getNamespaceName(), (String)"namespaceName must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getLoganParserDetails(), "loganParserDetails is required");
        return (ExtractStructuredLogFieldPathsResponse)this.clientCall(request, ExtractStructuredLogFieldPathsResponse::builder).logger(LOG, "extractStructuredLogFieldPaths").serviceDetails("LogAnalytics", "ExtractStructuredLogFieldPaths", "https://docs.oracle.com/iaas/api/#/en/logan-api-spec/20200601/LogAnalyticsParser/ExtractStructuredLogFieldPaths").method(Method.POST).requestBuilder(ExtractStructuredLogFieldPathsRequest::builder).basePath("/20200601").appendPathParam("namespaces").appendPathParam(request.getNamespaceName()).appendPathParam("parsers").appendPathParam("actions").appendPathParam("extractLogFieldPaths").appendEnumQueryParam("parserType", (BmcEnum)request.getParserType()).accept(new String[]{"application/json;charset=UTF-8"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleBody(ExtractLogFieldResults.class, ExtractStructuredLogFieldPathsResponse.Builder::extractLogFieldResults).handleResponseHeaderString("opc-request-id", ExtractStructuredLogFieldPathsResponse.Builder::opcRequestId).operationUsesDefaultRetries().callSync();
    }

    @Override
    public ExtractStructuredLogHeaderPathsResponse extractStructuredLogHeaderPaths(ExtractStructuredLogHeaderPathsRequest request) {
        Validate.notBlank((String)request.getNamespaceName(), (String)"namespaceName must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getLoganParserDetails(), "loganParserDetails is required");
        return (ExtractStructuredLogHeaderPathsResponse)this.clientCall(request, ExtractStructuredLogHeaderPathsResponse::builder).logger(LOG, "extractStructuredLogHeaderPaths").serviceDetails("LogAnalytics", "ExtractStructuredLogHeaderPaths", "https://docs.oracle.com/iaas/api/#/en/logan-api-spec/20200601/LogAnalyticsParser/ExtractStructuredLogHeaderPaths").method(Method.POST).requestBuilder(ExtractStructuredLogHeaderPathsRequest::builder).basePath("/20200601").appendPathParam("namespaces").appendPathParam(request.getNamespaceName()).appendPathParam("parsers").appendPathParam("actions").appendPathParam("extractLogHeaderPaths").appendEnumQueryParam("parserType", (BmcEnum)request.getParserType()).accept(new String[]{"application/json;charset=UTF-8"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleBody(ExtractLogHeaderResults.class, ExtractStructuredLogHeaderPathsResponse.Builder::extractLogHeaderResults).handleResponseHeaderString("opc-request-id", ExtractStructuredLogHeaderPathsResponse.Builder::opcRequestId).operationUsesDefaultRetries().callSync();
    }

    @Override
    public FilterResponse filter(FilterRequest request) {
        Validate.notBlank((String)request.getNamespaceName(), (String)"namespaceName must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getFilterDetails(), "filterDetails is required");
        return (FilterResponse)this.clientCall(request, FilterResponse::builder).logger(LOG, "filter").serviceDetails("LogAnalytics", "Filter", "https://docs.oracle.com/iaas/api/#/en/logan-api-spec/20200601/QueryDetails/Filter").method(Method.POST).requestBuilder(FilterRequest::builder).basePath("/20200601").appendPathParam("namespaces").appendPathParam(request.getNamespaceName()).appendPathParam("search").appendPathParam("actions").appendPathParam("filter").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleBody(FilterOutput.class, FilterResponse.Builder::filterOutput).handleResponseHeaderString("opc-request-id", FilterResponse.Builder::opcRequestId).operationUsesDefaultRetries().callSync();
    }

    @Override
    public GetAssociationSummaryResponse getAssociationSummary(GetAssociationSummaryRequest request) {
        Validate.notBlank((String)request.getNamespaceName(), (String)"namespaceName must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return (GetAssociationSummaryResponse)this.clientCall(request, GetAssociationSummaryResponse::builder).logger(LOG, "getAssociationSummary").serviceDetails("LogAnalytics", "GetAssociationSummary", "https://docs.oracle.com/iaas/api/#/en/logan-api-spec/20200601/LogAnalyticsAssociation/GetAssociationSummary").method(Method.GET).requestBuilder(GetAssociationSummaryRequest::builder).basePath("/20200601").appendPathParam("namespaces").appendPathParam(request.getNamespaceName()).appendPathParam("associationSummary").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).accept(new String[]{"application/json;charset=UTF-8"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(AssociationSummaryReport.class, GetAssociationSummaryResponse.Builder::associationSummaryReport).handleResponseHeaderString("opc-request-id", GetAssociationSummaryResponse.Builder::opcRequestId).operationUsesDefaultRetries().callSync();
    }

    @Override
    public GetCategoryResponse getCategory(GetCategoryRequest request) {
        Validate.notBlank((String)request.getNamespaceName(), (String)"namespaceName must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getCategoryName(), (String)"categoryName must not be blank", (Object[])new Object[0]);
        return (GetCategoryResponse)this.clientCall(request, GetCategoryResponse::builder).logger(LOG, "getCategory").serviceDetails("LogAnalytics", "GetCategory", "https://docs.oracle.com/iaas/api/#/en/logan-api-spec/20200601/LogAnalyticsCategory/GetCategory").method(Method.GET).requestBuilder(GetCategoryRequest::builder).basePath("/20200601").appendPathParam("namespaces").appendPathParam(request.getNamespaceName()).appendPathParam("categories").appendPathParam(request.getCategoryName()).accept(new String[]{"application/json;charset=UTF-8"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(LogAnalyticsCategory.class, GetCategoryResponse.Builder::logAnalyticsCategory).handleResponseHeaderString("opc-request-id", GetCategoryResponse.Builder::opcRequestId).operationUsesDefaultRetries().callSync();
    }

    @Override
    public GetColumnNamesResponse getColumnNames(GetColumnNamesRequest request) {
        Validate.notBlank((String)request.getNamespaceName(), (String)"namespaceName must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getSqlQuery(), "sqlQuery is required");
        return (GetColumnNamesResponse)this.clientCall(request, GetColumnNamesResponse::builder).logger(LOG, "getColumnNames").serviceDetails("LogAnalytics", "GetColumnNames", "https://docs.oracle.com/iaas/api/#/en/logan-api-spec/20200601/LogAnalyticsSource/GetColumnNames").method(Method.GET).requestBuilder(GetColumnNamesRequest::builder).basePath("/20200601").appendPathParam("namespaces").appendPathParam(request.getNamespaceName()).appendPathParam("sources").appendPathParam("sqlColumnNames").appendQueryParam("sqlQuery", (Object)request.getSqlQuery()).accept(new String[]{"application/json"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(ColumnNameCollection.class, GetColumnNamesResponse.Builder::columnNameCollection).handleResponseHeaderString("opc-request-id", GetColumnNamesResponse.Builder::opcRequestId).operationUsesDefaultRetries().callSync();
    }

    @Override
    public GetConfigWorkRequestResponse getConfigWorkRequest(GetConfigWorkRequestRequest request) {
        Validate.notBlank((String)request.getNamespaceName(), (String)"namespaceName must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getWorkRequestId(), (String)"workRequestId must not be blank", (Object[])new Object[0]);
        return (GetConfigWorkRequestResponse)this.clientCall(request, GetConfigWorkRequestResponse::builder).logger(LOG, "getConfigWorkRequest").serviceDetails("LogAnalytics", "GetConfigWorkRequest", "https://docs.oracle.com/iaas/api/#/en/logan-api-spec/20200601/LogAnalyticsConfigWorkRequest/GetConfigWorkRequest").method(Method.GET).requestBuilder(GetConfigWorkRequestRequest::builder).basePath("/20200601").appendPathParam("namespaces").appendPathParam(request.getNamespaceName()).appendPathParam("configWorkRequests").appendPathParam(request.getWorkRequestId()).accept(new String[]{"application/json;charset=UTF-8"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(LogAnalyticsConfigWorkRequest.class, GetConfigWorkRequestResponse.Builder::logAnalyticsConfigWorkRequest).handleResponseHeaderString("opc-request-id", GetConfigWorkRequestResponse.Builder::opcRequestId).operationUsesDefaultRetries().callSync();
    }

    @Override
    public GetFieldResponse getField(GetFieldRequest request) {
        Validate.notBlank((String)request.getNamespaceName(), (String)"namespaceName must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getFieldName(), (String)"fieldName must not be blank", (Object[])new Object[0]);
        return (GetFieldResponse)this.clientCall(request, GetFieldResponse::builder).logger(LOG, "getField").serviceDetails("LogAnalytics", "GetField", "https://docs.oracle.com/iaas/api/#/en/logan-api-spec/20200601/LogAnalyticsField/GetField").method(Method.GET).requestBuilder(GetFieldRequest::builder).basePath("/20200601").appendPathParam("namespaces").appendPathParam(request.getNamespaceName()).appendPathParam("fields").appendPathParam(request.getFieldName()).accept(new String[]{"application/json;charset=UTF-8"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(LogAnalyticsField.class, GetFieldResponse.Builder::logAnalyticsField).handleResponseHeaderString("etag", GetFieldResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetFieldResponse.Builder::opcRequestId).operationUsesDefaultRetries().callSync();
    }

    @Override
    public GetFieldsSummaryResponse getFieldsSummary(GetFieldsSummaryRequest request) {
        Validate.notBlank((String)request.getNamespaceName(), (String)"namespaceName must not be blank", (Object[])new Object[0]);
        return (GetFieldsSummaryResponse)this.clientCall(request, GetFieldsSummaryResponse::builder).logger(LOG, "getFieldsSummary").serviceDetails("LogAnalytics", "GetFieldsSummary", "https://docs.oracle.com/iaas/api/#/en/logan-api-spec/20200601/LogAnalyticsField/GetFieldsSummary").method(Method.GET).requestBuilder(GetFieldsSummaryRequest::builder).basePath("/20200601").appendPathParam("namespaces").appendPathParam(request.getNamespaceName()).appendPathParam("fieldSummary").appendQueryParam("isShowDetail", (Object)request.getIsShowDetail()).accept(new String[]{"application/json;charset=UTF-8"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(FieldSummaryReport.class, GetFieldsSummaryResponse.Builder::fieldSummaryReport).handleResponseHeaderString("opc-request-id", GetFieldsSummaryResponse.Builder::opcRequestId).operationUsesDefaultRetries().callSync();
    }

    @Override
    public GetIngestTimeRuleResponse getIngestTimeRule(GetIngestTimeRuleRequest request) {
        Validate.notBlank((String)request.getNamespaceName(), (String)"namespaceName must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getIngestTimeRuleId(), (String)"ingestTimeRuleId must not be blank", (Object[])new Object[0]);
        return (GetIngestTimeRuleResponse)this.clientCall(request, GetIngestTimeRuleResponse::builder).logger(LOG, "getIngestTimeRule").serviceDetails("LogAnalytics", "GetIngestTimeRule", "https://docs.oracle.com/iaas/api/#/en/logan-api-spec/20200601/IngestTimeRule/GetIngestTimeRule").method(Method.GET).requestBuilder(GetIngestTimeRuleRequest::builder).basePath("/20200601").appendPathParam("namespaces").appendPathParam(request.getNamespaceName()).appendPathParam("ingestTimeRules").appendPathParam(request.getIngestTimeRuleId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(IngestTimeRule.class, GetIngestTimeRuleResponse.Builder::ingestTimeRule).handleResponseHeaderString("etag", GetIngestTimeRuleResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetIngestTimeRuleResponse.Builder::opcRequestId).operationUsesDefaultRetries().callSync();
    }

    @Override
    public GetLabelResponse getLabel(GetLabelRequest request) {
        Validate.notBlank((String)request.getNamespaceName(), (String)"namespaceName must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getLabelName(), (String)"labelName must not be blank", (Object[])new Object[0]);
        return (GetLabelResponse)this.clientCall(request, GetLabelResponse::builder).logger(LOG, "getLabel").serviceDetails("LogAnalytics", "GetLabel", "https://docs.oracle.com/iaas/api/#/en/logan-api-spec/20200601/LogAnalyticsLabel/GetLabel").method(Method.GET).requestBuilder(GetLabelRequest::builder).basePath("/20200601").appendPathParam("namespaces").appendPathParam(request.getNamespaceName()).appendPathParam("labels").appendPathParam(request.getLabelName()).accept(new String[]{"application/json;charset=UTF-8"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(LogAnalyticsLabel.class, GetLabelResponse.Builder::logAnalyticsLabel).handleResponseHeaderString("etag", GetLabelResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetLabelResponse.Builder::opcRequestId).operationUsesDefaultRetries().callSync();
    }

    @Override
    public GetLabelSummaryResponse getLabelSummary(GetLabelSummaryRequest request) {
        Validate.notBlank((String)request.getNamespaceName(), (String)"namespaceName must not be blank", (Object[])new Object[0]);
        return (GetLabelSummaryResponse)this.clientCall(request, GetLabelSummaryResponse::builder).logger(LOG, "getLabelSummary").serviceDetails("LogAnalytics", "GetLabelSummary", "https://docs.oracle.com/iaas/api/#/en/logan-api-spec/20200601/LogAnalyticsLabel/GetLabelSummary").method(Method.GET).requestBuilder(GetLabelSummaryRequest::builder).basePath("/20200601").appendPathParam("namespaces").appendPathParam(request.getNamespaceName()).appendPathParam("labelSummary").accept(new String[]{"application/json;charset=UTF-8"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(LabelSummaryReport.class, GetLabelSummaryResponse.Builder::labelSummaryReport).handleResponseHeaderString("opc-request-id", GetLabelSummaryResponse.Builder::opcRequestId).operationUsesDefaultRetries().callSync();
    }

    @Override
    public GetLogAnalyticsEmBridgeResponse getLogAnalyticsEmBridge(GetLogAnalyticsEmBridgeRequest request) {
        Validate.notBlank((String)request.getNamespaceName(), (String)"namespaceName must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getLogAnalyticsEmBridgeId(), (String)"logAnalyticsEmBridgeId must not be blank", (Object[])new Object[0]);
        return (GetLogAnalyticsEmBridgeResponse)this.clientCall(request, GetLogAnalyticsEmBridgeResponse::builder).logger(LOG, "getLogAnalyticsEmBridge").serviceDetails("LogAnalytics", "GetLogAnalyticsEmBridge", "https://docs.oracle.com/iaas/api/#/en/logan-api-spec/20200601/LogAnalyticsEmBridge/GetLogAnalyticsEmBridge").method(Method.GET).requestBuilder(GetLogAnalyticsEmBridgeRequest::builder).basePath("/20200601").appendPathParam("namespaces").appendPathParam(request.getNamespaceName()).appendPathParam("logAnalyticsEmBridges").appendPathParam(request.getLogAnalyticsEmBridgeId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(LogAnalyticsEmBridge.class, GetLogAnalyticsEmBridgeResponse.Builder::logAnalyticsEmBridge).handleResponseHeaderString("etag", GetLogAnalyticsEmBridgeResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetLogAnalyticsEmBridgeResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public GetLogAnalyticsEmBridgeSummaryResponse getLogAnalyticsEmBridgeSummary(GetLogAnalyticsEmBridgeSummaryRequest request) {
        Validate.notBlank((String)request.getNamespaceName(), (String)"namespaceName must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return (GetLogAnalyticsEmBridgeSummaryResponse)this.clientCall(request, GetLogAnalyticsEmBridgeSummaryResponse::builder).logger(LOG, "getLogAnalyticsEmBridgeSummary").serviceDetails("LogAnalytics", "GetLogAnalyticsEmBridgeSummary", "https://docs.oracle.com/iaas/api/#/en/logan-api-spec/20200601/LogAnalyticsEmBridge/GetLogAnalyticsEmBridgeSummary").method(Method.GET).requestBuilder(GetLogAnalyticsEmBridgeSummaryRequest::builder).basePath("/20200601").appendPathParam("namespaces").appendPathParam(request.getNamespaceName()).appendPathParam("logAnalyticsEmBridges").appendPathParam("emBridgeSummary").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(LogAnalyticsEmBridgeSummaryReport.class, GetLogAnalyticsEmBridgeSummaryResponse.Builder::logAnalyticsEmBridgeSummaryReport).handleResponseHeaderString("opc-request-id", GetLogAnalyticsEmBridgeSummaryResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public GetLogAnalyticsEntitiesSummaryResponse getLogAnalyticsEntitiesSummary(GetLogAnalyticsEntitiesSummaryRequest request) {
        Validate.notBlank((String)request.getNamespaceName(), (String)"namespaceName must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return (GetLogAnalyticsEntitiesSummaryResponse)this.clientCall(request, GetLogAnalyticsEntitiesSummaryResponse::builder).logger(LOG, "getLogAnalyticsEntitiesSummary").serviceDetails("LogAnalytics", "GetLogAnalyticsEntitiesSummary", "https://docs.oracle.com/iaas/api/#/en/logan-api-spec/20200601/LogAnalyticsEntity/GetLogAnalyticsEntitiesSummary").method(Method.GET).requestBuilder(GetLogAnalyticsEntitiesSummaryRequest::builder).basePath("/20200601").appendPathParam("namespaces").appendPathParam(request.getNamespaceName()).appendPathParam("logAnalyticsEntities").appendPathParam("entitySummary").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(LogAnalyticsEntitySummaryReport.class, GetLogAnalyticsEntitiesSummaryResponse.Builder::logAnalyticsEntitySummaryReport).handleResponseHeaderString("opc-request-id", GetLogAnalyticsEntitiesSummaryResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public GetLogAnalyticsEntityResponse getLogAnalyticsEntity(GetLogAnalyticsEntityRequest request) {
        Validate.notBlank((String)request.getNamespaceName(), (String)"namespaceName must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getLogAnalyticsEntityId(), (String)"logAnalyticsEntityId must not be blank", (Object[])new Object[0]);
        return (GetLogAnalyticsEntityResponse)this.clientCall(request, GetLogAnalyticsEntityResponse::builder).logger(LOG, "getLogAnalyticsEntity").serviceDetails("LogAnalytics", "GetLogAnalyticsEntity", "https://docs.oracle.com/iaas/api/#/en/logan-api-spec/20200601/LogAnalyticsEntity/GetLogAnalyticsEntity").method(Method.GET).requestBuilder(GetLogAnalyticsEntityRequest::builder).basePath("/20200601").appendPathParam("namespaces").appendPathParam(request.getNamespaceName()).appendPathParam("logAnalyticsEntities").appendPathParam(request.getLogAnalyticsEntityId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(LogAnalyticsEntity.class, GetLogAnalyticsEntityResponse.Builder::logAnalyticsEntity).handleResponseHeaderString("etag", GetLogAnalyticsEntityResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetLogAnalyticsEntityResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public GetLogAnalyticsEntityTypeResponse getLogAnalyticsEntityType(GetLogAnalyticsEntityTypeRequest request) {
        Validate.notBlank((String)request.getNamespaceName(), (String)"namespaceName must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getEntityTypeName(), (String)"entityTypeName must not be blank", (Object[])new Object[0]);
        return (GetLogAnalyticsEntityTypeResponse)this.clientCall(request, GetLogAnalyticsEntityTypeResponse::builder).logger(LOG, "getLogAnalyticsEntityType").serviceDetails("LogAnalytics", "GetLogAnalyticsEntityType", "https://docs.oracle.com/iaas/api/#/en/logan-api-spec/20200601/LogAnalyticsEntityType/GetLogAnalyticsEntityType").method(Method.GET).requestBuilder(GetLogAnalyticsEntityTypeRequest::builder).basePath("/20200601").appendPathParam("namespaces").appendPathParam(request.getNamespaceName()).appendPathParam("logAnalyticsEntityTypes").appendPathParam(request.getEntityTypeName()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(LogAnalyticsEntityType.class, GetLogAnalyticsEntityTypeResponse.Builder::logAnalyticsEntityType).handleResponseHeaderString("etag", GetLogAnalyticsEntityTypeResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetLogAnalyticsEntityTypeResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public GetLogAnalyticsLogGroupResponse getLogAnalyticsLogGroup(GetLogAnalyticsLogGroupRequest request) {
        Validate.notBlank((String)request.getNamespaceName(), (String)"namespaceName must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getLogAnalyticsLogGroupId(), (String)"logAnalyticsLogGroupId must not be blank", (Object[])new Object[0]);
        return (GetLogAnalyticsLogGroupResponse)this.clientCall(request, GetLogAnalyticsLogGroupResponse::builder).logger(LOG, "getLogAnalyticsLogGroup").serviceDetails("LogAnalytics", "GetLogAnalyticsLogGroup", "https://docs.oracle.com/iaas/api/#/en/logan-api-spec/20200601/LogAnalyticsLogGroup/GetLogAnalyticsLogGroup").method(Method.GET).requestBuilder(GetLogAnalyticsLogGroupRequest::builder).basePath("/20200601").appendPathParam("namespaces").appendPathParam(request.getNamespaceName()).appendPathParam("logAnalyticsLogGroups").appendPathParam(request.getLogAnalyticsLogGroupId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(LogAnalyticsLogGroup.class, GetLogAnalyticsLogGroupResponse.Builder::logAnalyticsLogGroup).handleResponseHeaderString("etag", GetLogAnalyticsLogGroupResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetLogAnalyticsLogGroupResponse.Builder::opcRequestId).operationUsesDefaultRetries().callSync();
    }

    @Override
    public GetLogAnalyticsLogGroupsSummaryResponse getLogAnalyticsLogGroupsSummary(GetLogAnalyticsLogGroupsSummaryRequest request) {
        Validate.notBlank((String)request.getNamespaceName(), (String)"namespaceName must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return (GetLogAnalyticsLogGroupsSummaryResponse)this.clientCall(request, GetLogAnalyticsLogGroupsSummaryResponse::builder).logger(LOG, "getLogAnalyticsLogGroupsSummary").serviceDetails("LogAnalytics", "GetLogAnalyticsLogGroupsSummary", "https://docs.oracle.com/iaas/api/#/en/logan-api-spec/20200601/LogAnalyticsLogGroup/GetLogAnalyticsLogGroupsSummary").method(Method.GET).requestBuilder(GetLogAnalyticsLogGroupsSummaryRequest::builder).basePath("/20200601").appendPathParam("namespaces").appendPathParam(request.getNamespaceName()).appendPathParam("logAnalyticsLogGroupsSummary").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(LogGroupSummaryReport.class, GetLogAnalyticsLogGroupsSummaryResponse.Builder::logGroupSummaryReport).handleResponseHeaderString("opc-request-id", GetLogAnalyticsLogGroupsSummaryResponse.Builder::opcRequestId).operationUsesDefaultRetries().callSync();
    }

    @Override
    public GetLogAnalyticsObjectCollectionRuleResponse getLogAnalyticsObjectCollectionRule(GetLogAnalyticsObjectCollectionRuleRequest request) {
        Validate.notBlank((String)request.getNamespaceName(), (String)"namespaceName must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getLogAnalyticsObjectCollectionRuleId(), (String)"logAnalyticsObjectCollectionRuleId must not be blank", (Object[])new Object[0]);
        return (GetLogAnalyticsObjectCollectionRuleResponse)this.clientCall(request, GetLogAnalyticsObjectCollectionRuleResponse::builder).logger(LOG, "getLogAnalyticsObjectCollectionRule").serviceDetails("LogAnalytics", "GetLogAnalyticsObjectCollectionRule", "https://docs.oracle.com/iaas/api/#/en/logan-api-spec/20200601/LogAnalyticsObjectCollectionRule/GetLogAnalyticsObjectCollectionRule").method(Method.GET).requestBuilder(GetLogAnalyticsObjectCollectionRuleRequest::builder).basePath("/20200601").appendPathParam("namespaces").appendPathParam(request.getNamespaceName()).appendPathParam("logAnalyticsObjectCollectionRules").appendPathParam(request.getLogAnalyticsObjectCollectionRuleId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(LogAnalyticsObjectCollectionRule.class, GetLogAnalyticsObjectCollectionRuleResponse.Builder::logAnalyticsObjectCollectionRule).handleResponseHeaderString("etag", GetLogAnalyticsObjectCollectionRuleResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetLogAnalyticsObjectCollectionRuleResponse.Builder::opcRequestId).operationUsesDefaultRetries().callSync();
    }

    @Override
    public GetLogSetsCountResponse getLogSetsCount(GetLogSetsCountRequest request) {
        Validate.notBlank((String)request.getNamespaceName(), (String)"namespaceName must not be blank", (Object[])new Object[0]);
        return (GetLogSetsCountResponse)this.clientCall(request, GetLogSetsCountResponse::builder).logger(LOG, "getLogSetsCount").serviceDetails("LogAnalytics", "GetLogSetsCount", "https://docs.oracle.com/iaas/api/#/en/logan-api-spec/20200601/Storage/GetLogSetsCount").method(Method.GET).requestBuilder(GetLogSetsCountRequest::builder).basePath("/20200601").appendPathParam("namespaces").appendPathParam(request.getNamespaceName()).appendPathParam("storage").appendPathParam("logSetsCount").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(LogSetsCount.class, GetLogSetsCountResponse.Builder::logSetsCount).handleResponseHeaderString("opc-request-id", GetLogSetsCountResponse.Builder::opcRequestId).operationUsesDefaultRetries().callSync();
    }

    @Override
    public GetLookupResponse getLookup(GetLookupRequest request) {
        Validate.notBlank((String)request.getNamespaceName(), (String)"namespaceName must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getLookupName(), (String)"lookupName must not be blank", (Object[])new Object[0]);
        return (GetLookupResponse)this.clientCall(request, GetLookupResponse::builder).logger(LOG, "getLookup").serviceDetails("LogAnalytics", "GetLookup", "https://docs.oracle.com/iaas/api/#/en/logan-api-spec/20200601/LogAnalyticsLookup/GetLookup").method(Method.GET).requestBuilder(GetLookupRequest::builder).basePath("/20200601").appendPathParam("namespaces").appendPathParam(request.getNamespaceName()).appendPathParam("lookups").appendPathParam(request.getLookupName()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(LogAnalyticsLookup.class, GetLookupResponse.Builder::logAnalyticsLookup).handleResponseHeaderString("etag", GetLookupResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetLookupResponse.Builder::opcRequestId).operationUsesDefaultRetries().callSync();
    }

    @Override
    public GetLookupSummaryResponse getLookupSummary(GetLookupSummaryRequest request) {
        Validate.notBlank((String)request.getNamespaceName(), (String)"namespaceName must not be blank", (Object[])new Object[0]);
        return (GetLookupSummaryResponse)this.clientCall(request, GetLookupSummaryResponse::builder).logger(LOG, "getLookupSummary").serviceDetails("LogAnalytics", "GetLookupSummary", "https://docs.oracle.com/iaas/api/#/en/logan-api-spec/20200601/LogAnalyticsLookup/GetLookupSummary").method(Method.GET).requestBuilder(GetLookupSummaryRequest::builder).basePath("/20200601").appendPathParam("namespaces").appendPathParam(request.getNamespaceName()).appendPathParam("lookupSummary").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(LookupSummaryReport.class, GetLookupSummaryResponse.Builder::lookupSummaryReport).handleResponseHeaderString("opc-request-id", GetLookupSummaryResponse.Builder::opcRequestId).operationUsesDefaultRetries().callSync();
    }

    @Override
    public GetNamespaceResponse getNamespace(GetNamespaceRequest request) {
        Validate.notBlank((String)request.getNamespaceName(), (String)"namespaceName must not be blank", (Object[])new Object[0]);
        return (GetNamespaceResponse)this.clientCall(request, GetNamespaceResponse::builder).logger(LOG, "getNamespace").serviceDetails("LogAnalytics", "GetNamespace", "https://docs.oracle.com/iaas/api/#/en/logan-api-spec/20200601/Namespace/GetNamespace").method(Method.GET).requestBuilder(GetNamespaceRequest::builder).basePath("/20200601").appendPathParam("namespaces").appendPathParam(request.getNamespaceName()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(Namespace.class, GetNamespaceResponse.Builder::namespace).handleResponseHeaderString("opc-request-id", GetNamespaceResponse.Builder::opcRequestId).handleResponseHeaderString("etag", GetNamespaceResponse.Builder::etag).operationUsesDefaultRetries().callSync();
    }

    @Override
    public GetParserResponse getParser(GetParserRequest request) {
        Validate.notBlank((String)request.getNamespaceName(), (String)"namespaceName must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getParserName(), (String)"parserName must not be blank", (Object[])new Object[0]);
        return (GetParserResponse)this.clientCall(request, GetParserResponse::builder).logger(LOG, "getParser").serviceDetails("LogAnalytics", "GetParser", "https://docs.oracle.com/iaas/api/#/en/logan-api-spec/20200601/LogAnalyticsParser/GetParser").method(Method.GET).requestBuilder(GetParserRequest::builder).basePath("/20200601").appendPathParam("namespaces").appendPathParam(request.getNamespaceName()).appendPathParam("parsers").appendPathParam(request.getParserName()).accept(new String[]{"application/json;charset=UTF-8"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(LogAnalyticsParser.class, GetParserResponse.Builder::logAnalyticsParser).handleResponseHeaderString("etag", GetParserResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetParserResponse.Builder::opcRequestId).operationUsesDefaultRetries().callSync();
    }

    @Override
    public GetParserSummaryResponse getParserSummary(GetParserSummaryRequest request) {
        Validate.notBlank((String)request.getNamespaceName(), (String)"namespaceName must not be blank", (Object[])new Object[0]);
        return (GetParserSummaryResponse)this.clientCall(request, GetParserSummaryResponse::builder).logger(LOG, "getParserSummary").serviceDetails("LogAnalytics", "GetParserSummary", "https://docs.oracle.com/iaas/api/#/en/logan-api-spec/20200601/LogAnalyticsParser/GetParserSummary").method(Method.GET).requestBuilder(GetParserSummaryRequest::builder).basePath("/20200601").appendPathParam("namespaces").appendPathParam(request.getNamespaceName()).appendPathParam("parsersSummary").accept(new String[]{"application/json;charset=UTF-8"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(ParserSummaryReport.class, GetParserSummaryResponse.Builder::parserSummaryReport).handleResponseHeaderString("opc-request-id", GetParserSummaryResponse.Builder::opcRequestId).operationUsesDefaultRetries().callSync();
    }

    @Override
    public GetPreferencesResponse getPreferences(GetPreferencesRequest request) {
        Validate.notBlank((String)request.getNamespaceName(), (String)"namespaceName must not be blank", (Object[])new Object[0]);
        return (GetPreferencesResponse)this.clientCall(request, GetPreferencesResponse::builder).logger(LOG, "getPreferences").serviceDetails("LogAnalytics", "GetPreferences", "https://docs.oracle.com/iaas/api/#/en/logan-api-spec/20200601/LogAnalyticsPreference/GetPreferences").method(Method.GET).requestBuilder(GetPreferencesRequest::builder).basePath("/20200601").appendPathParam("namespaces").appendPathParam(request.getNamespaceName()).appendPathParam("preferences").appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).accept(new String[]{"application/json;charset=UTF-8"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(LogAnalyticsPreferenceCollection.class, GetPreferencesResponse.Builder::logAnalyticsPreferenceCollection).handleResponseHeaderString("opc-prev-page", GetPreferencesResponse.Builder::opcPrevPage).handleResponseHeaderString("opc-next-page", GetPreferencesResponse.Builder::opcNextPage).handleResponseHeaderString("opc-request-id", GetPreferencesResponse.Builder::opcRequestId).operationUsesDefaultRetries().callSync();
    }

    @Override
    public GetQueryResultResponse getQueryResult(GetQueryResultRequest request) {
        Validate.notBlank((String)request.getNamespaceName(), (String)"namespaceName must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getWorkRequestId(), "workRequestId is required");
        return (GetQueryResultResponse)this.clientCall(request, GetQueryResultResponse::builder).logger(LOG, "getQueryResult").serviceDetails("LogAnalytics", "GetQueryResult", "https://docs.oracle.com/iaas/api/#/en/logan-api-spec/20200601/QueryDetails/GetQueryResult").method(Method.GET).requestBuilder(GetQueryResultRequest::builder).basePath("/20200601").appendPathParam("namespaces").appendPathParam(request.getNamespaceName()).appendPathParam("search").appendPathParam("actions").appendPathParam("query").appendQueryParam("workRequestId", (Object)request.getWorkRequestId()).appendQueryParam("page", (Object)request.getPage()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("shouldIncludeColumns", (Object)request.getShouldIncludeColumns()).appendQueryParam("shouldIncludeFields", (Object)request.getShouldIncludeFields()).appendEnumQueryParam("outputMode", (BmcEnum)request.getOutputMode()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(QueryAggregation.class, GetQueryResultResponse.Builder::queryAggregation).handleResponseHeaderString("opc-request-id", GetQueryResultResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", GetQueryResultResponse.Builder::opcNextPage).handleResponseHeaderString("opc-prev-page", GetQueryResultResponse.Builder::opcPrevPage).handleResponseHeaderFloat("retry-after", GetQueryResultResponse.Builder::retryAfter).operationUsesDefaultRetries().callSync();
    }

    @Override
    public GetQueryWorkRequestResponse getQueryWorkRequest(GetQueryWorkRequestRequest request) {
        Validate.notBlank((String)request.getNamespaceName(), (String)"namespaceName must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getWorkRequestId(), (String)"workRequestId must not be blank", (Object[])new Object[0]);
        return (GetQueryWorkRequestResponse)this.clientCall(request, GetQueryWorkRequestResponse::builder).logger(LOG, "getQueryWorkRequest").serviceDetails("LogAnalytics", "GetQueryWorkRequest", "https://docs.oracle.com/iaas/api/#/en/logan-api-spec/20200601/QueryWorkRequest/GetQueryWorkRequest").method(Method.GET).requestBuilder(GetQueryWorkRequestRequest::builder).basePath("/20200601").appendPathParam("namespaces").appendPathParam(request.getNamespaceName()).appendPathParam("queryWorkRequests").appendPathParam(request.getWorkRequestId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(QueryWorkRequest.class, GetQueryWorkRequestResponse.Builder::queryWorkRequest).handleResponseHeaderString("opc-request-id", GetQueryWorkRequestResponse.Builder::opcRequestId).handleResponseHeaderString("etag", GetQueryWorkRequestResponse.Builder::etag).handleResponseHeaderFloat("retry-after", GetQueryWorkRequestResponse.Builder::retryAfter).operationUsesDefaultRetries().callSync();
    }

    @Override
    public GetScheduledTaskResponse getScheduledTask(GetScheduledTaskRequest request) {
        Validate.notBlank((String)request.getNamespaceName(), (String)"namespaceName must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getScheduledTaskId(), (String)"scheduledTaskId must not be blank", (Object[])new Object[0]);
        return (GetScheduledTaskResponse)this.clientCall(request, GetScheduledTaskResponse::builder).logger(LOG, "getScheduledTask").serviceDetails("LogAnalytics", "GetScheduledTask", "https://docs.oracle.com/iaas/api/#/en/logan-api-spec/20200601/ScheduledTask/GetScheduledTask").method(Method.GET).requestBuilder(GetScheduledTaskRequest::builder).basePath("/20200601").appendPathParam("namespaces").appendPathParam(request.getNamespaceName()).appendPathParam("scheduledTasks").appendPathParam(request.getScheduledTaskId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(ScheduledTask.class, GetScheduledTaskResponse.Builder::scheduledTask).handleResponseHeaderString("opc-request-id", GetScheduledTaskResponse.Builder::opcRequestId).handleResponseHeaderString("etag", GetScheduledTaskResponse.Builder::etag).operationUsesDefaultRetries().callSync();
    }

    @Override
    public GetSourceResponse getSource(GetSourceRequest request) {
        Validate.notBlank((String)request.getNamespaceName(), (String)"namespaceName must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getSourceName(), (String)"sourceName must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return (GetSourceResponse)this.clientCall(request, GetSourceResponse::builder).logger(LOG, "getSource").serviceDetails("LogAnalytics", "GetSource", "https://docs.oracle.com/iaas/api/#/en/logan-api-spec/20200601/LogAnalyticsSource/GetSource").method(Method.GET).requestBuilder(GetSourceRequest::builder).basePath("/20200601").appendPathParam("namespaces").appendPathParam(request.getNamespaceName()).appendPathParam("sources").appendPathParam(request.getSourceName()).appendQueryParam("compartmentId", (Object)request.getCompartmentId()).accept(new String[]{"application/json;charset=UTF-8"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(LogAnalyticsSource.class, GetSourceResponse.Builder::logAnalyticsSource).handleResponseHeaderString("etag", GetSourceResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetSourceResponse.Builder::opcRequestId).operationUsesDefaultRetries().callSync();
    }

    @Override
    public GetSourceSummaryResponse getSourceSummary(GetSourceSummaryRequest request) {
        Validate.notBlank((String)request.getNamespaceName(), (String)"namespaceName must not be blank", (Object[])new Object[0]);
        return (GetSourceSummaryResponse)this.clientCall(request, GetSourceSummaryResponse::builder).logger(LOG, "getSourceSummary").serviceDetails("LogAnalytics", "GetSourceSummary", "https://docs.oracle.com/iaas/api/#/en/logan-api-spec/20200601/LogAnalyticsSource/GetSourceSummary").method(Method.GET).requestBuilder(GetSourceSummaryRequest::builder).basePath("/20200601").appendPathParam("namespaces").appendPathParam(request.getNamespaceName()).appendPathParam("sourceSummary").accept(new String[]{"application/json;charset=UTF-8"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(SourceSummaryReport.class, GetSourceSummaryResponse.Builder::sourceSummaryReport).handleResponseHeaderString("opc-request-id", GetSourceSummaryResponse.Builder::opcRequestId).operationUsesDefaultRetries().callSync();
    }

    @Override
    public GetStorageResponse getStorage(GetStorageRequest request) {
        Validate.notBlank((String)request.getNamespaceName(), (String)"namespaceName must not be blank", (Object[])new Object[0]);
        return (GetStorageResponse)this.clientCall(request, GetStorageResponse::builder).logger(LOG, "getStorage").serviceDetails("LogAnalytics", "GetStorage", "https://docs.oracle.com/iaas/api/#/en/logan-api-spec/20200601/Storage/GetStorage").method(Method.GET).requestBuilder(GetStorageRequest::builder).basePath("/20200601").appendPathParam("namespaces").appendPathParam(request.getNamespaceName()).appendPathParam("storage").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(Storage.class, GetStorageResponse.Builder::storage).handleResponseHeaderString("opc-request-id", GetStorageResponse.Builder::opcRequestId).handleResponseHeaderString("etag", GetStorageResponse.Builder::etag).operationUsesDefaultRetries().callSync();
    }

    @Override
    public GetStorageUsageResponse getStorageUsage(GetStorageUsageRequest request) {
        Validate.notBlank((String)request.getNamespaceName(), (String)"namespaceName must not be blank", (Object[])new Object[0]);
        return (GetStorageUsageResponse)this.clientCall(request, GetStorageUsageResponse::builder).logger(LOG, "getStorageUsage").serviceDetails("LogAnalytics", "GetStorageUsage", "https://docs.oracle.com/iaas/api/#/en/logan-api-spec/20200601/Storage/GetStorageUsage").method(Method.GET).requestBuilder(GetStorageUsageRequest::builder).basePath("/20200601").appendPathParam("namespaces").appendPathParam(request.getNamespaceName()).appendPathParam("storage").appendPathParam("usage").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(StorageUsage.class, GetStorageUsageResponse.Builder::storageUsage).handleResponseHeaderString("opc-request-id", GetStorageUsageResponse.Builder::opcRequestId).operationUsesDefaultRetries().callSync();
    }

    @Override
    public GetStorageWorkRequestResponse getStorageWorkRequest(GetStorageWorkRequestRequest request) {
        Validate.notBlank((String)request.getWorkRequestId(), (String)"workRequestId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getNamespaceName(), (String)"namespaceName must not be blank", (Object[])new Object[0]);
        return (GetStorageWorkRequestResponse)this.clientCall(request, GetStorageWorkRequestResponse::builder).logger(LOG, "getStorageWorkRequest").serviceDetails("LogAnalytics", "GetStorageWorkRequest", "https://docs.oracle.com/iaas/api/#/en/logan-api-spec/20200601/Storage/GetStorageWorkRequest").method(Method.GET).requestBuilder(GetStorageWorkRequestRequest::builder).basePath("/20200601").appendPathParam("namespaces").appendPathParam(request.getNamespaceName()).appendPathParam("storageWorkRequests").appendPathParam(request.getWorkRequestId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(StorageWorkRequest.class, GetStorageWorkRequestResponse.Builder::storageWorkRequest).handleResponseHeaderString("opc-request-id", GetStorageWorkRequestResponse.Builder::opcRequestId).handleResponseHeaderString("etag", GetStorageWorkRequestResponse.Builder::etag).handleResponseHeaderFloat("retry-after", GetStorageWorkRequestResponse.Builder::retryAfter).operationUsesDefaultRetries().callSync();
    }

    @Override
    public GetUnprocessedDataBucketResponse getUnprocessedDataBucket(GetUnprocessedDataBucketRequest request) {
        Validate.notBlank((String)request.getNamespaceName(), (String)"namespaceName must not be blank", (Object[])new Object[0]);
        return (GetUnprocessedDataBucketResponse)this.clientCall(request, GetUnprocessedDataBucketResponse::builder).logger(LOG, "getUnprocessedDataBucket").serviceDetails("LogAnalytics", "GetUnprocessedDataBucket", "https://docs.oracle.com/iaas/api/#/en/logan-api-spec/20200601/Upload/GetUnprocessedDataBucket").method(Method.GET).requestBuilder(GetUnprocessedDataBucketRequest::builder).basePath("/20200601").appendPathParam("namespaces").appendPathParam(request.getNamespaceName()).appendPathParam("unprocessedDataBucket").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(UnprocessedDataBucket.class, GetUnprocessedDataBucketResponse.Builder::unprocessedDataBucket).handleResponseHeaderString("opc-request-id", GetUnprocessedDataBucketResponse.Builder::opcRequestId).operationUsesDefaultRetries().callSync();
    }

    @Override
    public GetUploadResponse getUpload(GetUploadRequest request) {
        Validate.notBlank((String)request.getNamespaceName(), (String)"namespaceName must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getUploadReference(), (String)"uploadReference must not be blank", (Object[])new Object[0]);
        return (GetUploadResponse)this.clientCall(request, GetUploadResponse::builder).logger(LOG, "getUpload").serviceDetails("LogAnalytics", "GetUpload", "https://docs.oracle.com/iaas/api/#/en/logan-api-spec/20200601/Upload/GetUpload").method(Method.GET).requestBuilder(GetUploadRequest::builder).basePath("/20200601").appendPathParam("namespaces").appendPathParam(request.getNamespaceName()).appendPathParam("uploads").appendPathParam(request.getUploadReference()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(Upload.class, GetUploadResponse.Builder::upload).handleResponseHeaderString("etag", GetUploadResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetUploadResponse.Builder::opcRequestId).operationUsesDefaultRetries().callSync();
    }

    @Override
    public GetWorkRequestResponse getWorkRequest(GetWorkRequestRequest request) {
        Validate.notBlank((String)request.getNamespaceName(), (String)"namespaceName must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getWorkRequestId(), (String)"workRequestId must not be blank", (Object[])new Object[0]);
        return (GetWorkRequestResponse)this.clientCall(request, GetWorkRequestResponse::builder).logger(LOG, "getWorkRequest").serviceDetails("LogAnalytics", "GetWorkRequest", "https://docs.oracle.com/iaas/api/#/en/logan-api-spec/20200601/WorkRequest/GetWorkRequest").method(Method.GET).requestBuilder(GetWorkRequestRequest::builder).basePath("/20200601").appendPathParam("namespaces").appendPathParam(request.getNamespaceName()).appendPathParam("workRequests").appendPathParam(request.getWorkRequestId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(WorkRequest.class, GetWorkRequestResponse.Builder::workRequest).handleResponseHeaderString("opc-request-id", GetWorkRequestResponse.Builder::opcRequestId).handleResponseHeaderFloat("retry-after", GetWorkRequestResponse.Builder::retryAfter).callSync();
    }

    @Override
    public ImportCustomContentResponse importCustomContent(ImportCustomContentRequest request) {
        Validate.notBlank((String)request.getNamespaceName(), (String)"namespaceName must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getImportCustomContentFileBody(), "importCustomContentFileBody is required");
        return (ImportCustomContentResponse)this.clientCall(request, ImportCustomContentResponse::builder).logger(LOG, "importCustomContent").serviceDetails("LogAnalytics", "ImportCustomContent", "https://docs.oracle.com/iaas/api/#/en/logan-api-spec/20200601/LogAnalyticsImportCustomContent/ImportCustomContent").method(Method.POST).requestBuilder(ImportCustomContentRequest::builder).basePath("/20200601").appendPathParam("namespaces").appendPathParam(request.getNamespaceName()).appendPathParam("contents").appendPathParam("actions").appendPathParam("importCustomContent").appendQueryParam("isOverwrite", (Object)request.getIsOverwrite()).accept(new String[]{"application/json;charset=UTF-8"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("expect", request.getExpect()).hasBinaryRequestBody().hasBody().handleBody(LogAnalyticsImportCustomContent.class, ImportCustomContentResponse.Builder::logAnalyticsImportCustomContent).handleResponseHeaderString("opc-request-id", ImportCustomContentResponse.Builder::opcRequestId).operationUsesDefaultRetries().callSync();
    }

    @Override
    public ListAssociableEntitiesResponse listAssociableEntities(ListAssociableEntitiesRequest request) {
        Validate.notBlank((String)request.getNamespaceName(), (String)"namespaceName must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getSourceName(), (String)"sourceName must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return (ListAssociableEntitiesResponse)this.clientCall(request, ListAssociableEntitiesResponse::builder).logger(LOG, "listAssociableEntities").serviceDetails("LogAnalytics", "ListAssociableEntities", "https://docs.oracle.com/iaas/api/#/en/logan-api-spec/20200601/LogAnalyticsSource/ListAssociableEntities").method(Method.GET).requestBuilder(ListAssociableEntitiesRequest::builder).basePath("/20200601").appendPathParam("namespaces").appendPathParam(request.getNamespaceName()).appendPathParam("sources").appendPathParam(request.getSourceName()).appendPathParam("associableEntities").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendEnumQueryParam("type", (BmcEnum)request.getType()).appendQueryParam("searchText", (Object)request.getSearchText()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).accept(new String[]{"application/json;charset=UTF-8"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(AssociableEntityCollection.class, ListAssociableEntitiesResponse.Builder::associableEntityCollection).handleResponseHeaderString("opc-prev-page", ListAssociableEntitiesResponse.Builder::opcPrevPage).handleResponseHeaderString("opc-next-page", ListAssociableEntitiesResponse.Builder::opcNextPage).handleResponseHeaderString("opc-request-id", ListAssociableEntitiesResponse.Builder::opcRequestId).operationUsesDefaultRetries().callSync();
    }

    @Override
    public ListAssociatedEntitiesResponse listAssociatedEntities(ListAssociatedEntitiesRequest request) {
        Validate.notBlank((String)request.getNamespaceName(), (String)"namespaceName must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return (ListAssociatedEntitiesResponse)this.clientCall(request, ListAssociatedEntitiesResponse::builder).logger(LOG, "listAssociatedEntities").serviceDetails("LogAnalytics", "ListAssociatedEntities", "https://docs.oracle.com/iaas/api/#/en/logan-api-spec/20200601/LogAnalyticsAssociation/ListAssociatedEntities").method(Method.GET).requestBuilder(ListAssociatedEntitiesRequest::builder).basePath("/20200601").appendPathParam("namespaces").appendPathParam(request.getNamespaceName()).appendPathParam("associatedEntities").appendQueryParam("entityId", (Object)request.getEntityId()).appendQueryParam("entityType", (Object)request.getEntityType()).appendQueryParam("entityTypeDisplayName", (Object)request.getEntityTypeDisplayName()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendQueryParam("compartmentId", (Object)request.getCompartmentId()).accept(new String[]{"application/json;charset=UTF-8"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(LogAnalyticsAssociatedEntityCollection.class, ListAssociatedEntitiesResponse.Builder::logAnalyticsAssociatedEntityCollection).handleResponseHeaderString("opc-prev-page", ListAssociatedEntitiesResponse.Builder::opcPrevPage).handleResponseHeaderString("opc-next-page", ListAssociatedEntitiesResponse.Builder::opcNextPage).handleResponseHeaderString("opc-request-id", ListAssociatedEntitiesResponse.Builder::opcRequestId).operationUsesDefaultRetries().callSync();
    }

    @Override
    public ListAutoAssociationsResponse listAutoAssociations(ListAutoAssociationsRequest request) {
        Validate.notBlank((String)request.getNamespaceName(), (String)"namespaceName must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getSourceName(), (String)"sourceName must not be blank", (Object[])new Object[0]);
        return (ListAutoAssociationsResponse)this.clientCall(request, ListAutoAssociationsResponse::builder).logger(LOG, "listAutoAssociations").serviceDetails("LogAnalytics", "ListAutoAssociations", "https://docs.oracle.com/iaas/api/#/en/logan-api-spec/20200601/LogAnalyticsSource/ListAutoAssociations").method(Method.GET).requestBuilder(ListAutoAssociationsRequest::builder).basePath("/20200601").appendPathParam("namespaces").appendPathParam(request.getNamespaceName()).appendPathParam("sources").appendPathParam(request.getSourceName()).appendPathParam("autoAssociations").appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).accept(new String[]{"application/json;charset=UTF-8"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(AutoAssociationCollection.class, ListAutoAssociationsResponse.Builder::autoAssociationCollection).handleResponseHeaderString("opc-prev-page", ListAutoAssociationsResponse.Builder::opcPrevPage).handleResponseHeaderString("opc-next-page", ListAutoAssociationsResponse.Builder::opcNextPage).handleResponseHeaderString("opc-request-id", ListAutoAssociationsResponse.Builder::opcRequestId).operationUsesDefaultRetries().callSync();
    }

    @Override
    public ListCategoriesResponse listCategories(ListCategoriesRequest request) {
        Validate.notBlank((String)request.getNamespaceName(), (String)"namespaceName must not be blank", (Object[])new Object[0]);
        return (ListCategoriesResponse)this.clientCall(request, ListCategoriesResponse::builder).logger(LOG, "listCategories").serviceDetails("LogAnalytics", "ListCategories", "https://docs.oracle.com/iaas/api/#/en/logan-api-spec/20200601/LogAnalyticsCategory/ListCategories").method(Method.GET).requestBuilder(ListCategoriesRequest::builder).basePath("/20200601").appendPathParam("namespaces").appendPathParam(request.getNamespaceName()).appendPathParam("categories").appendQueryParam("categoryType", (Object)request.getCategoryType()).appendQueryParam("categoryDisplayText", (Object)request.getCategoryDisplayText()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendQueryParam("name", (Object)request.getName()).accept(new String[]{"application/json;charset=UTF-8"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(LogAnalyticsCategoryCollection.class, ListCategoriesResponse.Builder::logAnalyticsCategoryCollection).handleResponseHeaderString("opc-prev-page", ListCategoriesResponse.Builder::opcPrevPage).handleResponseHeaderString("opc-next-page", ListCategoriesResponse.Builder::opcNextPage).handleResponseHeaderString("opc-request-id", ListCategoriesResponse.Builder::opcRequestId).operationUsesDefaultRetries().callSync();
    }

    @Override
    public ListConfigWorkRequestsResponse listConfigWorkRequests(ListConfigWorkRequestsRequest request) {
        Validate.notBlank((String)request.getNamespaceName(), (String)"namespaceName must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return (ListConfigWorkRequestsResponse)this.clientCall(request, ListConfigWorkRequestsResponse::builder).logger(LOG, "listConfigWorkRequests").serviceDetails("LogAnalytics", "ListConfigWorkRequests", "https://docs.oracle.com/iaas/api/#/en/logan-api-spec/20200601/LogAnalyticsConfigWorkRequest/ListConfigWorkRequests").method(Method.GET).requestBuilder(ListConfigWorkRequestsRequest::builder).basePath("/20200601").appendPathParam("namespaces").appendPathParam(request.getNamespaceName()).appendPathParam("configWorkRequests").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).accept(new String[]{"application/json;charset=UTF-8"}).handleBody(LogAnalyticsConfigWorkRequestCollection.class, ListConfigWorkRequestsResponse.Builder::logAnalyticsConfigWorkRequestCollection).handleResponseHeaderString("opc-prev-page", ListConfigWorkRequestsResponse.Builder::opcPrevPage).handleResponseHeaderString("opc-next-page", ListConfigWorkRequestsResponse.Builder::opcNextPage).handleResponseHeaderString("opc-request-id", ListConfigWorkRequestsResponse.Builder::opcRequestId).operationUsesDefaultRetries().callSync();
    }

    @Override
    public ListEncryptionKeyInfoResponse listEncryptionKeyInfo(ListEncryptionKeyInfoRequest request) {
        Validate.notBlank((String)request.getNamespaceName(), (String)"namespaceName must not be blank", (Object[])new Object[0]);
        return (ListEncryptionKeyInfoResponse)this.clientCall(request, ListEncryptionKeyInfoResponse::builder).logger(LOG, "listEncryptionKeyInfo").serviceDetails("LogAnalytics", "ListEncryptionKeyInfo", "https://docs.oracle.com/iaas/api/#/en/logan-api-spec/20200601/Storage/ListEncryptionKeyInfo").method(Method.GET).requestBuilder(ListEncryptionKeyInfoRequest::builder).basePath("/20200601").appendPathParam("namespaces").appendPathParam(request.getNamespaceName()).appendPathParam("storage").appendPathParam("encryptionKeyInfo").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(EncryptionKeyInfoCollection.class, ListEncryptionKeyInfoResponse.Builder::encryptionKeyInfoCollection).handleResponseHeaderString("opc-request-id", ListEncryptionKeyInfoResponse.Builder::opcRequestId).operationUsesDefaultRetries().callSync();
    }

    @Override
    public ListEntityAssociationsResponse listEntityAssociations(ListEntityAssociationsRequest request) {
        Validate.notBlank((String)request.getNamespaceName(), (String)"namespaceName must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getLogAnalyticsEntityId(), (String)"logAnalyticsEntityId must not be blank", (Object[])new Object[0]);
        return (ListEntityAssociationsResponse)this.clientCall(request, ListEntityAssociationsResponse::builder).logger(LOG, "listEntityAssociations").serviceDetails("LogAnalytics", "ListEntityAssociations", "https://docs.oracle.com/iaas/api/#/en/logan-api-spec/20200601/LogAnalyticsEntity/ListEntityAssociations").method(Method.GET).requestBuilder(ListEntityAssociationsRequest::builder).basePath("/20200601").appendPathParam("namespaces").appendPathParam(request.getNamespaceName()).appendPathParam("logAnalyticsEntities").appendPathParam(request.getLogAnalyticsEntityId()).appendPathParam("entityAssociations").appendEnumQueryParam("directOrAllAssociations", (BmcEnum)request.getDirectOrAllAssociations()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(LogAnalyticsEntityCollection.class, ListEntityAssociationsResponse.Builder::logAnalyticsEntityCollection).handleResponseHeaderString("opc-request-id", ListEntityAssociationsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListEntityAssociationsResponse.Builder::opcNextPage).callSync();
    }

    @Override
    public ListEntitySourceAssociationsResponse listEntitySourceAssociations(ListEntitySourceAssociationsRequest request) {
        Validate.notBlank((String)request.getNamespaceName(), (String)"namespaceName must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return (ListEntitySourceAssociationsResponse)this.clientCall(request, ListEntitySourceAssociationsResponse::builder).logger(LOG, "listEntitySourceAssociations").serviceDetails("LogAnalytics", "ListEntitySourceAssociations", "https://docs.oracle.com/iaas/api/#/en/logan-api-spec/20200601/LogAnalyticsAssociation/ListEntitySourceAssociations").method(Method.GET).requestBuilder(ListEntitySourceAssociationsRequest::builder).basePath("/20200601").appendPathParam("namespaces").appendPathParam(request.getNamespaceName()).appendPathParam("entityAssociations").appendQueryParam("entityId", (Object)request.getEntityId()).appendQueryParam("entityType", (Object)request.getEntityType()).appendQueryParam("entityTypeDisplayName", (Object)request.getEntityTypeDisplayName()).appendEnumQueryParam("lifeCycleState", (BmcEnum)request.getLifeCycleState()).appendQueryParam("isShowTotal", (Object)request.getIsShowTotal()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendQueryParam("compartmentId", (Object)request.getCompartmentId()).accept(new String[]{"application/json;charset=UTF-8"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(LogAnalyticsAssociationCollection.class, ListEntitySourceAssociationsResponse.Builder::logAnalyticsAssociationCollection).handleResponseHeaderString("opc-prev-page", ListEntitySourceAssociationsResponse.Builder::opcPrevPage).handleResponseHeaderString("opc-next-page", ListEntitySourceAssociationsResponse.Builder::opcNextPage).handleResponseHeaderString("opc-request-id", ListEntitySourceAssociationsResponse.Builder::opcRequestId).operationUsesDefaultRetries().callSync();
    }

    @Override
    public ListFieldsResponse listFields(ListFieldsRequest request) {
        Validate.notBlank((String)request.getNamespaceName(), (String)"namespaceName must not be blank", (Object[])new Object[0]);
        return (ListFieldsResponse)this.clientCall(request, ListFieldsResponse::builder).logger(LOG, "listFields").serviceDetails("LogAnalytics", "ListFields", "https://docs.oracle.com/iaas/api/#/en/logan-api-spec/20200601/LogAnalyticsField/ListFields").method(Method.GET).requestBuilder(ListFieldsRequest::builder).basePath("/20200601").appendPathParam("namespaces").appendPathParam(request.getNamespaceName()).appendPathParam("fields").appendQueryParam("isMatchAll", (Object)request.getIsMatchAll()).appendQueryParam("sourceIds", (Object)request.getSourceIds()).appendQueryParam("sourceNames", (Object)request.getSourceNames()).appendEnumQueryParam("parserType", (BmcEnum)request.getParserType()).appendQueryParam("parserIds", (Object)request.getParserIds()).appendQueryParam("parserNames", (Object)request.getParserNames()).appendQueryParam("isIncludeParser", (Object)request.getIsIncludeParser()).appendQueryParam("filter", (Object)request.getFilter()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).accept(new String[]{"application/json;charset=UTF-8"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(LogAnalyticsFieldCollection.class, ListFieldsResponse.Builder::logAnalyticsFieldCollection).handleResponseHeaderString("opc-prev-page", ListFieldsResponse.Builder::opcPrevPage).handleResponseHeaderString("opc-next-page", ListFieldsResponse.Builder::opcNextPage).handleResponseHeaderString("opc-request-id", ListFieldsResponse.Builder::opcRequestId).operationUsesDefaultRetries().callSync();
    }

    @Override
    public ListIngestTimeRulesResponse listIngestTimeRules(ListIngestTimeRulesRequest request) {
        Validate.notBlank((String)request.getNamespaceName(), (String)"namespaceName must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return (ListIngestTimeRulesResponse)this.clientCall(request, ListIngestTimeRulesResponse::builder).logger(LOG, "listIngestTimeRules").serviceDetails("LogAnalytics", "ListIngestTimeRules", "https://docs.oracle.com/iaas/api/#/en/logan-api-spec/20200601/IngestTimeRule/ListIngestTimeRules").method(Method.GET).requestBuilder(ListIngestTimeRulesRequest::builder).basePath("/20200601").appendPathParam("namespaces").appendPathParam(request.getNamespaceName()).appendPathParam("ingestTimeRules").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("displayName", (Object)request.getDisplayName()).appendEnumQueryParam("lifecycleState", (BmcEnum)request.getLifecycleState()).appendEnumQueryParam("conditionKind", (BmcEnum)request.getConditionKind()).appendQueryParam("fieldName", (Object)request.getFieldName()).appendQueryParam("fieldValue", (Object)request.getFieldValue()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(IngestTimeRuleSummaryCollection.class, ListIngestTimeRulesResponse.Builder::ingestTimeRuleSummaryCollection).handleResponseHeaderString("opc-prev-page", ListIngestTimeRulesResponse.Builder::opcPrevPage).handleResponseHeaderString("opc-request-id", ListIngestTimeRulesResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListIngestTimeRulesResponse.Builder::opcNextPage).operationUsesDefaultRetries().callSync();
    }

    @Override
    public ListLabelPrioritiesResponse listLabelPriorities(ListLabelPrioritiesRequest request) {
        Validate.notBlank((String)request.getNamespaceName(), (String)"namespaceName must not be blank", (Object[])new Object[0]);
        return (ListLabelPrioritiesResponse)this.clientCall(request, ListLabelPrioritiesResponse::builder).logger(LOG, "listLabelPriorities").serviceDetails("LogAnalytics", "ListLabelPriorities", "https://docs.oracle.com/iaas/api/#/en/logan-api-spec/20200601/LogAnalyticsLabel/ListLabelPriorities").method(Method.GET).requestBuilder(ListLabelPrioritiesRequest::builder).basePath("/20200601").appendPathParam("namespaces").appendPathParam(request.getNamespaceName()).appendPathParam("labelPriorities").appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).accept(new String[]{"application/json;charset=UTF-8"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(LabelPriorityCollection.class, ListLabelPrioritiesResponse.Builder::labelPriorityCollection).handleResponseHeaderString("opc-prev-page", ListLabelPrioritiesResponse.Builder::opcPrevPage).handleResponseHeaderString("opc-next-page", ListLabelPrioritiesResponse.Builder::opcNextPage).handleResponseHeaderString("opc-request-id", ListLabelPrioritiesResponse.Builder::opcRequestId).operationUsesDefaultRetries().callSync();
    }

    @Override
    public ListLabelSourceDetailsResponse listLabelSourceDetails(ListLabelSourceDetailsRequest request) {
        Validate.notBlank((String)request.getNamespaceName(), (String)"namespaceName must not be blank", (Object[])new Object[0]);
        return (ListLabelSourceDetailsResponse)this.clientCall(request, ListLabelSourceDetailsResponse::builder).logger(LOG, "listLabelSourceDetails").serviceDetails("LogAnalytics", "ListLabelSourceDetails", "https://docs.oracle.com/iaas/api/#/en/logan-api-spec/20200601/LogAnalyticsLabel/ListLabelSourceDetails").method(Method.GET).requestBuilder(ListLabelSourceDetailsRequest::builder).basePath("/20200601").appendPathParam("namespaces").appendPathParam(request.getNamespaceName()).appendPathParam("labelSourceDetails").appendQueryParam("labelName", (Object)request.getLabelName()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("labelSourceSortBy", (BmcEnum)request.getLabelSourceSortBy()).accept(new String[]{"application/json;charset=UTF-8"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(LabelSourceCollection.class, ListLabelSourceDetailsResponse.Builder::labelSourceCollection).handleResponseHeaderString("opc-prev-page", ListLabelSourceDetailsResponse.Builder::opcPrevPage).handleResponseHeaderString("opc-next-page", ListLabelSourceDetailsResponse.Builder::opcNextPage).handleResponseHeaderString("opc-request-id", ListLabelSourceDetailsResponse.Builder::opcRequestId).operationUsesDefaultRetries().callSync();
    }

    @Override
    public ListLabelsResponse listLabels(ListLabelsRequest request) {
        Validate.notBlank((String)request.getNamespaceName(), (String)"namespaceName must not be blank", (Object[])new Object[0]);
        return (ListLabelsResponse)this.clientCall(request, ListLabelsResponse::builder).logger(LOG, "listLabels").serviceDetails("LogAnalytics", "ListLabels", "https://docs.oracle.com/iaas/api/#/en/logan-api-spec/20200601/LogAnalyticsLabel/ListLabels").method(Method.GET).requestBuilder(ListLabelsRequest::builder).basePath("/20200601").appendPathParam("namespaces").appendPathParam(request.getNamespaceName()).appendPathParam("labels").appendQueryParam("labelName", (Object)request.getLabelName()).appendQueryParam("labelDisplayText", (Object)request.getLabelDisplayText()).appendEnumQueryParam("isSystem", (BmcEnum)request.getIsSystem()).appendEnumQueryParam("labelPriority", (BmcEnum)request.getLabelPriority()).appendQueryParam("isCountPop", (Object)request.getIsCountPop()).appendQueryParam("isAliasPop", (Object)request.getIsAliasPop()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("labelSortBy", (BmcEnum)request.getLabelSortBy()).accept(new String[]{"application/json;charset=UTF-8"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(LogAnalyticsLabelCollection.class, ListLabelsResponse.Builder::logAnalyticsLabelCollection).handleResponseHeaderString("opc-prev-page", ListLabelsResponse.Builder::opcPrevPage).handleResponseHeaderString("opc-next-page", ListLabelsResponse.Builder::opcNextPage).handleResponseHeaderString("opc-request-id", ListLabelsResponse.Builder::opcRequestId).operationUsesDefaultRetries().callSync();
    }

    @Override
    public ListLogAnalyticsEmBridgesResponse listLogAnalyticsEmBridges(ListLogAnalyticsEmBridgesRequest request) {
        Validate.notBlank((String)request.getNamespaceName(), (String)"namespaceName must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return (ListLogAnalyticsEmBridgesResponse)this.clientCall(request, ListLogAnalyticsEmBridgesResponse::builder).logger(LOG, "listLogAnalyticsEmBridges").serviceDetails("LogAnalytics", "ListLogAnalyticsEmBridges", "https://docs.oracle.com/iaas/api/#/en/logan-api-spec/20200601/LogAnalyticsEmBridge/ListLogAnalyticsEmBridges").method(Method.GET).requestBuilder(ListLogAnalyticsEmBridgesRequest::builder).basePath("/20200601").appendPathParam("namespaces").appendPathParam(request.getNamespaceName()).appendPathParam("logAnalyticsEmBridges").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("displayName", (Object)request.getDisplayName()).appendListQueryParam("lifecycleState", request.getLifecycleState(), CollectionFormatType.Multi).appendQueryParam("lifecycleDetailsContains", (Object)request.getLifecycleDetailsContains()).appendListQueryParam("importStatus", request.getImportStatus(), CollectionFormatType.Multi).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(LogAnalyticsEmBridgeCollection.class, ListLogAnalyticsEmBridgesResponse.Builder::logAnalyticsEmBridgeCollection).handleResponseHeaderString("opc-request-id", ListLogAnalyticsEmBridgesResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListLogAnalyticsEmBridgesResponse.Builder::opcNextPage).callSync();
    }

    @Override
    public ListLogAnalyticsEntitiesResponse listLogAnalyticsEntities(ListLogAnalyticsEntitiesRequest request) {
        Validate.notBlank((String)request.getNamespaceName(), (String)"namespaceName must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return (ListLogAnalyticsEntitiesResponse)this.clientCall(request, ListLogAnalyticsEntitiesResponse::builder).logger(LOG, "listLogAnalyticsEntities").serviceDetails("LogAnalytics", "ListLogAnalyticsEntities", "https://docs.oracle.com/iaas/api/#/en/logan-api-spec/20200601/LogAnalyticsEntity/ListLogAnalyticsEntities").method(Method.GET).requestBuilder(ListLogAnalyticsEntitiesRequest::builder).basePath("/20200601").appendPathParam("namespaces").appendPathParam(request.getNamespaceName()).appendPathParam("logAnalyticsEntities").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("name", (Object)request.getName()).appendQueryParam("nameContains", (Object)request.getNameContains()).appendListQueryParam("entityTypeName", request.getEntityTypeName(), CollectionFormatType.Multi).appendQueryParam("cloudResourceId", (Object)request.getCloudResourceId()).appendEnumQueryParam("lifecycleState", (BmcEnum)request.getLifecycleState()).appendQueryParam("lifecycleDetailsContains", (Object)request.getLifecycleDetailsContains()).appendEnumQueryParam("isManagementAgentIdNull", (BmcEnum)request.getIsManagementAgentIdNull()).appendQueryParam("hostname", (Object)request.getHostname()).appendQueryParam("hostnameContains", (Object)request.getHostnameContains()).appendQueryParam("sourceId", (Object)request.getSourceId()).appendListQueryParam("creationSourceType", request.getCreationSourceType(), CollectionFormatType.Multi).appendQueryParam("creationSourceDetails", (Object)request.getCreationSourceDetails()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(LogAnalyticsEntityCollection.class, ListLogAnalyticsEntitiesResponse.Builder::logAnalyticsEntityCollection).handleResponseHeaderString("opc-request-id", ListLogAnalyticsEntitiesResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListLogAnalyticsEntitiesResponse.Builder::opcNextPage).callSync();
    }

    @Override
    public ListLogAnalyticsEntityTopologyResponse listLogAnalyticsEntityTopology(ListLogAnalyticsEntityTopologyRequest request) {
        Validate.notBlank((String)request.getNamespaceName(), (String)"namespaceName must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getLogAnalyticsEntityId(), (String)"logAnalyticsEntityId must not be blank", (Object[])new Object[0]);
        return (ListLogAnalyticsEntityTopologyResponse)this.clientCall(request, ListLogAnalyticsEntityTopologyResponse::builder).logger(LOG, "listLogAnalyticsEntityTopology").serviceDetails("LogAnalytics", "ListLogAnalyticsEntityTopology", "https://docs.oracle.com/iaas/api/#/en/logan-api-spec/20200601/LogAnalyticsEntitySummary/ListLogAnalyticsEntityTopology").method(Method.GET).requestBuilder(ListLogAnalyticsEntityTopologyRequest::builder).basePath("/20200601").appendPathParam("namespaces").appendPathParam(request.getNamespaceName()).appendPathParam("logAnalyticsEntities").appendPathParam(request.getLogAnalyticsEntityId()).appendPathParam("entityTopology").appendEnumQueryParam("lifecycleState", (BmcEnum)request.getLifecycleState()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(LogAnalyticsEntityTopologyCollection.class, ListLogAnalyticsEntityTopologyResponse.Builder::logAnalyticsEntityTopologyCollection).handleResponseHeaderString("opc-request-id", ListLogAnalyticsEntityTopologyResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListLogAnalyticsEntityTopologyResponse.Builder::opcNextPage).callSync();
    }

    @Override
    public ListLogAnalyticsEntityTypesResponse listLogAnalyticsEntityTypes(ListLogAnalyticsEntityTypesRequest request) {
        Validate.notBlank((String)request.getNamespaceName(), (String)"namespaceName must not be blank", (Object[])new Object[0]);
        return (ListLogAnalyticsEntityTypesResponse)this.clientCall(request, ListLogAnalyticsEntityTypesResponse::builder).logger(LOG, "listLogAnalyticsEntityTypes").serviceDetails("LogAnalytics", "ListLogAnalyticsEntityTypes", "https://docs.oracle.com/iaas/api/#/en/logan-api-spec/20200601/LogAnalyticsEntityType/ListLogAnalyticsEntityTypes").method(Method.GET).requestBuilder(ListLogAnalyticsEntityTypesRequest::builder).basePath("/20200601").appendPathParam("namespaces").appendPathParam(request.getNamespaceName()).appendPathParam("logAnalyticsEntityTypes").appendQueryParam("name", (Object)request.getName()).appendQueryParam("nameContains", (Object)request.getNameContains()).appendEnumQueryParam("cloudType", (BmcEnum)request.getCloudType()).appendEnumQueryParam("lifecycleState", (BmcEnum)request.getLifecycleState()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(LogAnalyticsEntityTypeCollection.class, ListLogAnalyticsEntityTypesResponse.Builder::logAnalyticsEntityTypeCollection).handleResponseHeaderString("opc-request-id", ListLogAnalyticsEntityTypesResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListLogAnalyticsEntityTypesResponse.Builder::opcNextPage).callSync();
    }

    @Override
    public ListLogAnalyticsLogGroupsResponse listLogAnalyticsLogGroups(ListLogAnalyticsLogGroupsRequest request) {
        Validate.notBlank((String)request.getNamespaceName(), (String)"namespaceName must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return (ListLogAnalyticsLogGroupsResponse)this.clientCall(request, ListLogAnalyticsLogGroupsResponse::builder).logger(LOG, "listLogAnalyticsLogGroups").serviceDetails("LogAnalytics", "ListLogAnalyticsLogGroups", "https://docs.oracle.com/iaas/api/#/en/logan-api-spec/20200601/LogAnalyticsLogGroup/ListLogAnalyticsLogGroups").method(Method.GET).requestBuilder(ListLogAnalyticsLogGroupsRequest::builder).basePath("/20200601").appendPathParam("namespaces").appendPathParam(request.getNamespaceName()).appendPathParam("logAnalyticsLogGroups").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("displayName", (Object)request.getDisplayName()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(LogAnalyticsLogGroupSummaryCollection.class, ListLogAnalyticsLogGroupsResponse.Builder::logAnalyticsLogGroupSummaryCollection).handleResponseHeaderString("opc-prev-page", ListLogAnalyticsLogGroupsResponse.Builder::opcPrevPage).handleResponseHeaderString("opc-request-id", ListLogAnalyticsLogGroupsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListLogAnalyticsLogGroupsResponse.Builder::opcNextPage).operationUsesDefaultRetries().callSync();
    }

    @Override
    public ListLogAnalyticsObjectCollectionRulesResponse listLogAnalyticsObjectCollectionRules(ListLogAnalyticsObjectCollectionRulesRequest request) {
        Validate.notBlank((String)request.getNamespaceName(), (String)"namespaceName must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return (ListLogAnalyticsObjectCollectionRulesResponse)this.clientCall(request, ListLogAnalyticsObjectCollectionRulesResponse::builder).logger(LOG, "listLogAnalyticsObjectCollectionRules").serviceDetails("LogAnalytics", "ListLogAnalyticsObjectCollectionRules", "https://docs.oracle.com/iaas/api/#/en/logan-api-spec/20200601/LogAnalyticsObjectCollectionRule/ListLogAnalyticsObjectCollectionRules").method(Method.GET).requestBuilder(ListLogAnalyticsObjectCollectionRulesRequest::builder).basePath("/20200601").appendPathParam("namespaces").appendPathParam(request.getNamespaceName()).appendPathParam("logAnalyticsObjectCollectionRules").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("name", (Object)request.getName()).appendEnumQueryParam("lifecycleState", (BmcEnum)request.getLifecycleState()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(LogAnalyticsObjectCollectionRuleCollection.class, ListLogAnalyticsObjectCollectionRulesResponse.Builder::logAnalyticsObjectCollectionRuleCollection).handleResponseHeaderString("opc-request-id", ListLogAnalyticsObjectCollectionRulesResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListLogAnalyticsObjectCollectionRulesResponse.Builder::opcNextPage).operationUsesDefaultRetries().callSync();
    }

    @Override
    public ListLogSetsResponse listLogSets(ListLogSetsRequest request) {
        Validate.notBlank((String)request.getNamespaceName(), (String)"namespaceName must not be blank", (Object[])new Object[0]);
        return (ListLogSetsResponse)this.clientCall(request, ListLogSetsResponse::builder).logger(LOG, "listLogSets").serviceDetails("LogAnalytics", "ListLogSets", "https://docs.oracle.com/iaas/api/#/en/logan-api-spec/20200601/Storage/ListLogSets").method(Method.GET).requestBuilder(ListLogSetsRequest::builder).basePath("/20200601").appendPathParam("namespaces").appendPathParam(request.getNamespaceName()).appendPathParam("storage").appendPathParam("logSets").appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendListQueryParam("logSetNameContains", request.getLogSetNameContains(), CollectionFormatType.Multi).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(LogSetCollection.class, ListLogSetsResponse.Builder::logSetCollection).handleResponseHeaderString("opc-request-id", ListLogSetsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListLogSetsResponse.Builder::opcNextPage).operationUsesDefaultRetries().callSync();
    }

    @Override
    public ListLookupsResponse listLookups(ListLookupsRequest request) {
        Validate.notBlank((String)request.getNamespaceName(), (String)"namespaceName must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getType(), "type is required");
        return (ListLookupsResponse)this.clientCall(request, ListLookupsResponse::builder).logger(LOG, "listLookups").serviceDetails("LogAnalytics", "ListLookups", "https://docs.oracle.com/iaas/api/#/en/logan-api-spec/20200601/LogAnalyticsLookup/ListLookups").method(Method.GET).requestBuilder(ListLookupsRequest::builder).basePath("/20200601").appendPathParam("namespaces").appendPathParam(request.getNamespaceName()).appendPathParam("lookups").appendQueryParam("lookupDisplayText", (Object)request.getLookupDisplayText()).appendEnumQueryParam("type", (BmcEnum)request.getType()).appendEnumQueryParam("isSystem", (BmcEnum)request.getIsSystem()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendEnumQueryParam("status", (BmcEnum)request.getStatus()).appendQueryParam("categories", (Object)request.getCategories()).appendQueryParam("isHideSpecial", (Object)request.getIsHideSpecial()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(LogAnalyticsLookupCollection.class, ListLookupsResponse.Builder::logAnalyticsLookupCollection).handleResponseHeaderString("opc-prev-page", ListLookupsResponse.Builder::opcPrevPage).handleResponseHeaderString("opc-next-page", ListLookupsResponse.Builder::opcNextPage).handleResponseHeaderString("opc-request-id", ListLookupsResponse.Builder::opcRequestId).operationUsesDefaultRetries().callSync();
    }

    @Override
    public ListMetaSourceTypesResponse listMetaSourceTypes(ListMetaSourceTypesRequest request) {
        Validate.notBlank((String)request.getNamespaceName(), (String)"namespaceName must not be blank", (Object[])new Object[0]);
        return (ListMetaSourceTypesResponse)this.clientCall(request, ListMetaSourceTypesResponse::builder).logger(LOG, "listMetaSourceTypes").serviceDetails("LogAnalytics", "ListMetaSourceTypes", "https://docs.oracle.com/iaas/api/#/en/logan-api-spec/20200601/LogAnalyticsSource/ListMetaSourceTypes").method(Method.GET).requestBuilder(ListMetaSourceTypesRequest::builder).basePath("/20200601").appendPathParam("namespaces").appendPathParam(request.getNamespaceName()).appendPathParam("sourceMetaTypes").appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).accept(new String[]{"application/json;charset=UTF-8"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(LogAnalyticsMetaSourceTypeCollection.class, ListMetaSourceTypesResponse.Builder::logAnalyticsMetaSourceTypeCollection).handleResponseHeaderString("opc-prev-page", ListMetaSourceTypesResponse.Builder::opcPrevPage).handleResponseHeaderString("opc-next-page", ListMetaSourceTypesResponse.Builder::opcNextPage).handleResponseHeaderString("opc-request-id", ListMetaSourceTypesResponse.Builder::opcRequestId).operationUsesDefaultRetries().callSync();
    }

    @Override
    public ListNamespacesResponse listNamespaces(ListNamespacesRequest request) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return (ListNamespacesResponse)this.clientCall(request, ListNamespacesResponse::builder).logger(LOG, "listNamespaces").serviceDetails("LogAnalytics", "ListNamespaces", "https://docs.oracle.com/iaas/api/#/en/logan-api-spec/20200601/Namespace/ListNamespaces").method(Method.GET).requestBuilder(ListNamespacesRequest::builder).basePath("/20200601").appendPathParam("namespaces").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(NamespaceCollection.class, ListNamespacesResponse.Builder::namespaceCollection).handleResponseHeaderString("opc-request-id", ListNamespacesResponse.Builder::opcRequestId).operationUsesDefaultRetries().callSync();
    }

    @Override
    public ListParserFunctionsResponse listParserFunctions(ListParserFunctionsRequest request) {
        Validate.notBlank((String)request.getNamespaceName(), (String)"namespaceName must not be blank", (Object[])new Object[0]);
        return (ListParserFunctionsResponse)this.clientCall(request, ListParserFunctionsResponse::builder).logger(LOG, "listParserFunctions").serviceDetails("LogAnalytics", "ListParserFunctions", "https://docs.oracle.com/iaas/api/#/en/logan-api-spec/20200601/LogAnalyticsParser/ListParserFunctions").method(Method.GET).requestBuilder(ListParserFunctionsRequest::builder).basePath("/20200601").appendPathParam("namespaces").appendPathParam(request.getNamespaceName()).appendPathParam("parserFunctions").appendQueryParam("parserName", (Object)request.getParserName()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).accept(new String[]{"application/json;charset=UTF-8"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(LogAnalyticsParserFunctionCollection.class, ListParserFunctionsResponse.Builder::logAnalyticsParserFunctionCollection).handleResponseHeaderString("opc-prev-page", ListParserFunctionsResponse.Builder::opcPrevPage).handleResponseHeaderString("opc-next-page", ListParserFunctionsResponse.Builder::opcNextPage).handleResponseHeaderString("opc-request-id", ListParserFunctionsResponse.Builder::opcRequestId).operationUsesDefaultRetries().callSync();
    }

    @Override
    public ListParserMetaPluginsResponse listParserMetaPlugins(ListParserMetaPluginsRequest request) {
        Validate.notBlank((String)request.getNamespaceName(), (String)"namespaceName must not be blank", (Object[])new Object[0]);
        return (ListParserMetaPluginsResponse)this.clientCall(request, ListParserMetaPluginsResponse::builder).logger(LOG, "listParserMetaPlugins").serviceDetails("LogAnalytics", "ListParserMetaPlugins", "https://docs.oracle.com/iaas/api/#/en/logan-api-spec/20200601/LogAnalyticsParser/ListParserMetaPlugins").method(Method.GET).requestBuilder(ListParserMetaPluginsRequest::builder).basePath("/20200601").appendPathParam("namespaces").appendPathParam(request.getNamespaceName()).appendPathParam("parserMetaPlugins").appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).accept(new String[]{"application/json;charset=UTF-8"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(LogAnalyticsParserMetaPluginCollection.class, ListParserMetaPluginsResponse.Builder::logAnalyticsParserMetaPluginCollection).handleResponseHeaderString("opc-prev-page", ListParserMetaPluginsResponse.Builder::opcPrevPage).handleResponseHeaderString("opc-next-page", ListParserMetaPluginsResponse.Builder::opcNextPage).handleResponseHeaderString("opc-request-id", ListParserMetaPluginsResponse.Builder::opcRequestId).operationUsesDefaultRetries().callSync();
    }

    @Override
    public ListParsersResponse listParsers(ListParsersRequest request) {
        Validate.notBlank((String)request.getNamespaceName(), (String)"namespaceName must not be blank", (Object[])new Object[0]);
        return (ListParsersResponse)this.clientCall(request, ListParsersResponse::builder).logger(LOG, "listParsers").serviceDetails("LogAnalytics", "ListParsers", "https://docs.oracle.com/iaas/api/#/en/logan-api-spec/20200601/LogAnalyticsParser/ListParsers").method(Method.GET).requestBuilder(ListParsersRequest::builder).basePath("/20200601").appendPathParam("namespaces").appendPathParam(request.getNamespaceName()).appendPathParam("parsers").appendQueryParam("isMatchAll", (Object)request.getIsMatchAll()).appendEnumQueryParam("sourceType", (BmcEnum)request.getSourceType()).appendQueryParam("parserName", (Object)request.getParserName()).appendQueryParam("parserDisplayText", (Object)request.getParserDisplayText()).appendEnumQueryParam("parserType", (BmcEnum)request.getParserType()).appendQueryParam("categories", (Object)request.getCategories()).appendEnumQueryParam("isSystem", (BmcEnum)request.getIsSystem()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).accept(new String[]{"application/json;charset=UTF-8"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(LogAnalyticsParserCollection.class, ListParsersResponse.Builder::logAnalyticsParserCollection).handleResponseHeaderString("opc-prev-page", ListParsersResponse.Builder::opcPrevPage).handleResponseHeaderString("opc-next-page", ListParsersResponse.Builder::opcNextPage).handleResponseHeaderString("opc-request-id", ListParsersResponse.Builder::opcRequestId).operationUsesDefaultRetries().callSync();
    }

    @Override
    public ListQueryWorkRequestsResponse listQueryWorkRequests(ListQueryWorkRequestsRequest request) {
        Validate.notBlank((String)request.getNamespaceName(), (String)"namespaceName must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return (ListQueryWorkRequestsResponse)this.clientCall(request, ListQueryWorkRequestsResponse::builder).logger(LOG, "listQueryWorkRequests").serviceDetails("LogAnalytics", "ListQueryWorkRequests", "https://docs.oracle.com/iaas/api/#/en/logan-api-spec/20200601/QueryWorkRequest/ListQueryWorkRequests").method(Method.GET).requestBuilder(ListQueryWorkRequestsRequest::builder).basePath("/20200601").appendPathParam("namespaces").appendPathParam(request.getNamespaceName()).appendPathParam("queryWorkRequests").appendEnumQueryParam("mode", (BmcEnum)request.getMode()).appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(QueryWorkRequestCollection.class, ListQueryWorkRequestsResponse.Builder::queryWorkRequestCollection).handleResponseHeaderString("opc-request-id", ListQueryWorkRequestsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListQueryWorkRequestsResponse.Builder::opcNextPage).handleResponseHeaderString("opc-prev-page", ListQueryWorkRequestsResponse.Builder::opcPrevPage).operationUsesDefaultRetries().callSync();
    }

    @Override
    public ListRecalledDataResponse listRecalledData(ListRecalledDataRequest request) {
        Validate.notBlank((String)request.getNamespaceName(), (String)"namespaceName must not be blank", (Object[])new Object[0]);
        return (ListRecalledDataResponse)this.clientCall(request, ListRecalledDataResponse::builder).logger(LOG, "listRecalledData").serviceDetails("LogAnalytics", "ListRecalledData", "https://docs.oracle.com/iaas/api/#/en/logan-api-spec/20200601/Storage/ListRecalledData").method(Method.GET).requestBuilder(ListRecalledDataRequest::builder).basePath("/20200601").appendPathParam("namespaces").appendPathParam(request.getNamespaceName()).appendPathParam("storage").appendPathParam("recalledData").appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendQueryParam("timeDataStartedGreaterThanOrEqual", (Object)request.getTimeDataStartedGreaterThanOrEqual()).appendQueryParam("timeDataEndedLessThan", (Object)request.getTimeDataEndedLessThan()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(RecalledDataCollection.class, ListRecalledDataResponse.Builder::recalledDataCollection).handleResponseHeaderString("opc-request-id", ListRecalledDataResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListRecalledDataResponse.Builder::opcNextPage).handleResponseHeaderString("opc-prev-page", ListRecalledDataResponse.Builder::opcPrevPage).operationUsesDefaultRetries().callSync();
    }

    @Override
    public ListResourceCategoriesResponse listResourceCategories(ListResourceCategoriesRequest request) {
        Validate.notBlank((String)request.getNamespaceName(), (String)"namespaceName must not be blank", (Object[])new Object[0]);
        return (ListResourceCategoriesResponse)this.clientCall(request, ListResourceCategoriesResponse::builder).logger(LOG, "listResourceCategories").serviceDetails("LogAnalytics", "ListResourceCategories", "https://docs.oracle.com/iaas/api/#/en/logan-api-spec/20200601/LogAnalyticsCategory/ListResourceCategories").method(Method.GET).requestBuilder(ListResourceCategoriesRequest::builder).basePath("/20200601").appendPathParam("namespaces").appendPathParam(request.getNamespaceName()).appendPathParam("categories").appendPathParam("resourceCategories").appendQueryParam("categories", (Object)request.getCategories()).appendQueryParam("resourceTypes", (Object)request.getResourceTypes()).appendQueryParam("resourceIds", (Object)request.getResourceIds()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).accept(new String[]{"application/json;charset=UTF-8"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(LogAnalyticsResourceCategoryCollection.class, ListResourceCategoriesResponse.Builder::logAnalyticsResourceCategoryCollection).handleResponseHeaderString("opc-prev-page", ListResourceCategoriesResponse.Builder::opcPrevPage).handleResponseHeaderString("opc-next-page", ListResourceCategoriesResponse.Builder::opcNextPage).handleResponseHeaderString("opc-request-id", ListResourceCategoriesResponse.Builder::opcRequestId).operationUsesDefaultRetries().callSync();
    }

    @Override
    public ListRulesResponse listRules(ListRulesRequest request) {
        Validate.notBlank((String)request.getNamespaceName(), (String)"namespaceName must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return (ListRulesResponse)this.clientCall(request, ListRulesResponse::builder).logger(LOG, "listRules").serviceDetails("LogAnalytics", "ListRules", "https://docs.oracle.com/iaas/api/#/en/logan-api-spec/20200601/Rule/ListRules").method(Method.GET).requestBuilder(ListRulesRequest::builder).basePath("/20200601").appendPathParam("namespaces").appendPathParam(request.getNamespaceName()).appendPathParam("rules").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("displayName", (Object)request.getDisplayName()).appendEnumQueryParam("kind", (BmcEnum)request.getKind()).appendEnumQueryParam("lifecycleState", (BmcEnum)request.getLifecycleState()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(RuleSummaryCollection.class, ListRulesResponse.Builder::ruleSummaryCollection).handleResponseHeaderString("opc-prev-page", ListRulesResponse.Builder::opcPrevPage).handleResponseHeaderString("opc-request-id", ListRulesResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListRulesResponse.Builder::opcNextPage).operationUsesDefaultRetries().callSync();
    }

    @Override
    public ListScheduledTasksResponse listScheduledTasks(ListScheduledTasksRequest request) {
        Validate.notBlank((String)request.getNamespaceName(), (String)"namespaceName must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getTaskType(), "taskType is required");
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return (ListScheduledTasksResponse)this.clientCall(request, ListScheduledTasksResponse::builder).logger(LOG, "listScheduledTasks").serviceDetails("LogAnalytics", "ListScheduledTasks", "https://docs.oracle.com/iaas/api/#/en/logan-api-spec/20200601/ScheduledTask/ListScheduledTasks").method(Method.GET).requestBuilder(ListScheduledTasksRequest::builder).basePath("/20200601").appendPathParam("namespaces").appendPathParam(request.getNamespaceName()).appendPathParam("scheduledTasks").appendEnumQueryParam("taskType", (BmcEnum)request.getTaskType()).appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendQueryParam("displayName", (Object)request.getDisplayName()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendQueryParam("savedSearchId", (Object)request.getSavedSearchId()).appendQueryParam("displayNameContains", (Object)request.getDisplayNameContains()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(ScheduledTaskCollection.class, ListScheduledTasksResponse.Builder::scheduledTaskCollection).handleResponseHeaderString("opc-request-id", ListScheduledTasksResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListScheduledTasksResponse.Builder::opcNextPage).handleResponseHeaderString("opc-prev-page", ListScheduledTasksResponse.Builder::opcPrevPage).operationUsesDefaultRetries().callSync();
    }

    @Override
    public ListSourceAssociationsResponse listSourceAssociations(ListSourceAssociationsRequest request) {
        Validate.notBlank((String)request.getNamespaceName(), (String)"namespaceName must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getSourceName(), "sourceName is required");
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return (ListSourceAssociationsResponse)this.clientCall(request, ListSourceAssociationsResponse::builder).logger(LOG, "listSourceAssociations").serviceDetails("LogAnalytics", "ListSourceAssociations", "https://docs.oracle.com/iaas/api/#/en/logan-api-spec/20200601/LogAnalyticsAssociation/ListSourceAssociations").method(Method.GET).requestBuilder(ListSourceAssociationsRequest::builder).basePath("/20200601").appendPathParam("namespaces").appendPathParam(request.getNamespaceName()).appendPathParam("sourceAssociations").appendQueryParam("sourceName", (Object)request.getSourceName()).appendQueryParam("entityId", (Object)request.getEntityId()).appendEnumQueryParam("lifeCycleState", (BmcEnum)request.getLifeCycleState()).appendQueryParam("isShowTotal", (Object)request.getIsShowTotal()).appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).accept(new String[]{"application/json;charset=UTF-8"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(LogAnalyticsAssociationCollection.class, ListSourceAssociationsResponse.Builder::logAnalyticsAssociationCollection).handleResponseHeaderString("opc-prev-page", ListSourceAssociationsResponse.Builder::opcPrevPage).handleResponseHeaderString("opc-next-page", ListSourceAssociationsResponse.Builder::opcNextPage).handleResponseHeaderString("opc-request-id", ListSourceAssociationsResponse.Builder::opcRequestId).operationUsesDefaultRetries().callSync();
    }

    @Override
    public ListSourceEventTypesResponse listSourceEventTypes(ListSourceEventTypesRequest request) {
        Validate.notBlank((String)request.getNamespaceName(), (String)"namespaceName must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getSourceName(), (String)"sourceName must not be blank", (Object[])new Object[0]);
        return (ListSourceEventTypesResponse)this.clientCall(request, ListSourceEventTypesResponse::builder).logger(LOG, "listSourceEventTypes").serviceDetails("LogAnalytics", "ListSourceEventTypes", "https://docs.oracle.com/iaas/api/#/en/logan-api-spec/20200601/LogAnalyticsSource/ListSourceEventTypes").method(Method.GET).requestBuilder(ListSourceEventTypesRequest::builder).basePath("/20200601").appendPathParam("namespaces").appendPathParam(request.getNamespaceName()).appendPathParam("sources").appendPathParam(request.getSourceName()).appendPathParam("eventTypes").appendQueryParam("displayText", (Object)request.getDisplayText()).appendEnumQueryParam("isSystem", (BmcEnum)request.getIsSystem()).appendQueryParam("isEnabled", (Object)request.getIsEnabled()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).accept(new String[]{"application/json;charset=UTF-8"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(EventTypeCollection.class, ListSourceEventTypesResponse.Builder::eventTypeCollection).handleResponseHeaderString("opc-prev-page", ListSourceEventTypesResponse.Builder::opcPrevPage).handleResponseHeaderString("opc-next-page", ListSourceEventTypesResponse.Builder::opcNextPage).handleResponseHeaderString("opc-request-id", ListSourceEventTypesResponse.Builder::opcRequestId).operationUsesDefaultRetries().callSync();
    }

    @Override
    public ListSourceExtendedFieldDefinitionsResponse listSourceExtendedFieldDefinitions(ListSourceExtendedFieldDefinitionsRequest request) {
        Validate.notBlank((String)request.getNamespaceName(), (String)"namespaceName must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getSourceName(), (String)"sourceName must not be blank", (Object[])new Object[0]);
        return (ListSourceExtendedFieldDefinitionsResponse)this.clientCall(request, ListSourceExtendedFieldDefinitionsResponse::builder).logger(LOG, "listSourceExtendedFieldDefinitions").serviceDetails("LogAnalytics", "ListSourceExtendedFieldDefinitions", "https://docs.oracle.com/iaas/api/#/en/logan-api-spec/20200601/LogAnalyticsSource/ListSourceExtendedFieldDefinitions").method(Method.GET).requestBuilder(ListSourceExtendedFieldDefinitionsRequest::builder).basePath("/20200601").appendPathParam("namespaces").appendPathParam(request.getNamespaceName()).appendPathParam("sources").appendPathParam(request.getSourceName()).appendPathParam("extendedFieldDefinitions").appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).accept(new String[]{"application/json;charset=UTF-8"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(LogAnalyticsSourceExtendedFieldDefinitionCollection.class, ListSourceExtendedFieldDefinitionsResponse.Builder::logAnalyticsSourceExtendedFieldDefinitionCollection).handleResponseHeaderString("opc-prev-page", ListSourceExtendedFieldDefinitionsResponse.Builder::opcPrevPage).handleResponseHeaderString("opc-next-page", ListSourceExtendedFieldDefinitionsResponse.Builder::opcNextPage).handleResponseHeaderString("opc-request-id", ListSourceExtendedFieldDefinitionsResponse.Builder::opcRequestId).operationUsesDefaultRetries().callSync();
    }

    @Override
    public ListSourceLabelOperatorsResponse listSourceLabelOperators(ListSourceLabelOperatorsRequest request) {
        Validate.notBlank((String)request.getNamespaceName(), (String)"namespaceName must not be blank", (Object[])new Object[0]);
        return (ListSourceLabelOperatorsResponse)this.clientCall(request, ListSourceLabelOperatorsResponse::builder).logger(LOG, "listSourceLabelOperators").serviceDetails("LogAnalytics", "ListSourceLabelOperators", "https://docs.oracle.com/iaas/api/#/en/logan-api-spec/20200601/LogAnalyticsSource/ListSourceLabelOperators").method(Method.GET).requestBuilder(ListSourceLabelOperatorsRequest::builder).basePath("/20200601").appendPathParam("namespaces").appendPathParam(request.getNamespaceName()).appendPathParam("sourceLabelOperators").appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).accept(new String[]{"application/json;charset=UTF-8"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(LogAnalyticsLabelOperatorCollection.class, ListSourceLabelOperatorsResponse.Builder::logAnalyticsLabelOperatorCollection).handleResponseHeaderString("opc-prev-page", ListSourceLabelOperatorsResponse.Builder::opcPrevPage).handleResponseHeaderString("opc-next-page", ListSourceLabelOperatorsResponse.Builder::opcNextPage).handleResponseHeaderString("opc-request-id", ListSourceLabelOperatorsResponse.Builder::opcRequestId).operationUsesDefaultRetries().callSync();
    }

    @Override
    public ListSourceMetaFunctionsResponse listSourceMetaFunctions(ListSourceMetaFunctionsRequest request) {
        Validate.notBlank((String)request.getNamespaceName(), (String)"namespaceName must not be blank", (Object[])new Object[0]);
        return (ListSourceMetaFunctionsResponse)this.clientCall(request, ListSourceMetaFunctionsResponse::builder).logger(LOG, "listSourceMetaFunctions").serviceDetails("LogAnalytics", "ListSourceMetaFunctions", "https://docs.oracle.com/iaas/api/#/en/logan-api-spec/20200601/LogAnalyticsSource/ListSourceMetaFunctions").method(Method.GET).requestBuilder(ListSourceMetaFunctionsRequest::builder).basePath("/20200601").appendPathParam("namespaces").appendPathParam(request.getNamespaceName()).appendPathParam("sourceMetaFunctions").appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).accept(new String[]{"application/json;charset=UTF-8"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(LogAnalyticsMetaFunctionCollection.class, ListSourceMetaFunctionsResponse.Builder::logAnalyticsMetaFunctionCollection).handleResponseHeaderString("opc-prev-page", ListSourceMetaFunctionsResponse.Builder::opcPrevPage).handleResponseHeaderString("opc-next-page", ListSourceMetaFunctionsResponse.Builder::opcNextPage).handleResponseHeaderString("opc-request-id", ListSourceMetaFunctionsResponse.Builder::opcRequestId).operationUsesDefaultRetries().callSync();
    }

    @Override
    public ListSourcePatternsResponse listSourcePatterns(ListSourcePatternsRequest request) {
        Validate.notBlank((String)request.getNamespaceName(), (String)"namespaceName must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getSourceName(), (String)"sourceName must not be blank", (Object[])new Object[0]);
        return (ListSourcePatternsResponse)this.clientCall(request, ListSourcePatternsResponse::builder).logger(LOG, "listSourcePatterns").serviceDetails("LogAnalytics", "ListSourcePatterns", "https://docs.oracle.com/iaas/api/#/en/logan-api-spec/20200601/LogAnalyticsSource/ListSourcePatterns").method(Method.GET).requestBuilder(ListSourcePatternsRequest::builder).basePath("/20200601").appendPathParam("namespaces").appendPathParam(request.getNamespaceName()).appendPathParam("sources").appendPathParam(request.getSourceName()).appendPathParam("patterns").appendQueryParam("isInclude", (Object)request.getIsInclude()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).accept(new String[]{"application/json;charset=UTF-8"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(LogAnalyticsSourcePatternCollection.class, ListSourcePatternsResponse.Builder::logAnalyticsSourcePatternCollection).handleResponseHeaderString("opc-prev-page", ListSourcePatternsResponse.Builder::opcPrevPage).handleResponseHeaderString("opc-next-page", ListSourcePatternsResponse.Builder::opcNextPage).handleResponseHeaderString("opc-request-id", ListSourcePatternsResponse.Builder::opcRequestId).operationUsesDefaultRetries().callSync();
    }

    @Override
    public ListSourcesResponse listSources(ListSourcesRequest request) {
        Validate.notBlank((String)request.getNamespaceName(), (String)"namespaceName must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return (ListSourcesResponse)this.clientCall(request, ListSourcesResponse::builder).logger(LOG, "listSources").serviceDetails("LogAnalytics", "ListSources", "https://docs.oracle.com/iaas/api/#/en/logan-api-spec/20200601/LogAnalyticsSource/ListSources").method(Method.GET).requestBuilder(ListSourcesRequest::builder).basePath("/20200601").appendPathParam("namespaces").appendPathParam(request.getNamespaceName()).appendPathParam("sources").appendQueryParam("entityType", (Object)request.getEntityType()).appendQueryParam("sourceDisplayText", (Object)request.getSourceDisplayText()).appendEnumQueryParam("isSystem", (BmcEnum)request.getIsSystem()).appendQueryParam("isAutoAssociated", (Object)request.getIsAutoAssociated()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendQueryParam("name", (Object)request.getName()).appendQueryParam("categories", (Object)request.getCategories()).appendQueryParam("isSimplified", (Object)request.getIsSimplified()).appendQueryParam("compartmentId", (Object)request.getCompartmentId()).accept(new String[]{"application/json;charset=UTF-8"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(LogAnalyticsSourceCollection.class, ListSourcesResponse.Builder::logAnalyticsSourceCollection).handleResponseHeaderString("opc-prev-page", ListSourcesResponse.Builder::opcPrevPage).handleResponseHeaderString("opc-next-page", ListSourcesResponse.Builder::opcNextPage).handleResponseHeaderString("opc-request-id", ListSourcesResponse.Builder::opcRequestId).operationUsesDefaultRetries().callSync();
    }

    @Override
    public ListStorageWorkRequestErrorsResponse listStorageWorkRequestErrors(ListStorageWorkRequestErrorsRequest request) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        Validate.notBlank((String)request.getWorkRequestId(), (String)"workRequestId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getNamespaceName(), (String)"namespaceName must not be blank", (Object[])new Object[0]);
        return (ListStorageWorkRequestErrorsResponse)this.clientCall(request, ListStorageWorkRequestErrorsResponse::builder).logger(LOG, "listStorageWorkRequestErrors").serviceDetails("LogAnalytics", "ListStorageWorkRequestErrors", "https://docs.oracle.com/iaas/api/#/en/logan-api-spec/20200601/Storage/ListStorageWorkRequestErrors").method(Method.GET).requestBuilder(ListStorageWorkRequestErrorsRequest::builder).basePath("/20200601").appendPathParam("namespaces").appendPathParam(request.getNamespaceName()).appendPathParam("storageWorkRequests").appendPathParam(request.getWorkRequestId()).appendPathParam("errors").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(WorkRequestErrorCollection.class, ListStorageWorkRequestErrorsResponse.Builder::workRequestErrorCollection).handleResponseHeaderString("opc-request-id", ListStorageWorkRequestErrorsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListStorageWorkRequestErrorsResponse.Builder::opcNextPage).handleResponseHeaderString("opc-prev-page", ListStorageWorkRequestErrorsResponse.Builder::opcPrevPage).operationUsesDefaultRetries().callSync();
    }

    @Override
    public ListStorageWorkRequestsResponse listStorageWorkRequests(ListStorageWorkRequestsRequest request) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        Validate.notBlank((String)request.getNamespaceName(), (String)"namespaceName must not be blank", (Object[])new Object[0]);
        return (ListStorageWorkRequestsResponse)this.clientCall(request, ListStorageWorkRequestsResponse::builder).logger(LOG, "listStorageWorkRequests").serviceDetails("LogAnalytics", "ListStorageWorkRequests", "https://docs.oracle.com/iaas/api/#/en/logan-api-spec/20200601/Storage/ListStorageWorkRequests").method(Method.GET).requestBuilder(ListStorageWorkRequestsRequest::builder).basePath("/20200601").appendPathParam("namespaces").appendPathParam(request.getNamespaceName()).appendPathParam("storageWorkRequests").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendEnumQueryParam("operationType", (BmcEnum)request.getOperationType()).appendEnumQueryParam("status", (BmcEnum)request.getStatus()).appendQueryParam("timeStarted", (Object)request.getTimeStarted()).appendQueryParam("timeFinished", (Object)request.getTimeFinished()).appendQueryParam("policyName", (Object)request.getPolicyName()).appendQueryParam("policyId", (Object)request.getPolicyId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(StorageWorkRequestCollection.class, ListStorageWorkRequestsResponse.Builder::storageWorkRequestCollection).handleResponseHeaderString("opc-request-id", ListStorageWorkRequestsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListStorageWorkRequestsResponse.Builder::opcNextPage).handleResponseHeaderString("opc-prev-page", ListStorageWorkRequestsResponse.Builder::opcPrevPage).operationUsesDefaultRetries().callSync();
    }

    @Override
    public ListSupportedCharEncodingsResponse listSupportedCharEncodings(ListSupportedCharEncodingsRequest request) {
        Validate.notBlank((String)request.getNamespaceName(), (String)"namespaceName must not be blank", (Object[])new Object[0]);
        return (ListSupportedCharEncodingsResponse)this.clientCall(request, ListSupportedCharEncodingsResponse::builder).logger(LOG, "listSupportedCharEncodings").serviceDetails("LogAnalytics", "ListSupportedCharEncodings", "https://docs.oracle.com/iaas/api/#/en/logan-api-spec/20200601/CharEncodingCollection/ListSupportedCharEncodings").method(Method.GET).requestBuilder(ListSupportedCharEncodingsRequest::builder).basePath("/20200601").appendPathParam("namespaces").appendPathParam(request.getNamespaceName()).appendPathParam("supportedCharEncodings").appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(CharEncodingCollection.class, ListSupportedCharEncodingsResponse.Builder::charEncodingCollection).handleResponseHeaderString("opc-request-id", ListSupportedCharEncodingsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListSupportedCharEncodingsResponse.Builder::opcNextPage).handleResponseHeaderLong("opc-total-items", ListSupportedCharEncodingsResponse.Builder::opcTotalItems).operationUsesDefaultRetries().callSync();
    }

    @Override
    public ListSupportedTimezonesResponse listSupportedTimezones(ListSupportedTimezonesRequest request) {
        Validate.notBlank((String)request.getNamespaceName(), (String)"namespaceName must not be blank", (Object[])new Object[0]);
        return (ListSupportedTimezonesResponse)this.clientCall(request, ListSupportedTimezonesResponse::builder).logger(LOG, "listSupportedTimezones").serviceDetails("LogAnalytics", "ListSupportedTimezones", "https://docs.oracle.com/iaas/api/#/en/logan-api-spec/20200601/TimezoneCollection/ListSupportedTimezones").method(Method.GET).requestBuilder(ListSupportedTimezonesRequest::builder).basePath("/20200601").appendPathParam("namespaces").appendPathParam(request.getNamespaceName()).appendPathParam("supportedTimezones").appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(TimezoneCollection.class, ListSupportedTimezonesResponse.Builder::timezoneCollection).handleResponseHeaderString("opc-request-id", ListSupportedTimezonesResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListSupportedTimezonesResponse.Builder::opcNextPage).handleResponseHeaderLong("opc-total-items", ListSupportedTimezonesResponse.Builder::opcTotalItems).operationUsesDefaultRetries().callSync();
    }

    @Override
    public ListUploadFilesResponse listUploadFiles(ListUploadFilesRequest request) {
        Validate.notBlank((String)request.getNamespaceName(), (String)"namespaceName must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getUploadReference(), (String)"uploadReference must not be blank", (Object[])new Object[0]);
        return (ListUploadFilesResponse)this.clientCall(request, ListUploadFilesResponse::builder).logger(LOG, "listUploadFiles").serviceDetails("LogAnalytics", "ListUploadFiles", "https://docs.oracle.com/iaas/api/#/en/logan-api-spec/20200601/Upload/ListUploadFiles").method(Method.GET).requestBuilder(ListUploadFilesRequest::builder).basePath("/20200601").appendPathParam("namespaces").appendPathParam(request.getNamespaceName()).appendPathParam("uploads").appendPathParam(request.getUploadReference()).appendPathParam("files").appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendQueryParam("searchStr", (Object)request.getSearchStr()).appendListQueryParam("status", request.getStatus(), CollectionFormatType.Multi).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(UploadFileCollection.class, ListUploadFilesResponse.Builder::uploadFileCollection).handleResponseHeaderString("opc-request-id", ListUploadFilesResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListUploadFilesResponse.Builder::opcNextPage).operationUsesDefaultRetries().callSync();
    }

    @Override
    public ListUploadWarningsResponse listUploadWarnings(ListUploadWarningsRequest request) {
        Validate.notBlank((String)request.getNamespaceName(), (String)"namespaceName must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getUploadReference(), (String)"uploadReference must not be blank", (Object[])new Object[0]);
        return (ListUploadWarningsResponse)this.clientCall(request, ListUploadWarningsResponse::builder).logger(LOG, "listUploadWarnings").serviceDetails("LogAnalytics", "ListUploadWarnings", "https://docs.oracle.com/iaas/api/#/en/logan-api-spec/20200601/Upload/ListUploadWarnings").method(Method.GET).requestBuilder(ListUploadWarningsRequest::builder).basePath("/20200601").appendPathParam("namespaces").appendPathParam(request.getNamespaceName()).appendPathParam("uploads").appendPathParam(request.getUploadReference()).appendPathParam("warnings").appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(UploadWarningCollection.class, ListUploadWarningsResponse.Builder::uploadWarningCollection).handleResponseHeaderString("opc-request-id", ListUploadWarningsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListUploadWarningsResponse.Builder::opcNextPage).operationUsesDefaultRetries().callSync();
    }

    @Override
    public ListUploadsResponse listUploads(ListUploadsRequest request) {
        Validate.notBlank((String)request.getNamespaceName(), (String)"namespaceName must not be blank", (Object[])new Object[0]);
        return (ListUploadsResponse)this.clientCall(request, ListUploadsResponse::builder).logger(LOG, "listUploads").serviceDetails("LogAnalytics", "ListUploads", "https://docs.oracle.com/iaas/api/#/en/logan-api-spec/20200601/Upload/ListUploads").method(Method.GET).requestBuilder(ListUploadsRequest::builder).basePath("/20200601").appendPathParam("namespaces").appendPathParam(request.getNamespaceName()).appendPathParam("uploads").appendQueryParam("name", (Object)request.getName()).appendQueryParam("nameContains", (Object)request.getNameContains()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendEnumQueryParam("warningsFilter", (BmcEnum)request.getWarningsFilter()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(UploadCollection.class, ListUploadsResponse.Builder::uploadCollection).handleResponseHeaderString("opc-request-id", ListUploadsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListUploadsResponse.Builder::opcNextPage).handleResponseHeaderLong("opc-total-items", ListUploadsResponse.Builder::opcTotalItems).operationUsesDefaultRetries().callSync();
    }

    @Override
    public ListWarningsResponse listWarnings(ListWarningsRequest request) {
        Validate.notBlank((String)request.getNamespaceName(), (String)"namespaceName must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return (ListWarningsResponse)this.clientCall(request, ListWarningsResponse::builder).logger(LOG, "listWarnings").serviceDetails("LogAnalytics", "ListWarnings", "https://docs.oracle.com/iaas/api/#/en/logan-api-spec/20200601/LogAnalyticsWarning/ListWarnings").method(Method.GET).requestBuilder(ListWarningsRequest::builder).basePath("/20200601").appendPathParam("namespaces").appendPathParam(request.getNamespaceName()).appendPathParam("warnings").appendEnumQueryParam("warningState", (BmcEnum)request.getWarningState()).appendQueryParam("sourceName", (Object)request.getSourceName()).appendQueryParam("sourcePattern", (Object)request.getSourcePattern()).appendQueryParam("warningMessage", (Object)request.getWarningMessage()).appendQueryParam("entityName", (Object)request.getEntityName()).appendQueryParam("entityType", (Object)request.getEntityType()).appendQueryParam("warningType", (Object)request.getWarningType()).appendQueryParam("isNoSource", (Object)request.getIsNoSource()).appendQueryParam("startTime", (Object)request.getStartTime()).appendQueryParam("endTime", (Object)request.getEndTime()).appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(LogAnalyticsWarningCollection.class, ListWarningsResponse.Builder::logAnalyticsWarningCollection).handleResponseHeaderString("opc-prev-page", ListWarningsResponse.Builder::opcPrevPage).handleResponseHeaderString("opc-next-page", ListWarningsResponse.Builder::opcNextPage).handleResponseHeaderString("opc-request-id", ListWarningsResponse.Builder::opcRequestId).operationUsesDefaultRetries().callSync();
    }

    @Override
    public ListWorkRequestErrorsResponse listWorkRequestErrors(ListWorkRequestErrorsRequest request) {
        Validate.notBlank((String)request.getNamespaceName(), (String)"namespaceName must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getWorkRequestId(), (String)"workRequestId must not be blank", (Object[])new Object[0]);
        return (ListWorkRequestErrorsResponse)this.clientCall(request, ListWorkRequestErrorsResponse::builder).logger(LOG, "listWorkRequestErrors").serviceDetails("LogAnalytics", "ListWorkRequestErrors", "https://docs.oracle.com/iaas/api/#/en/logan-api-spec/20200601/WorkRequestError/ListWorkRequestErrors").method(Method.GET).requestBuilder(ListWorkRequestErrorsRequest::builder).basePath("/20200601").appendPathParam("namespaces").appendPathParam(request.getNamespaceName()).appendPathParam("workRequests").appendPathParam(request.getWorkRequestId()).appendPathParam("errors").appendQueryParam("page", (Object)request.getPage()).appendQueryParam("limit", (Object)request.getLimit()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(WorkRequestErrorCollection.class, ListWorkRequestErrorsResponse.Builder::workRequestErrorCollection).handleResponseHeaderString("opc-next-page", ListWorkRequestErrorsResponse.Builder::opcNextPage).handleResponseHeaderString("opc-request-id", ListWorkRequestErrorsResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public ListWorkRequestLogsResponse listWorkRequestLogs(ListWorkRequestLogsRequest request) {
        Validate.notBlank((String)request.getNamespaceName(), (String)"namespaceName must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getWorkRequestId(), (String)"workRequestId must not be blank", (Object[])new Object[0]);
        return (ListWorkRequestLogsResponse)this.clientCall(request, ListWorkRequestLogsResponse::builder).logger(LOG, "listWorkRequestLogs").serviceDetails("LogAnalytics", "ListWorkRequestLogs", "https://docs.oracle.com/iaas/api/#/en/logan-api-spec/20200601/WorkRequestLog/ListWorkRequestLogs").method(Method.GET).requestBuilder(ListWorkRequestLogsRequest::builder).basePath("/20200601").appendPathParam("namespaces").appendPathParam(request.getNamespaceName()).appendPathParam("workRequests").appendPathParam(request.getWorkRequestId()).appendPathParam("logs").appendQueryParam("page", (Object)request.getPage()).appendQueryParam("limit", (Object)request.getLimit()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(WorkRequestLogCollection.class, ListWorkRequestLogsResponse.Builder::workRequestLogCollection).handleResponseHeaderString("opc-next-page", ListWorkRequestLogsResponse.Builder::opcNextPage).handleResponseHeaderString("opc-request-id", ListWorkRequestLogsResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public ListWorkRequestsResponse listWorkRequests(ListWorkRequestsRequest request) {
        Validate.notBlank((String)request.getNamespaceName(), (String)"namespaceName must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return (ListWorkRequestsResponse)this.clientCall(request, ListWorkRequestsResponse::builder).logger(LOG, "listWorkRequests").serviceDetails("LogAnalytics", "ListWorkRequests", "https://docs.oracle.com/iaas/api/#/en/logan-api-spec/20200601/WorkRequest/ListWorkRequests").method(Method.GET).requestBuilder(ListWorkRequestsRequest::builder).basePath("/20200601").appendPathParam("namespaces").appendPathParam(request.getNamespaceName()).appendPathParam("workRequests").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("page", (Object)request.getPage()).appendQueryParam("limit", (Object)request.getLimit()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(WorkRequestCollection.class, ListWorkRequestsResponse.Builder::workRequestCollection).handleResponseHeaderString("opc-request-id", ListWorkRequestsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListWorkRequestsResponse.Builder::opcNextPage).callSync();
    }

    @Override
    public OffboardNamespaceResponse offboardNamespace(OffboardNamespaceRequest request) {
        Validate.notBlank((String)request.getNamespaceName(), (String)"namespaceName must not be blank", (Object[])new Object[0]);
        return (OffboardNamespaceResponse)this.clientCall(request, OffboardNamespaceResponse::builder).logger(LOG, "offboardNamespace").serviceDetails("LogAnalytics", "OffboardNamespace", "https://docs.oracle.com/iaas/api/#/en/logan-api-spec/20200601/Namespace/OffboardNamespace").method(Method.POST).requestBuilder(OffboardNamespaceRequest::builder).basePath("/20200601").appendPathParam("namespaces").appendPathParam(request.getNamespaceName()).appendPathParam("actions").appendPathParam("offboard").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).handleResponseHeaderString("opc-work-request-id", OffboardNamespaceResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", OffboardNamespaceResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public OnboardNamespaceResponse onboardNamespace(OnboardNamespaceRequest request) {
        Validate.notBlank((String)request.getNamespaceName(), (String)"namespaceName must not be blank", (Object[])new Object[0]);
        return (OnboardNamespaceResponse)this.clientCall(request, OnboardNamespaceResponse::builder).logger(LOG, "onboardNamespace").serviceDetails("LogAnalytics", "OnboardNamespace", "https://docs.oracle.com/iaas/api/#/en/logan-api-spec/20200601/Namespace/OnboardNamespace").method(Method.POST).requestBuilder(OnboardNamespaceRequest::builder).basePath("/20200601").appendPathParam("namespaces").appendPathParam(request.getNamespaceName()).appendPathParam("actions").appendPathParam("onboard").accept(new String[]{"application/json"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("opc-request-id", request.getOpcRequestId()).handleResponseHeaderString("opc-work-request-id", OnboardNamespaceResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", OnboardNamespaceResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public ParseQueryResponse parseQuery(ParseQueryRequest request) {
        Validate.notBlank((String)request.getNamespaceName(), (String)"namespaceName must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getParseQueryDetails(), "parseQueryDetails is required");
        return (ParseQueryResponse)this.clientCall(request, ParseQueryResponse::builder).logger(LOG, "parseQuery").serviceDetails("LogAnalytics", "ParseQuery", "https://docs.oracle.com/iaas/api/#/en/logan-api-spec/20200601/QueryDetails/ParseQuery").method(Method.POST).requestBuilder(ParseQueryRequest::builder).basePath("/20200601").appendPathParam("namespaces").appendPathParam(request.getNamespaceName()).appendPathParam("search").appendPathParam("actions").appendPathParam("parse").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleBody(ParseQueryOutput.class, ParseQueryResponse.Builder::parseQueryOutput).handleResponseHeaderString("opc-request-id", ParseQueryResponse.Builder::opcRequestId).operationUsesDefaultRetries().callSync();
    }

    @Override
    public PauseScheduledTaskResponse pauseScheduledTask(PauseScheduledTaskRequest request) {
        Validate.notBlank((String)request.getNamespaceName(), (String)"namespaceName must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getScheduledTaskId(), (String)"scheduledTaskId must not be blank", (Object[])new Object[0]);
        return (PauseScheduledTaskResponse)this.clientCall(request, PauseScheduledTaskResponse::builder).logger(LOG, "pauseScheduledTask").serviceDetails("LogAnalytics", "PauseScheduledTask", "https://docs.oracle.com/iaas/api/#/en/logan-api-spec/20200601/ScheduledTask/PauseScheduledTask").method(Method.POST).requestBuilder(PauseScheduledTaskRequest::builder).basePath("/20200601").appendPathParam("namespaces").appendPathParam(request.getNamespaceName()).appendPathParam("scheduledTasks").appendPathParam(request.getScheduledTaskId()).appendPathParam("actions").appendPathParam("pause").accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(ScheduledTask.class, PauseScheduledTaskResponse.Builder::scheduledTask).handleResponseHeaderString("opc-request-id", PauseScheduledTaskResponse.Builder::opcRequestId).handleResponseHeaderString("etag", PauseScheduledTaskResponse.Builder::etag).operationUsesDefaultRetries().callSync();
    }

    @Override
    public PurgeStorageDataResponse purgeStorageData(PurgeStorageDataRequest request) {
        Validate.notBlank((String)request.getNamespaceName(), (String)"namespaceName must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getPurgeStorageDataDetails(), "purgeStorageDataDetails is required");
        return (PurgeStorageDataResponse)this.clientCall(request, PurgeStorageDataResponse::builder).logger(LOG, "purgeStorageData").serviceDetails("LogAnalytics", "PurgeStorageData", "https://docs.oracle.com/iaas/api/#/en/logan-api-spec/20200601/Storage/PurgeStorageData").method(Method.POST).requestBuilder(PurgeStorageDataRequest::builder).basePath("/20200601").appendPathParam("namespaces").appendPathParam(request.getNamespaceName()).appendPathParam("storage").appendPathParam("actions").appendPathParam("purgeData").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("if-match", request.getIfMatch()).hasBody().handleResponseHeaderString("opc-request-id", PurgeStorageDataResponse.Builder::opcRequestId).handleResponseHeaderString("opc-work-request-id", PurgeStorageDataResponse.Builder::opcWorkRequestId).handleResponseHeaderString("location", PurgeStorageDataResponse.Builder::location).callSync();
    }

    @Override
    public PutQueryWorkRequestBackgroundResponse putQueryWorkRequestBackground(PutQueryWorkRequestBackgroundRequest request) {
        Validate.notBlank((String)request.getNamespaceName(), (String)"namespaceName must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getWorkRequestId(), (String)"workRequestId must not be blank", (Object[])new Object[0]);
        return (PutQueryWorkRequestBackgroundResponse)this.clientCall(request, PutQueryWorkRequestBackgroundResponse::builder).logger(LOG, "putQueryWorkRequestBackground").serviceDetails("LogAnalytics", "PutQueryWorkRequestBackground", "https://docs.oracle.com/iaas/api/#/en/logan-api-spec/20200601/QueryWorkRequest/PutQueryWorkRequestBackground").method(Method.PUT).requestBuilder(PutQueryWorkRequestBackgroundRequest::builder).basePath("/20200601").appendPathParam("namespaces").appendPathParam(request.getNamespaceName()).appendPathParam("queryWorkRequests").appendPathParam(request.getWorkRequestId()).appendPathParam("actions").appendPathParam("background").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("if-match", request.getIfMatch()).handleBody(QueryWorkRequest.class, PutQueryWorkRequestBackgroundResponse.Builder::queryWorkRequest).handleResponseHeaderString("etag", PutQueryWorkRequestBackgroundResponse.Builder::etag).handleResponseHeaderString("opc-request-id", PutQueryWorkRequestBackgroundResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public QueryResponse query(QueryRequest request) {
        Validate.notBlank((String)request.getNamespaceName(), (String)"namespaceName must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getQueryDetails(), "queryDetails is required");
        return (QueryResponse)this.clientCall(request, QueryResponse::builder).logger(LOG, "query").serviceDetails("LogAnalytics", "Query", "https://docs.oracle.com/iaas/api/#/en/logan-api-spec/20200601/QueryDetails/Query").method(Method.POST).requestBuilder(QueryRequest::builder).basePath("/20200601").appendPathParam("namespaces").appendPathParam(request.getNamespaceName()).appendPathParam("search").appendPathParam("actions").appendPathParam("query").appendQueryParam("page", (Object)request.getPage()).appendQueryParam("limit", (Object)request.getLimit()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleBody(QueryAggregation.class, QueryResponse.Builder::queryAggregation).handleResponseHeaderString("opc-request-id", QueryResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page-id", QueryResponse.Builder::opcNextPageId).handleResponseHeaderString("opc-prev-page-id", QueryResponse.Builder::opcPrevPageId).handleResponseHeaderString("opc-work-request-id", QueryResponse.Builder::opcWorkRequestId).handleResponseHeaderString("location", QueryResponse.Builder::location).operationUsesDefaultRetries().callSync();
    }

    @Override
    public RecallArchivedDataResponse recallArchivedData(RecallArchivedDataRequest request) {
        Validate.notBlank((String)request.getNamespaceName(), (String)"namespaceName must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getRecallArchivedDataDetails(), "recallArchivedDataDetails is required");
        return (RecallArchivedDataResponse)this.clientCall(request, RecallArchivedDataResponse::builder).logger(LOG, "recallArchivedData").serviceDetails("LogAnalytics", "RecallArchivedData", "https://docs.oracle.com/iaas/api/#/en/logan-api-spec/20200601/Storage/RecallArchivedData").method(Method.POST).requestBuilder(RecallArchivedDataRequest::builder).basePath("/20200601").appendPathParam("namespaces").appendPathParam(request.getNamespaceName()).appendPathParam("storage").appendPathParam("actions").appendPathParam("recallArchivedData").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("if-match", request.getIfMatch()).hasBody().handleResponseHeaderString("opc-request-id", RecallArchivedDataResponse.Builder::opcRequestId).handleResponseHeaderString("opc-work-request-id", RecallArchivedDataResponse.Builder::opcWorkRequestId).handleResponseHeaderString("location", RecallArchivedDataResponse.Builder::location).callSync();
    }

    @Override
    public RegisterLookupResponse registerLookup(RegisterLookupRequest request) {
        Validate.notBlank((String)request.getNamespaceName(), (String)"namespaceName must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getType(), "type is required");
        Objects.requireNonNull(request.getRegisterLookupContentFileBody(), "registerLookupContentFileBody is required");
        return (RegisterLookupResponse)this.clientCall(request, RegisterLookupResponse::builder).logger(LOG, "registerLookup").serviceDetails("LogAnalytics", "RegisterLookup", "https://docs.oracle.com/iaas/api/#/en/logan-api-spec/20200601/LogAnalyticsLookup/RegisterLookup").method(Method.POST).requestBuilder(RegisterLookupRequest::builder).basePath("/20200601").appendPathParam("namespaces").appendPathParam(request.getNamespaceName()).appendPathParam("lookups").appendPathParam("actions").appendPathParam("register").appendQueryParam("name", (Object)request.getName()).appendQueryParam("description", (Object)request.getDescription()).appendQueryParam("charEncoding", (Object)request.getCharEncoding()).appendQueryParam("isHidden", (Object)request.getIsHidden()).appendEnumQueryParam("type", (BmcEnum)request.getType()).accept(new String[]{"application/json;charset=UTF-8"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("expect", request.getExpect()).hasBinaryRequestBody().hasBody().handleBody(LogAnalyticsLookup.class, RegisterLookupResponse.Builder::logAnalyticsLookup).handleResponseHeaderString("etag", RegisterLookupResponse.Builder::etag).handleResponseHeaderString("opc-request-id", RegisterLookupResponse.Builder::opcRequestId).operationUsesDefaultRetries().callSync();
    }

    @Override
    public ReleaseRecalledDataResponse releaseRecalledData(ReleaseRecalledDataRequest request) {
        Validate.notBlank((String)request.getNamespaceName(), (String)"namespaceName must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getReleaseRecalledDataDetails(), "releaseRecalledDataDetails is required");
        return (ReleaseRecalledDataResponse)this.clientCall(request, ReleaseRecalledDataResponse::builder).logger(LOG, "releaseRecalledData").serviceDetails("LogAnalytics", "ReleaseRecalledData", "https://docs.oracle.com/iaas/api/#/en/logan-api-spec/20200601/Storage/ReleaseRecalledData").method(Method.POST).requestBuilder(ReleaseRecalledDataRequest::builder).basePath("/20200601").appendPathParam("namespaces").appendPathParam(request.getNamespaceName()).appendPathParam("storage").appendPathParam("actions").appendPathParam("releaseRecalledData").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("if-match", request.getIfMatch()).hasBody().handleResponseHeaderString("opc-request-id", ReleaseRecalledDataResponse.Builder::opcRequestId).handleResponseHeaderString("opc-work-request-id", ReleaseRecalledDataResponse.Builder::opcWorkRequestId).handleResponseHeaderString("location", ReleaseRecalledDataResponse.Builder::location).callSync();
    }

    @Override
    public RemoveEntityAssociationsResponse removeEntityAssociations(RemoveEntityAssociationsRequest request) {
        Validate.notBlank((String)request.getNamespaceName(), (String)"namespaceName must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getLogAnalyticsEntityId(), (String)"logAnalyticsEntityId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getRemoveEntityAssociationsDetails(), "removeEntityAssociationsDetails is required");
        return (RemoveEntityAssociationsResponse)this.clientCall(request, RemoveEntityAssociationsResponse::builder).logger(LOG, "removeEntityAssociations").serviceDetails("LogAnalytics", "RemoveEntityAssociations", "https://docs.oracle.com/iaas/api/#/en/logan-api-spec/20200601/LogAnalyticsEntity/RemoveEntityAssociations").method(Method.POST).requestBuilder(RemoveEntityAssociationsRequest::builder).basePath("/20200601").appendPathParam("namespaces").appendPathParam(request.getNamespaceName()).appendPathParam("logAnalyticsEntities").appendPathParam(request.getLogAnalyticsEntityId()).appendPathParam("actions").appendPathParam("removeEntityAssociations").accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBody().handleResponseHeaderString("opc-request-id", RemoveEntityAssociationsResponse.Builder::opcRequestId).operationUsesDefaultRetries().callSync();
    }

    @Override
    public RemovePreferencesResponse removePreferences(RemovePreferencesRequest request) {
        Validate.notBlank((String)request.getNamespaceName(), (String)"namespaceName must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getRemovePreferencesDetails(), "removePreferencesDetails is required");
        return (RemovePreferencesResponse)this.clientCall(request, RemovePreferencesResponse::builder).logger(LOG, "removePreferences").serviceDetails("LogAnalytics", "RemovePreferences", "https://docs.oracle.com/iaas/api/#/en/logan-api-spec/20200601/LogAnalyticsPreference/RemovePreferences").method(Method.POST).requestBuilder(RemovePreferencesRequest::builder).basePath("/20200601").appendPathParam("namespaces").appendPathParam(request.getNamespaceName()).appendPathParam("preferences").appendPathParam("actions").appendPathParam("removePreferences").accept(new String[]{"application/json"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleResponseHeaderString("opc-request-id", RemovePreferencesResponse.Builder::opcRequestId).operationUsesDefaultRetries().callSync();
    }

    @Override
    public RemoveResourceCategoriesResponse removeResourceCategories(RemoveResourceCategoriesRequest request) {
        Validate.notBlank((String)request.getNamespaceName(), (String)"namespaceName must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getRemoveResourceCategoriesDetails(), "removeResourceCategoriesDetails is required");
        return (RemoveResourceCategoriesResponse)this.clientCall(request, RemoveResourceCategoriesResponse::builder).logger(LOG, "removeResourceCategories").serviceDetails("LogAnalytics", "RemoveResourceCategories", "https://docs.oracle.com/iaas/api/#/en/logan-api-spec/20200601/LogAnalyticsCategory/RemoveResourceCategories").method(Method.POST).requestBuilder(RemoveResourceCategoriesRequest::builder).basePath("/20200601").appendPathParam("namespaces").appendPathParam(request.getNamespaceName()).appendPathParam("categories").appendPathParam("actions").appendPathParam("removeResourceCategories").accept(new String[]{"application/json;charset=UTF-8"}).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleResponseHeaderString("opc-request-id", RemoveResourceCategoriesResponse.Builder::opcRequestId).operationUsesDefaultRetries().callSync();
    }

    @Override
    public RemoveSourceEventTypesResponse removeSourceEventTypes(RemoveSourceEventTypesRequest request) {
        Validate.notBlank((String)request.getNamespaceName(), (String)"namespaceName must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getSourceName(), (String)"sourceName must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getRemoveEventTypeDetails(), "removeEventTypeDetails is required");
        return (RemoveSourceEventTypesResponse)this.clientCall(request, RemoveSourceEventTypesResponse::builder).logger(LOG, "removeSourceEventTypes").serviceDetails("LogAnalytics", "RemoveSourceEventTypes", "https://docs.oracle.com/iaas/api/#/en/logan-api-spec/20200601/LogAnalyticsSource/RemoveSourceEventTypes").method(Method.POST).requestBuilder(RemoveSourceEventTypesRequest::builder).basePath("/20200601").appendPathParam("namespaces").appendPathParam(request.getNamespaceName()).appendPathParam("sources").appendPathParam(request.getSourceName()).appendPathParam("actions").appendPathParam("removeEventTypes").accept(new String[]{"application/json"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleResponseHeaderString("opc-request-id", RemoveSourceEventTypesResponse.Builder::opcRequestId).operationUsesDefaultRetries().callSync();
    }

    @Override
    public ResumeScheduledTaskResponse resumeScheduledTask(ResumeScheduledTaskRequest request) {
        Validate.notBlank((String)request.getNamespaceName(), (String)"namespaceName must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getScheduledTaskId(), (String)"scheduledTaskId must not be blank", (Object[])new Object[0]);
        return (ResumeScheduledTaskResponse)this.clientCall(request, ResumeScheduledTaskResponse::builder).logger(LOG, "resumeScheduledTask").serviceDetails("LogAnalytics", "ResumeScheduledTask", "https://docs.oracle.com/iaas/api/#/en/logan-api-spec/20200601/ScheduledTask/ResumeScheduledTask").method(Method.POST).requestBuilder(ResumeScheduledTaskRequest::builder).basePath("/20200601").appendPathParam("namespaces").appendPathParam(request.getNamespaceName()).appendPathParam("scheduledTasks").appendPathParam(request.getScheduledTaskId()).appendPathParam("actions").appendPathParam("resume").accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(ScheduledTask.class, ResumeScheduledTaskResponse.Builder::scheduledTask).handleResponseHeaderString("opc-request-id", ResumeScheduledTaskResponse.Builder::opcRequestId).handleResponseHeaderString("etag", ResumeScheduledTaskResponse.Builder::etag).operationUsesDefaultRetries().callSync();
    }

    @Override
    public RunResponse run(RunRequest request) {
        Validate.notBlank((String)request.getNamespaceName(), (String)"namespaceName must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getScheduledTaskId(), (String)"scheduledTaskId must not be blank", (Object[])new Object[0]);
        return (RunResponse)this.clientCall(request, RunResponse::builder).logger(LOG, "run").serviceDetails("LogAnalytics", "Run", "https://docs.oracle.com/iaas/api/#/en/logan-api-spec/20200601/ScheduledTask/Run").method(Method.POST).requestBuilder(RunRequest::builder).basePath("/20200601").appendPathParam("namespaces").appendPathParam(request.getNamespaceName()).appendPathParam("scheduledTasks").appendPathParam(request.getScheduledTaskId()).appendPathParam("actions").appendPathParam("run").appendQueryParam("timeStart", (Object)request.getTimeStart()).appendQueryParam("timeEnd", (Object)request.getTimeEnd()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).handleResponseHeaderString("opc-request-id", RunResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public SetUnprocessedDataBucketResponse setUnprocessedDataBucket(SetUnprocessedDataBucketRequest request) {
        Validate.notBlank((String)request.getNamespaceName(), (String)"namespaceName must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getBucketName(), "bucketName is required");
        return (SetUnprocessedDataBucketResponse)this.clientCall(request, SetUnprocessedDataBucketResponse::builder).logger(LOG, "setUnprocessedDataBucket").serviceDetails("LogAnalytics", "SetUnprocessedDataBucket", "https://docs.oracle.com/iaas/api/#/en/logan-api-spec/20200601/Upload/SetUnprocessedDataBucket").method(Method.POST).requestBuilder(SetUnprocessedDataBucketRequest::builder).basePath("/20200601").appendPathParam("namespaces").appendPathParam(request.getNamespaceName()).appendPathParam("actions").appendPathParam("setUnprocessedDataBucket").appendQueryParam("bucketName", (Object)request.getBucketName()).appendQueryParam("isEnabled", (Object)request.getIsEnabled()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(UnprocessedDataBucket.class, SetUnprocessedDataBucketResponse.Builder::unprocessedDataBucket).handleResponseHeaderString("opc-request-id", SetUnprocessedDataBucketResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public SuggestResponse suggest(SuggestRequest request) {
        Validate.notBlank((String)request.getNamespaceName(), (String)"namespaceName must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getSuggestDetails(), "suggestDetails is required");
        return (SuggestResponse)this.clientCall(request, SuggestResponse::builder).logger(LOG, "suggest").serviceDetails("LogAnalytics", "Suggest", "https://docs.oracle.com/iaas/api/#/en/logan-api-spec/20200601/QueryDetails/Suggest").method(Method.POST).requestBuilder(SuggestRequest::builder).basePath("/20200601").appendPathParam("namespaces").appendPathParam(request.getNamespaceName()).appendPathParam("search").appendPathParam("actions").appendPathParam("suggest").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleBody(SuggestOutput.class, SuggestResponse.Builder::suggestOutput).handleResponseHeaderString("opc-request-id", SuggestResponse.Builder::opcRequestId).operationUsesDefaultRetries().callSync();
    }

    @Override
    public SuppressWarningResponse suppressWarning(SuppressWarningRequest request) {
        Validate.notBlank((String)request.getNamespaceName(), (String)"namespaceName must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getWarningReferenceDetails(), "warningReferenceDetails is required");
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return (SuppressWarningResponse)this.clientCall(request, SuppressWarningResponse::builder).logger(LOG, "suppressWarning").serviceDetails("LogAnalytics", "SuppressWarning", "https://docs.oracle.com/iaas/api/#/en/logan-api-spec/20200601/LogAnalyticsWarning/SuppressWarning").method(Method.POST).requestBuilder(SuppressWarningRequest::builder).basePath("/20200601").appendPathParam("namespaces").appendPathParam(request.getNamespaceName()).appendPathParam("warnings").appendPathParam("actions").appendPathParam("suppress").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).accept(new String[]{"application/json"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleResponseHeaderString("opc-request-id", SuppressWarningResponse.Builder::opcRequestId).operationUsesDefaultRetries().callSync();
    }

    @Override
    public TestParserResponse testParser(TestParserRequest request) {
        Validate.notBlank((String)request.getNamespaceName(), (String)"namespaceName must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getTestParserPayloadDetails(), "testParserPayloadDetails is required");
        return (TestParserResponse)this.clientCall(request, TestParserResponse::builder).logger(LOG, "testParser").serviceDetails("LogAnalytics", "TestParser", "https://docs.oracle.com/iaas/api/#/en/logan-api-spec/20200601/LogAnalyticsParser/TestParser").method(Method.POST).requestBuilder(TestParserRequest::builder).basePath("/20200601").appendPathParam("namespaces").appendPathParam(request.getNamespaceName()).appendPathParam("parsers").appendPathParam("actions").appendPathParam("test").appendEnumQueryParam("scope", (BmcEnum)request.getScope()).appendQueryParam("reqOriginModule", (Object)request.getReqOriginModule()).accept(new String[]{"application/json"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleBody(ParserTestResult.class, TestParserResponse.Builder::parserTestResult).handleResponseHeaderString("opc-request-id", TestParserResponse.Builder::opcRequestId).operationUsesDefaultRetries().callSync();
    }

    @Override
    public UnsuppressWarningResponse unsuppressWarning(UnsuppressWarningRequest request) {
        Validate.notBlank((String)request.getNamespaceName(), (String)"namespaceName must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getWarningReferenceDetails(), "warningReferenceDetails is required");
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return (UnsuppressWarningResponse)this.clientCall(request, UnsuppressWarningResponse::builder).logger(LOG, "unsuppressWarning").serviceDetails("LogAnalytics", "UnsuppressWarning", "https://docs.oracle.com/iaas/api/#/en/logan-api-spec/20200601/LogAnalyticsWarning/UnsuppressWarning").method(Method.POST).requestBuilder(UnsuppressWarningRequest::builder).basePath("/20200601").appendPathParam("namespaces").appendPathParam(request.getNamespaceName()).appendPathParam("warnings").appendPathParam("actions").appendPathParam("unsuppress").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).accept(new String[]{"application/json"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleResponseHeaderString("opc-request-id", UnsuppressWarningResponse.Builder::opcRequestId).operationUsesDefaultRetries().callSync();
    }

    @Override
    public UpdateIngestTimeRuleResponse updateIngestTimeRule(UpdateIngestTimeRuleRequest request) {
        Validate.notBlank((String)request.getNamespaceName(), (String)"namespaceName must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getIngestTimeRuleId(), (String)"ingestTimeRuleId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdateIngestTimeRuleDetails(), "updateIngestTimeRuleDetails is required");
        return (UpdateIngestTimeRuleResponse)this.clientCall(request, UpdateIngestTimeRuleResponse::builder).logger(LOG, "updateIngestTimeRule").serviceDetails("LogAnalytics", "UpdateIngestTimeRule", "https://docs.oracle.com/iaas/api/#/en/logan-api-spec/20200601/IngestTimeRule/UpdateIngestTimeRule").method(Method.PUT).requestBuilder(UpdateIngestTimeRuleRequest::builder).basePath("/20200601").appendPathParam("namespaces").appendPathParam(request.getNamespaceName()).appendPathParam("ingestTimeRules").appendPathParam(request.getIngestTimeRuleId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleBody(IngestTimeRule.class, UpdateIngestTimeRuleResponse.Builder::ingestTimeRule).handleResponseHeaderString("etag", UpdateIngestTimeRuleResponse.Builder::etag).handleResponseHeaderString("opc-request-id", UpdateIngestTimeRuleResponse.Builder::opcRequestId).operationUsesDefaultRetries().callSync();
    }

    @Override
    public UpdateLogAnalyticsEmBridgeResponse updateLogAnalyticsEmBridge(UpdateLogAnalyticsEmBridgeRequest request) {
        Validate.notBlank((String)request.getNamespaceName(), (String)"namespaceName must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getLogAnalyticsEmBridgeId(), (String)"logAnalyticsEmBridgeId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdateLogAnalyticsEmBridgeDetails(), "updateLogAnalyticsEmBridgeDetails is required");
        return (UpdateLogAnalyticsEmBridgeResponse)this.clientCall(request, UpdateLogAnalyticsEmBridgeResponse::builder).logger(LOG, "updateLogAnalyticsEmBridge").serviceDetails("LogAnalytics", "UpdateLogAnalyticsEmBridge", "https://docs.oracle.com/iaas/api/#/en/logan-api-spec/20200601/LogAnalyticsEmBridge/UpdateLogAnalyticsEmBridge").method(Method.PUT).requestBuilder(UpdateLogAnalyticsEmBridgeRequest::builder).basePath("/20200601").appendPathParam("namespaces").appendPathParam(request.getNamespaceName()).appendPathParam("logAnalyticsEmBridges").appendPathParam(request.getLogAnalyticsEmBridgeId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleBody(LogAnalyticsEmBridge.class, UpdateLogAnalyticsEmBridgeResponse.Builder::logAnalyticsEmBridge).handleResponseHeaderString("etag", UpdateLogAnalyticsEmBridgeResponse.Builder::etag).handleResponseHeaderString("opc-request-id", UpdateLogAnalyticsEmBridgeResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public UpdateLogAnalyticsEntityResponse updateLogAnalyticsEntity(UpdateLogAnalyticsEntityRequest request) {
        Validate.notBlank((String)request.getNamespaceName(), (String)"namespaceName must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getLogAnalyticsEntityId(), (String)"logAnalyticsEntityId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdateLogAnalyticsEntityDetails(), "updateLogAnalyticsEntityDetails is required");
        return (UpdateLogAnalyticsEntityResponse)this.clientCall(request, UpdateLogAnalyticsEntityResponse::builder).logger(LOG, "updateLogAnalyticsEntity").serviceDetails("LogAnalytics", "UpdateLogAnalyticsEntity", "https://docs.oracle.com/iaas/api/#/en/logan-api-spec/20200601/LogAnalyticsEntity/UpdateLogAnalyticsEntity").method(Method.PUT).requestBuilder(UpdateLogAnalyticsEntityRequest::builder).basePath("/20200601").appendPathParam("namespaces").appendPathParam(request.getNamespaceName()).appendPathParam("logAnalyticsEntities").appendPathParam(request.getLogAnalyticsEntityId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleBody(LogAnalyticsEntity.class, UpdateLogAnalyticsEntityResponse.Builder::logAnalyticsEntity).handleResponseHeaderString("etag", UpdateLogAnalyticsEntityResponse.Builder::etag).handleResponseHeaderString("opc-request-id", UpdateLogAnalyticsEntityResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public UpdateLogAnalyticsEntityTypeResponse updateLogAnalyticsEntityType(UpdateLogAnalyticsEntityTypeRequest request) {
        Validate.notBlank((String)request.getNamespaceName(), (String)"namespaceName must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdateLogAnalyticsEntityTypeDetails(), "updateLogAnalyticsEntityTypeDetails is required");
        Validate.notBlank((String)request.getEntityTypeName(), (String)"entityTypeName must not be blank", (Object[])new Object[0]);
        return (UpdateLogAnalyticsEntityTypeResponse)this.clientCall(request, UpdateLogAnalyticsEntityTypeResponse::builder).logger(LOG, "updateLogAnalyticsEntityType").serviceDetails("LogAnalytics", "UpdateLogAnalyticsEntityType", "https://docs.oracle.com/iaas/api/#/en/logan-api-spec/20200601/LogAnalyticsEntityType/UpdateLogAnalyticsEntityType").method(Method.PUT).requestBuilder(UpdateLogAnalyticsEntityTypeRequest::builder).basePath("/20200601").appendPathParam("namespaces").appendPathParam(request.getNamespaceName()).appendPathParam("logAnalyticsEntityTypes").appendPathParam(request.getEntityTypeName()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("if-match", request.getIfMatch()).hasBody().handleResponseHeaderString("opc-request-id", UpdateLogAnalyticsEntityTypeResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public UpdateLogAnalyticsLogGroupResponse updateLogAnalyticsLogGroup(UpdateLogAnalyticsLogGroupRequest request) {
        Validate.notBlank((String)request.getNamespaceName(), (String)"namespaceName must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getLogAnalyticsLogGroupId(), (String)"logAnalyticsLogGroupId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdateLogAnalyticsLogGroupDetails(), "updateLogAnalyticsLogGroupDetails is required");
        return (UpdateLogAnalyticsLogGroupResponse)this.clientCall(request, UpdateLogAnalyticsLogGroupResponse::builder).logger(LOG, "updateLogAnalyticsLogGroup").serviceDetails("LogAnalytics", "UpdateLogAnalyticsLogGroup", "https://docs.oracle.com/iaas/api/#/en/logan-api-spec/20200601/LogAnalyticsLogGroup/UpdateLogAnalyticsLogGroup").method(Method.PUT).requestBuilder(UpdateLogAnalyticsLogGroupRequest::builder).basePath("/20200601").appendPathParam("namespaces").appendPathParam(request.getNamespaceName()).appendPathParam("logAnalyticsLogGroups").appendPathParam(request.getLogAnalyticsLogGroupId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleBody(LogAnalyticsLogGroup.class, UpdateLogAnalyticsLogGroupResponse.Builder::logAnalyticsLogGroup).handleResponseHeaderString("etag", UpdateLogAnalyticsLogGroupResponse.Builder::etag).handleResponseHeaderString("opc-request-id", UpdateLogAnalyticsLogGroupResponse.Builder::opcRequestId).operationUsesDefaultRetries().callSync();
    }

    @Override
    public UpdateLogAnalyticsObjectCollectionRuleResponse updateLogAnalyticsObjectCollectionRule(UpdateLogAnalyticsObjectCollectionRuleRequest request) {
        Validate.notBlank((String)request.getNamespaceName(), (String)"namespaceName must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getLogAnalyticsObjectCollectionRuleId(), (String)"logAnalyticsObjectCollectionRuleId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdateLogAnalyticsObjectCollectionRuleDetails(), "updateLogAnalyticsObjectCollectionRuleDetails is required");
        return (UpdateLogAnalyticsObjectCollectionRuleResponse)this.clientCall(request, UpdateLogAnalyticsObjectCollectionRuleResponse::builder).logger(LOG, "updateLogAnalyticsObjectCollectionRule").serviceDetails("LogAnalytics", "UpdateLogAnalyticsObjectCollectionRule", "https://docs.oracle.com/iaas/api/#/en/logan-api-spec/20200601/LogAnalyticsObjectCollectionRule/UpdateLogAnalyticsObjectCollectionRule").method(Method.PUT).requestBuilder(UpdateLogAnalyticsObjectCollectionRuleRequest::builder).basePath("/20200601").appendPathParam("namespaces").appendPathParam(request.getNamespaceName()).appendPathParam("logAnalyticsObjectCollectionRules").appendPathParam(request.getLogAnalyticsObjectCollectionRuleId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleBody(LogAnalyticsObjectCollectionRule.class, UpdateLogAnalyticsObjectCollectionRuleResponse.Builder::logAnalyticsObjectCollectionRule).handleResponseHeaderString("etag", UpdateLogAnalyticsObjectCollectionRuleResponse.Builder::etag).handleResponseHeaderString("opc-request-id", UpdateLogAnalyticsObjectCollectionRuleResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public UpdateLookupResponse updateLookup(UpdateLookupRequest request) {
        Validate.notBlank((String)request.getNamespaceName(), (String)"namespaceName must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getLookupName(), (String)"lookupName must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdateLookupMetadataDetails(), "updateLookupMetadataDetails is required");
        return (UpdateLookupResponse)this.clientCall(request, UpdateLookupResponse::builder).logger(LOG, "updateLookup").serviceDetails("LogAnalytics", "UpdateLookup", "https://docs.oracle.com/iaas/api/#/en/logan-api-spec/20200601/LogAnalyticsLookup/UpdateLookup").method(Method.PUT).requestBuilder(UpdateLookupRequest::builder).basePath("/20200601").appendPathParam("namespaces").appendPathParam(request.getNamespaceName()).appendPathParam("lookups").appendPathParam(request.getLookupName()).accept(new String[]{"application/json"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("if-match", request.getIfMatch()).hasBody().handleBody(LogAnalyticsLookup.class, UpdateLookupResponse.Builder::logAnalyticsLookup).handleResponseHeaderString("etag", UpdateLookupResponse.Builder::etag).handleResponseHeaderString("opc-request-id", UpdateLookupResponse.Builder::opcRequestId).operationUsesDefaultRetries().callSync();
    }

    @Override
    public UpdateLookupDataResponse updateLookupData(UpdateLookupDataRequest request) {
        Validate.notBlank((String)request.getNamespaceName(), (String)"namespaceName must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getLookupName(), (String)"lookupName must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdateLookupFileBody(), "updateLookupFileBody is required");
        return (UpdateLookupDataResponse)this.clientCall(request, UpdateLookupDataResponse::builder).logger(LOG, "updateLookupData").serviceDetails("LogAnalytics", "UpdateLookupData", "https://docs.oracle.com/iaas/api/#/en/logan-api-spec/20200601/LogAnalyticsLookup/UpdateLookupData").method(Method.POST).requestBuilder(UpdateLookupDataRequest::builder).basePath("/20200601").appendPathParam("namespaces").appendPathParam(request.getNamespaceName()).appendPathParam("lookups").appendPathParam(request.getLookupName()).appendPathParam("actions").appendPathParam("updateData").appendQueryParam("isForce", (Object)request.getIsForce()).appendQueryParam("charEncoding", (Object)request.getCharEncoding()).accept(new String[]{"application/json"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("if-match", request.getIfMatch()).appendHeader("expect", request.getExpect()).hasBinaryRequestBody().hasBody().handleResponseHeaderString("opc-work-request-id", UpdateLookupDataResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", UpdateLookupDataResponse.Builder::opcRequestId).operationUsesDefaultRetries().callSync();
    }

    @Override
    public UpdatePreferencesResponse updatePreferences(UpdatePreferencesRequest request) {
        Validate.notBlank((String)request.getNamespaceName(), (String)"namespaceName must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdatePreferencesDetails(), "updatePreferencesDetails is required");
        return (UpdatePreferencesResponse)this.clientCall(request, UpdatePreferencesResponse::builder).logger(LOG, "updatePreferences").serviceDetails("LogAnalytics", "UpdatePreferences", "https://docs.oracle.com/iaas/api/#/en/logan-api-spec/20200601/LogAnalyticsPreference/UpdatePreferences").method(Method.POST).requestBuilder(UpdatePreferencesRequest::builder).basePath("/20200601").appendPathParam("namespaces").appendPathParam(request.getNamespaceName()).appendPathParam("preferences").appendPathParam("actions").appendPathParam("updatePreferences").accept(new String[]{"application/json"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleResponseHeaderString("opc-request-id", UpdatePreferencesResponse.Builder::opcRequestId).operationUsesDefaultRetries().callSync();
    }

    @Override
    public UpdateResourceCategoriesResponse updateResourceCategories(UpdateResourceCategoriesRequest request) {
        Validate.notBlank((String)request.getNamespaceName(), (String)"namespaceName must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdateResourceCategoriesDetails(), "updateResourceCategoriesDetails is required");
        return (UpdateResourceCategoriesResponse)this.clientCall(request, UpdateResourceCategoriesResponse::builder).logger(LOG, "updateResourceCategories").serviceDetails("LogAnalytics", "UpdateResourceCategories", "https://docs.oracle.com/iaas/api/#/en/logan-api-spec/20200601/LogAnalyticsCategory/UpdateResourceCategories").method(Method.POST).requestBuilder(UpdateResourceCategoriesRequest::builder).basePath("/20200601").appendPathParam("namespaces").appendPathParam(request.getNamespaceName()).appendPathParam("categories").appendPathParam("actions").appendPathParam("updateResourceCategories").accept(new String[]{"application/json;charset=UTF-8"}).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleResponseHeaderString("opc-request-id", UpdateResourceCategoriesResponse.Builder::opcRequestId).operationUsesDefaultRetries().callSync();
    }

    @Override
    public UpdateScheduledTaskResponse updateScheduledTask(UpdateScheduledTaskRequest request) {
        Validate.notBlank((String)request.getNamespaceName(), (String)"namespaceName must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getScheduledTaskId(), (String)"scheduledTaskId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdateScheduledTaskDetails(), "updateScheduledTaskDetails is required");
        return (UpdateScheduledTaskResponse)this.clientCall(request, UpdateScheduledTaskResponse::builder).logger(LOG, "updateScheduledTask").serviceDetails("LogAnalytics", "UpdateScheduledTask", "https://docs.oracle.com/iaas/api/#/en/logan-api-spec/20200601/ScheduledTask/UpdateScheduledTask").method(Method.PUT).requestBuilder(UpdateScheduledTaskRequest::builder).basePath("/20200601").appendPathParam("namespaces").appendPathParam(request.getNamespaceName()).appendPathParam("scheduledTasks").appendPathParam(request.getScheduledTaskId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("if-match", request.getIfMatch()).hasBody().handleBody(ScheduledTask.class, UpdateScheduledTaskResponse.Builder::scheduledTask).handleResponseHeaderString("opc-request-id", UpdateScheduledTaskResponse.Builder::opcRequestId).handleResponseHeaderString("etag", UpdateScheduledTaskResponse.Builder::etag).operationUsesDefaultRetries().callSync();
    }

    @Override
    public UpdateStorageResponse updateStorage(UpdateStorageRequest request) {
        Validate.notBlank((String)request.getNamespaceName(), (String)"namespaceName must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdateStorageDetails(), "updateStorageDetails is required");
        return (UpdateStorageResponse)this.clientCall(request, UpdateStorageResponse::builder).logger(LOG, "updateStorage").serviceDetails("LogAnalytics", "UpdateStorage", "https://docs.oracle.com/iaas/api/#/en/logan-api-spec/20200601/Storage/UpdateStorage").method(Method.PUT).requestBuilder(UpdateStorageRequest::builder).basePath("/20200601").appendPathParam("namespaces").appendPathParam(request.getNamespaceName()).appendPathParam("storage").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("if-match", request.getIfMatch()).hasBody().handleBody(Storage.class, UpdateStorageResponse.Builder::storage).handleResponseHeaderString("opc-request-id", UpdateStorageResponse.Builder::opcRequestId).handleResponseHeaderString("etag", UpdateStorageResponse.Builder::etag).operationUsesDefaultRetries().callSync();
    }

    @Override
    public UploadLogEventsFileResponse uploadLogEventsFile(UploadLogEventsFileRequest request) {
        Validate.notBlank((String)request.getNamespaceName(), (String)"namespaceName must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getLogGroupId(), "logGroupId is required");
        Objects.requireNonNull(request.getUploadLogEventsFileDetails(), "uploadLogEventsFileDetails is required");
        return (UploadLogEventsFileResponse)this.clientCall(request, UploadLogEventsFileResponse::builder).logger(LOG, "uploadLogEventsFile").serviceDetails("LogAnalytics", "UploadLogEventsFile", "https://docs.oracle.com/iaas/api/#/en/logan-api-spec/20200601/Upload/UploadLogEventsFile").method(Method.POST).requestBuilder(UploadLogEventsFileRequest::builder).obmcsSigningStrategy(SigningStrategy.EXCLUDE_BODY).basePath("/20200601").appendPathParam("namespaces").appendPathParam(request.getNamespaceName()).appendPathParam("actions").appendPathParam("uploadLogEventsFile").appendQueryParam("logGroupId", (Object)request.getLogGroupId()).appendQueryParam("logSet", (Object)request.getLogSet()).appendEnumQueryParam("payloadType", (BmcEnum)request.getPayloadType()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("content-type", request.getContentType()).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("expect", request.getExpect()).hasBinaryRequestBody().hasBody().handleResponseHeaderString("opc-request-id", UploadLogEventsFileResponse.Builder::opcRequestId).handleResponseHeaderString("opc-object-id", UploadLogEventsFileResponse.Builder::opcObjectId).handleResponseHeaderDate("timeCreated", UploadLogEventsFileResponse.Builder::timeCreated).operationUsesDefaultRetries().callSync();
    }

    @Override
    public UploadLogFileResponse uploadLogFile(UploadLogFileRequest request) {
        Validate.notBlank((String)request.getNamespaceName(), (String)"namespaceName must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUploadName(), "uploadName is required");
        Objects.requireNonNull(request.getLogSourceName(), "logSourceName is required");
        Objects.requireNonNull(request.getFilename(), "filename is required");
        Objects.requireNonNull(request.getOpcMetaLoggrpid(), "opcMetaLoggrpid is required");
        Objects.requireNonNull(request.getUploadLogFileBody(), "uploadLogFileBody is required");
        return (UploadLogFileResponse)this.clientCall(request, UploadLogFileResponse::builder).logger(LOG, "uploadLogFile").serviceDetails("LogAnalytics", "UploadLogFile", "https://docs.oracle.com/iaas/api/#/en/logan-api-spec/20200601/Upload/UploadLogFile").method(Method.POST).requestBuilder(UploadLogFileRequest::builder).obmcsSigningStrategy(SigningStrategy.EXCLUDE_BODY).basePath("/20200601").appendPathParam("namespaces").appendPathParam(request.getNamespaceName()).appendPathParam("actions").appendPathParam("uploadLogFile").appendQueryParam("uploadName", (Object)request.getUploadName()).appendQueryParam("logSourceName", (Object)request.getLogSourceName()).appendQueryParam("entityId", (Object)request.getEntityId()).appendQueryParam("timezone", (Object)request.getTimezone()).appendQueryParam("charEncoding", (Object)request.getCharEncoding()).appendQueryParam("dateFormat", (Object)request.getDateFormat()).appendQueryParam("dateYear", (Object)request.getDateYear()).appendQueryParam("invalidateCache", (Object)request.getInvalidateCache()).appendQueryParam("filename", (Object)request.getFilename()).appendQueryParam("logSet", (Object)request.getLogSet()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("content-md5", request.getContentMd5()).appendHeader("content-type", request.getContentType()).appendHeader("opc-meta-loggrpid", request.getOpcMetaLoggrpid()).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("expect", request.getExpect()).hasBinaryRequestBody().hasBody().handleBody(Upload.class, UploadLogFileResponse.Builder::upload).handleResponseHeaderString("opc-request-id", UploadLogFileResponse.Builder::opcRequestId).handleResponseHeaderString("opc-content-md5", UploadLogFileResponse.Builder::opcContentMd5).handleResponseHeaderString("opc-object-id", UploadLogFileResponse.Builder::opcObjectId).operationUsesDefaultRetries().callSync();
    }

    @Override
    public UpsertAssociationsResponse upsertAssociations(UpsertAssociationsRequest request) {
        Validate.notBlank((String)request.getNamespaceName(), (String)"namespaceName must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpsertLogAnalyticsAssociationDetails(), "upsertLogAnalyticsAssociationDetails is required");
        return (UpsertAssociationsResponse)this.clientCall(request, UpsertAssociationsResponse::builder).logger(LOG, "upsertAssociations").serviceDetails("LogAnalytics", "UpsertAssociations", "https://docs.oracle.com/iaas/api/#/en/logan-api-spec/20200601/LogAnalyticsAssociation/UpsertAssociations").method(Method.POST).requestBuilder(UpsertAssociationsRequest::builder).basePath("/20200601").appendPathParam("namespaces").appendPathParam(request.getNamespaceName()).appendPathParam("associations").appendPathParam("actions").appendPathParam("upsert").appendQueryParam("isFromRepublish", (Object)request.getIsFromRepublish()).accept(new String[]{"application/json"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleResponseHeaderString("opc-work-request-id", UpsertAssociationsResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", UpsertAssociationsResponse.Builder::opcRequestId).operationUsesDefaultRetries().callSync();
    }

    @Override
    public UpsertFieldResponse upsertField(UpsertFieldRequest request) {
        Validate.notBlank((String)request.getNamespaceName(), (String)"namespaceName must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpsertLogAnalyticsFieldDetails(), "upsertLogAnalyticsFieldDetails is required");
        return (UpsertFieldResponse)this.clientCall(request, UpsertFieldResponse::builder).logger(LOG, "upsertField").serviceDetails("LogAnalytics", "UpsertField", "https://docs.oracle.com/iaas/api/#/en/logan-api-spec/20200601/LogAnalyticsField/UpsertField").method(Method.POST).requestBuilder(UpsertFieldRequest::builder).basePath("/20200601").appendPathParam("namespaces").appendPathParam(request.getNamespaceName()).appendPathParam("fields").appendPathParam("actions").appendPathParam("upsert").accept(new String[]{"application/json"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("if-match", request.getIfMatch()).hasBody().handleBody(LogAnalyticsField.class, UpsertFieldResponse.Builder::logAnalyticsField).handleResponseHeaderString("etag", UpsertFieldResponse.Builder::etag).handleResponseHeaderString("opc-request-id", UpsertFieldResponse.Builder::opcRequestId).operationUsesDefaultRetries().callSync();
    }

    @Override
    public UpsertLabelResponse upsertLabel(UpsertLabelRequest request) {
        Validate.notBlank((String)request.getNamespaceName(), (String)"namespaceName must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpsertLogAnalyticsLabelDetails(), "upsertLogAnalyticsLabelDetails is required");
        return (UpsertLabelResponse)this.clientCall(request, UpsertLabelResponse::builder).logger(LOG, "upsertLabel").serviceDetails("LogAnalytics", "UpsertLabel", "https://docs.oracle.com/iaas/api/#/en/logan-api-spec/20200601/LogAnalyticsLabel/UpsertLabel").method(Method.POST).requestBuilder(UpsertLabelRequest::builder).basePath("/20200601").appendPathParam("namespaces").appendPathParam(request.getNamespaceName()).appendPathParam("labels").appendPathParam("actions").appendPathParam("upsert").accept(new String[]{"application/json"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("if-match", request.getIfMatch()).hasBody().handleBody(LogAnalyticsLabel.class, UpsertLabelResponse.Builder::logAnalyticsLabel).handleResponseHeaderString("etag", UpsertLabelResponse.Builder::etag).handleResponseHeaderString("opc-request-id", UpsertLabelResponse.Builder::opcRequestId).operationUsesDefaultRetries().callSync();
    }

    @Override
    public UpsertParserResponse upsertParser(UpsertParserRequest request) {
        Validate.notBlank((String)request.getNamespaceName(), (String)"namespaceName must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpsertLogAnalyticsParserDetails(), "upsertLogAnalyticsParserDetails is required");
        return (UpsertParserResponse)this.clientCall(request, UpsertParserResponse::builder).logger(LOG, "upsertParser").serviceDetails("LogAnalytics", "UpsertParser", "https://docs.oracle.com/iaas/api/#/en/logan-api-spec/20200601/LogAnalyticsParser/UpsertParser").method(Method.POST).requestBuilder(UpsertParserRequest::builder).basePath("/20200601").appendPathParam("namespaces").appendPathParam(request.getNamespaceName()).appendPathParam("parsers").appendPathParam("actions").appendPathParam("upsert").accept(new String[]{"application/json"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("if-match", request.getIfMatch()).hasBody().handleBody(LogAnalyticsParser.class, UpsertParserResponse.Builder::logAnalyticsParser).handleResponseHeaderString("etag", UpsertParserResponse.Builder::etag).handleResponseHeaderString("opc-request-id", UpsertParserResponse.Builder::opcRequestId).operationUsesDefaultRetries().callSync();
    }

    @Override
    public UpsertSourceResponse upsertSource(UpsertSourceRequest request) {
        Validate.notBlank((String)request.getNamespaceName(), (String)"namespaceName must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpsertLogAnalyticsSourceDetails(), "upsertLogAnalyticsSourceDetails is required");
        return (UpsertSourceResponse)this.clientCall(request, UpsertSourceResponse::builder).logger(LOG, "upsertSource").serviceDetails("LogAnalytics", "UpsertSource", "https://docs.oracle.com/iaas/api/#/en/logan-api-spec/20200601/LogAnalyticsSource/UpsertSource").method(Method.POST).requestBuilder(UpsertSourceRequest::builder).basePath("/20200601").appendPathParam("namespaces").appendPathParam(request.getNamespaceName()).appendPathParam("sources").appendPathParam("actions").appendPathParam("upsert").appendQueryParam("createLikeSourceId", (Object)request.getCreateLikeSourceId()).appendQueryParam("isIncremental", (Object)request.getIsIncremental()).appendQueryParam("isIgnoreWarning", (Object)request.getIsIgnoreWarning()).accept(new String[]{"application/json"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("if-match", request.getIfMatch()).hasBody().handleBody(LogAnalyticsSource.class, UpsertSourceResponse.Builder::logAnalyticsSource).handleResponseHeaderString("etag", UpsertSourceResponse.Builder::etag).handleResponseHeaderString("opc-request-id", UpsertSourceResponse.Builder::opcRequestId).operationUsesDefaultRetries().callSync();
    }

    @Override
    public ValidateAssociationParametersResponse validateAssociationParameters(ValidateAssociationParametersRequest request) {
        Validate.notBlank((String)request.getNamespaceName(), (String)"namespaceName must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpsertLogAnalyticsAssociationDetails(), "upsertLogAnalyticsAssociationDetails is required");
        return (ValidateAssociationParametersResponse)this.clientCall(request, ValidateAssociationParametersResponse::builder).logger(LOG, "validateAssociationParameters").serviceDetails("LogAnalytics", "ValidateAssociationParameters", "https://docs.oracle.com/iaas/api/#/en/logan-api-spec/20200601/LogAnalyticsAssociation/ValidateAssociationParameters").method(Method.POST).requestBuilder(ValidateAssociationParametersRequest::builder).basePath("/20200601").appendPathParam("namespaces").appendPathParam(request.getNamespaceName()).appendPathParam("associations").appendPathParam("actions").appendPathParam("validateParameters").appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).accept(new String[]{"application/json"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleBody(LogAnalyticsAssociationParameterCollection.class, ValidateAssociationParametersResponse.Builder::logAnalyticsAssociationParameterCollection).handleResponseHeaderString("etag", ValidateAssociationParametersResponse.Builder::etag).handleResponseHeaderString("opc-request-id", ValidateAssociationParametersResponse.Builder::opcRequestId).operationUsesDefaultRetries().callSync();
    }

    @Override
    public ValidateFileResponse validateFile(ValidateFileRequest request) {
        Validate.notBlank((String)request.getNamespaceName(), (String)"namespaceName must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getObjectLocation(), "objectLocation is required");
        Objects.requireNonNull(request.getFilename(), "filename is required");
        return (ValidateFileResponse)this.clientCall(request, ValidateFileResponse::builder).logger(LOG, "validateFile").serviceDetails("LogAnalytics", "ValidateFile", "https://docs.oracle.com/iaas/api/#/en/logan-api-spec/20200601/Upload/ValidateFile").method(Method.POST).requestBuilder(ValidateFileRequest::builder).basePath("/20200601").appendPathParam("namespaces").appendPathParam(request.getNamespaceName()).appendPathParam("uploads").appendPathParam("actions").appendPathParam("validateFile").appendQueryParam("objectLocation", (Object)request.getObjectLocation()).appendQueryParam("filename", (Object)request.getFilename()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(FileValidationResponse.class, ValidateFileResponse.Builder::fileValidationResponse).handleResponseHeaderString("opc-request-id", ValidateFileResponse.Builder::opcRequestId).operationUsesDefaultRetries().callSync();
    }

    @Override
    public ValidateSourceResponse validateSource(ValidateSourceRequest request) {
        Validate.notBlank((String)request.getNamespaceName(), (String)"namespaceName must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpsertLogAnalyticsSourceDetails(), "upsertLogAnalyticsSourceDetails is required");
        return (ValidateSourceResponse)this.clientCall(request, ValidateSourceResponse::builder).logger(LOG, "validateSource").serviceDetails("LogAnalytics", "ValidateSource", "https://docs.oracle.com/iaas/api/#/en/logan-api-spec/20200601/LogAnalyticsSource/ValidateSource").method(Method.POST).requestBuilder(ValidateSourceRequest::builder).basePath("/20200601").appendPathParam("namespaces").appendPathParam(request.getNamespaceName()).appendPathParam("sources").appendPathParam("actions").appendPathParam("validate").appendQueryParam("createLikeSourceId", (Object)request.getCreateLikeSourceId()).appendQueryParam("isIncremental", (Object)request.getIsIncremental()).appendQueryParam("isIgnoreWarning", (Object)request.getIsIgnoreWarning()).accept(new String[]{"application/json"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleBody(SourceValidateResults.class, ValidateSourceResponse.Builder::sourceValidateResults).handleResponseHeaderString("opc-request-id", ValidateSourceResponse.Builder::opcRequestId).operationUsesDefaultRetries().callSync();
    }

    @Override
    public ValidateSourceExtendedFieldDetailsResponse validateSourceExtendedFieldDetails(ValidateSourceExtendedFieldDetailsRequest request) {
        Validate.notBlank((String)request.getNamespaceName(), (String)"namespaceName must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getLogAnalyticsSource(), "logAnalyticsSource is required");
        return (ValidateSourceExtendedFieldDetailsResponse)this.clientCall(request, ValidateSourceExtendedFieldDetailsResponse::builder).logger(LOG, "validateSourceExtendedFieldDetails").serviceDetails("LogAnalytics", "ValidateSourceExtendedFieldDetails", "https://docs.oracle.com/iaas/api/#/en/logan-api-spec/20200601/LogAnalyticsSource/ValidateSourceExtendedFieldDetails").method(Method.POST).requestBuilder(ValidateSourceExtendedFieldDetailsRequest::builder).basePath("/20200601").appendPathParam("namespaces").appendPathParam(request.getNamespaceName()).appendPathParam("sources").appendPathParam("actions").appendPathParam("validateExtendedFields").accept(new String[]{"application/json;charset=UTF-8"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleBody(ExtendedFieldsValidationResult.class, ValidateSourceExtendedFieldDetailsResponse.Builder::extendedFieldsValidationResult).handleResponseHeaderString("opc-request-id", ValidateSourceExtendedFieldDetailsResponse.Builder::opcRequestId).operationUsesDefaultRetries().callSync();
    }

    @Override
    public ValidateSourceMappingResponse validateSourceMapping(ValidateSourceMappingRequest request) {
        Validate.notBlank((String)request.getNamespaceName(), (String)"namespaceName must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getObjectLocation(), "objectLocation is required");
        Objects.requireNonNull(request.getFilename(), "filename is required");
        Objects.requireNonNull(request.getLogSourceName(), "logSourceName is required");
        return (ValidateSourceMappingResponse)this.clientCall(request, ValidateSourceMappingResponse::builder).logger(LOG, "validateSourceMapping").serviceDetails("LogAnalytics", "ValidateSourceMapping", "https://docs.oracle.com/iaas/api/#/en/logan-api-spec/20200601/Upload/ValidateSourceMapping").method(Method.POST).requestBuilder(ValidateSourceMappingRequest::builder).basePath("/20200601").appendPathParam("namespaces").appendPathParam(request.getNamespaceName()).appendPathParam("uploads").appendPathParam("actions").appendPathParam("validateSourceMapping").appendQueryParam("objectLocation", (Object)request.getObjectLocation()).appendQueryParam("filename", (Object)request.getFilename()).appendQueryParam("logSourceName", (Object)request.getLogSourceName()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(SourceMappingResponse.class, ValidateSourceMappingResponse.Builder::sourceMappingResponse).handleResponseHeaderString("opc-request-id", ValidateSourceMappingResponse.Builder::opcRequestId).operationUsesDefaultRetries().callSync();
    }

    @Override
    public VerifyResponse verify(VerifyRequest request) {
        Validate.notBlank((String)request.getNamespaceName(), (String)"namespaceName must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getScheduledTaskId(), (String)"scheduledTaskId must not be blank", (Object[])new Object[0]);
        return (VerifyResponse)this.clientCall(request, VerifyResponse::builder).logger(LOG, "verify").serviceDetails("LogAnalytics", "Verify", "https://docs.oracle.com/iaas/api/#/en/logan-api-spec/20200601/ScheduledTask/Verify").method(Method.POST).requestBuilder(VerifyRequest::builder).basePath("/20200601").appendPathParam("namespaces").appendPathParam(request.getNamespaceName()).appendPathParam("scheduledTasks").appendPathParam(request.getScheduledTaskId()).appendPathParam("actions").appendPathParam("verify").appendQueryParam("shouldIncludeResults", (Object)request.getShouldIncludeResults()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).handleBody(VerifyOutput.class, VerifyResponse.Builder::verifyOutput).handleResponseHeaderString("opc-request-id", VerifyResponse.Builder::opcRequestId).operationUsesDefaultRetries().callSync();
    }

    @Override
    public LogAnalyticsWaiters getWaiters() {
        return this.waiters;
    }

    @Override
    public LogAnalyticsPaginators getPaginators() {
        return this.paginators;
    }

    @Deprecated
    public LogAnalyticsClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider) {
        this((ClientBuilderBase<?, ?>)LogAnalyticsClient.builder(), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider, null);
    }

    @Deprecated
    public LogAnalyticsClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration) {
        this(LogAnalyticsClient.builder().configuration(configuration), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider, null);
    }

    @Deprecated
    public LogAnalyticsClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator) {
        this(((Builder)LogAnalyticsClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider, null);
    }

    @Deprecated
    public LogAnalyticsClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory) {
        this(((Builder)((Builder)LogAnalyticsClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory), authenticationDetailsProvider, null);
    }

    @Deprecated
    public LogAnalyticsClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators) {
        this(((Builder)((Builder)((Builder)LogAnalyticsClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators), authenticationDetailsProvider, null);
    }

    @Deprecated
    public LogAnalyticsClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(((Builder)((Builder)((Builder)((Builder)LogAnalyticsClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint), authenticationDetailsProvider, null);
    }

    @Deprecated
    public LogAnalyticsClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(((Builder)((Builder)((Builder)((Builder)((Builder)LogAnalyticsClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint)).signingStrategyRequestSignerFactories(signingStrategyRequestSignerFactories), authenticationDetailsProvider, null);
    }

    @Deprecated
    public LogAnalyticsClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint, ExecutorService executorService) {
        this(((Builder)((Builder)((Builder)((Builder)((Builder)LogAnalyticsClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint)).signingStrategyRequestSignerFactories(signingStrategyRequestSignerFactories), authenticationDetailsProvider, executorService);
    }

    public static class Builder
    extends RegionalClientBuilder<Builder, LogAnalyticsClient> {
        private boolean isStreamWarningEnabled = true;
        private ExecutorService executorService;

        private Builder(Service service) {
            super(service);
            this.requestSignerFactory = new DefaultRequestSignerFactory(SigningStrategy.STANDARD);
        }

        public Builder executorService(ExecutorService executorService) {
            this.executorService = executorService;
            return this;
        }

        public Builder isStreamWarningEnabled(boolean isStreamWarningEnabled) {
            this.isStreamWarningEnabled = isStreamWarningEnabled;
            return this;
        }

        public LogAnalyticsClient build(@Nonnull AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
            return new LogAnalyticsClient((ClientBuilderBase<?, ?>)this, authenticationDetailsProvider, this.executorService, this.isStreamWarningEnabled);
        }
    }
}

