/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.loganalytics.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.loganalytics.model.Schedule;
import java.util.Date;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="type")
@JsonFilter(value="explicitlySetFilter")
public final class CronSchedule
extends Schedule {
    @JsonProperty(value="expression")
    private final String expression;
    @JsonProperty(value="timeZone")
    private final String timeZone;

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    @Deprecated
    public CronSchedule(Schedule.MisfirePolicy misfirePolicy, Date timeOfFirstExecution, String expression, String timeZone) {
        super(misfirePolicy, timeOfFirstExecution);
        this.expression = expression;
        this.timeZone = timeZone;
    }

    public String getExpression() {
        return this.expression;
    }

    public String getTimeZone() {
        return this.timeZone;
    }

    @Override
    public String toString() {
        return this.toString(true);
    }

    @Override
    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("CronSchedule(");
        sb.append("super=").append(super.toString(includeByteArrayContents));
        sb.append(", expression=").append(String.valueOf(this.expression));
        sb.append(", timeZone=").append(String.valueOf(this.timeZone));
        sb.append(")");
        return sb.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CronSchedule)) {
            return false;
        }
        CronSchedule other = (CronSchedule)((Object)o);
        return Objects.equals(this.expression, other.expression) && Objects.equals(this.timeZone, other.timeZone) && super.equals((Object)other);
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.expression == null ? 43 : this.expression.hashCode());
        result = result * 59 + (this.timeZone == null ? 43 : this.timeZone.hashCode());
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="misfirePolicy")
        private Schedule.MisfirePolicy misfirePolicy;
        @JsonProperty(value="timeOfFirstExecution")
        private Date timeOfFirstExecution;
        @JsonProperty(value="expression")
        private String expression;
        @JsonProperty(value="timeZone")
        private String timeZone;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder misfirePolicy(Schedule.MisfirePolicy misfirePolicy) {
            this.misfirePolicy = misfirePolicy;
            this.__explicitlySet__.add("misfirePolicy");
            return this;
        }

        public Builder timeOfFirstExecution(Date timeOfFirstExecution) {
            this.timeOfFirstExecution = timeOfFirstExecution;
            this.__explicitlySet__.add("timeOfFirstExecution");
            return this;
        }

        public Builder expression(String expression) {
            this.expression = expression;
            this.__explicitlySet__.add("expression");
            return this;
        }

        public Builder timeZone(String timeZone) {
            this.timeZone = timeZone;
            this.__explicitlySet__.add("timeZone");
            return this;
        }

        public CronSchedule build() {
            CronSchedule model = new CronSchedule(this.misfirePolicy, this.timeOfFirstExecution, this.expression, this.timeZone);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(CronSchedule model) {
            if (model.wasPropertyExplicitlySet("misfirePolicy")) {
                this.misfirePolicy(model.getMisfirePolicy());
            }
            if (model.wasPropertyExplicitlySet("timeOfFirstExecution")) {
                this.timeOfFirstExecution(model.getTimeOfFirstExecution());
            }
            if (model.wasPropertyExplicitlySet("expression")) {
                this.expression(model.getExpression());
            }
            if (model.wasPropertyExplicitlySet("timeZone")) {
                this.timeZone(model.getTimeZone());
            }
            return this;
        }
    }
}

