/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.loganalytics.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import java.beans.ConstructorProperties;
import java.util.Date;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class EstimateRecallDataSizeResult
extends ExplicitlySetBmcModel {
    @JsonProperty(value="timeDataEnded")
    private final Date timeDataEnded;
    @JsonProperty(value="timeDataStarted")
    private final Date timeDataStarted;
    @JsonProperty(value="sizeInBytes")
    private final Long sizeInBytes;
    @JsonProperty(value="isOverlappingWithExistingRecalls")
    private final Boolean isOverlappingWithExistingRecalls;

    @Deprecated
    @ConstructorProperties(value={"timeDataEnded", "timeDataStarted", "sizeInBytes", "isOverlappingWithExistingRecalls"})
    public EstimateRecallDataSizeResult(Date timeDataEnded, Date timeDataStarted, Long sizeInBytes, Boolean isOverlappingWithExistingRecalls) {
        this.timeDataEnded = timeDataEnded;
        this.timeDataStarted = timeDataStarted;
        this.sizeInBytes = sizeInBytes;
        this.isOverlappingWithExistingRecalls = isOverlappingWithExistingRecalls;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public Date getTimeDataEnded() {
        return this.timeDataEnded;
    }

    public Date getTimeDataStarted() {
        return this.timeDataStarted;
    }

    public Long getSizeInBytes() {
        return this.sizeInBytes;
    }

    public Boolean getIsOverlappingWithExistingRecalls() {
        return this.isOverlappingWithExistingRecalls;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("EstimateRecallDataSizeResult(");
        sb.append("super=").append(super.toString());
        sb.append("timeDataEnded=").append(String.valueOf(this.timeDataEnded));
        sb.append(", timeDataStarted=").append(String.valueOf(this.timeDataStarted));
        sb.append(", sizeInBytes=").append(String.valueOf(this.sizeInBytes));
        sb.append(", isOverlappingWithExistingRecalls=").append(String.valueOf(this.isOverlappingWithExistingRecalls));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof EstimateRecallDataSizeResult)) {
            return false;
        }
        EstimateRecallDataSizeResult other = (EstimateRecallDataSizeResult)((Object)o);
        return Objects.equals(this.timeDataEnded, other.timeDataEnded) && Objects.equals(this.timeDataStarted, other.timeDataStarted) && Objects.equals(this.sizeInBytes, other.sizeInBytes) && Objects.equals(this.isOverlappingWithExistingRecalls, other.isOverlappingWithExistingRecalls) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.timeDataEnded == null ? 43 : this.timeDataEnded.hashCode());
        result = result * 59 + (this.timeDataStarted == null ? 43 : this.timeDataStarted.hashCode());
        result = result * 59 + (this.sizeInBytes == null ? 43 : this.sizeInBytes.hashCode());
        result = result * 59 + (this.isOverlappingWithExistingRecalls == null ? 43 : this.isOverlappingWithExistingRecalls.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="timeDataEnded")
        private Date timeDataEnded;
        @JsonProperty(value="timeDataStarted")
        private Date timeDataStarted;
        @JsonProperty(value="sizeInBytes")
        private Long sizeInBytes;
        @JsonProperty(value="isOverlappingWithExistingRecalls")
        private Boolean isOverlappingWithExistingRecalls;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder timeDataEnded(Date timeDataEnded) {
            this.timeDataEnded = timeDataEnded;
            this.__explicitlySet__.add("timeDataEnded");
            return this;
        }

        public Builder timeDataStarted(Date timeDataStarted) {
            this.timeDataStarted = timeDataStarted;
            this.__explicitlySet__.add("timeDataStarted");
            return this;
        }

        public Builder sizeInBytes(Long sizeInBytes) {
            this.sizeInBytes = sizeInBytes;
            this.__explicitlySet__.add("sizeInBytes");
            return this;
        }

        public Builder isOverlappingWithExistingRecalls(Boolean isOverlappingWithExistingRecalls) {
            this.isOverlappingWithExistingRecalls = isOverlappingWithExistingRecalls;
            this.__explicitlySet__.add("isOverlappingWithExistingRecalls");
            return this;
        }

        public EstimateRecallDataSizeResult build() {
            EstimateRecallDataSizeResult model = new EstimateRecallDataSizeResult(this.timeDataEnded, this.timeDataStarted, this.sizeInBytes, this.isOverlappingWithExistingRecalls);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(EstimateRecallDataSizeResult model) {
            if (model.wasPropertyExplicitlySet("timeDataEnded")) {
                this.timeDataEnded(model.getTimeDataEnded());
            }
            if (model.wasPropertyExplicitlySet("timeDataStarted")) {
                this.timeDataStarted(model.getTimeDataStarted());
            }
            if (model.wasPropertyExplicitlySet("sizeInBytes")) {
                this.sizeInBytes(model.getSizeInBytes());
            }
            if (model.wasPropertyExplicitlySet("isOverlappingWithExistingRecalls")) {
                this.isOverlappingWithExistingRecalls(model.getIsOverlappingWithExistingRecalls());
            }
            return this;
        }
    }
}

