/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.loganalytics.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.http.internal.BmcEnum;
import com.oracle.bmc.loganalytics.model.AutoLookups;
import com.oracle.bmc.loganalytics.model.LogAnalyticsCategory;
import com.oracle.bmc.loganalytics.model.LookupField;
import com.oracle.bmc.loganalytics.model.StatusSummary;
import java.beans.ConstructorProperties;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class LogAnalyticsLookup
extends ExplicitlySetBmcModel {
    @JsonProperty(value="activeEditVersion")
    private final Long activeEditVersion;
    @JsonProperty(value="canonicalLink")
    private final String canonicalLink;
    @JsonProperty(value="description")
    private final String description;
    @JsonProperty(value="editVersion")
    private final Long editVersion;
    @JsonProperty(value="fields")
    private final List<LookupField> fields;
    @JsonProperty(value="lookupReference")
    private final Long lookupReference;
    @JsonProperty(value="lookupReferenceString")
    private final String lookupReferenceString;
    @JsonProperty(value="type")
    private final Type type;
    @JsonProperty(value="name")
    private final String name;
    @JsonProperty(value="isBuiltIn")
    private final Long isBuiltIn;
    @JsonProperty(value="isHidden")
    private final Boolean isHidden;
    @JsonProperty(value="lookupDisplayName")
    private final String lookupDisplayName;
    @JsonProperty(value="referringSources")
    private final AutoLookups referringSources;
    @JsonProperty(value="statusSummary")
    private final StatusSummary statusSummary;
    @JsonProperty(value="timeUpdated")
    private final Date timeUpdated;
    @JsonProperty(value="categories")
    private final List<LogAnalyticsCategory> categories;

    @Deprecated
    @ConstructorProperties(value={"activeEditVersion", "canonicalLink", "description", "editVersion", "fields", "lookupReference", "lookupReferenceString", "type", "name", "isBuiltIn", "isHidden", "lookupDisplayName", "referringSources", "statusSummary", "timeUpdated", "categories"})
    public LogAnalyticsLookup(Long activeEditVersion, String canonicalLink, String description, Long editVersion, List<LookupField> fields, Long lookupReference, String lookupReferenceString, Type type, String name, Long isBuiltIn, Boolean isHidden, String lookupDisplayName, AutoLookups referringSources, StatusSummary statusSummary, Date timeUpdated, List<LogAnalyticsCategory> categories) {
        this.activeEditVersion = activeEditVersion;
        this.canonicalLink = canonicalLink;
        this.description = description;
        this.editVersion = editVersion;
        this.fields = fields;
        this.lookupReference = lookupReference;
        this.lookupReferenceString = lookupReferenceString;
        this.type = type;
        this.name = name;
        this.isBuiltIn = isBuiltIn;
        this.isHidden = isHidden;
        this.lookupDisplayName = lookupDisplayName;
        this.referringSources = referringSources;
        this.statusSummary = statusSummary;
        this.timeUpdated = timeUpdated;
        this.categories = categories;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public Long getActiveEditVersion() {
        return this.activeEditVersion;
    }

    public String getCanonicalLink() {
        return this.canonicalLink;
    }

    public String getDescription() {
        return this.description;
    }

    public Long getEditVersion() {
        return this.editVersion;
    }

    public List<LookupField> getFields() {
        return this.fields;
    }

    public Long getLookupReference() {
        return this.lookupReference;
    }

    public String getLookupReferenceString() {
        return this.lookupReferenceString;
    }

    public Type getType() {
        return this.type;
    }

    public String getName() {
        return this.name;
    }

    public Long getIsBuiltIn() {
        return this.isBuiltIn;
    }

    public Boolean getIsHidden() {
        return this.isHidden;
    }

    public String getLookupDisplayName() {
        return this.lookupDisplayName;
    }

    public AutoLookups getReferringSources() {
        return this.referringSources;
    }

    public StatusSummary getStatusSummary() {
        return this.statusSummary;
    }

    public Date getTimeUpdated() {
        return this.timeUpdated;
    }

    public List<LogAnalyticsCategory> getCategories() {
        return this.categories;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("LogAnalyticsLookup(");
        sb.append("super=").append(super.toString());
        sb.append("activeEditVersion=").append(String.valueOf(this.activeEditVersion));
        sb.append(", canonicalLink=").append(String.valueOf(this.canonicalLink));
        sb.append(", description=").append(String.valueOf(this.description));
        sb.append(", editVersion=").append(String.valueOf(this.editVersion));
        sb.append(", fields=").append(String.valueOf(this.fields));
        sb.append(", lookupReference=").append(String.valueOf(this.lookupReference));
        sb.append(", lookupReferenceString=").append(String.valueOf(this.lookupReferenceString));
        sb.append(", type=").append(String.valueOf((Object)this.type));
        sb.append(", name=").append(String.valueOf(this.name));
        sb.append(", isBuiltIn=").append(String.valueOf(this.isBuiltIn));
        sb.append(", isHidden=").append(String.valueOf(this.isHidden));
        sb.append(", lookupDisplayName=").append(String.valueOf(this.lookupDisplayName));
        sb.append(", referringSources=").append(String.valueOf((Object)this.referringSources));
        sb.append(", statusSummary=").append(String.valueOf((Object)this.statusSummary));
        sb.append(", timeUpdated=").append(String.valueOf(this.timeUpdated));
        sb.append(", categories=").append(String.valueOf(this.categories));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof LogAnalyticsLookup)) {
            return false;
        }
        LogAnalyticsLookup other = (LogAnalyticsLookup)((Object)o);
        return Objects.equals(this.activeEditVersion, other.activeEditVersion) && Objects.equals(this.canonicalLink, other.canonicalLink) && Objects.equals(this.description, other.description) && Objects.equals(this.editVersion, other.editVersion) && Objects.equals(this.fields, other.fields) && Objects.equals(this.lookupReference, other.lookupReference) && Objects.equals(this.lookupReferenceString, other.lookupReferenceString) && Objects.equals((Object)this.type, (Object)other.type) && Objects.equals(this.name, other.name) && Objects.equals(this.isBuiltIn, other.isBuiltIn) && Objects.equals(this.isHidden, other.isHidden) && Objects.equals(this.lookupDisplayName, other.lookupDisplayName) && Objects.equals((Object)this.referringSources, (Object)other.referringSources) && Objects.equals((Object)this.statusSummary, (Object)other.statusSummary) && Objects.equals(this.timeUpdated, other.timeUpdated) && Objects.equals(this.categories, other.categories) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.activeEditVersion == null ? 43 : this.activeEditVersion.hashCode());
        result = result * 59 + (this.canonicalLink == null ? 43 : this.canonicalLink.hashCode());
        result = result * 59 + (this.description == null ? 43 : this.description.hashCode());
        result = result * 59 + (this.editVersion == null ? 43 : this.editVersion.hashCode());
        result = result * 59 + (this.fields == null ? 43 : this.fields.hashCode());
        result = result * 59 + (this.lookupReference == null ? 43 : this.lookupReference.hashCode());
        result = result * 59 + (this.lookupReferenceString == null ? 43 : this.lookupReferenceString.hashCode());
        result = result * 59 + (this.type == null ? 43 : this.type.hashCode());
        result = result * 59 + (this.name == null ? 43 : this.name.hashCode());
        result = result * 59 + (this.isBuiltIn == null ? 43 : this.isBuiltIn.hashCode());
        result = result * 59 + (this.isHidden == null ? 43 : this.isHidden.hashCode());
        result = result * 59 + (this.lookupDisplayName == null ? 43 : this.lookupDisplayName.hashCode());
        result = result * 59 + (this.referringSources == null ? 43 : this.referringSources.hashCode());
        result = result * 59 + (this.statusSummary == null ? 43 : this.statusSummary.hashCode());
        result = result * 59 + (this.timeUpdated == null ? 43 : this.timeUpdated.hashCode());
        result = result * 59 + (this.categories == null ? 43 : this.categories.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    public static enum Type implements BmcEnum
    {
        Lookup("Lookup"),
        Dictionary("Dictionary"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, Type> map;

        private Type(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static Type create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'Type', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(Type.class);
            map = new HashMap<String, Type>();
            for (Type v : Type.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="activeEditVersion")
        private Long activeEditVersion;
        @JsonProperty(value="canonicalLink")
        private String canonicalLink;
        @JsonProperty(value="description")
        private String description;
        @JsonProperty(value="editVersion")
        private Long editVersion;
        @JsonProperty(value="fields")
        private List<LookupField> fields;
        @JsonProperty(value="lookupReference")
        private Long lookupReference;
        @JsonProperty(value="lookupReferenceString")
        private String lookupReferenceString;
        @JsonProperty(value="type")
        private Type type;
        @JsonProperty(value="name")
        private String name;
        @JsonProperty(value="isBuiltIn")
        private Long isBuiltIn;
        @JsonProperty(value="isHidden")
        private Boolean isHidden;
        @JsonProperty(value="lookupDisplayName")
        private String lookupDisplayName;
        @JsonProperty(value="referringSources")
        private AutoLookups referringSources;
        @JsonProperty(value="statusSummary")
        private StatusSummary statusSummary;
        @JsonProperty(value="timeUpdated")
        private Date timeUpdated;
        @JsonProperty(value="categories")
        private List<LogAnalyticsCategory> categories;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder activeEditVersion(Long activeEditVersion) {
            this.activeEditVersion = activeEditVersion;
            this.__explicitlySet__.add("activeEditVersion");
            return this;
        }

        public Builder canonicalLink(String canonicalLink) {
            this.canonicalLink = canonicalLink;
            this.__explicitlySet__.add("canonicalLink");
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            this.__explicitlySet__.add("description");
            return this;
        }

        public Builder editVersion(Long editVersion) {
            this.editVersion = editVersion;
            this.__explicitlySet__.add("editVersion");
            return this;
        }

        public Builder fields(List<LookupField> fields) {
            this.fields = fields;
            this.__explicitlySet__.add("fields");
            return this;
        }

        public Builder lookupReference(Long lookupReference) {
            this.lookupReference = lookupReference;
            this.__explicitlySet__.add("lookupReference");
            return this;
        }

        public Builder lookupReferenceString(String lookupReferenceString) {
            this.lookupReferenceString = lookupReferenceString;
            this.__explicitlySet__.add("lookupReferenceString");
            return this;
        }

        public Builder type(Type type) {
            this.type = type;
            this.__explicitlySet__.add("type");
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            this.__explicitlySet__.add("name");
            return this;
        }

        public Builder isBuiltIn(Long isBuiltIn) {
            this.isBuiltIn = isBuiltIn;
            this.__explicitlySet__.add("isBuiltIn");
            return this;
        }

        public Builder isHidden(Boolean isHidden) {
            this.isHidden = isHidden;
            this.__explicitlySet__.add("isHidden");
            return this;
        }

        public Builder lookupDisplayName(String lookupDisplayName) {
            this.lookupDisplayName = lookupDisplayName;
            this.__explicitlySet__.add("lookupDisplayName");
            return this;
        }

        public Builder referringSources(AutoLookups referringSources) {
            this.referringSources = referringSources;
            this.__explicitlySet__.add("referringSources");
            return this;
        }

        public Builder statusSummary(StatusSummary statusSummary) {
            this.statusSummary = statusSummary;
            this.__explicitlySet__.add("statusSummary");
            return this;
        }

        public Builder timeUpdated(Date timeUpdated) {
            this.timeUpdated = timeUpdated;
            this.__explicitlySet__.add("timeUpdated");
            return this;
        }

        public Builder categories(List<LogAnalyticsCategory> categories) {
            this.categories = categories;
            this.__explicitlySet__.add("categories");
            return this;
        }

        public LogAnalyticsLookup build() {
            LogAnalyticsLookup model = new LogAnalyticsLookup(this.activeEditVersion, this.canonicalLink, this.description, this.editVersion, this.fields, this.lookupReference, this.lookupReferenceString, this.type, this.name, this.isBuiltIn, this.isHidden, this.lookupDisplayName, this.referringSources, this.statusSummary, this.timeUpdated, this.categories);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(LogAnalyticsLookup model) {
            if (model.wasPropertyExplicitlySet("activeEditVersion")) {
                this.activeEditVersion(model.getActiveEditVersion());
            }
            if (model.wasPropertyExplicitlySet("canonicalLink")) {
                this.canonicalLink(model.getCanonicalLink());
            }
            if (model.wasPropertyExplicitlySet("description")) {
                this.description(model.getDescription());
            }
            if (model.wasPropertyExplicitlySet("editVersion")) {
                this.editVersion(model.getEditVersion());
            }
            if (model.wasPropertyExplicitlySet("fields")) {
                this.fields(model.getFields());
            }
            if (model.wasPropertyExplicitlySet("lookupReference")) {
                this.lookupReference(model.getLookupReference());
            }
            if (model.wasPropertyExplicitlySet("lookupReferenceString")) {
                this.lookupReferenceString(model.getLookupReferenceString());
            }
            if (model.wasPropertyExplicitlySet("type")) {
                this.type(model.getType());
            }
            if (model.wasPropertyExplicitlySet("name")) {
                this.name(model.getName());
            }
            if (model.wasPropertyExplicitlySet("isBuiltIn")) {
                this.isBuiltIn(model.getIsBuiltIn());
            }
            if (model.wasPropertyExplicitlySet("isHidden")) {
                this.isHidden(model.getIsHidden());
            }
            if (model.wasPropertyExplicitlySet("lookupDisplayName")) {
                this.lookupDisplayName(model.getLookupDisplayName());
            }
            if (model.wasPropertyExplicitlySet("referringSources")) {
                this.referringSources(model.getReferringSources());
            }
            if (model.wasPropertyExplicitlySet("statusSummary")) {
                this.statusSummary(model.getStatusSummary());
            }
            if (model.wasPropertyExplicitlySet("timeUpdated")) {
                this.timeUpdated(model.getTimeUpdated());
            }
            if (model.wasPropertyExplicitlySet("categories")) {
                this.categories(model.getCategories());
            }
            return this;
        }
    }
}

