/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.loganalytics.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import java.beans.ConstructorProperties;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class StatusSummary
extends ExplicitlySetBmcModel {
    @JsonProperty(value="chunksProcessed")
    private final Long chunksProcessed;
    @JsonProperty(value="failureDetails")
    private final String failureDetails;
    @JsonProperty(value="filename")
    private final String filename;
    @JsonProperty(value="status")
    private final String status;
    @JsonProperty(value="totalChunks")
    private final Long totalChunks;

    @Deprecated
    @ConstructorProperties(value={"chunksProcessed", "failureDetails", "filename", "status", "totalChunks"})
    public StatusSummary(Long chunksProcessed, String failureDetails, String filename, String status, Long totalChunks) {
        this.chunksProcessed = chunksProcessed;
        this.failureDetails = failureDetails;
        this.filename = filename;
        this.status = status;
        this.totalChunks = totalChunks;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public Long getChunksProcessed() {
        return this.chunksProcessed;
    }

    public String getFailureDetails() {
        return this.failureDetails;
    }

    public String getFilename() {
        return this.filename;
    }

    public String getStatus() {
        return this.status;
    }

    public Long getTotalChunks() {
        return this.totalChunks;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("StatusSummary(");
        sb.append("super=").append(super.toString());
        sb.append("chunksProcessed=").append(String.valueOf(this.chunksProcessed));
        sb.append(", failureDetails=").append(String.valueOf(this.failureDetails));
        sb.append(", filename=").append(String.valueOf(this.filename));
        sb.append(", status=").append(String.valueOf(this.status));
        sb.append(", totalChunks=").append(String.valueOf(this.totalChunks));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof StatusSummary)) {
            return false;
        }
        StatusSummary other = (StatusSummary)((Object)o);
        return Objects.equals(this.chunksProcessed, other.chunksProcessed) && Objects.equals(this.failureDetails, other.failureDetails) && Objects.equals(this.filename, other.filename) && Objects.equals(this.status, other.status) && Objects.equals(this.totalChunks, other.totalChunks) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.chunksProcessed == null ? 43 : this.chunksProcessed.hashCode());
        result = result * 59 + (this.failureDetails == null ? 43 : this.failureDetails.hashCode());
        result = result * 59 + (this.filename == null ? 43 : this.filename.hashCode());
        result = result * 59 + (this.status == null ? 43 : this.status.hashCode());
        result = result * 59 + (this.totalChunks == null ? 43 : this.totalChunks.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="chunksProcessed")
        private Long chunksProcessed;
        @JsonProperty(value="failureDetails")
        private String failureDetails;
        @JsonProperty(value="filename")
        private String filename;
        @JsonProperty(value="status")
        private String status;
        @JsonProperty(value="totalChunks")
        private Long totalChunks;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder chunksProcessed(Long chunksProcessed) {
            this.chunksProcessed = chunksProcessed;
            this.__explicitlySet__.add("chunksProcessed");
            return this;
        }

        public Builder failureDetails(String failureDetails) {
            this.failureDetails = failureDetails;
            this.__explicitlySet__.add("failureDetails");
            return this;
        }

        public Builder filename(String filename) {
            this.filename = filename;
            this.__explicitlySet__.add("filename");
            return this;
        }

        public Builder status(String status) {
            this.status = status;
            this.__explicitlySet__.add("status");
            return this;
        }

        public Builder totalChunks(Long totalChunks) {
            this.totalChunks = totalChunks;
            this.__explicitlySet__.add("totalChunks");
            return this;
        }

        public StatusSummary build() {
            StatusSummary model = new StatusSummary(this.chunksProcessed, this.failureDetails, this.filename, this.status, this.totalChunks);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(StatusSummary model) {
            if (model.wasPropertyExplicitlySet("chunksProcessed")) {
                this.chunksProcessed(model.getChunksProcessed());
            }
            if (model.wasPropertyExplicitlySet("failureDetails")) {
                this.failureDetails(model.getFailureDetails());
            }
            if (model.wasPropertyExplicitlySet("filename")) {
                this.filename(model.getFilename());
            }
            if (model.wasPropertyExplicitlySet("status")) {
                this.status(model.getStatus());
            }
            if (model.wasPropertyExplicitlySet("totalChunks")) {
                this.totalChunks(model.getTotalChunks());
            }
            return this;
        }
    }
}

