/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.loganalytics.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.loganalytics.model.EncryptionKeyType;
import com.oracle.bmc.loganalytics.model.StorageDataType;
import com.oracle.bmc.loganalytics.model.StorageOperationType;
import com.oracle.bmc.loganalytics.model.WorkRequestStatus;
import java.beans.ConstructorProperties;
import java.util.Date;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class StorageWorkRequest
extends ExplicitlySetBmcModel {
    @JsonProperty(value="id")
    private final String id;
    @JsonProperty(value="compartmentId")
    private final String compartmentId;
    @JsonProperty(value="timeStarted")
    private final Date timeStarted;
    @JsonProperty(value="timeAccepted")
    private final Date timeAccepted;
    @JsonProperty(value="timeFinished")
    private final Date timeFinished;
    @JsonProperty(value="timeExpires")
    private final Date timeExpires;
    @JsonProperty(value="percentComplete")
    private final Integer percentComplete;
    @JsonProperty(value="status")
    private final WorkRequestStatus status;
    @JsonProperty(value="timeDataStarted")
    private final Date timeDataStarted;
    @JsonProperty(value="timeDataEnded")
    private final Date timeDataEnded;
    @JsonProperty(value="purgeQueryString")
    private final String purgeQueryString;
    @JsonProperty(value="dataType")
    private final StorageDataType dataType;
    @JsonProperty(value="statusDetails")
    private final String statusDetails;
    @JsonProperty(value="operationDetails")
    private final String operationDetails;
    @JsonProperty(value="policyName")
    private final String policyName;
    @JsonProperty(value="policyId")
    private final String policyId;
    @JsonProperty(value="storageUsageInBytes")
    private final Long storageUsageInBytes;
    @JsonProperty(value="compartmentIdInSubtree")
    private final Boolean compartmentIdInSubtree;
    @JsonProperty(value="operationType")
    private final StorageOperationType operationType;
    @JsonProperty(value="keyId")
    private final String keyId;
    @JsonProperty(value="keyType")
    private final EncryptionKeyType keyType;

    @Deprecated
    @ConstructorProperties(value={"id", "compartmentId", "timeStarted", "timeAccepted", "timeFinished", "timeExpires", "percentComplete", "status", "timeDataStarted", "timeDataEnded", "purgeQueryString", "dataType", "statusDetails", "operationDetails", "policyName", "policyId", "storageUsageInBytes", "compartmentIdInSubtree", "operationType", "keyId", "keyType"})
    public StorageWorkRequest(String id, String compartmentId, Date timeStarted, Date timeAccepted, Date timeFinished, Date timeExpires, Integer percentComplete, WorkRequestStatus status, Date timeDataStarted, Date timeDataEnded, String purgeQueryString, StorageDataType dataType, String statusDetails, String operationDetails, String policyName, String policyId, Long storageUsageInBytes, Boolean compartmentIdInSubtree, StorageOperationType operationType, String keyId, EncryptionKeyType keyType) {
        this.id = id;
        this.compartmentId = compartmentId;
        this.timeStarted = timeStarted;
        this.timeAccepted = timeAccepted;
        this.timeFinished = timeFinished;
        this.timeExpires = timeExpires;
        this.percentComplete = percentComplete;
        this.status = status;
        this.timeDataStarted = timeDataStarted;
        this.timeDataEnded = timeDataEnded;
        this.purgeQueryString = purgeQueryString;
        this.dataType = dataType;
        this.statusDetails = statusDetails;
        this.operationDetails = operationDetails;
        this.policyName = policyName;
        this.policyId = policyId;
        this.storageUsageInBytes = storageUsageInBytes;
        this.compartmentIdInSubtree = compartmentIdInSubtree;
        this.operationType = operationType;
        this.keyId = keyId;
        this.keyType = keyType;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getId() {
        return this.id;
    }

    public String getCompartmentId() {
        return this.compartmentId;
    }

    public Date getTimeStarted() {
        return this.timeStarted;
    }

    public Date getTimeAccepted() {
        return this.timeAccepted;
    }

    public Date getTimeFinished() {
        return this.timeFinished;
    }

    public Date getTimeExpires() {
        return this.timeExpires;
    }

    public Integer getPercentComplete() {
        return this.percentComplete;
    }

    public WorkRequestStatus getStatus() {
        return this.status;
    }

    public Date getTimeDataStarted() {
        return this.timeDataStarted;
    }

    public Date getTimeDataEnded() {
        return this.timeDataEnded;
    }

    public String getPurgeQueryString() {
        return this.purgeQueryString;
    }

    public StorageDataType getDataType() {
        return this.dataType;
    }

    public String getStatusDetails() {
        return this.statusDetails;
    }

    public String getOperationDetails() {
        return this.operationDetails;
    }

    public String getPolicyName() {
        return this.policyName;
    }

    public String getPolicyId() {
        return this.policyId;
    }

    public Long getStorageUsageInBytes() {
        return this.storageUsageInBytes;
    }

    public Boolean getCompartmentIdInSubtree() {
        return this.compartmentIdInSubtree;
    }

    public StorageOperationType getOperationType() {
        return this.operationType;
    }

    public String getKeyId() {
        return this.keyId;
    }

    public EncryptionKeyType getKeyType() {
        return this.keyType;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("StorageWorkRequest(");
        sb.append("super=").append(super.toString());
        sb.append("id=").append(String.valueOf(this.id));
        sb.append(", compartmentId=").append(String.valueOf(this.compartmentId));
        sb.append(", timeStarted=").append(String.valueOf(this.timeStarted));
        sb.append(", timeAccepted=").append(String.valueOf(this.timeAccepted));
        sb.append(", timeFinished=").append(String.valueOf(this.timeFinished));
        sb.append(", timeExpires=").append(String.valueOf(this.timeExpires));
        sb.append(", percentComplete=").append(String.valueOf(this.percentComplete));
        sb.append(", status=").append(String.valueOf((Object)this.status));
        sb.append(", timeDataStarted=").append(String.valueOf(this.timeDataStarted));
        sb.append(", timeDataEnded=").append(String.valueOf(this.timeDataEnded));
        sb.append(", purgeQueryString=").append(String.valueOf(this.purgeQueryString));
        sb.append(", dataType=").append(String.valueOf((Object)this.dataType));
        sb.append(", statusDetails=").append(String.valueOf(this.statusDetails));
        sb.append(", operationDetails=").append(String.valueOf(this.operationDetails));
        sb.append(", policyName=").append(String.valueOf(this.policyName));
        sb.append(", policyId=").append(String.valueOf(this.policyId));
        sb.append(", storageUsageInBytes=").append(String.valueOf(this.storageUsageInBytes));
        sb.append(", compartmentIdInSubtree=").append(String.valueOf(this.compartmentIdInSubtree));
        sb.append(", operationType=").append(String.valueOf((Object)this.operationType));
        sb.append(", keyId=").append(String.valueOf(this.keyId));
        sb.append(", keyType=").append(String.valueOf((Object)this.keyType));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof StorageWorkRequest)) {
            return false;
        }
        StorageWorkRequest other = (StorageWorkRequest)((Object)o);
        return Objects.equals(this.id, other.id) && Objects.equals(this.compartmentId, other.compartmentId) && Objects.equals(this.timeStarted, other.timeStarted) && Objects.equals(this.timeAccepted, other.timeAccepted) && Objects.equals(this.timeFinished, other.timeFinished) && Objects.equals(this.timeExpires, other.timeExpires) && Objects.equals(this.percentComplete, other.percentComplete) && Objects.equals((Object)this.status, (Object)other.status) && Objects.equals(this.timeDataStarted, other.timeDataStarted) && Objects.equals(this.timeDataEnded, other.timeDataEnded) && Objects.equals(this.purgeQueryString, other.purgeQueryString) && Objects.equals((Object)this.dataType, (Object)other.dataType) && Objects.equals(this.statusDetails, other.statusDetails) && Objects.equals(this.operationDetails, other.operationDetails) && Objects.equals(this.policyName, other.policyName) && Objects.equals(this.policyId, other.policyId) && Objects.equals(this.storageUsageInBytes, other.storageUsageInBytes) && Objects.equals(this.compartmentIdInSubtree, other.compartmentIdInSubtree) && Objects.equals((Object)this.operationType, (Object)other.operationType) && Objects.equals(this.keyId, other.keyId) && Objects.equals((Object)this.keyType, (Object)other.keyType) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.id == null ? 43 : this.id.hashCode());
        result = result * 59 + (this.compartmentId == null ? 43 : this.compartmentId.hashCode());
        result = result * 59 + (this.timeStarted == null ? 43 : this.timeStarted.hashCode());
        result = result * 59 + (this.timeAccepted == null ? 43 : this.timeAccepted.hashCode());
        result = result * 59 + (this.timeFinished == null ? 43 : this.timeFinished.hashCode());
        result = result * 59 + (this.timeExpires == null ? 43 : this.timeExpires.hashCode());
        result = result * 59 + (this.percentComplete == null ? 43 : this.percentComplete.hashCode());
        result = result * 59 + (this.status == null ? 43 : this.status.hashCode());
        result = result * 59 + (this.timeDataStarted == null ? 43 : this.timeDataStarted.hashCode());
        result = result * 59 + (this.timeDataEnded == null ? 43 : this.timeDataEnded.hashCode());
        result = result * 59 + (this.purgeQueryString == null ? 43 : this.purgeQueryString.hashCode());
        result = result * 59 + (this.dataType == null ? 43 : this.dataType.hashCode());
        result = result * 59 + (this.statusDetails == null ? 43 : this.statusDetails.hashCode());
        result = result * 59 + (this.operationDetails == null ? 43 : this.operationDetails.hashCode());
        result = result * 59 + (this.policyName == null ? 43 : this.policyName.hashCode());
        result = result * 59 + (this.policyId == null ? 43 : this.policyId.hashCode());
        result = result * 59 + (this.storageUsageInBytes == null ? 43 : this.storageUsageInBytes.hashCode());
        result = result * 59 + (this.compartmentIdInSubtree == null ? 43 : this.compartmentIdInSubtree.hashCode());
        result = result * 59 + (this.operationType == null ? 43 : this.operationType.hashCode());
        result = result * 59 + (this.keyId == null ? 43 : this.keyId.hashCode());
        result = result * 59 + (this.keyType == null ? 43 : this.keyType.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="id")
        private String id;
        @JsonProperty(value="compartmentId")
        private String compartmentId;
        @JsonProperty(value="timeStarted")
        private Date timeStarted;
        @JsonProperty(value="timeAccepted")
        private Date timeAccepted;
        @JsonProperty(value="timeFinished")
        private Date timeFinished;
        @JsonProperty(value="timeExpires")
        private Date timeExpires;
        @JsonProperty(value="percentComplete")
        private Integer percentComplete;
        @JsonProperty(value="status")
        private WorkRequestStatus status;
        @JsonProperty(value="timeDataStarted")
        private Date timeDataStarted;
        @JsonProperty(value="timeDataEnded")
        private Date timeDataEnded;
        @JsonProperty(value="purgeQueryString")
        private String purgeQueryString;
        @JsonProperty(value="dataType")
        private StorageDataType dataType;
        @JsonProperty(value="statusDetails")
        private String statusDetails;
        @JsonProperty(value="operationDetails")
        private String operationDetails;
        @JsonProperty(value="policyName")
        private String policyName;
        @JsonProperty(value="policyId")
        private String policyId;
        @JsonProperty(value="storageUsageInBytes")
        private Long storageUsageInBytes;
        @JsonProperty(value="compartmentIdInSubtree")
        private Boolean compartmentIdInSubtree;
        @JsonProperty(value="operationType")
        private StorageOperationType operationType;
        @JsonProperty(value="keyId")
        private String keyId;
        @JsonProperty(value="keyType")
        private EncryptionKeyType keyType;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder id(String id) {
            this.id = id;
            this.__explicitlySet__.add("id");
            return this;
        }

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            this.__explicitlySet__.add("compartmentId");
            return this;
        }

        public Builder timeStarted(Date timeStarted) {
            this.timeStarted = timeStarted;
            this.__explicitlySet__.add("timeStarted");
            return this;
        }

        public Builder timeAccepted(Date timeAccepted) {
            this.timeAccepted = timeAccepted;
            this.__explicitlySet__.add("timeAccepted");
            return this;
        }

        public Builder timeFinished(Date timeFinished) {
            this.timeFinished = timeFinished;
            this.__explicitlySet__.add("timeFinished");
            return this;
        }

        public Builder timeExpires(Date timeExpires) {
            this.timeExpires = timeExpires;
            this.__explicitlySet__.add("timeExpires");
            return this;
        }

        public Builder percentComplete(Integer percentComplete) {
            this.percentComplete = percentComplete;
            this.__explicitlySet__.add("percentComplete");
            return this;
        }

        public Builder status(WorkRequestStatus status) {
            this.status = status;
            this.__explicitlySet__.add("status");
            return this;
        }

        public Builder timeDataStarted(Date timeDataStarted) {
            this.timeDataStarted = timeDataStarted;
            this.__explicitlySet__.add("timeDataStarted");
            return this;
        }

        public Builder timeDataEnded(Date timeDataEnded) {
            this.timeDataEnded = timeDataEnded;
            this.__explicitlySet__.add("timeDataEnded");
            return this;
        }

        public Builder purgeQueryString(String purgeQueryString) {
            this.purgeQueryString = purgeQueryString;
            this.__explicitlySet__.add("purgeQueryString");
            return this;
        }

        public Builder dataType(StorageDataType dataType) {
            this.dataType = dataType;
            this.__explicitlySet__.add("dataType");
            return this;
        }

        public Builder statusDetails(String statusDetails) {
            this.statusDetails = statusDetails;
            this.__explicitlySet__.add("statusDetails");
            return this;
        }

        public Builder operationDetails(String operationDetails) {
            this.operationDetails = operationDetails;
            this.__explicitlySet__.add("operationDetails");
            return this;
        }

        public Builder policyName(String policyName) {
            this.policyName = policyName;
            this.__explicitlySet__.add("policyName");
            return this;
        }

        public Builder policyId(String policyId) {
            this.policyId = policyId;
            this.__explicitlySet__.add("policyId");
            return this;
        }

        public Builder storageUsageInBytes(Long storageUsageInBytes) {
            this.storageUsageInBytes = storageUsageInBytes;
            this.__explicitlySet__.add("storageUsageInBytes");
            return this;
        }

        public Builder compartmentIdInSubtree(Boolean compartmentIdInSubtree) {
            this.compartmentIdInSubtree = compartmentIdInSubtree;
            this.__explicitlySet__.add("compartmentIdInSubtree");
            return this;
        }

        public Builder operationType(StorageOperationType operationType) {
            this.operationType = operationType;
            this.__explicitlySet__.add("operationType");
            return this;
        }

        public Builder keyId(String keyId) {
            this.keyId = keyId;
            this.__explicitlySet__.add("keyId");
            return this;
        }

        public Builder keyType(EncryptionKeyType keyType) {
            this.keyType = keyType;
            this.__explicitlySet__.add("keyType");
            return this;
        }

        public StorageWorkRequest build() {
            StorageWorkRequest model = new StorageWorkRequest(this.id, this.compartmentId, this.timeStarted, this.timeAccepted, this.timeFinished, this.timeExpires, this.percentComplete, this.status, this.timeDataStarted, this.timeDataEnded, this.purgeQueryString, this.dataType, this.statusDetails, this.operationDetails, this.policyName, this.policyId, this.storageUsageInBytes, this.compartmentIdInSubtree, this.operationType, this.keyId, this.keyType);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(StorageWorkRequest model) {
            if (model.wasPropertyExplicitlySet("id")) {
                this.id(model.getId());
            }
            if (model.wasPropertyExplicitlySet("compartmentId")) {
                this.compartmentId(model.getCompartmentId());
            }
            if (model.wasPropertyExplicitlySet("timeStarted")) {
                this.timeStarted(model.getTimeStarted());
            }
            if (model.wasPropertyExplicitlySet("timeAccepted")) {
                this.timeAccepted(model.getTimeAccepted());
            }
            if (model.wasPropertyExplicitlySet("timeFinished")) {
                this.timeFinished(model.getTimeFinished());
            }
            if (model.wasPropertyExplicitlySet("timeExpires")) {
                this.timeExpires(model.getTimeExpires());
            }
            if (model.wasPropertyExplicitlySet("percentComplete")) {
                this.percentComplete(model.getPercentComplete());
            }
            if (model.wasPropertyExplicitlySet("status")) {
                this.status(model.getStatus());
            }
            if (model.wasPropertyExplicitlySet("timeDataStarted")) {
                this.timeDataStarted(model.getTimeDataStarted());
            }
            if (model.wasPropertyExplicitlySet("timeDataEnded")) {
                this.timeDataEnded(model.getTimeDataEnded());
            }
            if (model.wasPropertyExplicitlySet("purgeQueryString")) {
                this.purgeQueryString(model.getPurgeQueryString());
            }
            if (model.wasPropertyExplicitlySet("dataType")) {
                this.dataType(model.getDataType());
            }
            if (model.wasPropertyExplicitlySet("statusDetails")) {
                this.statusDetails(model.getStatusDetails());
            }
            if (model.wasPropertyExplicitlySet("operationDetails")) {
                this.operationDetails(model.getOperationDetails());
            }
            if (model.wasPropertyExplicitlySet("policyName")) {
                this.policyName(model.getPolicyName());
            }
            if (model.wasPropertyExplicitlySet("policyId")) {
                this.policyId(model.getPolicyId());
            }
            if (model.wasPropertyExplicitlySet("storageUsageInBytes")) {
                this.storageUsageInBytes(model.getStorageUsageInBytes());
            }
            if (model.wasPropertyExplicitlySet("compartmentIdInSubtree")) {
                this.compartmentIdInSubtree(model.getCompartmentIdInSubtree());
            }
            if (model.wasPropertyExplicitlySet("operationType")) {
                this.operationType(model.getOperationType());
            }
            if (model.wasPropertyExplicitlySet("keyId")) {
                this.keyId(model.getKeyId());
            }
            if (model.wasPropertyExplicitlySet("keyType")) {
                this.keyType(model.getKeyType());
            }
            return this;
        }
    }
}

