/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.loganalytics.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.loganalytics.model.Action;
import com.oracle.bmc.loganalytics.model.MetricExtraction;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="type")
@JsonFilter(value="explicitlySetFilter")
public final class StreamAction
extends Action {
    @JsonProperty(value="savedSearchId")
    private final String savedSearchId;
    @JsonProperty(value="metricExtraction")
    private final MetricExtraction metricExtraction;
    @JsonProperty(value="savedSearchDuration")
    private final String savedSearchDuration;

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    @Deprecated
    public StreamAction(String savedSearchId, MetricExtraction metricExtraction, String savedSearchDuration) {
        this.savedSearchId = savedSearchId;
        this.metricExtraction = metricExtraction;
        this.savedSearchDuration = savedSearchDuration;
    }

    public String getSavedSearchId() {
        return this.savedSearchId;
    }

    public MetricExtraction getMetricExtraction() {
        return this.metricExtraction;
    }

    public String getSavedSearchDuration() {
        return this.savedSearchDuration;
    }

    @Override
    public String toString() {
        return this.toString(true);
    }

    @Override
    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("StreamAction(");
        sb.append("super=").append(super.toString(includeByteArrayContents));
        sb.append(", savedSearchId=").append(String.valueOf(this.savedSearchId));
        sb.append(", metricExtraction=").append(String.valueOf((Object)this.metricExtraction));
        sb.append(", savedSearchDuration=").append(String.valueOf(this.savedSearchDuration));
        sb.append(")");
        return sb.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof StreamAction)) {
            return false;
        }
        StreamAction other = (StreamAction)((Object)o);
        return Objects.equals(this.savedSearchId, other.savedSearchId) && Objects.equals((Object)this.metricExtraction, (Object)other.metricExtraction) && Objects.equals(this.savedSearchDuration, other.savedSearchDuration) && super.equals((Object)other);
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.savedSearchId == null ? 43 : this.savedSearchId.hashCode());
        result = result * 59 + (this.metricExtraction == null ? 43 : this.metricExtraction.hashCode());
        result = result * 59 + (this.savedSearchDuration == null ? 43 : this.savedSearchDuration.hashCode());
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="savedSearchId")
        private String savedSearchId;
        @JsonProperty(value="metricExtraction")
        private MetricExtraction metricExtraction;
        @JsonProperty(value="savedSearchDuration")
        private String savedSearchDuration;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder savedSearchId(String savedSearchId) {
            this.savedSearchId = savedSearchId;
            this.__explicitlySet__.add("savedSearchId");
            return this;
        }

        public Builder metricExtraction(MetricExtraction metricExtraction) {
            this.metricExtraction = metricExtraction;
            this.__explicitlySet__.add("metricExtraction");
            return this;
        }

        public Builder savedSearchDuration(String savedSearchDuration) {
            this.savedSearchDuration = savedSearchDuration;
            this.__explicitlySet__.add("savedSearchDuration");
            return this;
        }

        public StreamAction build() {
            StreamAction model = new StreamAction(this.savedSearchId, this.metricExtraction, this.savedSearchDuration);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(StreamAction model) {
            if (model.wasPropertyExplicitlySet("savedSearchId")) {
                this.savedSearchId(model.getSavedSearchId());
            }
            if (model.wasPropertyExplicitlySet("metricExtraction")) {
                this.metricExtraction(model.getMetricExtraction());
            }
            if (model.wasPropertyExplicitlySet("savedSearchDuration")) {
                this.savedSearchDuration(model.getSavedSearchDuration());
            }
            return this;
        }
    }
}

