/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.loganalytics.requests;

import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class GetLogAnalyticsEmBridgeRequest
extends BmcRequest<Void> {
    private String namespaceName;
    private String logAnalyticsEmBridgeId;
    private String opcRequestId;

    public String getNamespaceName() {
        return this.namespaceName;
    }

    public String getLogAnalyticsEmBridgeId() {
        return this.logAnalyticsEmBridgeId;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public Builder toBuilder() {
        return new Builder().namespaceName(this.namespaceName).logAnalyticsEmBridgeId(this.logAnalyticsEmBridgeId).opcRequestId(this.opcRequestId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",namespaceName=").append(String.valueOf(this.namespaceName));
        sb.append(",logAnalyticsEmBridgeId=").append(String.valueOf(this.logAnalyticsEmBridgeId));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GetLogAnalyticsEmBridgeRequest)) {
            return false;
        }
        GetLogAnalyticsEmBridgeRequest other = (GetLogAnalyticsEmBridgeRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.namespaceName, other.namespaceName) && Objects.equals(this.logAnalyticsEmBridgeId, other.logAnalyticsEmBridgeId) && Objects.equals(this.opcRequestId, other.opcRequestId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.namespaceName == null ? 43 : this.namespaceName.hashCode());
        result = result * 59 + (this.logAnalyticsEmBridgeId == null ? 43 : this.logAnalyticsEmBridgeId.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<GetLogAnalyticsEmBridgeRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String namespaceName = null;
        private String logAnalyticsEmBridgeId = null;
        private String opcRequestId = null;

        public Builder namespaceName(String namespaceName) {
            this.namespaceName = namespaceName;
            return this;
        }

        public Builder logAnalyticsEmBridgeId(String logAnalyticsEmBridgeId) {
            this.logAnalyticsEmBridgeId = logAnalyticsEmBridgeId;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(GetLogAnalyticsEmBridgeRequest o) {
            this.namespaceName(o.getNamespaceName());
            this.logAnalyticsEmBridgeId(o.getLogAnalyticsEmBridgeId());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public GetLogAnalyticsEmBridgeRequest build() {
            GetLogAnalyticsEmBridgeRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public GetLogAnalyticsEmBridgeRequest buildWithoutInvocationCallback() {
            GetLogAnalyticsEmBridgeRequest request = new GetLogAnalyticsEmBridgeRequest();
            request.namespaceName = this.namespaceName;
            request.logAnalyticsEmBridgeId = this.logAnalyticsEmBridgeId;
            request.opcRequestId = this.opcRequestId;
            return request;
        }
    }
}

