/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.loganalytics.requests;

import com.oracle.bmc.InternalSdk;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.loganalytics.model.LogAnalyticsPreferenceDetails;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class RemovePreferencesRequest
extends BmcRequest<LogAnalyticsPreferenceDetails> {
    private String namespaceName;
    private LogAnalyticsPreferenceDetails removePreferencesDetails;
    private String opcRetryToken;
    private String opcRequestId;

    public String getNamespaceName() {
        return this.namespaceName;
    }

    public LogAnalyticsPreferenceDetails getRemovePreferencesDetails() {
        return this.removePreferencesDetails;
    }

    public String getOpcRetryToken() {
        return this.opcRetryToken;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    @InternalSdk
    public LogAnalyticsPreferenceDetails getBody$() {
        return this.removePreferencesDetails;
    }

    public boolean supportsExpect100Continue() {
        return true;
    }

    public Builder toBuilder() {
        return new Builder().namespaceName(this.namespaceName).removePreferencesDetails(this.removePreferencesDetails).opcRetryToken(this.opcRetryToken).opcRequestId(this.opcRequestId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",namespaceName=").append(String.valueOf(this.namespaceName));
        sb.append(",removePreferencesDetails=").append(String.valueOf((Object)this.removePreferencesDetails));
        sb.append(",opcRetryToken=").append(String.valueOf(this.opcRetryToken));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof RemovePreferencesRequest)) {
            return false;
        }
        RemovePreferencesRequest other = (RemovePreferencesRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.namespaceName, other.namespaceName) && Objects.equals((Object)this.removePreferencesDetails, (Object)other.removePreferencesDetails) && Objects.equals(this.opcRetryToken, other.opcRetryToken) && Objects.equals(this.opcRequestId, other.opcRequestId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.namespaceName == null ? 43 : this.namespaceName.hashCode());
        result = result * 59 + (this.removePreferencesDetails == null ? 43 : this.removePreferencesDetails.hashCode());
        result = result * 59 + (this.opcRetryToken == null ? 43 : this.opcRetryToken.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<RemovePreferencesRequest, LogAnalyticsPreferenceDetails> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String namespaceName = null;
        private LogAnalyticsPreferenceDetails removePreferencesDetails = null;
        private String opcRetryToken = null;
        private String opcRequestId = null;

        public Builder namespaceName(String namespaceName) {
            this.namespaceName = namespaceName;
            return this;
        }

        public Builder removePreferencesDetails(LogAnalyticsPreferenceDetails removePreferencesDetails) {
            this.removePreferencesDetails = removePreferencesDetails;
            return this;
        }

        public Builder opcRetryToken(String opcRetryToken) {
            this.opcRetryToken = opcRetryToken;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(RemovePreferencesRequest o) {
            this.namespaceName(o.getNamespaceName());
            this.removePreferencesDetails(o.getRemovePreferencesDetails());
            this.opcRetryToken(o.getOpcRetryToken());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public RemovePreferencesRequest build() {
            RemovePreferencesRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        @InternalSdk
        public Builder body$(LogAnalyticsPreferenceDetails body) {
            this.removePreferencesDetails(body);
            return this;
        }

        public RemovePreferencesRequest buildWithoutInvocationCallback() {
            RemovePreferencesRequest request = new RemovePreferencesRequest();
            request.namespaceName = this.namespaceName;
            request.removePreferencesDetails = this.removePreferencesDetails;
            request.opcRetryToken = this.opcRetryToken;
            request.opcRequestId = this.opcRequestId;
            return request;
        }
    }
}

