/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.loganalytics.requests;

import com.oracle.bmc.InternalSdk;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.loganalytics.model.UpdateScheduledTaskDetails;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class UpdateScheduledTaskRequest
extends BmcRequest<UpdateScheduledTaskDetails> {
    private String namespaceName;
    private String scheduledTaskId;
    private UpdateScheduledTaskDetails updateScheduledTaskDetails;
    private String opcRequestId;
    private String ifMatch;

    public String getNamespaceName() {
        return this.namespaceName;
    }

    public String getScheduledTaskId() {
        return this.scheduledTaskId;
    }

    public UpdateScheduledTaskDetails getUpdateScheduledTaskDetails() {
        return this.updateScheduledTaskDetails;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public String getIfMatch() {
        return this.ifMatch;
    }

    @InternalSdk
    public UpdateScheduledTaskDetails getBody$() {
        return this.updateScheduledTaskDetails;
    }

    public boolean supportsExpect100Continue() {
        return true;
    }

    public Builder toBuilder() {
        return new Builder().namespaceName(this.namespaceName).scheduledTaskId(this.scheduledTaskId).updateScheduledTaskDetails(this.updateScheduledTaskDetails).opcRequestId(this.opcRequestId).ifMatch(this.ifMatch);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",namespaceName=").append(String.valueOf(this.namespaceName));
        sb.append(",scheduledTaskId=").append(String.valueOf(this.scheduledTaskId));
        sb.append(",updateScheduledTaskDetails=").append(String.valueOf((Object)this.updateScheduledTaskDetails));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(",ifMatch=").append(String.valueOf(this.ifMatch));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof UpdateScheduledTaskRequest)) {
            return false;
        }
        UpdateScheduledTaskRequest other = (UpdateScheduledTaskRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.namespaceName, other.namespaceName) && Objects.equals(this.scheduledTaskId, other.scheduledTaskId) && Objects.equals((Object)this.updateScheduledTaskDetails, (Object)other.updateScheduledTaskDetails) && Objects.equals(this.opcRequestId, other.opcRequestId) && Objects.equals(this.ifMatch, other.ifMatch);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.namespaceName == null ? 43 : this.namespaceName.hashCode());
        result = result * 59 + (this.scheduledTaskId == null ? 43 : this.scheduledTaskId.hashCode());
        result = result * 59 + (this.updateScheduledTaskDetails == null ? 43 : this.updateScheduledTaskDetails.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        result = result * 59 + (this.ifMatch == null ? 43 : this.ifMatch.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<UpdateScheduledTaskRequest, UpdateScheduledTaskDetails> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String namespaceName = null;
        private String scheduledTaskId = null;
        private UpdateScheduledTaskDetails updateScheduledTaskDetails = null;
        private String opcRequestId = null;
        private String ifMatch = null;

        public Builder namespaceName(String namespaceName) {
            this.namespaceName = namespaceName;
            return this;
        }

        public Builder scheduledTaskId(String scheduledTaskId) {
            this.scheduledTaskId = scheduledTaskId;
            return this;
        }

        public Builder updateScheduledTaskDetails(UpdateScheduledTaskDetails updateScheduledTaskDetails) {
            this.updateScheduledTaskDetails = updateScheduledTaskDetails;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(UpdateScheduledTaskRequest o) {
            this.namespaceName(o.getNamespaceName());
            this.scheduledTaskId(o.getScheduledTaskId());
            this.updateScheduledTaskDetails(o.getUpdateScheduledTaskDetails());
            this.opcRequestId(o.getOpcRequestId());
            this.ifMatch(o.getIfMatch());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public UpdateScheduledTaskRequest build() {
            UpdateScheduledTaskRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        @InternalSdk
        public Builder body$(UpdateScheduledTaskDetails body) {
            this.updateScheduledTaskDetails(body);
            return this;
        }

        public UpdateScheduledTaskRequest buildWithoutInvocationCallback() {
            UpdateScheduledTaskRequest request = new UpdateScheduledTaskRequest();
            request.namespaceName = this.namespaceName;
            request.scheduledTaskId = this.scheduledTaskId;
            request.updateScheduledTaskDetails = this.updateScheduledTaskDetails;
            request.opcRequestId = this.opcRequestId;
            request.ifMatch = this.ifMatch;
            return request;
        }
    }
}

