/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.loganalytics.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.loganalytics.model.AbstractColumn;
import com.oracle.bmc.loganalytics.model.FieldValue;
import com.oracle.bmc.loganalytics.model.SubSystemName;
import com.oracle.bmc.loganalytics.model.ValueType;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="type")
@JsonFilter(value="explicitlySetFilter")
public final class ClassifyColumn
extends AbstractColumn {
    @JsonProperty(value="classifyFieldNames")
    private final List<String> classifyFieldNames;
    @JsonProperty(value="classifyFieldNullCount")
    private final List<Long> classifyFieldNullCount;
    @JsonProperty(value="classifyAnomalyIntervalCounts")
    private final List<Long> classifyAnomalyIntervalCounts;
    @JsonProperty(value="classifyColumns")
    private final List<AbstractColumn> classifyColumns;
    @JsonProperty(value="classifyResult")
    private final List<Map<String, Object>> classifyResult;
    @JsonProperty(value="classifyCorrelateColumns")
    private final List<AbstractColumn> classifyCorrelateColumns;
    @JsonProperty(value="classifyCorrelateResult")
    private final List<Map<String, Object>> classifyCorrelateResult;

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    @Deprecated
    public ClassifyColumn(String displayName, SubSystemName subSystem, List<FieldValue> values, Boolean isListOfValues, Boolean isMultiValued, Boolean isCaseSensitive, Boolean isGroupable, Boolean isEvaluable, ValueType valueType, String originalDisplayName, String internalName, List<String> classifyFieldNames, List<Long> classifyFieldNullCount, List<Long> classifyAnomalyIntervalCounts, List<AbstractColumn> classifyColumns, List<Map<String, Object>> classifyResult, List<AbstractColumn> classifyCorrelateColumns, List<Map<String, Object>> classifyCorrelateResult) {
        super(displayName, subSystem, values, isListOfValues, isMultiValued, isCaseSensitive, isGroupable, isEvaluable, valueType, originalDisplayName, internalName);
        this.classifyFieldNames = classifyFieldNames;
        this.classifyFieldNullCount = classifyFieldNullCount;
        this.classifyAnomalyIntervalCounts = classifyAnomalyIntervalCounts;
        this.classifyColumns = classifyColumns;
        this.classifyResult = classifyResult;
        this.classifyCorrelateColumns = classifyCorrelateColumns;
        this.classifyCorrelateResult = classifyCorrelateResult;
    }

    public List<String> getClassifyFieldNames() {
        return this.classifyFieldNames;
    }

    public List<Long> getClassifyFieldNullCount() {
        return this.classifyFieldNullCount;
    }

    public List<Long> getClassifyAnomalyIntervalCounts() {
        return this.classifyAnomalyIntervalCounts;
    }

    public List<AbstractColumn> getClassifyColumns() {
        return this.classifyColumns;
    }

    public List<Map<String, Object>> getClassifyResult() {
        return this.classifyResult;
    }

    public List<AbstractColumn> getClassifyCorrelateColumns() {
        return this.classifyCorrelateColumns;
    }

    public List<Map<String, Object>> getClassifyCorrelateResult() {
        return this.classifyCorrelateResult;
    }

    @Override
    public String toString() {
        return this.toString(true);
    }

    @Override
    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("ClassifyColumn(");
        sb.append("super=").append(super.toString(includeByteArrayContents));
        sb.append(", classifyFieldNames=").append(String.valueOf(this.classifyFieldNames));
        sb.append(", classifyFieldNullCount=").append(String.valueOf(this.classifyFieldNullCount));
        sb.append(", classifyAnomalyIntervalCounts=").append(String.valueOf(this.classifyAnomalyIntervalCounts));
        sb.append(", classifyColumns=").append(String.valueOf(this.classifyColumns));
        sb.append(", classifyResult=").append(String.valueOf(this.classifyResult));
        sb.append(", classifyCorrelateColumns=").append(String.valueOf(this.classifyCorrelateColumns));
        sb.append(", classifyCorrelateResult=").append(String.valueOf(this.classifyCorrelateResult));
        sb.append(")");
        return sb.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ClassifyColumn)) {
            return false;
        }
        ClassifyColumn other = (ClassifyColumn)((Object)o);
        return Objects.equals(this.classifyFieldNames, other.classifyFieldNames) && Objects.equals(this.classifyFieldNullCount, other.classifyFieldNullCount) && Objects.equals(this.classifyAnomalyIntervalCounts, other.classifyAnomalyIntervalCounts) && Objects.equals(this.classifyColumns, other.classifyColumns) && Objects.equals(this.classifyResult, other.classifyResult) && Objects.equals(this.classifyCorrelateColumns, other.classifyCorrelateColumns) && Objects.equals(this.classifyCorrelateResult, other.classifyCorrelateResult) && super.equals((Object)other);
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.classifyFieldNames == null ? 43 : this.classifyFieldNames.hashCode());
        result = result * 59 + (this.classifyFieldNullCount == null ? 43 : this.classifyFieldNullCount.hashCode());
        result = result * 59 + (this.classifyAnomalyIntervalCounts == null ? 43 : this.classifyAnomalyIntervalCounts.hashCode());
        result = result * 59 + (this.classifyColumns == null ? 43 : this.classifyColumns.hashCode());
        result = result * 59 + (this.classifyResult == null ? 43 : this.classifyResult.hashCode());
        result = result * 59 + (this.classifyCorrelateColumns == null ? 43 : this.classifyCorrelateColumns.hashCode());
        result = result * 59 + (this.classifyCorrelateResult == null ? 43 : this.classifyCorrelateResult.hashCode());
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="displayName")
        private String displayName;
        @JsonProperty(value="subSystem")
        private SubSystemName subSystem;
        @JsonProperty(value="values")
        private List<FieldValue> values;
        @JsonProperty(value="isListOfValues")
        private Boolean isListOfValues;
        @JsonProperty(value="isMultiValued")
        private Boolean isMultiValued;
        @JsonProperty(value="isCaseSensitive")
        private Boolean isCaseSensitive;
        @JsonProperty(value="isGroupable")
        private Boolean isGroupable;
        @JsonProperty(value="isEvaluable")
        private Boolean isEvaluable;
        @JsonProperty(value="valueType")
        private ValueType valueType;
        @JsonProperty(value="originalDisplayName")
        private String originalDisplayName;
        @JsonProperty(value="internalName")
        private String internalName;
        @JsonProperty(value="classifyFieldNames")
        private List<String> classifyFieldNames;
        @JsonProperty(value="classifyFieldNullCount")
        private List<Long> classifyFieldNullCount;
        @JsonProperty(value="classifyAnomalyIntervalCounts")
        private List<Long> classifyAnomalyIntervalCounts;
        @JsonProperty(value="classifyColumns")
        private List<AbstractColumn> classifyColumns;
        @JsonProperty(value="classifyResult")
        private List<Map<String, Object>> classifyResult;
        @JsonProperty(value="classifyCorrelateColumns")
        private List<AbstractColumn> classifyCorrelateColumns;
        @JsonProperty(value="classifyCorrelateResult")
        private List<Map<String, Object>> classifyCorrelateResult;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.__explicitlySet__.add("displayName");
            return this;
        }

        public Builder subSystem(SubSystemName subSystem) {
            this.subSystem = subSystem;
            this.__explicitlySet__.add("subSystem");
            return this;
        }

        public Builder values(List<FieldValue> values) {
            this.values = values;
            this.__explicitlySet__.add("values");
            return this;
        }

        public Builder isListOfValues(Boolean isListOfValues) {
            this.isListOfValues = isListOfValues;
            this.__explicitlySet__.add("isListOfValues");
            return this;
        }

        public Builder isMultiValued(Boolean isMultiValued) {
            this.isMultiValued = isMultiValued;
            this.__explicitlySet__.add("isMultiValued");
            return this;
        }

        public Builder isCaseSensitive(Boolean isCaseSensitive) {
            this.isCaseSensitive = isCaseSensitive;
            this.__explicitlySet__.add("isCaseSensitive");
            return this;
        }

        public Builder isGroupable(Boolean isGroupable) {
            this.isGroupable = isGroupable;
            this.__explicitlySet__.add("isGroupable");
            return this;
        }

        public Builder isEvaluable(Boolean isEvaluable) {
            this.isEvaluable = isEvaluable;
            this.__explicitlySet__.add("isEvaluable");
            return this;
        }

        public Builder valueType(ValueType valueType) {
            this.valueType = valueType;
            this.__explicitlySet__.add("valueType");
            return this;
        }

        public Builder originalDisplayName(String originalDisplayName) {
            this.originalDisplayName = originalDisplayName;
            this.__explicitlySet__.add("originalDisplayName");
            return this;
        }

        public Builder internalName(String internalName) {
            this.internalName = internalName;
            this.__explicitlySet__.add("internalName");
            return this;
        }

        public Builder classifyFieldNames(List<String> classifyFieldNames) {
            this.classifyFieldNames = classifyFieldNames;
            this.__explicitlySet__.add("classifyFieldNames");
            return this;
        }

        public Builder classifyFieldNullCount(List<Long> classifyFieldNullCount) {
            this.classifyFieldNullCount = classifyFieldNullCount;
            this.__explicitlySet__.add("classifyFieldNullCount");
            return this;
        }

        public Builder classifyAnomalyIntervalCounts(List<Long> classifyAnomalyIntervalCounts) {
            this.classifyAnomalyIntervalCounts = classifyAnomalyIntervalCounts;
            this.__explicitlySet__.add("classifyAnomalyIntervalCounts");
            return this;
        }

        public Builder classifyColumns(List<AbstractColumn> classifyColumns) {
            this.classifyColumns = classifyColumns;
            this.__explicitlySet__.add("classifyColumns");
            return this;
        }

        public Builder classifyResult(List<Map<String, Object>> classifyResult) {
            this.classifyResult = classifyResult;
            this.__explicitlySet__.add("classifyResult");
            return this;
        }

        public Builder classifyCorrelateColumns(List<AbstractColumn> classifyCorrelateColumns) {
            this.classifyCorrelateColumns = classifyCorrelateColumns;
            this.__explicitlySet__.add("classifyCorrelateColumns");
            return this;
        }

        public Builder classifyCorrelateResult(List<Map<String, Object>> classifyCorrelateResult) {
            this.classifyCorrelateResult = classifyCorrelateResult;
            this.__explicitlySet__.add("classifyCorrelateResult");
            return this;
        }

        public ClassifyColumn build() {
            ClassifyColumn model = new ClassifyColumn(this.displayName, this.subSystem, this.values, this.isListOfValues, this.isMultiValued, this.isCaseSensitive, this.isGroupable, this.isEvaluable, this.valueType, this.originalDisplayName, this.internalName, this.classifyFieldNames, this.classifyFieldNullCount, this.classifyAnomalyIntervalCounts, this.classifyColumns, this.classifyResult, this.classifyCorrelateColumns, this.classifyCorrelateResult);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(ClassifyColumn model) {
            if (model.wasPropertyExplicitlySet("displayName")) {
                this.displayName(model.getDisplayName());
            }
            if (model.wasPropertyExplicitlySet("subSystem")) {
                this.subSystem(model.getSubSystem());
            }
            if (model.wasPropertyExplicitlySet("values")) {
                this.values(model.getValues());
            }
            if (model.wasPropertyExplicitlySet("isListOfValues")) {
                this.isListOfValues(model.getIsListOfValues());
            }
            if (model.wasPropertyExplicitlySet("isMultiValued")) {
                this.isMultiValued(model.getIsMultiValued());
            }
            if (model.wasPropertyExplicitlySet("isCaseSensitive")) {
                this.isCaseSensitive(model.getIsCaseSensitive());
            }
            if (model.wasPropertyExplicitlySet("isGroupable")) {
                this.isGroupable(model.getIsGroupable());
            }
            if (model.wasPropertyExplicitlySet("isEvaluable")) {
                this.isEvaluable(model.getIsEvaluable());
            }
            if (model.wasPropertyExplicitlySet("valueType")) {
                this.valueType(model.getValueType());
            }
            if (model.wasPropertyExplicitlySet("originalDisplayName")) {
                this.originalDisplayName(model.getOriginalDisplayName());
            }
            if (model.wasPropertyExplicitlySet("internalName")) {
                this.internalName(model.getInternalName());
            }
            if (model.wasPropertyExplicitlySet("classifyFieldNames")) {
                this.classifyFieldNames(model.getClassifyFieldNames());
            }
            if (model.wasPropertyExplicitlySet("classifyFieldNullCount")) {
                this.classifyFieldNullCount(model.getClassifyFieldNullCount());
            }
            if (model.wasPropertyExplicitlySet("classifyAnomalyIntervalCounts")) {
                this.classifyAnomalyIntervalCounts(model.getClassifyAnomalyIntervalCounts());
            }
            if (model.wasPropertyExplicitlySet("classifyColumns")) {
                this.classifyColumns(model.getClassifyColumns());
            }
            if (model.wasPropertyExplicitlySet("classifyResult")) {
                this.classifyResult(model.getClassifyResult());
            }
            if (model.wasPropertyExplicitlySet("classifyCorrelateColumns")) {
                this.classifyCorrelateColumns(model.getClassifyCorrelateColumns());
            }
            if (model.wasPropertyExplicitlySet("classifyCorrelateResult")) {
                this.classifyCorrelateResult(model.getClassifyCorrelateResult());
            }
            return this;
        }
    }
}

