/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.loganalytics.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.loganalytics.model.LogAnalyticsParser;
import java.beans.ConstructorProperties;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class LogAnalyticsParserFilter
extends ExplicitlySetBmcModel {
    @JsonProperty(value="id")
    private final String id;
    @JsonProperty(value="parser")
    private final LogAnalyticsParser parser;
    @JsonProperty(value="agentVersion")
    private final String agentVersion;
    @JsonProperty(value="isInUse")
    private final Long isInUse;
    @JsonProperty(value="operatingSystem")
    private final String operatingSystem;
    @JsonProperty(value="parserId")
    private final Long parserId;
    @JsonProperty(value="version")
    private final String version;

    @Deprecated
    @ConstructorProperties(value={"id", "parser", "agentVersion", "isInUse", "operatingSystem", "parserId", "version"})
    public LogAnalyticsParserFilter(String id, LogAnalyticsParser parser, String agentVersion, Long isInUse, String operatingSystem, Long parserId, String version) {
        this.id = id;
        this.parser = parser;
        this.agentVersion = agentVersion;
        this.isInUse = isInUse;
        this.operatingSystem = operatingSystem;
        this.parserId = parserId;
        this.version = version;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getId() {
        return this.id;
    }

    public LogAnalyticsParser getParser() {
        return this.parser;
    }

    public String getAgentVersion() {
        return this.agentVersion;
    }

    public Long getIsInUse() {
        return this.isInUse;
    }

    public String getOperatingSystem() {
        return this.operatingSystem;
    }

    public Long getParserId() {
        return this.parserId;
    }

    public String getVersion() {
        return this.version;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("LogAnalyticsParserFilter(");
        sb.append("super=").append(super.toString());
        sb.append("id=").append(String.valueOf(this.id));
        sb.append(", parser=").append(String.valueOf((Object)this.parser));
        sb.append(", agentVersion=").append(String.valueOf(this.agentVersion));
        sb.append(", isInUse=").append(String.valueOf(this.isInUse));
        sb.append(", operatingSystem=").append(String.valueOf(this.operatingSystem));
        sb.append(", parserId=").append(String.valueOf(this.parserId));
        sb.append(", version=").append(String.valueOf(this.version));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof LogAnalyticsParserFilter)) {
            return false;
        }
        LogAnalyticsParserFilter other = (LogAnalyticsParserFilter)((Object)o);
        return Objects.equals(this.id, other.id) && Objects.equals((Object)this.parser, (Object)other.parser) && Objects.equals(this.agentVersion, other.agentVersion) && Objects.equals(this.isInUse, other.isInUse) && Objects.equals(this.operatingSystem, other.operatingSystem) && Objects.equals(this.parserId, other.parserId) && Objects.equals(this.version, other.version) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.id == null ? 43 : this.id.hashCode());
        result = result * 59 + (this.parser == null ? 43 : this.parser.hashCode());
        result = result * 59 + (this.agentVersion == null ? 43 : this.agentVersion.hashCode());
        result = result * 59 + (this.isInUse == null ? 43 : this.isInUse.hashCode());
        result = result * 59 + (this.operatingSystem == null ? 43 : this.operatingSystem.hashCode());
        result = result * 59 + (this.parserId == null ? 43 : this.parserId.hashCode());
        result = result * 59 + (this.version == null ? 43 : this.version.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="id")
        private String id;
        @JsonProperty(value="parser")
        private LogAnalyticsParser parser;
        @JsonProperty(value="agentVersion")
        private String agentVersion;
        @JsonProperty(value="isInUse")
        private Long isInUse;
        @JsonProperty(value="operatingSystem")
        private String operatingSystem;
        @JsonProperty(value="parserId")
        private Long parserId;
        @JsonProperty(value="version")
        private String version;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder id(String id) {
            this.id = id;
            this.__explicitlySet__.add("id");
            return this;
        }

        public Builder parser(LogAnalyticsParser parser) {
            this.parser = parser;
            this.__explicitlySet__.add("parser");
            return this;
        }

        public Builder agentVersion(String agentVersion) {
            this.agentVersion = agentVersion;
            this.__explicitlySet__.add("agentVersion");
            return this;
        }

        public Builder isInUse(Long isInUse) {
            this.isInUse = isInUse;
            this.__explicitlySet__.add("isInUse");
            return this;
        }

        public Builder operatingSystem(String operatingSystem) {
            this.operatingSystem = operatingSystem;
            this.__explicitlySet__.add("operatingSystem");
            return this;
        }

        public Builder parserId(Long parserId) {
            this.parserId = parserId;
            this.__explicitlySet__.add("parserId");
            return this;
        }

        public Builder version(String version) {
            this.version = version;
            this.__explicitlySet__.add("version");
            return this;
        }

        public LogAnalyticsParserFilter build() {
            LogAnalyticsParserFilter model = new LogAnalyticsParserFilter(this.id, this.parser, this.agentVersion, this.isInUse, this.operatingSystem, this.parserId, this.version);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(LogAnalyticsParserFilter model) {
            if (model.wasPropertyExplicitlySet("id")) {
                this.id(model.getId());
            }
            if (model.wasPropertyExplicitlySet("parser")) {
                this.parser(model.getParser());
            }
            if (model.wasPropertyExplicitlySet("agentVersion")) {
                this.agentVersion(model.getAgentVersion());
            }
            if (model.wasPropertyExplicitlySet("isInUse")) {
                this.isInUse(model.getIsInUse());
            }
            if (model.wasPropertyExplicitlySet("operatingSystem")) {
                this.operatingSystem(model.getOperatingSystem());
            }
            if (model.wasPropertyExplicitlySet("parserId")) {
                this.parserId(model.getParserId());
            }
            if (model.wasPropertyExplicitlySet("version")) {
                this.version(model.getVersion());
            }
            return this;
        }
    }
}

