/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.loganalytics.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.loganalytics.model.ResultColumn;
import java.beans.ConstructorProperties;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class VerifyOutput
extends ExplicitlySetBmcModel {
    @JsonProperty(value="scheduledTaskId")
    private final String scheduledTaskId;
    @JsonProperty(value="responseTimeInMs")
    private final Long responseTimeInMs;
    @JsonProperty(value="totalMatchedCount")
    private final Long totalMatchedCount;
    @JsonProperty(value="totalCount")
    private final Integer totalCount;
    @JsonProperty(value="columns")
    private final List<ResultColumn> columns;
    @JsonProperty(value="results")
    private final List<Map<String, Object>> results;

    @Deprecated
    @ConstructorProperties(value={"scheduledTaskId", "responseTimeInMs", "totalMatchedCount", "totalCount", "columns", "results"})
    public VerifyOutput(String scheduledTaskId, Long responseTimeInMs, Long totalMatchedCount, Integer totalCount, List<ResultColumn> columns, List<Map<String, Object>> results) {
        this.scheduledTaskId = scheduledTaskId;
        this.responseTimeInMs = responseTimeInMs;
        this.totalMatchedCount = totalMatchedCount;
        this.totalCount = totalCount;
        this.columns = columns;
        this.results = results;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getScheduledTaskId() {
        return this.scheduledTaskId;
    }

    public Long getResponseTimeInMs() {
        return this.responseTimeInMs;
    }

    public Long getTotalMatchedCount() {
        return this.totalMatchedCount;
    }

    public Integer getTotalCount() {
        return this.totalCount;
    }

    public List<ResultColumn> getColumns() {
        return this.columns;
    }

    public List<Map<String, Object>> getResults() {
        return this.results;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("VerifyOutput(");
        sb.append("super=").append(super.toString());
        sb.append("scheduledTaskId=").append(String.valueOf(this.scheduledTaskId));
        sb.append(", responseTimeInMs=").append(String.valueOf(this.responseTimeInMs));
        sb.append(", totalMatchedCount=").append(String.valueOf(this.totalMatchedCount));
        sb.append(", totalCount=").append(String.valueOf(this.totalCount));
        sb.append(", columns=").append(String.valueOf(this.columns));
        sb.append(", results=").append(String.valueOf(this.results));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof VerifyOutput)) {
            return false;
        }
        VerifyOutput other = (VerifyOutput)((Object)o);
        return Objects.equals(this.scheduledTaskId, other.scheduledTaskId) && Objects.equals(this.responseTimeInMs, other.responseTimeInMs) && Objects.equals(this.totalMatchedCount, other.totalMatchedCount) && Objects.equals(this.totalCount, other.totalCount) && Objects.equals(this.columns, other.columns) && Objects.equals(this.results, other.results) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.scheduledTaskId == null ? 43 : this.scheduledTaskId.hashCode());
        result = result * 59 + (this.responseTimeInMs == null ? 43 : this.responseTimeInMs.hashCode());
        result = result * 59 + (this.totalMatchedCount == null ? 43 : this.totalMatchedCount.hashCode());
        result = result * 59 + (this.totalCount == null ? 43 : this.totalCount.hashCode());
        result = result * 59 + (this.columns == null ? 43 : this.columns.hashCode());
        result = result * 59 + (this.results == null ? 43 : this.results.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="scheduledTaskId")
        private String scheduledTaskId;
        @JsonProperty(value="responseTimeInMs")
        private Long responseTimeInMs;
        @JsonProperty(value="totalMatchedCount")
        private Long totalMatchedCount;
        @JsonProperty(value="totalCount")
        private Integer totalCount;
        @JsonProperty(value="columns")
        private List<ResultColumn> columns;
        @JsonProperty(value="results")
        private List<Map<String, Object>> results;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder scheduledTaskId(String scheduledTaskId) {
            this.scheduledTaskId = scheduledTaskId;
            this.__explicitlySet__.add("scheduledTaskId");
            return this;
        }

        public Builder responseTimeInMs(Long responseTimeInMs) {
            this.responseTimeInMs = responseTimeInMs;
            this.__explicitlySet__.add("responseTimeInMs");
            return this;
        }

        public Builder totalMatchedCount(Long totalMatchedCount) {
            this.totalMatchedCount = totalMatchedCount;
            this.__explicitlySet__.add("totalMatchedCount");
            return this;
        }

        public Builder totalCount(Integer totalCount) {
            this.totalCount = totalCount;
            this.__explicitlySet__.add("totalCount");
            return this;
        }

        public Builder columns(List<ResultColumn> columns) {
            this.columns = columns;
            this.__explicitlySet__.add("columns");
            return this;
        }

        public Builder results(List<Map<String, Object>> results) {
            this.results = results;
            this.__explicitlySet__.add("results");
            return this;
        }

        public VerifyOutput build() {
            VerifyOutput model = new VerifyOutput(this.scheduledTaskId, this.responseTimeInMs, this.totalMatchedCount, this.totalCount, this.columns, this.results);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(VerifyOutput model) {
            if (model.wasPropertyExplicitlySet("scheduledTaskId")) {
                this.scheduledTaskId(model.getScheduledTaskId());
            }
            if (model.wasPropertyExplicitlySet("responseTimeInMs")) {
                this.responseTimeInMs(model.getResponseTimeInMs());
            }
            if (model.wasPropertyExplicitlySet("totalMatchedCount")) {
                this.totalMatchedCount(model.getTotalMatchedCount());
            }
            if (model.wasPropertyExplicitlySet("totalCount")) {
                this.totalCount(model.getTotalCount());
            }
            if (model.wasPropertyExplicitlySet("columns")) {
                this.columns(model.getColumns());
            }
            if (model.wasPropertyExplicitlySet("results")) {
                this.results(model.getResults());
            }
            return this;
        }
    }
}

