/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.loganalytics.requests;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.oracle.bmc.InternalSdk;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.http.internal.BmcEnum;
import com.oracle.bmc.loganalytics.model.LabelNames;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public class BatchGetBasicInfoRequest
extends BmcRequest<LabelNames> {
    private String namespaceName;
    private LabelNames basicDetails;
    private Boolean isIncludeDeleted;
    private Integer limit;
    private String page;
    private SortOrder sortOrder;
    private BasicLabelSortBy basicLabelSortBy;
    private String opcRequestId;

    public String getNamespaceName() {
        return this.namespaceName;
    }

    public LabelNames getBasicDetails() {
        return this.basicDetails;
    }

    public Boolean getIsIncludeDeleted() {
        return this.isIncludeDeleted;
    }

    public Integer getLimit() {
        return this.limit;
    }

    public String getPage() {
        return this.page;
    }

    public SortOrder getSortOrder() {
        return this.sortOrder;
    }

    public BasicLabelSortBy getBasicLabelSortBy() {
        return this.basicLabelSortBy;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    @InternalSdk
    public LabelNames getBody$() {
        return this.basicDetails;
    }

    public boolean supportsExpect100Continue() {
        return true;
    }

    public Builder toBuilder() {
        return new Builder().namespaceName(this.namespaceName).basicDetails(this.basicDetails).isIncludeDeleted(this.isIncludeDeleted).limit(this.limit).page(this.page).sortOrder(this.sortOrder).basicLabelSortBy(this.basicLabelSortBy).opcRequestId(this.opcRequestId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",namespaceName=").append(String.valueOf(this.namespaceName));
        sb.append(",basicDetails=").append(String.valueOf((Object)this.basicDetails));
        sb.append(",isIncludeDeleted=").append(String.valueOf(this.isIncludeDeleted));
        sb.append(",limit=").append(String.valueOf(this.limit));
        sb.append(",page=").append(String.valueOf(this.page));
        sb.append(",sortOrder=").append(String.valueOf((Object)this.sortOrder));
        sb.append(",basicLabelSortBy=").append(String.valueOf((Object)this.basicLabelSortBy));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof BatchGetBasicInfoRequest)) {
            return false;
        }
        BatchGetBasicInfoRequest other = (BatchGetBasicInfoRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.namespaceName, other.namespaceName) && Objects.equals((Object)this.basicDetails, (Object)other.basicDetails) && Objects.equals(this.isIncludeDeleted, other.isIncludeDeleted) && Objects.equals(this.limit, other.limit) && Objects.equals(this.page, other.page) && Objects.equals((Object)this.sortOrder, (Object)other.sortOrder) && Objects.equals((Object)this.basicLabelSortBy, (Object)other.basicLabelSortBy) && Objects.equals(this.opcRequestId, other.opcRequestId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.namespaceName == null ? 43 : this.namespaceName.hashCode());
        result = result * 59 + (this.basicDetails == null ? 43 : this.basicDetails.hashCode());
        result = result * 59 + (this.isIncludeDeleted == null ? 43 : this.isIncludeDeleted.hashCode());
        result = result * 59 + (this.limit == null ? 43 : this.limit.hashCode());
        result = result * 59 + (this.page == null ? 43 : this.page.hashCode());
        result = result * 59 + (this.sortOrder == null ? 43 : this.sortOrder.hashCode());
        result = result * 59 + (this.basicLabelSortBy == null ? 43 : this.basicLabelSortBy.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<BatchGetBasicInfoRequest, LabelNames> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String namespaceName = null;
        private LabelNames basicDetails = null;
        private Boolean isIncludeDeleted = null;
        private Integer limit = null;
        private String page = null;
        private SortOrder sortOrder = null;
        private BasicLabelSortBy basicLabelSortBy = null;
        private String opcRequestId = null;

        public Builder namespaceName(String namespaceName) {
            this.namespaceName = namespaceName;
            return this;
        }

        public Builder basicDetails(LabelNames basicDetails) {
            this.basicDetails = basicDetails;
            return this;
        }

        public Builder isIncludeDeleted(Boolean isIncludeDeleted) {
            this.isIncludeDeleted = isIncludeDeleted;
            return this;
        }

        public Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public Builder page(String page) {
            this.page = page;
            return this;
        }

        public Builder sortOrder(SortOrder sortOrder) {
            this.sortOrder = sortOrder;
            return this;
        }

        public Builder basicLabelSortBy(BasicLabelSortBy basicLabelSortBy) {
            this.basicLabelSortBy = basicLabelSortBy;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(BatchGetBasicInfoRequest o) {
            this.namespaceName(o.getNamespaceName());
            this.basicDetails(o.getBasicDetails());
            this.isIncludeDeleted(o.getIsIncludeDeleted());
            this.limit(o.getLimit());
            this.page(o.getPage());
            this.sortOrder(o.getSortOrder());
            this.basicLabelSortBy(o.getBasicLabelSortBy());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public BatchGetBasicInfoRequest build() {
            BatchGetBasicInfoRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        @InternalSdk
        public Builder body$(LabelNames body) {
            this.basicDetails(body);
            return this;
        }

        public BatchGetBasicInfoRequest buildWithoutInvocationCallback() {
            BatchGetBasicInfoRequest request = new BatchGetBasicInfoRequest();
            request.namespaceName = this.namespaceName;
            request.basicDetails = this.basicDetails;
            request.isIncludeDeleted = this.isIncludeDeleted;
            request.limit = this.limit;
            request.page = this.page;
            request.sortOrder = this.sortOrder;
            request.basicLabelSortBy = this.basicLabelSortBy;
            request.opcRequestId = this.opcRequestId;
            return request;
        }
    }

    public static enum BasicLabelSortBy implements BmcEnum
    {
        Name("name"),
        Priority("priority");

        private final String value;
        private static Map<String, BasicLabelSortBy> map;

        private BasicLabelSortBy(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static BasicLabelSortBy create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid BasicLabelSortBy: " + key);
        }

        static {
            map = new HashMap<String, BasicLabelSortBy>();
            for (BasicLabelSortBy v : BasicLabelSortBy.values()) {
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum SortOrder implements BmcEnum
    {
        Asc("ASC"),
        Desc("DESC");

        private final String value;
        private static Map<String, SortOrder> map;

        private SortOrder(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static SortOrder create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid SortOrder: " + key);
        }

        static {
            map = new HashMap<String, SortOrder>();
            for (SortOrder v : SortOrder.values()) {
                map.put(v.getValue(), v);
            }
        }
    }
}

