/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.loganalytics.responses;

import com.oracle.bmc.loganalytics.model.RecalledDataInfo;
import com.oracle.bmc.responses.BmcResponse;
import java.beans.ConstructorProperties;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class RecallArchivedDataResponse
extends BmcResponse {
    private String opcRequestId;
    private String opcWorkRequestId;
    private String location;
    private String etag;
    private RecalledDataInfo recalledDataInfo;

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public String getOpcWorkRequestId() {
        return this.opcWorkRequestId;
    }

    public String getLocation() {
        return this.location;
    }

    public String getEtag() {
        return this.etag;
    }

    public RecalledDataInfo getRecalledDataInfo() {
        return this.recalledDataInfo;
    }

    @ConstructorProperties(value={"__httpStatusCode__", "headers", "opcRequestId", "opcWorkRequestId", "location", "etag", "recalledDataInfo"})
    private RecallArchivedDataResponse(int __httpStatusCode__, Map<String, List<String>> headers, String opcRequestId, String opcWorkRequestId, String location, String etag, RecalledDataInfo recalledDataInfo) {
        super(__httpStatusCode__, headers);
        this.opcRequestId = opcRequestId;
        this.opcWorkRequestId = opcWorkRequestId;
        this.location = location;
        this.etag = etag;
        this.recalledDataInfo = recalledDataInfo;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(",opcWorkRequestId=").append(String.valueOf(this.opcWorkRequestId));
        sb.append(",location=").append(String.valueOf(this.location));
        sb.append(",etag=").append(String.valueOf(this.etag));
        sb.append(",recalledDataInfo=").append(String.valueOf((Object)this.recalledDataInfo));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof RecallArchivedDataResponse)) {
            return false;
        }
        RecallArchivedDataResponse other = (RecallArchivedDataResponse)((Object)o);
        return super.equals(o) && Objects.equals(this.opcRequestId, other.opcRequestId) && Objects.equals(this.opcWorkRequestId, other.opcWorkRequestId) && Objects.equals(this.location, other.location) && Objects.equals(this.etag, other.etag) && Objects.equals((Object)this.recalledDataInfo, (Object)other.recalledDataInfo);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        result = result * 59 + (this.opcWorkRequestId == null ? 43 : this.opcWorkRequestId.hashCode());
        result = result * 59 + (this.location == null ? 43 : this.location.hashCode());
        result = result * 59 + (this.etag == null ? 43 : this.etag.hashCode());
        result = result * 59 + (this.recalledDataInfo == null ? 43 : this.recalledDataInfo.hashCode());
        return result;
    }

    public static class Builder
    implements BmcResponse.Builder<RecallArchivedDataResponse> {
        private int __httpStatusCode__;
        private Map<String, List<String>> headers;
        private String opcRequestId;
        private String opcWorkRequestId;
        private String location;
        private String etag;
        private RecalledDataInfo recalledDataInfo;

        public Builder __httpStatusCode__(int __httpStatusCode__) {
            this.__httpStatusCode__ = __httpStatusCode__;
            return this;
        }

        public Builder headers(Map<String, List<String>> headers) {
            this.headers = headers;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder opcWorkRequestId(String opcWorkRequestId) {
            this.opcWorkRequestId = opcWorkRequestId;
            return this;
        }

        public Builder location(String location) {
            this.location = location;
            return this;
        }

        public Builder etag(String etag) {
            this.etag = etag;
            return this;
        }

        public Builder recalledDataInfo(RecalledDataInfo recalledDataInfo) {
            this.recalledDataInfo = recalledDataInfo;
            return this;
        }

        public Builder copy(RecallArchivedDataResponse o) {
            this.__httpStatusCode__(o.get__httpStatusCode__());
            this.headers(o.getHeaders());
            this.opcRequestId(o.getOpcRequestId());
            this.opcWorkRequestId(o.getOpcWorkRequestId());
            this.location(o.getLocation());
            this.etag(o.getEtag());
            this.recalledDataInfo(o.getRecalledDataInfo());
            return this;
        }

        public RecallArchivedDataResponse build() {
            return new RecallArchivedDataResponse(this.__httpStatusCode__, this.headers, this.opcRequestId, this.opcWorkRequestId, this.location, this.etag, this.recalledDataInfo);
        }
    }
}

