/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.loganalytics.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonValue;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.http.internal.BmcEnum;
import com.oracle.bmc.loganalytics.model.ChartColumn;
import com.oracle.bmc.loganalytics.model.ChartDataColumn;
import com.oracle.bmc.loganalytics.model.ClassifyColumn;
import com.oracle.bmc.loganalytics.model.Column;
import com.oracle.bmc.loganalytics.model.FieldValue;
import com.oracle.bmc.loganalytics.model.SubSystemName;
import com.oracle.bmc.loganalytics.model.TableColumn;
import com.oracle.bmc.loganalytics.model.TimeClusterColumn;
import com.oracle.bmc.loganalytics.model.TimeClusterDataColumn;
import com.oracle.bmc.loganalytics.model.TimeColumn;
import com.oracle.bmc.loganalytics.model.TimeStatsColumn;
import com.oracle.bmc.loganalytics.model.TimeStatsDataColumn;
import com.oracle.bmc.loganalytics.model.TrendColumn;
import com.oracle.bmc.loganalytics.model.ValueType;
import java.beans.ConstructorProperties;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="type", defaultImpl=AbstractColumn.class)
@JsonSubTypes(value={@JsonSubTypes.Type(value=TimeColumn.class, name="TIME_COLUMN"), @JsonSubTypes.Type(value=ClassifyColumn.class, name="CLASSIFY_COLUMN"), @JsonSubTypes.Type(value=TrendColumn.class, name="TREND_COLUMN"), @JsonSubTypes.Type(value=TimeStatsColumn.class, name="TIME_STATS_COLUMN"), @JsonSubTypes.Type(value=TimeClusterColumn.class, name="TIME_CLUSTER_COLUMN"), @JsonSubTypes.Type(value=Column.class, name="COLUMN"), @JsonSubTypes.Type(value=TimeClusterDataColumn.class, name="TIME_CLUSTER_DATA_COLUMN"), @JsonSubTypes.Type(value=TimeStatsDataColumn.class, name="TIME_STATS_DATA_COLUMN"), @JsonSubTypes.Type(value=TableColumn.class, name="TABLE_COLUMN"), @JsonSubTypes.Type(value=ChartColumn.class, name="CHART_COLUMN"), @JsonSubTypes.Type(value=ChartDataColumn.class, name="CHART_DATA_COLUMN")})
@JsonFilter(value="explicitlySetFilter")
public class AbstractColumn
extends ExplicitlySetBmcModel {
    @JsonProperty(value="displayName")
    private final String displayName;
    @JsonProperty(value="subSystem")
    private final SubSystemName subSystem;
    @JsonProperty(value="values")
    private final List<FieldValue> values;
    @JsonProperty(value="isListOfValues")
    private final Boolean isListOfValues;
    @JsonProperty(value="isMultiValued")
    private final Boolean isMultiValued;
    @JsonProperty(value="isCaseSensitive")
    private final Boolean isCaseSensitive;
    @JsonProperty(value="isGroupable")
    private final Boolean isGroupable;
    @JsonProperty(value="isEvaluable")
    private final Boolean isEvaluable;
    @JsonProperty(value="valueType")
    private final ValueType valueType;
    @JsonProperty(value="originalDisplayName")
    private final String originalDisplayName;
    @JsonProperty(value="internalName")
    private final String internalName;

    @Deprecated
    @ConstructorProperties(value={"displayName", "subSystem", "values", "isListOfValues", "isMultiValued", "isCaseSensitive", "isGroupable", "isEvaluable", "valueType", "originalDisplayName", "internalName"})
    protected AbstractColumn(String displayName, SubSystemName subSystem, List<FieldValue> values, Boolean isListOfValues, Boolean isMultiValued, Boolean isCaseSensitive, Boolean isGroupable, Boolean isEvaluable, ValueType valueType, String originalDisplayName, String internalName) {
        this.displayName = displayName;
        this.subSystem = subSystem;
        this.values = values;
        this.isListOfValues = isListOfValues;
        this.isMultiValued = isMultiValued;
        this.isCaseSensitive = isCaseSensitive;
        this.isGroupable = isGroupable;
        this.isEvaluable = isEvaluable;
        this.valueType = valueType;
        this.originalDisplayName = originalDisplayName;
        this.internalName = internalName;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public SubSystemName getSubSystem() {
        return this.subSystem;
    }

    public List<FieldValue> getValues() {
        return this.values;
    }

    public Boolean getIsListOfValues() {
        return this.isListOfValues;
    }

    public Boolean getIsMultiValued() {
        return this.isMultiValued;
    }

    public Boolean getIsCaseSensitive() {
        return this.isCaseSensitive;
    }

    public Boolean getIsGroupable() {
        return this.isGroupable;
    }

    public Boolean getIsEvaluable() {
        return this.isEvaluable;
    }

    public ValueType getValueType() {
        return this.valueType;
    }

    public String getOriginalDisplayName() {
        return this.originalDisplayName;
    }

    public String getInternalName() {
        return this.internalName;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("AbstractColumn(");
        sb.append("super=").append(super.toString());
        sb.append("displayName=").append(String.valueOf(this.displayName));
        sb.append(", subSystem=").append(String.valueOf((Object)this.subSystem));
        sb.append(", values=").append(String.valueOf(this.values));
        sb.append(", isListOfValues=").append(String.valueOf(this.isListOfValues));
        sb.append(", isMultiValued=").append(String.valueOf(this.isMultiValued));
        sb.append(", isCaseSensitive=").append(String.valueOf(this.isCaseSensitive));
        sb.append(", isGroupable=").append(String.valueOf(this.isGroupable));
        sb.append(", isEvaluable=").append(String.valueOf(this.isEvaluable));
        sb.append(", valueType=").append(String.valueOf((Object)this.valueType));
        sb.append(", originalDisplayName=").append(String.valueOf(this.originalDisplayName));
        sb.append(", internalName=").append(String.valueOf(this.internalName));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof AbstractColumn)) {
            return false;
        }
        AbstractColumn other = (AbstractColumn)((Object)o);
        return Objects.equals(this.displayName, other.displayName) && Objects.equals((Object)this.subSystem, (Object)other.subSystem) && Objects.equals(this.values, other.values) && Objects.equals(this.isListOfValues, other.isListOfValues) && Objects.equals(this.isMultiValued, other.isMultiValued) && Objects.equals(this.isCaseSensitive, other.isCaseSensitive) && Objects.equals(this.isGroupable, other.isGroupable) && Objects.equals(this.isEvaluable, other.isEvaluable) && Objects.equals((Object)this.valueType, (Object)other.valueType) && Objects.equals(this.originalDisplayName, other.originalDisplayName) && Objects.equals(this.internalName, other.internalName) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.displayName == null ? 43 : this.displayName.hashCode());
        result = result * 59 + (this.subSystem == null ? 43 : this.subSystem.hashCode());
        result = result * 59 + (this.values == null ? 43 : this.values.hashCode());
        result = result * 59 + (this.isListOfValues == null ? 43 : this.isListOfValues.hashCode());
        result = result * 59 + (this.isMultiValued == null ? 43 : this.isMultiValued.hashCode());
        result = result * 59 + (this.isCaseSensitive == null ? 43 : this.isCaseSensitive.hashCode());
        result = result * 59 + (this.isGroupable == null ? 43 : this.isGroupable.hashCode());
        result = result * 59 + (this.isEvaluable == null ? 43 : this.isEvaluable.hashCode());
        result = result * 59 + (this.valueType == null ? 43 : this.valueType.hashCode());
        result = result * 59 + (this.originalDisplayName == null ? 43 : this.originalDisplayName.hashCode());
        result = result * 59 + (this.internalName == null ? 43 : this.internalName.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    public static enum Type implements BmcEnum
    {
        Column("COLUMN"),
        ChartColumn("CHART_COLUMN"),
        ChartDataColumn("CHART_DATA_COLUMN"),
        TimeStatsColumn("TIME_STATS_COLUMN"),
        TimeStatsDataColumn("TIME_STATS_DATA_COLUMN"),
        TimeClusterColumn("TIME_CLUSTER_COLUMN"),
        TimeClusterDataColumn("TIME_CLUSTER_DATA_COLUMN"),
        TableColumn("TABLE_COLUMN"),
        TimeColumn("TIME_COLUMN"),
        TrendColumn("TREND_COLUMN"),
        ClassifyColumn("CLASSIFY_COLUMN"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, Type> map;

        private Type(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static Type create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'Type', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(Type.class);
            map = new HashMap<String, Type>();
            for (Type v : Type.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }
}

