/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.loganalytics.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.http.internal.BmcEnum;
import com.oracle.bmc.loganalytics.model.CredentialEndpoint;
import java.beans.ConstructorProperties;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class EndpointCredentials
extends ExplicitlySetBmcModel {
    @JsonProperty(value="credentialType")
    private final CredentialType credentialType;
    @JsonProperty(value="credentialName")
    private final String credentialName;
    @JsonProperty(value="credentialEndpoint")
    private final CredentialEndpoint credentialEndpoint;

    @Deprecated
    @ConstructorProperties(value={"credentialType", "credentialName", "credentialEndpoint"})
    public EndpointCredentials(CredentialType credentialType, String credentialName, CredentialEndpoint credentialEndpoint) {
        this.credentialType = credentialType;
        this.credentialName = credentialName;
        this.credentialEndpoint = credentialEndpoint;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public CredentialType getCredentialType() {
        return this.credentialType;
    }

    public String getCredentialName() {
        return this.credentialName;
    }

    public CredentialEndpoint getCredentialEndpoint() {
        return this.credentialEndpoint;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("EndpointCredentials(");
        sb.append("super=").append(super.toString());
        sb.append("credentialType=").append(String.valueOf((Object)this.credentialType));
        sb.append(", credentialName=").append(String.valueOf(this.credentialName));
        sb.append(", credentialEndpoint=").append(String.valueOf((Object)this.credentialEndpoint));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof EndpointCredentials)) {
            return false;
        }
        EndpointCredentials other = (EndpointCredentials)((Object)o);
        return Objects.equals((Object)this.credentialType, (Object)other.credentialType) && Objects.equals(this.credentialName, other.credentialName) && Objects.equals((Object)this.credentialEndpoint, (Object)other.credentialEndpoint) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.credentialType == null ? 43 : this.credentialType.hashCode());
        result = result * 59 + (this.credentialName == null ? 43 : this.credentialName.hashCode());
        result = result * 59 + (this.credentialEndpoint == null ? 43 : this.credentialEndpoint.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    public static enum CredentialType implements BmcEnum
    {
        None("NONE"),
        BasicAuth("BASIC_AUTH"),
        StaticToken("STATIC_TOKEN"),
        DynamicToken("DYNAMIC_TOKEN"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, CredentialType> map;

        private CredentialType(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static CredentialType create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'CredentialType', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(CredentialType.class);
            map = new HashMap<String, CredentialType>();
            for (CredentialType v : CredentialType.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="credentialType")
        private CredentialType credentialType;
        @JsonProperty(value="credentialName")
        private String credentialName;
        @JsonProperty(value="credentialEndpoint")
        private CredentialEndpoint credentialEndpoint;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder credentialType(CredentialType credentialType) {
            this.credentialType = credentialType;
            this.__explicitlySet__.add("credentialType");
            return this;
        }

        public Builder credentialName(String credentialName) {
            this.credentialName = credentialName;
            this.__explicitlySet__.add("credentialName");
            return this;
        }

        public Builder credentialEndpoint(CredentialEndpoint credentialEndpoint) {
            this.credentialEndpoint = credentialEndpoint;
            this.__explicitlySet__.add("credentialEndpoint");
            return this;
        }

        public EndpointCredentials build() {
            EndpointCredentials model = new EndpointCredentials(this.credentialType, this.credentialName, this.credentialEndpoint);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(EndpointCredentials model) {
            if (model.wasPropertyExplicitlySet("credentialType")) {
                this.credentialType(model.getCredentialType());
            }
            if (model.wasPropertyExplicitlySet("credentialName")) {
                this.credentialName(model.getCredentialName());
            }
            if (model.wasPropertyExplicitlySet("credentialEndpoint")) {
                this.credentialEndpoint(model.getCredentialEndpoint());
            }
            return this;
        }
    }
}

