/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.loganalytics.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.http.internal.BmcEnum;
import com.oracle.bmc.loganalytics.model.ScopeFilter;
import com.oracle.bmc.loganalytics.model.SubSystemName;
import com.oracle.bmc.loganalytics.model.TimeRange;
import java.beans.ConstructorProperties;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class ExportDetails
extends ExplicitlySetBmcModel {
    @JsonProperty(value="compartmentId")
    private final String compartmentId;
    @JsonProperty(value="compartmentIdInSubtree")
    private final Boolean compartmentIdInSubtree;
    @JsonProperty(value="queryString")
    private final String queryString;
    @JsonProperty(value="subSystem")
    private final SubSystemName subSystem;
    @JsonProperty(value="scopeFilters")
    private final List<ScopeFilter> scopeFilters;
    @JsonProperty(value="maxTotalCount")
    private final Integer maxTotalCount;
    @JsonProperty(value="timeFilter")
    private final TimeRange timeFilter;
    @JsonProperty(value="queryTimeoutInSeconds")
    private final Integer queryTimeoutInSeconds;
    @JsonProperty(value="shouldIncludeColumns")
    private final Boolean shouldIncludeColumns;
    @JsonProperty(value="outputFormat")
    private final OutputFormat outputFormat;
    @JsonProperty(value="shouldLocalize")
    private final Boolean shouldLocalize;
    @JsonProperty(value="shouldUseAcceleration")
    private final Boolean shouldUseAcceleration;

    @Deprecated
    @ConstructorProperties(value={"compartmentId", "compartmentIdInSubtree", "queryString", "subSystem", "scopeFilters", "maxTotalCount", "timeFilter", "queryTimeoutInSeconds", "shouldIncludeColumns", "outputFormat", "shouldLocalize", "shouldUseAcceleration"})
    public ExportDetails(String compartmentId, Boolean compartmentIdInSubtree, String queryString, SubSystemName subSystem, List<ScopeFilter> scopeFilters, Integer maxTotalCount, TimeRange timeFilter, Integer queryTimeoutInSeconds, Boolean shouldIncludeColumns, OutputFormat outputFormat, Boolean shouldLocalize, Boolean shouldUseAcceleration) {
        this.compartmentId = compartmentId;
        this.compartmentIdInSubtree = compartmentIdInSubtree;
        this.queryString = queryString;
        this.subSystem = subSystem;
        this.scopeFilters = scopeFilters;
        this.maxTotalCount = maxTotalCount;
        this.timeFilter = timeFilter;
        this.queryTimeoutInSeconds = queryTimeoutInSeconds;
        this.shouldIncludeColumns = shouldIncludeColumns;
        this.outputFormat = outputFormat;
        this.shouldLocalize = shouldLocalize;
        this.shouldUseAcceleration = shouldUseAcceleration;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getCompartmentId() {
        return this.compartmentId;
    }

    public Boolean getCompartmentIdInSubtree() {
        return this.compartmentIdInSubtree;
    }

    public String getQueryString() {
        return this.queryString;
    }

    public SubSystemName getSubSystem() {
        return this.subSystem;
    }

    public List<ScopeFilter> getScopeFilters() {
        return this.scopeFilters;
    }

    public Integer getMaxTotalCount() {
        return this.maxTotalCount;
    }

    public TimeRange getTimeFilter() {
        return this.timeFilter;
    }

    public Integer getQueryTimeoutInSeconds() {
        return this.queryTimeoutInSeconds;
    }

    public Boolean getShouldIncludeColumns() {
        return this.shouldIncludeColumns;
    }

    public OutputFormat getOutputFormat() {
        return this.outputFormat;
    }

    public Boolean getShouldLocalize() {
        return this.shouldLocalize;
    }

    public Boolean getShouldUseAcceleration() {
        return this.shouldUseAcceleration;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("ExportDetails(");
        sb.append("super=").append(super.toString());
        sb.append("compartmentId=").append(String.valueOf(this.compartmentId));
        sb.append(", compartmentIdInSubtree=").append(String.valueOf(this.compartmentIdInSubtree));
        sb.append(", queryString=").append(String.valueOf(this.queryString));
        sb.append(", subSystem=").append(String.valueOf((Object)this.subSystem));
        sb.append(", scopeFilters=").append(String.valueOf(this.scopeFilters));
        sb.append(", maxTotalCount=").append(String.valueOf(this.maxTotalCount));
        sb.append(", timeFilter=").append(String.valueOf((Object)this.timeFilter));
        sb.append(", queryTimeoutInSeconds=").append(String.valueOf(this.queryTimeoutInSeconds));
        sb.append(", shouldIncludeColumns=").append(String.valueOf(this.shouldIncludeColumns));
        sb.append(", outputFormat=").append(String.valueOf((Object)this.outputFormat));
        sb.append(", shouldLocalize=").append(String.valueOf(this.shouldLocalize));
        sb.append(", shouldUseAcceleration=").append(String.valueOf(this.shouldUseAcceleration));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ExportDetails)) {
            return false;
        }
        ExportDetails other = (ExportDetails)((Object)o);
        return Objects.equals(this.compartmentId, other.compartmentId) && Objects.equals(this.compartmentIdInSubtree, other.compartmentIdInSubtree) && Objects.equals(this.queryString, other.queryString) && Objects.equals((Object)this.subSystem, (Object)other.subSystem) && Objects.equals(this.scopeFilters, other.scopeFilters) && Objects.equals(this.maxTotalCount, other.maxTotalCount) && Objects.equals((Object)this.timeFilter, (Object)other.timeFilter) && Objects.equals(this.queryTimeoutInSeconds, other.queryTimeoutInSeconds) && Objects.equals(this.shouldIncludeColumns, other.shouldIncludeColumns) && Objects.equals((Object)this.outputFormat, (Object)other.outputFormat) && Objects.equals(this.shouldLocalize, other.shouldLocalize) && Objects.equals(this.shouldUseAcceleration, other.shouldUseAcceleration) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.compartmentId == null ? 43 : this.compartmentId.hashCode());
        result = result * 59 + (this.compartmentIdInSubtree == null ? 43 : this.compartmentIdInSubtree.hashCode());
        result = result * 59 + (this.queryString == null ? 43 : this.queryString.hashCode());
        result = result * 59 + (this.subSystem == null ? 43 : this.subSystem.hashCode());
        result = result * 59 + (this.scopeFilters == null ? 43 : this.scopeFilters.hashCode());
        result = result * 59 + (this.maxTotalCount == null ? 43 : this.maxTotalCount.hashCode());
        result = result * 59 + (this.timeFilter == null ? 43 : this.timeFilter.hashCode());
        result = result * 59 + (this.queryTimeoutInSeconds == null ? 43 : this.queryTimeoutInSeconds.hashCode());
        result = result * 59 + (this.shouldIncludeColumns == null ? 43 : this.shouldIncludeColumns.hashCode());
        result = result * 59 + (this.outputFormat == null ? 43 : this.outputFormat.hashCode());
        result = result * 59 + (this.shouldLocalize == null ? 43 : this.shouldLocalize.hashCode());
        result = result * 59 + (this.shouldUseAcceleration == null ? 43 : this.shouldUseAcceleration.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    public static enum OutputFormat implements BmcEnum
    {
        Csv("CSV"),
        Json("JSON");

        private final String value;
        private static Map<String, OutputFormat> map;

        private OutputFormat(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static OutputFormat create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid OutputFormat: " + key);
        }

        static {
            map = new HashMap<String, OutputFormat>();
            for (OutputFormat v : OutputFormat.values()) {
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="compartmentId")
        private String compartmentId;
        @JsonProperty(value="compartmentIdInSubtree")
        private Boolean compartmentIdInSubtree;
        @JsonProperty(value="queryString")
        private String queryString;
        @JsonProperty(value="subSystem")
        private SubSystemName subSystem;
        @JsonProperty(value="scopeFilters")
        private List<ScopeFilter> scopeFilters;
        @JsonProperty(value="maxTotalCount")
        private Integer maxTotalCount;
        @JsonProperty(value="timeFilter")
        private TimeRange timeFilter;
        @JsonProperty(value="queryTimeoutInSeconds")
        private Integer queryTimeoutInSeconds;
        @JsonProperty(value="shouldIncludeColumns")
        private Boolean shouldIncludeColumns;
        @JsonProperty(value="outputFormat")
        private OutputFormat outputFormat;
        @JsonProperty(value="shouldLocalize")
        private Boolean shouldLocalize;
        @JsonProperty(value="shouldUseAcceleration")
        private Boolean shouldUseAcceleration;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            this.__explicitlySet__.add("compartmentId");
            return this;
        }

        public Builder compartmentIdInSubtree(Boolean compartmentIdInSubtree) {
            this.compartmentIdInSubtree = compartmentIdInSubtree;
            this.__explicitlySet__.add("compartmentIdInSubtree");
            return this;
        }

        public Builder queryString(String queryString) {
            this.queryString = queryString;
            this.__explicitlySet__.add("queryString");
            return this;
        }

        public Builder subSystem(SubSystemName subSystem) {
            this.subSystem = subSystem;
            this.__explicitlySet__.add("subSystem");
            return this;
        }

        public Builder scopeFilters(List<ScopeFilter> scopeFilters) {
            this.scopeFilters = scopeFilters;
            this.__explicitlySet__.add("scopeFilters");
            return this;
        }

        public Builder maxTotalCount(Integer maxTotalCount) {
            this.maxTotalCount = maxTotalCount;
            this.__explicitlySet__.add("maxTotalCount");
            return this;
        }

        public Builder timeFilter(TimeRange timeFilter) {
            this.timeFilter = timeFilter;
            this.__explicitlySet__.add("timeFilter");
            return this;
        }

        public Builder queryTimeoutInSeconds(Integer queryTimeoutInSeconds) {
            this.queryTimeoutInSeconds = queryTimeoutInSeconds;
            this.__explicitlySet__.add("queryTimeoutInSeconds");
            return this;
        }

        public Builder shouldIncludeColumns(Boolean shouldIncludeColumns) {
            this.shouldIncludeColumns = shouldIncludeColumns;
            this.__explicitlySet__.add("shouldIncludeColumns");
            return this;
        }

        public Builder outputFormat(OutputFormat outputFormat) {
            this.outputFormat = outputFormat;
            this.__explicitlySet__.add("outputFormat");
            return this;
        }

        public Builder shouldLocalize(Boolean shouldLocalize) {
            this.shouldLocalize = shouldLocalize;
            this.__explicitlySet__.add("shouldLocalize");
            return this;
        }

        public Builder shouldUseAcceleration(Boolean shouldUseAcceleration) {
            this.shouldUseAcceleration = shouldUseAcceleration;
            this.__explicitlySet__.add("shouldUseAcceleration");
            return this;
        }

        public ExportDetails build() {
            ExportDetails model = new ExportDetails(this.compartmentId, this.compartmentIdInSubtree, this.queryString, this.subSystem, this.scopeFilters, this.maxTotalCount, this.timeFilter, this.queryTimeoutInSeconds, this.shouldIncludeColumns, this.outputFormat, this.shouldLocalize, this.shouldUseAcceleration);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(ExportDetails model) {
            if (model.wasPropertyExplicitlySet("compartmentId")) {
                this.compartmentId(model.getCompartmentId());
            }
            if (model.wasPropertyExplicitlySet("compartmentIdInSubtree")) {
                this.compartmentIdInSubtree(model.getCompartmentIdInSubtree());
            }
            if (model.wasPropertyExplicitlySet("queryString")) {
                this.queryString(model.getQueryString());
            }
            if (model.wasPropertyExplicitlySet("subSystem")) {
                this.subSystem(model.getSubSystem());
            }
            if (model.wasPropertyExplicitlySet("scopeFilters")) {
                this.scopeFilters(model.getScopeFilters());
            }
            if (model.wasPropertyExplicitlySet("maxTotalCount")) {
                this.maxTotalCount(model.getMaxTotalCount());
            }
            if (model.wasPropertyExplicitlySet("timeFilter")) {
                this.timeFilter(model.getTimeFilter());
            }
            if (model.wasPropertyExplicitlySet("queryTimeoutInSeconds")) {
                this.queryTimeoutInSeconds(model.getQueryTimeoutInSeconds());
            }
            if (model.wasPropertyExplicitlySet("shouldIncludeColumns")) {
                this.shouldIncludeColumns(model.getShouldIncludeColumns());
            }
            if (model.wasPropertyExplicitlySet("outputFormat")) {
                this.outputFormat(model.getOutputFormat());
            }
            if (model.wasPropertyExplicitlySet("shouldLocalize")) {
                this.shouldLocalize(model.getShouldLocalize());
            }
            if (model.wasPropertyExplicitlySet("shouldUseAcceleration")) {
                this.shouldUseAcceleration(model.getShouldUseAcceleration());
            }
            return this;
        }
    }
}

