/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.loganalytics.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import java.beans.ConstructorProperties;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class LogAnalyticsEntitySummaryReport
extends ExplicitlySetBmcModel {
    @JsonProperty(value="activeEntitiesCount")
    private final Integer activeEntitiesCount;
    @JsonProperty(value="entitiesWithHasLogsCollectedCount")
    private final Integer entitiesWithHasLogsCollectedCount;
    @JsonProperty(value="entitiesWithManagementAgentCount")
    private final Integer entitiesWithManagementAgentCount;
    @JsonProperty(value="compartmentId")
    private final String compartmentId;

    @Deprecated
    @ConstructorProperties(value={"activeEntitiesCount", "entitiesWithHasLogsCollectedCount", "entitiesWithManagementAgentCount", "compartmentId"})
    public LogAnalyticsEntitySummaryReport(Integer activeEntitiesCount, Integer entitiesWithHasLogsCollectedCount, Integer entitiesWithManagementAgentCount, String compartmentId) {
        this.activeEntitiesCount = activeEntitiesCount;
        this.entitiesWithHasLogsCollectedCount = entitiesWithHasLogsCollectedCount;
        this.entitiesWithManagementAgentCount = entitiesWithManagementAgentCount;
        this.compartmentId = compartmentId;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public Integer getActiveEntitiesCount() {
        return this.activeEntitiesCount;
    }

    public Integer getEntitiesWithHasLogsCollectedCount() {
        return this.entitiesWithHasLogsCollectedCount;
    }

    public Integer getEntitiesWithManagementAgentCount() {
        return this.entitiesWithManagementAgentCount;
    }

    public String getCompartmentId() {
        return this.compartmentId;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("LogAnalyticsEntitySummaryReport(");
        sb.append("super=").append(super.toString());
        sb.append("activeEntitiesCount=").append(String.valueOf(this.activeEntitiesCount));
        sb.append(", entitiesWithHasLogsCollectedCount=").append(String.valueOf(this.entitiesWithHasLogsCollectedCount));
        sb.append(", entitiesWithManagementAgentCount=").append(String.valueOf(this.entitiesWithManagementAgentCount));
        sb.append(", compartmentId=").append(String.valueOf(this.compartmentId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof LogAnalyticsEntitySummaryReport)) {
            return false;
        }
        LogAnalyticsEntitySummaryReport other = (LogAnalyticsEntitySummaryReport)((Object)o);
        return Objects.equals(this.activeEntitiesCount, other.activeEntitiesCount) && Objects.equals(this.entitiesWithHasLogsCollectedCount, other.entitiesWithHasLogsCollectedCount) && Objects.equals(this.entitiesWithManagementAgentCount, other.entitiesWithManagementAgentCount) && Objects.equals(this.compartmentId, other.compartmentId) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.activeEntitiesCount == null ? 43 : this.activeEntitiesCount.hashCode());
        result = result * 59 + (this.entitiesWithHasLogsCollectedCount == null ? 43 : this.entitiesWithHasLogsCollectedCount.hashCode());
        result = result * 59 + (this.entitiesWithManagementAgentCount == null ? 43 : this.entitiesWithManagementAgentCount.hashCode());
        result = result * 59 + (this.compartmentId == null ? 43 : this.compartmentId.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="activeEntitiesCount")
        private Integer activeEntitiesCount;
        @JsonProperty(value="entitiesWithHasLogsCollectedCount")
        private Integer entitiesWithHasLogsCollectedCount;
        @JsonProperty(value="entitiesWithManagementAgentCount")
        private Integer entitiesWithManagementAgentCount;
        @JsonProperty(value="compartmentId")
        private String compartmentId;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder activeEntitiesCount(Integer activeEntitiesCount) {
            this.activeEntitiesCount = activeEntitiesCount;
            this.__explicitlySet__.add("activeEntitiesCount");
            return this;
        }

        public Builder entitiesWithHasLogsCollectedCount(Integer entitiesWithHasLogsCollectedCount) {
            this.entitiesWithHasLogsCollectedCount = entitiesWithHasLogsCollectedCount;
            this.__explicitlySet__.add("entitiesWithHasLogsCollectedCount");
            return this;
        }

        public Builder entitiesWithManagementAgentCount(Integer entitiesWithManagementAgentCount) {
            this.entitiesWithManagementAgentCount = entitiesWithManagementAgentCount;
            this.__explicitlySet__.add("entitiesWithManagementAgentCount");
            return this;
        }

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            this.__explicitlySet__.add("compartmentId");
            return this;
        }

        public LogAnalyticsEntitySummaryReport build() {
            LogAnalyticsEntitySummaryReport model = new LogAnalyticsEntitySummaryReport(this.activeEntitiesCount, this.entitiesWithHasLogsCollectedCount, this.entitiesWithManagementAgentCount, this.compartmentId);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(LogAnalyticsEntitySummaryReport model) {
            if (model.wasPropertyExplicitlySet("activeEntitiesCount")) {
                this.activeEntitiesCount(model.getActiveEntitiesCount());
            }
            if (model.wasPropertyExplicitlySet("entitiesWithHasLogsCollectedCount")) {
                this.entitiesWithHasLogsCollectedCount(model.getEntitiesWithHasLogsCollectedCount());
            }
            if (model.wasPropertyExplicitlySet("entitiesWithManagementAgentCount")) {
                this.entitiesWithManagementAgentCount(model.getEntitiesWithManagementAgentCount());
            }
            if (model.wasPropertyExplicitlySet("compartmentId")) {
                this.compartmentId(model.getCompartmentId());
            }
            return this;
        }
    }
}

