/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.loganalytics.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.internal.BmcEnum;
import com.oracle.bmc.loganalytics.model.AbstractField;
import com.oracle.bmc.loganalytics.model.ValueType;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonDeserialize(builder=Builder.class)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="name")
@JsonFilter(value="explicitlySetFilter")
public final class SortField
extends AbstractField {
    @JsonProperty(value="direction")
    private final Direction direction;

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    @Deprecated
    public SortField(String displayName, Boolean isDeclared, List<String> originalDisplayNames, String internalName, ValueType valueType, Boolean isGroupable, Boolean isDuration, String alias, String filterQueryString, String unitType, Direction direction) {
        super(displayName, isDeclared, originalDisplayNames, internalName, valueType, isGroupable, isDuration, alias, filterQueryString, unitType);
        this.direction = direction;
    }

    public Direction getDirection() {
        return this.direction;
    }

    @Override
    public String toString() {
        return this.toString(true);
    }

    @Override
    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("SortField(");
        sb.append("super=").append(super.toString(includeByteArrayContents));
        sb.append(", direction=").append(String.valueOf((Object)this.direction));
        sb.append(")");
        return sb.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SortField)) {
            return false;
        }
        SortField other = (SortField)((Object)o);
        return Objects.equals((Object)this.direction, (Object)other.direction) && super.equals((Object)other);
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.direction == null ? 43 : this.direction.hashCode());
        return result;
    }

    public static enum Direction implements BmcEnum
    {
        Ascending("ASCENDING"),
        Descending("DESCENDING"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, Direction> map;

        private Direction(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static Direction create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'Direction', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(Direction.class);
            map = new HashMap<String, Direction>();
            for (Direction v : Direction.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="displayName")
        private String displayName;
        @JsonProperty(value="isDeclared")
        private Boolean isDeclared;
        @JsonProperty(value="originalDisplayNames")
        private List<String> originalDisplayNames;
        @JsonProperty(value="internalName")
        private String internalName;
        @JsonProperty(value="valueType")
        private ValueType valueType;
        @JsonProperty(value="isGroupable")
        private Boolean isGroupable;
        @JsonProperty(value="isDuration")
        private Boolean isDuration;
        @JsonProperty(value="alias")
        private String alias;
        @JsonProperty(value="filterQueryString")
        private String filterQueryString;
        @JsonProperty(value="unitType")
        private String unitType;
        @JsonProperty(value="direction")
        private Direction direction;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.__explicitlySet__.add("displayName");
            return this;
        }

        public Builder isDeclared(Boolean isDeclared) {
            this.isDeclared = isDeclared;
            this.__explicitlySet__.add("isDeclared");
            return this;
        }

        public Builder originalDisplayNames(List<String> originalDisplayNames) {
            this.originalDisplayNames = originalDisplayNames;
            this.__explicitlySet__.add("originalDisplayNames");
            return this;
        }

        public Builder internalName(String internalName) {
            this.internalName = internalName;
            this.__explicitlySet__.add("internalName");
            return this;
        }

        public Builder valueType(ValueType valueType) {
            this.valueType = valueType;
            this.__explicitlySet__.add("valueType");
            return this;
        }

        public Builder isGroupable(Boolean isGroupable) {
            this.isGroupable = isGroupable;
            this.__explicitlySet__.add("isGroupable");
            return this;
        }

        public Builder isDuration(Boolean isDuration) {
            this.isDuration = isDuration;
            this.__explicitlySet__.add("isDuration");
            return this;
        }

        public Builder alias(String alias) {
            this.alias = alias;
            this.__explicitlySet__.add("alias");
            return this;
        }

        public Builder filterQueryString(String filterQueryString) {
            this.filterQueryString = filterQueryString;
            this.__explicitlySet__.add("filterQueryString");
            return this;
        }

        public Builder unitType(String unitType) {
            this.unitType = unitType;
            this.__explicitlySet__.add("unitType");
            return this;
        }

        public Builder direction(Direction direction) {
            this.direction = direction;
            this.__explicitlySet__.add("direction");
            return this;
        }

        public SortField build() {
            SortField model = new SortField(this.displayName, this.isDeclared, this.originalDisplayNames, this.internalName, this.valueType, this.isGroupable, this.isDuration, this.alias, this.filterQueryString, this.unitType, this.direction);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(SortField model) {
            if (model.wasPropertyExplicitlySet("displayName")) {
                this.displayName(model.getDisplayName());
            }
            if (model.wasPropertyExplicitlySet("isDeclared")) {
                this.isDeclared(model.getIsDeclared());
            }
            if (model.wasPropertyExplicitlySet("originalDisplayNames")) {
                this.originalDisplayNames(model.getOriginalDisplayNames());
            }
            if (model.wasPropertyExplicitlySet("internalName")) {
                this.internalName(model.getInternalName());
            }
            if (model.wasPropertyExplicitlySet("valueType")) {
                this.valueType(model.getValueType());
            }
            if (model.wasPropertyExplicitlySet("isGroupable")) {
                this.isGroupable(model.getIsGroupable());
            }
            if (model.wasPropertyExplicitlySet("isDuration")) {
                this.isDuration(model.getIsDuration());
            }
            if (model.wasPropertyExplicitlySet("alias")) {
                this.alias(model.getAlias());
            }
            if (model.wasPropertyExplicitlySet("filterQueryString")) {
                this.filterQueryString(model.getFilterQueryString());
            }
            if (model.wasPropertyExplicitlySet("unitType")) {
                this.unitType(model.getUnitType());
            }
            if (model.wasPropertyExplicitlySet("direction")) {
                this.direction(model.getDirection());
            }
            return this;
        }
    }
}

