/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.loganalytics.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.loganalytics.model.AbstractColumn;
import com.oracle.bmc.loganalytics.model.FieldValue;
import com.oracle.bmc.loganalytics.model.SubSystemName;
import com.oracle.bmc.loganalytics.model.TimeClusterDataColumn;
import com.oracle.bmc.loganalytics.model.TimeStatsCluster;
import com.oracle.bmc.loganalytics.model.ValueType;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="type")
@JsonFilter(value="explicitlySetFilter")
public final class TimeClusterColumn
extends AbstractColumn {
    @JsonProperty(value="intervalGap")
    private final String intervalGap;
    @JsonProperty(value="intervals")
    private final List<Long> intervals;
    @JsonProperty(value="groupByColumns")
    private final List<AbstractColumn> groupByColumns;
    @JsonProperty(value="clusters")
    private final Map<String, TimeStatsCluster> clusters;
    @JsonProperty(value="series")
    private final List<TimeClusterDataColumn> series;

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    @Deprecated
    public TimeClusterColumn(String displayName, SubSystemName subSystem, List<FieldValue> values, Boolean isListOfValues, Boolean isMultiValued, Boolean isCaseSensitive, Boolean isGroupable, Boolean isEvaluable, ValueType valueType, String originalDisplayName, String internalName, String intervalGap, List<Long> intervals, List<AbstractColumn> groupByColumns, Map<String, TimeStatsCluster> clusters, List<TimeClusterDataColumn> series) {
        super(displayName, subSystem, values, isListOfValues, isMultiValued, isCaseSensitive, isGroupable, isEvaluable, valueType, originalDisplayName, internalName);
        this.intervalGap = intervalGap;
        this.intervals = intervals;
        this.groupByColumns = groupByColumns;
        this.clusters = clusters;
        this.series = series;
    }

    public String getIntervalGap() {
        return this.intervalGap;
    }

    public List<Long> getIntervals() {
        return this.intervals;
    }

    public List<AbstractColumn> getGroupByColumns() {
        return this.groupByColumns;
    }

    public Map<String, TimeStatsCluster> getClusters() {
        return this.clusters;
    }

    public List<TimeClusterDataColumn> getSeries() {
        return this.series;
    }

    @Override
    public String toString() {
        return this.toString(true);
    }

    @Override
    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("TimeClusterColumn(");
        sb.append("super=").append(super.toString(includeByteArrayContents));
        sb.append(", intervalGap=").append(String.valueOf(this.intervalGap));
        sb.append(", intervals=").append(String.valueOf(this.intervals));
        sb.append(", groupByColumns=").append(String.valueOf(this.groupByColumns));
        sb.append(", clusters=").append(String.valueOf(this.clusters));
        sb.append(", series=").append(String.valueOf(this.series));
        sb.append(")");
        return sb.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof TimeClusterColumn)) {
            return false;
        }
        TimeClusterColumn other = (TimeClusterColumn)((Object)o);
        return Objects.equals(this.intervalGap, other.intervalGap) && Objects.equals(this.intervals, other.intervals) && Objects.equals(this.groupByColumns, other.groupByColumns) && Objects.equals(this.clusters, other.clusters) && Objects.equals(this.series, other.series) && super.equals((Object)other);
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.intervalGap == null ? 43 : this.intervalGap.hashCode());
        result = result * 59 + (this.intervals == null ? 43 : this.intervals.hashCode());
        result = result * 59 + (this.groupByColumns == null ? 43 : this.groupByColumns.hashCode());
        result = result * 59 + (this.clusters == null ? 43 : this.clusters.hashCode());
        result = result * 59 + (this.series == null ? 43 : this.series.hashCode());
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="displayName")
        private String displayName;
        @JsonProperty(value="subSystem")
        private SubSystemName subSystem;
        @JsonProperty(value="values")
        private List<FieldValue> values;
        @JsonProperty(value="isListOfValues")
        private Boolean isListOfValues;
        @JsonProperty(value="isMultiValued")
        private Boolean isMultiValued;
        @JsonProperty(value="isCaseSensitive")
        private Boolean isCaseSensitive;
        @JsonProperty(value="isGroupable")
        private Boolean isGroupable;
        @JsonProperty(value="isEvaluable")
        private Boolean isEvaluable;
        @JsonProperty(value="valueType")
        private ValueType valueType;
        @JsonProperty(value="originalDisplayName")
        private String originalDisplayName;
        @JsonProperty(value="internalName")
        private String internalName;
        @JsonProperty(value="intervalGap")
        private String intervalGap;
        @JsonProperty(value="intervals")
        private List<Long> intervals;
        @JsonProperty(value="groupByColumns")
        private List<AbstractColumn> groupByColumns;
        @JsonProperty(value="clusters")
        private Map<String, TimeStatsCluster> clusters;
        @JsonProperty(value="series")
        private List<TimeClusterDataColumn> series;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.__explicitlySet__.add("displayName");
            return this;
        }

        public Builder subSystem(SubSystemName subSystem) {
            this.subSystem = subSystem;
            this.__explicitlySet__.add("subSystem");
            return this;
        }

        public Builder values(List<FieldValue> values) {
            this.values = values;
            this.__explicitlySet__.add("values");
            return this;
        }

        public Builder isListOfValues(Boolean isListOfValues) {
            this.isListOfValues = isListOfValues;
            this.__explicitlySet__.add("isListOfValues");
            return this;
        }

        public Builder isMultiValued(Boolean isMultiValued) {
            this.isMultiValued = isMultiValued;
            this.__explicitlySet__.add("isMultiValued");
            return this;
        }

        public Builder isCaseSensitive(Boolean isCaseSensitive) {
            this.isCaseSensitive = isCaseSensitive;
            this.__explicitlySet__.add("isCaseSensitive");
            return this;
        }

        public Builder isGroupable(Boolean isGroupable) {
            this.isGroupable = isGroupable;
            this.__explicitlySet__.add("isGroupable");
            return this;
        }

        public Builder isEvaluable(Boolean isEvaluable) {
            this.isEvaluable = isEvaluable;
            this.__explicitlySet__.add("isEvaluable");
            return this;
        }

        public Builder valueType(ValueType valueType) {
            this.valueType = valueType;
            this.__explicitlySet__.add("valueType");
            return this;
        }

        public Builder originalDisplayName(String originalDisplayName) {
            this.originalDisplayName = originalDisplayName;
            this.__explicitlySet__.add("originalDisplayName");
            return this;
        }

        public Builder internalName(String internalName) {
            this.internalName = internalName;
            this.__explicitlySet__.add("internalName");
            return this;
        }

        public Builder intervalGap(String intervalGap) {
            this.intervalGap = intervalGap;
            this.__explicitlySet__.add("intervalGap");
            return this;
        }

        public Builder intervals(List<Long> intervals) {
            this.intervals = intervals;
            this.__explicitlySet__.add("intervals");
            return this;
        }

        public Builder groupByColumns(List<AbstractColumn> groupByColumns) {
            this.groupByColumns = groupByColumns;
            this.__explicitlySet__.add("groupByColumns");
            return this;
        }

        public Builder clusters(Map<String, TimeStatsCluster> clusters) {
            this.clusters = clusters;
            this.__explicitlySet__.add("clusters");
            return this;
        }

        public Builder series(List<TimeClusterDataColumn> series) {
            this.series = series;
            this.__explicitlySet__.add("series");
            return this;
        }

        public TimeClusterColumn build() {
            TimeClusterColumn model = new TimeClusterColumn(this.displayName, this.subSystem, this.values, this.isListOfValues, this.isMultiValued, this.isCaseSensitive, this.isGroupable, this.isEvaluable, this.valueType, this.originalDisplayName, this.internalName, this.intervalGap, this.intervals, this.groupByColumns, this.clusters, this.series);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(TimeClusterColumn model) {
            if (model.wasPropertyExplicitlySet("displayName")) {
                this.displayName(model.getDisplayName());
            }
            if (model.wasPropertyExplicitlySet("subSystem")) {
                this.subSystem(model.getSubSystem());
            }
            if (model.wasPropertyExplicitlySet("values")) {
                this.values(model.getValues());
            }
            if (model.wasPropertyExplicitlySet("isListOfValues")) {
                this.isListOfValues(model.getIsListOfValues());
            }
            if (model.wasPropertyExplicitlySet("isMultiValued")) {
                this.isMultiValued(model.getIsMultiValued());
            }
            if (model.wasPropertyExplicitlySet("isCaseSensitive")) {
                this.isCaseSensitive(model.getIsCaseSensitive());
            }
            if (model.wasPropertyExplicitlySet("isGroupable")) {
                this.isGroupable(model.getIsGroupable());
            }
            if (model.wasPropertyExplicitlySet("isEvaluable")) {
                this.isEvaluable(model.getIsEvaluable());
            }
            if (model.wasPropertyExplicitlySet("valueType")) {
                this.valueType(model.getValueType());
            }
            if (model.wasPropertyExplicitlySet("originalDisplayName")) {
                this.originalDisplayName(model.getOriginalDisplayName());
            }
            if (model.wasPropertyExplicitlySet("internalName")) {
                this.internalName(model.getInternalName());
            }
            if (model.wasPropertyExplicitlySet("intervalGap")) {
                this.intervalGap(model.getIntervalGap());
            }
            if (model.wasPropertyExplicitlySet("intervals")) {
                this.intervals(model.getIntervals());
            }
            if (model.wasPropertyExplicitlySet("groupByColumns")) {
                this.groupByColumns(model.getGroupByColumns());
            }
            if (model.wasPropertyExplicitlySet("clusters")) {
                this.clusters(model.getClusters());
            }
            if (model.wasPropertyExplicitlySet("series")) {
                this.series(model.getSeries());
            }
            return this;
        }
    }
}

