/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.loganalytics.requests;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.oracle.bmc.InternalSdk;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.http.internal.BmcEnum;
import com.oracle.bmc.loganalytics.model.PayloadType;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public class UploadDiscoveryDataRequest
extends BmcRequest<InputStream> {
    private String namespaceName;
    private InputStream uploadDiscoveryDataDetails;
    private String opcRequestId;
    private String opcMetaProperties;
    private DiscoveryDataType discoveryDataType;
    private PayloadType payloadType;
    private String contentType;
    private String opcRetryToken;
    private String expect;

    public String getNamespaceName() {
        return this.namespaceName;
    }

    public InputStream getUploadDiscoveryDataDetails() {
        return this.uploadDiscoveryDataDetails;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public String getOpcMetaProperties() {
        return this.opcMetaProperties;
    }

    public DiscoveryDataType getDiscoveryDataType() {
        return this.discoveryDataType;
    }

    public PayloadType getPayloadType() {
        return this.payloadType;
    }

    public String getContentType() {
        return this.contentType;
    }

    public String getOpcRetryToken() {
        return this.opcRetryToken;
    }

    public String getExpect() {
        return this.expect;
    }

    @InternalSdk
    public InputStream getBody$() {
        return this.uploadDiscoveryDataDetails;
    }

    public boolean supportsExpect100Continue() {
        return true;
    }

    public Builder toBuilder() {
        return new Builder().namespaceName(this.namespaceName).uploadDiscoveryDataDetails(this.uploadDiscoveryDataDetails).opcRequestId(this.opcRequestId).opcMetaProperties(this.opcMetaProperties).discoveryDataType(this.discoveryDataType).payloadType(this.payloadType).contentType(this.contentType).opcRetryToken(this.opcRetryToken).expect(this.expect);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",namespaceName=").append(String.valueOf(this.namespaceName));
        sb.append(",uploadDiscoveryDataDetails=").append(String.valueOf(this.uploadDiscoveryDataDetails));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(",opcMetaProperties=").append(String.valueOf(this.opcMetaProperties));
        sb.append(",discoveryDataType=").append(String.valueOf((Object)this.discoveryDataType));
        sb.append(",payloadType=").append(String.valueOf((Object)this.payloadType));
        sb.append(",contentType=").append(String.valueOf(this.contentType));
        sb.append(",opcRetryToken=").append(String.valueOf(this.opcRetryToken));
        sb.append(",expect=").append(String.valueOf(this.expect));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof UploadDiscoveryDataRequest)) {
            return false;
        }
        UploadDiscoveryDataRequest other = (UploadDiscoveryDataRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.namespaceName, other.namespaceName) && Objects.equals(this.uploadDiscoveryDataDetails, other.uploadDiscoveryDataDetails) && Objects.equals(this.opcRequestId, other.opcRequestId) && Objects.equals(this.opcMetaProperties, other.opcMetaProperties) && Objects.equals((Object)this.discoveryDataType, (Object)other.discoveryDataType) && Objects.equals((Object)this.payloadType, (Object)other.payloadType) && Objects.equals(this.contentType, other.contentType) && Objects.equals(this.opcRetryToken, other.opcRetryToken) && Objects.equals(this.expect, other.expect);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.namespaceName == null ? 43 : this.namespaceName.hashCode());
        result = result * 59 + (this.uploadDiscoveryDataDetails == null ? 43 : this.uploadDiscoveryDataDetails.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        result = result * 59 + (this.opcMetaProperties == null ? 43 : this.opcMetaProperties.hashCode());
        result = result * 59 + (this.discoveryDataType == null ? 43 : this.discoveryDataType.hashCode());
        result = result * 59 + (this.payloadType == null ? 43 : this.payloadType.hashCode());
        result = result * 59 + (this.contentType == null ? 43 : this.contentType.hashCode());
        result = result * 59 + (this.opcRetryToken == null ? 43 : this.opcRetryToken.hashCode());
        result = result * 59 + (this.expect == null ? 43 : this.expect.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<UploadDiscoveryDataRequest, InputStream> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String namespaceName = null;
        private InputStream uploadDiscoveryDataDetails = null;
        private String opcRequestId = null;
        private String opcMetaProperties = null;
        private DiscoveryDataType discoveryDataType = null;
        private PayloadType payloadType = null;
        private String contentType = null;
        private String opcRetryToken = null;
        private String expect = null;

        public Builder namespaceName(String namespaceName) {
            this.namespaceName = namespaceName;
            return this;
        }

        public Builder uploadDiscoveryDataDetails(InputStream uploadDiscoveryDataDetails) {
            this.uploadDiscoveryDataDetails = uploadDiscoveryDataDetails;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder opcMetaProperties(String opcMetaProperties) {
            this.opcMetaProperties = opcMetaProperties;
            return this;
        }

        public Builder discoveryDataType(DiscoveryDataType discoveryDataType) {
            this.discoveryDataType = discoveryDataType;
            return this;
        }

        public Builder payloadType(PayloadType payloadType) {
            this.payloadType = payloadType;
            return this;
        }

        public Builder contentType(String contentType) {
            this.contentType = contentType;
            return this;
        }

        public Builder opcRetryToken(String opcRetryToken) {
            this.opcRetryToken = opcRetryToken;
            return this;
        }

        public Builder expect(String expect) {
            this.expect = expect;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(UploadDiscoveryDataRequest o) {
            this.namespaceName(o.getNamespaceName());
            this.uploadDiscoveryDataDetails(o.getUploadDiscoveryDataDetails());
            this.opcRequestId(o.getOpcRequestId());
            this.opcMetaProperties(o.getOpcMetaProperties());
            this.discoveryDataType(o.getDiscoveryDataType());
            this.payloadType(o.getPayloadType());
            this.contentType(o.getContentType());
            this.opcRetryToken(o.getOpcRetryToken());
            this.expect(o.getExpect());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public UploadDiscoveryDataRequest build() {
            UploadDiscoveryDataRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        @InternalSdk
        public Builder body$(InputStream body) {
            this.uploadDiscoveryDataDetails(body);
            return this;
        }

        public UploadDiscoveryDataRequest buildWithoutInvocationCallback() {
            UploadDiscoveryDataRequest request = new UploadDiscoveryDataRequest();
            request.namespaceName = this.namespaceName;
            request.uploadDiscoveryDataDetails = this.uploadDiscoveryDataDetails;
            request.opcRequestId = this.opcRequestId;
            request.opcMetaProperties = this.opcMetaProperties;
            request.discoveryDataType = this.discoveryDataType;
            request.payloadType = this.payloadType;
            request.contentType = this.contentType;
            request.opcRetryToken = this.opcRetryToken;
            request.expect = this.expect;
            return request;
        }
    }

    public static enum DiscoveryDataType implements BmcEnum
    {
        Entity("ENTITY"),
        K8SObjects("K8S_OBJECTS");

        private final String value;
        private static Map<String, DiscoveryDataType> map;

        private DiscoveryDataType(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static DiscoveryDataType create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid DiscoveryDataType: " + key);
        }

        static {
            map = new HashMap<String, DiscoveryDataType>();
            for (DiscoveryDataType v : DiscoveryDataType.values()) {
                map.put(v.getValue(), v);
            }
        }
    }
}

