/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.loganalytics.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonValue;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.http.internal.BmcEnum;
import com.oracle.bmc.loganalytics.model.Field;
import com.oracle.bmc.loganalytics.model.FieldsAddRemoveField;
import com.oracle.bmc.loganalytics.model.FunctionField;
import com.oracle.bmc.loganalytics.model.SortField;
import com.oracle.bmc.loganalytics.model.ValueType;
import java.beans.ConstructorProperties;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="name", defaultImpl=AbstractField.class)
@JsonSubTypes(value={@JsonSubTypes.Type(value=FieldsAddRemoveField.class, name="FIELDS"), @JsonSubTypes.Type(value=FunctionField.class, name="FUNCTION"), @JsonSubTypes.Type(value=Field.class, name="FIELD"), @JsonSubTypes.Type(value=SortField.class, name="SORT")})
@JsonFilter(value="explicitlySetFilter")
public class AbstractField
extends ExplicitlySetBmcModel {
    @JsonProperty(value="displayName")
    private final String displayName;
    @JsonProperty(value="isDeclared")
    private final Boolean isDeclared;
    @JsonProperty(value="originalDisplayNames")
    private final List<String> originalDisplayNames;
    @JsonProperty(value="internalName")
    private final String internalName;
    @JsonProperty(value="valueType")
    private final ValueType valueType;
    @JsonProperty(value="isGroupable")
    private final Boolean isGroupable;
    @JsonProperty(value="isDuration")
    private final Boolean isDuration;
    @JsonProperty(value="alias")
    private final String alias;
    @JsonProperty(value="filterQueryString")
    private final String filterQueryString;
    @JsonProperty(value="unitType")
    private final String unitType;

    @Deprecated
    @ConstructorProperties(value={"displayName", "isDeclared", "originalDisplayNames", "internalName", "valueType", "isGroupable", "isDuration", "alias", "filterQueryString", "unitType"})
    protected AbstractField(String displayName, Boolean isDeclared, List<String> originalDisplayNames, String internalName, ValueType valueType, Boolean isGroupable, Boolean isDuration, String alias, String filterQueryString, String unitType) {
        this.displayName = displayName;
        this.isDeclared = isDeclared;
        this.originalDisplayNames = originalDisplayNames;
        this.internalName = internalName;
        this.valueType = valueType;
        this.isGroupable = isGroupable;
        this.isDuration = isDuration;
        this.alias = alias;
        this.filterQueryString = filterQueryString;
        this.unitType = unitType;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public Boolean getIsDeclared() {
        return this.isDeclared;
    }

    public List<String> getOriginalDisplayNames() {
        return this.originalDisplayNames;
    }

    public String getInternalName() {
        return this.internalName;
    }

    public ValueType getValueType() {
        return this.valueType;
    }

    public Boolean getIsGroupable() {
        return this.isGroupable;
    }

    public Boolean getIsDuration() {
        return this.isDuration;
    }

    public String getAlias() {
        return this.alias;
    }

    public String getFilterQueryString() {
        return this.filterQueryString;
    }

    public String getUnitType() {
        return this.unitType;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("AbstractField(");
        sb.append("super=").append(super.toString());
        sb.append("displayName=").append(String.valueOf(this.displayName));
        sb.append(", isDeclared=").append(String.valueOf(this.isDeclared));
        sb.append(", originalDisplayNames=").append(String.valueOf(this.originalDisplayNames));
        sb.append(", internalName=").append(String.valueOf(this.internalName));
        sb.append(", valueType=").append(String.valueOf((Object)this.valueType));
        sb.append(", isGroupable=").append(String.valueOf(this.isGroupable));
        sb.append(", isDuration=").append(String.valueOf(this.isDuration));
        sb.append(", alias=").append(String.valueOf(this.alias));
        sb.append(", filterQueryString=").append(String.valueOf(this.filterQueryString));
        sb.append(", unitType=").append(String.valueOf(this.unitType));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof AbstractField)) {
            return false;
        }
        AbstractField other = (AbstractField)((Object)o);
        return Objects.equals(this.displayName, other.displayName) && Objects.equals(this.isDeclared, other.isDeclared) && Objects.equals(this.originalDisplayNames, other.originalDisplayNames) && Objects.equals(this.internalName, other.internalName) && Objects.equals((Object)this.valueType, (Object)other.valueType) && Objects.equals(this.isGroupable, other.isGroupable) && Objects.equals(this.isDuration, other.isDuration) && Objects.equals(this.alias, other.alias) && Objects.equals(this.filterQueryString, other.filterQueryString) && Objects.equals(this.unitType, other.unitType) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.displayName == null ? 43 : this.displayName.hashCode());
        result = result * 59 + (this.isDeclared == null ? 43 : this.isDeclared.hashCode());
        result = result * 59 + (this.originalDisplayNames == null ? 43 : this.originalDisplayNames.hashCode());
        result = result * 59 + (this.internalName == null ? 43 : this.internalName.hashCode());
        result = result * 59 + (this.valueType == null ? 43 : this.valueType.hashCode());
        result = result * 59 + (this.isGroupable == null ? 43 : this.isGroupable.hashCode());
        result = result * 59 + (this.isDuration == null ? 43 : this.isDuration.hashCode());
        result = result * 59 + (this.alias == null ? 43 : this.alias.hashCode());
        result = result * 59 + (this.filterQueryString == null ? 43 : this.filterQueryString.hashCode());
        result = result * 59 + (this.unitType == null ? 43 : this.unitType.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    public static enum Name implements BmcEnum
    {
        Field("FIELD"),
        Fields("FIELDS"),
        Function("FUNCTION"),
        Sort("SORT"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, Name> map;

        private Name(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static Name create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'Name', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(Name.class);
            map = new HashMap<String, Name>();
            for (Name v : Name.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }
}

