/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.loganalytics.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.loganalytics.model.AbstractCommandDescriptor;
import com.oracle.bmc.loganalytics.model.AbstractField;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="name")
@JsonFilter(value="explicitlySetFilter")
public final class ClusterCompareCommandDescriptor
extends AbstractCommandDescriptor {
    @JsonProperty(value="timeShift")
    private final String timeShift;
    @JsonProperty(value="timeStart")
    private final Long timeStart;
    @JsonProperty(value="timeEnd")
    private final Long timeEnd;
    @JsonProperty(value="shouldIncludeTrends")
    private final Boolean shouldIncludeTrends;
    @JsonProperty(value="span")
    private final String span;
    @JsonProperty(value="baselineQuery")
    private final String baselineQuery;

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    @Deprecated
    public ClusterCompareCommandDescriptor(String displayQueryString, String internalQueryString, String category, List<AbstractField> referencedFields, List<AbstractField> declaredFields, Boolean isHidden, String timeShift, Long timeStart, Long timeEnd, Boolean shouldIncludeTrends, String span, String baselineQuery) {
        super(displayQueryString, internalQueryString, category, referencedFields, declaredFields, isHidden);
        this.timeShift = timeShift;
        this.timeStart = timeStart;
        this.timeEnd = timeEnd;
        this.shouldIncludeTrends = shouldIncludeTrends;
        this.span = span;
        this.baselineQuery = baselineQuery;
    }

    public String getTimeShift() {
        return this.timeShift;
    }

    public Long getTimeStart() {
        return this.timeStart;
    }

    public Long getTimeEnd() {
        return this.timeEnd;
    }

    public Boolean getShouldIncludeTrends() {
        return this.shouldIncludeTrends;
    }

    public String getSpan() {
        return this.span;
    }

    public String getBaselineQuery() {
        return this.baselineQuery;
    }

    @Override
    public String toString() {
        return this.toString(true);
    }

    @Override
    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("ClusterCompareCommandDescriptor(");
        sb.append("super=").append(super.toString(includeByteArrayContents));
        sb.append(", timeShift=").append(String.valueOf(this.timeShift));
        sb.append(", timeStart=").append(String.valueOf(this.timeStart));
        sb.append(", timeEnd=").append(String.valueOf(this.timeEnd));
        sb.append(", shouldIncludeTrends=").append(String.valueOf(this.shouldIncludeTrends));
        sb.append(", span=").append(String.valueOf(this.span));
        sb.append(", baselineQuery=").append(String.valueOf(this.baselineQuery));
        sb.append(")");
        return sb.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ClusterCompareCommandDescriptor)) {
            return false;
        }
        ClusterCompareCommandDescriptor other = (ClusterCompareCommandDescriptor)((Object)o);
        return Objects.equals(this.timeShift, other.timeShift) && Objects.equals(this.timeStart, other.timeStart) && Objects.equals(this.timeEnd, other.timeEnd) && Objects.equals(this.shouldIncludeTrends, other.shouldIncludeTrends) && Objects.equals(this.span, other.span) && Objects.equals(this.baselineQuery, other.baselineQuery) && super.equals((Object)other);
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.timeShift == null ? 43 : this.timeShift.hashCode());
        result = result * 59 + (this.timeStart == null ? 43 : this.timeStart.hashCode());
        result = result * 59 + (this.timeEnd == null ? 43 : this.timeEnd.hashCode());
        result = result * 59 + (this.shouldIncludeTrends == null ? 43 : this.shouldIncludeTrends.hashCode());
        result = result * 59 + (this.span == null ? 43 : this.span.hashCode());
        result = result * 59 + (this.baselineQuery == null ? 43 : this.baselineQuery.hashCode());
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="displayQueryString")
        private String displayQueryString;
        @JsonProperty(value="internalQueryString")
        private String internalQueryString;
        @JsonProperty(value="category")
        private String category;
        @JsonProperty(value="referencedFields")
        private List<AbstractField> referencedFields;
        @JsonProperty(value="declaredFields")
        private List<AbstractField> declaredFields;
        @JsonProperty(value="isHidden")
        private Boolean isHidden;
        @JsonProperty(value="timeShift")
        private String timeShift;
        @JsonProperty(value="timeStart")
        private Long timeStart;
        @JsonProperty(value="timeEnd")
        private Long timeEnd;
        @JsonProperty(value="shouldIncludeTrends")
        private Boolean shouldIncludeTrends;
        @JsonProperty(value="span")
        private String span;
        @JsonProperty(value="baselineQuery")
        private String baselineQuery;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder displayQueryString(String displayQueryString) {
            this.displayQueryString = displayQueryString;
            this.__explicitlySet__.add("displayQueryString");
            return this;
        }

        public Builder internalQueryString(String internalQueryString) {
            this.internalQueryString = internalQueryString;
            this.__explicitlySet__.add("internalQueryString");
            return this;
        }

        public Builder category(String category) {
            this.category = category;
            this.__explicitlySet__.add("category");
            return this;
        }

        public Builder referencedFields(List<AbstractField> referencedFields) {
            this.referencedFields = referencedFields;
            this.__explicitlySet__.add("referencedFields");
            return this;
        }

        public Builder declaredFields(List<AbstractField> declaredFields) {
            this.declaredFields = declaredFields;
            this.__explicitlySet__.add("declaredFields");
            return this;
        }

        public Builder isHidden(Boolean isHidden) {
            this.isHidden = isHidden;
            this.__explicitlySet__.add("isHidden");
            return this;
        }

        public Builder timeShift(String timeShift) {
            this.timeShift = timeShift;
            this.__explicitlySet__.add("timeShift");
            return this;
        }

        public Builder timeStart(Long timeStart) {
            this.timeStart = timeStart;
            this.__explicitlySet__.add("timeStart");
            return this;
        }

        public Builder timeEnd(Long timeEnd) {
            this.timeEnd = timeEnd;
            this.__explicitlySet__.add("timeEnd");
            return this;
        }

        public Builder shouldIncludeTrends(Boolean shouldIncludeTrends) {
            this.shouldIncludeTrends = shouldIncludeTrends;
            this.__explicitlySet__.add("shouldIncludeTrends");
            return this;
        }

        public Builder span(String span) {
            this.span = span;
            this.__explicitlySet__.add("span");
            return this;
        }

        public Builder baselineQuery(String baselineQuery) {
            this.baselineQuery = baselineQuery;
            this.__explicitlySet__.add("baselineQuery");
            return this;
        }

        public ClusterCompareCommandDescriptor build() {
            ClusterCompareCommandDescriptor model = new ClusterCompareCommandDescriptor(this.displayQueryString, this.internalQueryString, this.category, this.referencedFields, this.declaredFields, this.isHidden, this.timeShift, this.timeStart, this.timeEnd, this.shouldIncludeTrends, this.span, this.baselineQuery);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(ClusterCompareCommandDescriptor model) {
            if (model.wasPropertyExplicitlySet("displayQueryString")) {
                this.displayQueryString(model.getDisplayQueryString());
            }
            if (model.wasPropertyExplicitlySet("internalQueryString")) {
                this.internalQueryString(model.getInternalQueryString());
            }
            if (model.wasPropertyExplicitlySet("category")) {
                this.category(model.getCategory());
            }
            if (model.wasPropertyExplicitlySet("referencedFields")) {
                this.referencedFields(model.getReferencedFields());
            }
            if (model.wasPropertyExplicitlySet("declaredFields")) {
                this.declaredFields(model.getDeclaredFields());
            }
            if (model.wasPropertyExplicitlySet("isHidden")) {
                this.isHidden(model.getIsHidden());
            }
            if (model.wasPropertyExplicitlySet("timeShift")) {
                this.timeShift(model.getTimeShift());
            }
            if (model.wasPropertyExplicitlySet("timeStart")) {
                this.timeStart(model.getTimeStart());
            }
            if (model.wasPropertyExplicitlySet("timeEnd")) {
                this.timeEnd(model.getTimeEnd());
            }
            if (model.wasPropertyExplicitlySet("shouldIncludeTrends")) {
                this.shouldIncludeTrends(model.getShouldIncludeTrends());
            }
            if (model.wasPropertyExplicitlySet("span")) {
                this.span(model.getSpan());
            }
            if (model.wasPropertyExplicitlySet("baselineQuery")) {
                this.baselineQuery(model.getBaselineQuery());
            }
            return this;
        }
    }
}

