/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.loganalytics.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.loganalytics.model.EndpointProxy;
import com.oracle.bmc.loganalytics.model.EndpointRequest;
import com.oracle.bmc.loganalytics.model.EndpointResponse;
import java.beans.ConstructorProperties;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class CredentialEndpoint
extends ExplicitlySetBmcModel {
    @JsonProperty(value="name")
    private final String name;
    @JsonProperty(value="description")
    private final String description;
    @JsonProperty(value="model")
    private final String model;
    @JsonProperty(value="endpointId")
    private final Long endpointId;
    @JsonProperty(value="request")
    private final EndpointRequest request;
    @JsonProperty(value="response")
    private final EndpointResponse response;
    @JsonProperty(value="proxy")
    private final EndpointProxy proxy;

    @Deprecated
    @ConstructorProperties(value={"name", "description", "model", "endpointId", "request", "response", "proxy"})
    public CredentialEndpoint(String name, String description, String model, Long endpointId, EndpointRequest request, EndpointResponse response, EndpointProxy proxy) {
        this.name = name;
        this.description = description;
        this.model = model;
        this.endpointId = endpointId;
        this.request = request;
        this.response = response;
        this.proxy = proxy;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public String getModel() {
        return this.model;
    }

    public Long getEndpointId() {
        return this.endpointId;
    }

    public EndpointRequest getRequest() {
        return this.request;
    }

    public EndpointResponse getResponse() {
        return this.response;
    }

    public EndpointProxy getProxy() {
        return this.proxy;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("CredentialEndpoint(");
        sb.append("super=").append(super.toString());
        sb.append("name=").append(String.valueOf(this.name));
        sb.append(", description=").append(String.valueOf(this.description));
        sb.append(", model=").append(String.valueOf(this.model));
        sb.append(", endpointId=").append(String.valueOf(this.endpointId));
        sb.append(", request=").append(String.valueOf((Object)this.request));
        sb.append(", response=").append(String.valueOf((Object)this.response));
        sb.append(", proxy=").append(String.valueOf((Object)this.proxy));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CredentialEndpoint)) {
            return false;
        }
        CredentialEndpoint other = (CredentialEndpoint)((Object)o);
        return Objects.equals(this.name, other.name) && Objects.equals(this.description, other.description) && Objects.equals(this.model, other.model) && Objects.equals(this.endpointId, other.endpointId) && Objects.equals((Object)this.request, (Object)other.request) && Objects.equals((Object)this.response, (Object)other.response) && Objects.equals((Object)this.proxy, (Object)other.proxy) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.name == null ? 43 : this.name.hashCode());
        result = result * 59 + (this.description == null ? 43 : this.description.hashCode());
        result = result * 59 + (this.model == null ? 43 : this.model.hashCode());
        result = result * 59 + (this.endpointId == null ? 43 : this.endpointId.hashCode());
        result = result * 59 + (this.request == null ? 43 : this.request.hashCode());
        result = result * 59 + (this.response == null ? 43 : this.response.hashCode());
        result = result * 59 + (this.proxy == null ? 43 : this.proxy.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="name")
        private String name;
        @JsonProperty(value="description")
        private String description;
        @JsonProperty(value="model")
        private String model;
        @JsonProperty(value="endpointId")
        private Long endpointId;
        @JsonProperty(value="request")
        private EndpointRequest request;
        @JsonProperty(value="response")
        private EndpointResponse response;
        @JsonProperty(value="proxy")
        private EndpointProxy proxy;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder name(String name) {
            this.name = name;
            this.__explicitlySet__.add("name");
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            this.__explicitlySet__.add("description");
            return this;
        }

        public Builder model(String model) {
            this.model = model;
            this.__explicitlySet__.add("model");
            return this;
        }

        public Builder endpointId(Long endpointId) {
            this.endpointId = endpointId;
            this.__explicitlySet__.add("endpointId");
            return this;
        }

        public Builder request(EndpointRequest request) {
            this.request = request;
            this.__explicitlySet__.add("request");
            return this;
        }

        public Builder response(EndpointResponse response) {
            this.response = response;
            this.__explicitlySet__.add("response");
            return this;
        }

        public Builder proxy(EndpointProxy proxy) {
            this.proxy = proxy;
            this.__explicitlySet__.add("proxy");
            return this;
        }

        public CredentialEndpoint build() {
            CredentialEndpoint model = new CredentialEndpoint(this.name, this.description, this.model, this.endpointId, this.request, this.response, this.proxy);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(CredentialEndpoint model) {
            if (model.wasPropertyExplicitlySet("name")) {
                this.name(model.getName());
            }
            if (model.wasPropertyExplicitlySet("description")) {
                this.description(model.getDescription());
            }
            if (model.wasPropertyExplicitlySet("model")) {
                this.model(model.getModel());
            }
            if (model.wasPropertyExplicitlySet("endpointId")) {
                this.endpointId(model.getEndpointId());
            }
            if (model.wasPropertyExplicitlySet("request")) {
                this.request(model.getRequest());
            }
            if (model.wasPropertyExplicitlySet("response")) {
                this.response(model.getResponse());
            }
            if (model.wasPropertyExplicitlySet("proxy")) {
                this.proxy(model.getProxy());
            }
            return this;
        }
    }
}

