/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.loganalytics.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import java.beans.ConstructorProperties;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class Dependency
extends ExplicitlySetBmcModel {
    @JsonProperty(value="type")
    private final String type;
    @JsonProperty(value="referenceType")
    private final String referenceType;
    @JsonProperty(value="referenceId")
    private final Long referenceId;

    @Deprecated
    @ConstructorProperties(value={"type", "referenceType", "referenceId"})
    public Dependency(String type, String referenceType, Long referenceId) {
        this.type = type;
        this.referenceType = referenceType;
        this.referenceId = referenceId;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getType() {
        return this.type;
    }

    public String getReferenceType() {
        return this.referenceType;
    }

    public Long getReferenceId() {
        return this.referenceId;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("Dependency(");
        sb.append("super=").append(super.toString());
        sb.append("type=").append(String.valueOf(this.type));
        sb.append(", referenceType=").append(String.valueOf(this.referenceType));
        sb.append(", referenceId=").append(String.valueOf(this.referenceId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Dependency)) {
            return false;
        }
        Dependency other = (Dependency)((Object)o);
        return Objects.equals(this.type, other.type) && Objects.equals(this.referenceType, other.referenceType) && Objects.equals(this.referenceId, other.referenceId) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.type == null ? 43 : this.type.hashCode());
        result = result * 59 + (this.referenceType == null ? 43 : this.referenceType.hashCode());
        result = result * 59 + (this.referenceId == null ? 43 : this.referenceId.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="type")
        private String type;
        @JsonProperty(value="referenceType")
        private String referenceType;
        @JsonProperty(value="referenceId")
        private Long referenceId;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder type(String type) {
            this.type = type;
            this.__explicitlySet__.add("type");
            return this;
        }

        public Builder referenceType(String referenceType) {
            this.referenceType = referenceType;
            this.__explicitlySet__.add("referenceType");
            return this;
        }

        public Builder referenceId(Long referenceId) {
            this.referenceId = referenceId;
            this.__explicitlySet__.add("referenceId");
            return this;
        }

        public Dependency build() {
            Dependency model = new Dependency(this.type, this.referenceType, this.referenceId);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(Dependency model) {
            if (model.wasPropertyExplicitlySet("type")) {
                this.type(model.getType());
            }
            if (model.wasPropertyExplicitlySet("referenceType")) {
                this.referenceType(model.getReferenceType());
            }
            if (model.wasPropertyExplicitlySet("referenceId")) {
                this.referenceId(model.getReferenceId());
            }
            return this;
        }
    }
}

