/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.loganalytics.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.http.internal.BmcEnum;
import com.oracle.bmc.loganalytics.model.Dependency;
import java.beans.ConstructorProperties;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class DependentParser
extends ExplicitlySetBmcModel {
    @JsonProperty(value="parserName")
    private final String parserName;
    @JsonProperty(value="parserDisplayName")
    private final String parserDisplayName;
    @JsonProperty(value="parserId")
    private final Long parserId;
    @JsonProperty(value="isSystem")
    private final Boolean isSystem;
    @JsonProperty(value="parserType")
    private final ParserType parserType;
    @JsonProperty(value="dependencies")
    private final List<Dependency> dependencies;

    @Deprecated
    @ConstructorProperties(value={"parserName", "parserDisplayName", "parserId", "isSystem", "parserType", "dependencies"})
    public DependentParser(String parserName, String parserDisplayName, Long parserId, Boolean isSystem, ParserType parserType, List<Dependency> dependencies) {
        this.parserName = parserName;
        this.parserDisplayName = parserDisplayName;
        this.parserId = parserId;
        this.isSystem = isSystem;
        this.parserType = parserType;
        this.dependencies = dependencies;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getParserName() {
        return this.parserName;
    }

    public String getParserDisplayName() {
        return this.parserDisplayName;
    }

    public Long getParserId() {
        return this.parserId;
    }

    public Boolean getIsSystem() {
        return this.isSystem;
    }

    public ParserType getParserType() {
        return this.parserType;
    }

    public List<Dependency> getDependencies() {
        return this.dependencies;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("DependentParser(");
        sb.append("super=").append(super.toString());
        sb.append("parserName=").append(String.valueOf(this.parserName));
        sb.append(", parserDisplayName=").append(String.valueOf(this.parserDisplayName));
        sb.append(", parserId=").append(String.valueOf(this.parserId));
        sb.append(", isSystem=").append(String.valueOf(this.isSystem));
        sb.append(", parserType=").append(String.valueOf((Object)this.parserType));
        sb.append(", dependencies=").append(String.valueOf(this.dependencies));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DependentParser)) {
            return false;
        }
        DependentParser other = (DependentParser)((Object)o);
        return Objects.equals(this.parserName, other.parserName) && Objects.equals(this.parserDisplayName, other.parserDisplayName) && Objects.equals(this.parserId, other.parserId) && Objects.equals(this.isSystem, other.isSystem) && Objects.equals((Object)this.parserType, (Object)other.parserType) && Objects.equals(this.dependencies, other.dependencies) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.parserName == null ? 43 : this.parserName.hashCode());
        result = result * 59 + (this.parserDisplayName == null ? 43 : this.parserDisplayName.hashCode());
        result = result * 59 + (this.parserId == null ? 43 : this.parserId.hashCode());
        result = result * 59 + (this.isSystem == null ? 43 : this.isSystem.hashCode());
        result = result * 59 + (this.parserType == null ? 43 : this.parserType.hashCode());
        result = result * 59 + (this.dependencies == null ? 43 : this.dependencies.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    public static enum ParserType implements BmcEnum
    {
        Xml("XML"),
        Json("JSON"),
        Regex("REGEX"),
        Odl("ODL"),
        Delimited("DELIMITED"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, ParserType> map;

        private ParserType(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static ParserType create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'ParserType', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(ParserType.class);
            map = new HashMap<String, ParserType>();
            for (ParserType v : ParserType.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="parserName")
        private String parserName;
        @JsonProperty(value="parserDisplayName")
        private String parserDisplayName;
        @JsonProperty(value="parserId")
        private Long parserId;
        @JsonProperty(value="isSystem")
        private Boolean isSystem;
        @JsonProperty(value="parserType")
        private ParserType parserType;
        @JsonProperty(value="dependencies")
        private List<Dependency> dependencies;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder parserName(String parserName) {
            this.parserName = parserName;
            this.__explicitlySet__.add("parserName");
            return this;
        }

        public Builder parserDisplayName(String parserDisplayName) {
            this.parserDisplayName = parserDisplayName;
            this.__explicitlySet__.add("parserDisplayName");
            return this;
        }

        public Builder parserId(Long parserId) {
            this.parserId = parserId;
            this.__explicitlySet__.add("parserId");
            return this;
        }

        public Builder isSystem(Boolean isSystem) {
            this.isSystem = isSystem;
            this.__explicitlySet__.add("isSystem");
            return this;
        }

        public Builder parserType(ParserType parserType) {
            this.parserType = parserType;
            this.__explicitlySet__.add("parserType");
            return this;
        }

        public Builder dependencies(List<Dependency> dependencies) {
            this.dependencies = dependencies;
            this.__explicitlySet__.add("dependencies");
            return this;
        }

        public DependentParser build() {
            DependentParser model = new DependentParser(this.parserName, this.parserDisplayName, this.parserId, this.isSystem, this.parserType, this.dependencies);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(DependentParser model) {
            if (model.wasPropertyExplicitlySet("parserName")) {
                this.parserName(model.getParserName());
            }
            if (model.wasPropertyExplicitlySet("parserDisplayName")) {
                this.parserDisplayName(model.getParserDisplayName());
            }
            if (model.wasPropertyExplicitlySet("parserId")) {
                this.parserId(model.getParserId());
            }
            if (model.wasPropertyExplicitlySet("isSystem")) {
                this.isSystem(model.getIsSystem());
            }
            if (model.wasPropertyExplicitlySet("parserType")) {
                this.parserType(model.getParserType());
            }
            if (model.wasPropertyExplicitlySet("dependencies")) {
                this.dependencies(model.getDependencies());
            }
            return this;
        }
    }
}

