/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.loganalytics.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.loganalytics.model.Dependency;
import com.oracle.bmc.loganalytics.model.LogAnalyticsSourceEntityType;
import java.beans.ConstructorProperties;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class DependentSource
extends ExplicitlySetBmcModel {
    @JsonProperty(value="sourceName")
    private final String sourceName;
    @JsonProperty(value="sourceDisplayName")
    private final String sourceDisplayName;
    @JsonProperty(value="sourceId")
    private final Long sourceId;
    @JsonProperty(value="sourceType")
    private final String sourceType;
    @JsonProperty(value="isSystem")
    private final Boolean isSystem;
    @JsonProperty(value="isAutoAssociationEnabled")
    private final Boolean isAutoAssociationEnabled;
    @JsonProperty(value="entityTypes")
    private final List<LogAnalyticsSourceEntityType> entityTypes;
    @JsonProperty(value="dependencies")
    private final List<Dependency> dependencies;

    @Deprecated
    @ConstructorProperties(value={"sourceName", "sourceDisplayName", "sourceId", "sourceType", "isSystem", "isAutoAssociationEnabled", "entityTypes", "dependencies"})
    public DependentSource(String sourceName, String sourceDisplayName, Long sourceId, String sourceType, Boolean isSystem, Boolean isAutoAssociationEnabled, List<LogAnalyticsSourceEntityType> entityTypes, List<Dependency> dependencies) {
        this.sourceName = sourceName;
        this.sourceDisplayName = sourceDisplayName;
        this.sourceId = sourceId;
        this.sourceType = sourceType;
        this.isSystem = isSystem;
        this.isAutoAssociationEnabled = isAutoAssociationEnabled;
        this.entityTypes = entityTypes;
        this.dependencies = dependencies;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getSourceName() {
        return this.sourceName;
    }

    public String getSourceDisplayName() {
        return this.sourceDisplayName;
    }

    public Long getSourceId() {
        return this.sourceId;
    }

    public String getSourceType() {
        return this.sourceType;
    }

    public Boolean getIsSystem() {
        return this.isSystem;
    }

    public Boolean getIsAutoAssociationEnabled() {
        return this.isAutoAssociationEnabled;
    }

    public List<LogAnalyticsSourceEntityType> getEntityTypes() {
        return this.entityTypes;
    }

    public List<Dependency> getDependencies() {
        return this.dependencies;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("DependentSource(");
        sb.append("super=").append(super.toString());
        sb.append("sourceName=").append(String.valueOf(this.sourceName));
        sb.append(", sourceDisplayName=").append(String.valueOf(this.sourceDisplayName));
        sb.append(", sourceId=").append(String.valueOf(this.sourceId));
        sb.append(", sourceType=").append(String.valueOf(this.sourceType));
        sb.append(", isSystem=").append(String.valueOf(this.isSystem));
        sb.append(", isAutoAssociationEnabled=").append(String.valueOf(this.isAutoAssociationEnabled));
        sb.append(", entityTypes=").append(String.valueOf(this.entityTypes));
        sb.append(", dependencies=").append(String.valueOf(this.dependencies));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DependentSource)) {
            return false;
        }
        DependentSource other = (DependentSource)((Object)o);
        return Objects.equals(this.sourceName, other.sourceName) && Objects.equals(this.sourceDisplayName, other.sourceDisplayName) && Objects.equals(this.sourceId, other.sourceId) && Objects.equals(this.sourceType, other.sourceType) && Objects.equals(this.isSystem, other.isSystem) && Objects.equals(this.isAutoAssociationEnabled, other.isAutoAssociationEnabled) && Objects.equals(this.entityTypes, other.entityTypes) && Objects.equals(this.dependencies, other.dependencies) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.sourceName == null ? 43 : this.sourceName.hashCode());
        result = result * 59 + (this.sourceDisplayName == null ? 43 : this.sourceDisplayName.hashCode());
        result = result * 59 + (this.sourceId == null ? 43 : this.sourceId.hashCode());
        result = result * 59 + (this.sourceType == null ? 43 : this.sourceType.hashCode());
        result = result * 59 + (this.isSystem == null ? 43 : this.isSystem.hashCode());
        result = result * 59 + (this.isAutoAssociationEnabled == null ? 43 : this.isAutoAssociationEnabled.hashCode());
        result = result * 59 + (this.entityTypes == null ? 43 : this.entityTypes.hashCode());
        result = result * 59 + (this.dependencies == null ? 43 : this.dependencies.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="sourceName")
        private String sourceName;
        @JsonProperty(value="sourceDisplayName")
        private String sourceDisplayName;
        @JsonProperty(value="sourceId")
        private Long sourceId;
        @JsonProperty(value="sourceType")
        private String sourceType;
        @JsonProperty(value="isSystem")
        private Boolean isSystem;
        @JsonProperty(value="isAutoAssociationEnabled")
        private Boolean isAutoAssociationEnabled;
        @JsonProperty(value="entityTypes")
        private List<LogAnalyticsSourceEntityType> entityTypes;
        @JsonProperty(value="dependencies")
        private List<Dependency> dependencies;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder sourceName(String sourceName) {
            this.sourceName = sourceName;
            this.__explicitlySet__.add("sourceName");
            return this;
        }

        public Builder sourceDisplayName(String sourceDisplayName) {
            this.sourceDisplayName = sourceDisplayName;
            this.__explicitlySet__.add("sourceDisplayName");
            return this;
        }

        public Builder sourceId(Long sourceId) {
            this.sourceId = sourceId;
            this.__explicitlySet__.add("sourceId");
            return this;
        }

        public Builder sourceType(String sourceType) {
            this.sourceType = sourceType;
            this.__explicitlySet__.add("sourceType");
            return this;
        }

        public Builder isSystem(Boolean isSystem) {
            this.isSystem = isSystem;
            this.__explicitlySet__.add("isSystem");
            return this;
        }

        public Builder isAutoAssociationEnabled(Boolean isAutoAssociationEnabled) {
            this.isAutoAssociationEnabled = isAutoAssociationEnabled;
            this.__explicitlySet__.add("isAutoAssociationEnabled");
            return this;
        }

        public Builder entityTypes(List<LogAnalyticsSourceEntityType> entityTypes) {
            this.entityTypes = entityTypes;
            this.__explicitlySet__.add("entityTypes");
            return this;
        }

        public Builder dependencies(List<Dependency> dependencies) {
            this.dependencies = dependencies;
            this.__explicitlySet__.add("dependencies");
            return this;
        }

        public DependentSource build() {
            DependentSource model = new DependentSource(this.sourceName, this.sourceDisplayName, this.sourceId, this.sourceType, this.isSystem, this.isAutoAssociationEnabled, this.entityTypes, this.dependencies);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(DependentSource model) {
            if (model.wasPropertyExplicitlySet("sourceName")) {
                this.sourceName(model.getSourceName());
            }
            if (model.wasPropertyExplicitlySet("sourceDisplayName")) {
                this.sourceDisplayName(model.getSourceDisplayName());
            }
            if (model.wasPropertyExplicitlySet("sourceId")) {
                this.sourceId(model.getSourceId());
            }
            if (model.wasPropertyExplicitlySet("sourceType")) {
                this.sourceType(model.getSourceType());
            }
            if (model.wasPropertyExplicitlySet("isSystem")) {
                this.isSystem(model.getIsSystem());
            }
            if (model.wasPropertyExplicitlySet("isAutoAssociationEnabled")) {
                this.isAutoAssociationEnabled(model.getIsAutoAssociationEnabled());
            }
            if (model.wasPropertyExplicitlySet("entityTypes")) {
                this.entityTypes(model.getEntityTypes());
            }
            if (model.wasPropertyExplicitlySet("dependencies")) {
                this.dependencies(model.getDependencies());
            }
            return this;
        }
    }
}

