/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.loganalytics.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.http.internal.BmcEnum;
import java.beans.ConstructorProperties;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class EndpointProxy
extends ExplicitlySetBmcModel {
    @JsonProperty(value="url")
    private final String url;
    @JsonProperty(value="credentialName")
    private final String credentialName;
    @JsonProperty(value="credentialType")
    private final CredentialType credentialType;

    @Deprecated
    @ConstructorProperties(value={"url", "credentialName", "credentialType"})
    public EndpointProxy(String url, String credentialName, CredentialType credentialType) {
        this.url = url;
        this.credentialName = credentialName;
        this.credentialType = credentialType;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getUrl() {
        return this.url;
    }

    public String getCredentialName() {
        return this.credentialName;
    }

    public CredentialType getCredentialType() {
        return this.credentialType;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("EndpointProxy(");
        sb.append("super=").append(super.toString());
        sb.append("url=").append(String.valueOf(this.url));
        sb.append(", credentialName=").append(String.valueOf(this.credentialName));
        sb.append(", credentialType=").append(String.valueOf((Object)this.credentialType));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof EndpointProxy)) {
            return false;
        }
        EndpointProxy other = (EndpointProxy)((Object)o);
        return Objects.equals(this.url, other.url) && Objects.equals(this.credentialName, other.credentialName) && Objects.equals((Object)this.credentialType, (Object)other.credentialType) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.url == null ? 43 : this.url.hashCode());
        result = result * 59 + (this.credentialName == null ? 43 : this.credentialName.hashCode());
        result = result * 59 + (this.credentialType == null ? 43 : this.credentialType.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    public static enum CredentialType implements BmcEnum
    {
        None("NONE"),
        BasicAuth("BASIC_AUTH"),
        Token("TOKEN"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, CredentialType> map;

        private CredentialType(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static CredentialType create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'CredentialType', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(CredentialType.class);
            map = new HashMap<String, CredentialType>();
            for (CredentialType v : CredentialType.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="url")
        private String url;
        @JsonProperty(value="credentialName")
        private String credentialName;
        @JsonProperty(value="credentialType")
        private CredentialType credentialType;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder url(String url) {
            this.url = url;
            this.__explicitlySet__.add("url");
            return this;
        }

        public Builder credentialName(String credentialName) {
            this.credentialName = credentialName;
            this.__explicitlySet__.add("credentialName");
            return this;
        }

        public Builder credentialType(CredentialType credentialType) {
            this.credentialType = credentialType;
            this.__explicitlySet__.add("credentialType");
            return this;
        }

        public EndpointProxy build() {
            EndpointProxy model = new EndpointProxy(this.url, this.credentialName, this.credentialType);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(EndpointProxy model) {
            if (model.wasPropertyExplicitlySet("url")) {
                this.url(model.getUrl());
            }
            if (model.wasPropertyExplicitlySet("credentialName")) {
                this.credentialName(model.getCredentialName());
            }
            if (model.wasPropertyExplicitlySet("credentialType")) {
                this.credentialType(model.getCredentialType());
            }
            return this;
        }
    }
}

